# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAccessRequestAuditLogReportResult',
    'AwaitableGetAccessRequestAuditLogReportResult',
    'get_access_request_audit_log_report',
    'get_access_request_audit_log_report_output',
]

@pulumi.output_type
class GetAccessRequestAuditLogReportResult:
    """
    A collection of values returned by getAccessRequestAuditLogReport.
    """
    def __init__(__self__, access_request_id=None, audit_report_status=None, enable_process_tree=None, id=None, process_tree=None, report=None, time_of_report_generation=None):
        if access_request_id and not isinstance(access_request_id, str):
            raise TypeError("Expected argument 'access_request_id' to be a str")
        pulumi.set(__self__, "access_request_id", access_request_id)
        if audit_report_status and not isinstance(audit_report_status, str):
            raise TypeError("Expected argument 'audit_report_status' to be a str")
        pulumi.set(__self__, "audit_report_status", audit_report_status)
        if enable_process_tree and not isinstance(enable_process_tree, int):
            raise TypeError("Expected argument 'enable_process_tree' to be a int")
        pulumi.set(__self__, "enable_process_tree", enable_process_tree)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if process_tree and not isinstance(process_tree, str):
            raise TypeError("Expected argument 'process_tree' to be a str")
        pulumi.set(__self__, "process_tree", process_tree)
        if report and not isinstance(report, str):
            raise TypeError("Expected argument 'report' to be a str")
        pulumi.set(__self__, "report", report)
        if time_of_report_generation and not isinstance(time_of_report_generation, str):
            raise TypeError("Expected argument 'time_of_report_generation' to be a str")
        pulumi.set(__self__, "time_of_report_generation", time_of_report_generation)

    @property
    @pulumi.getter(name="accessRequestId")
    def access_request_id(self) -> str:
        return pulumi.get(self, "access_request_id")

    @property
    @pulumi.getter(name="auditReportStatus")
    def audit_report_status(self) -> str:
        """
        auditReportStatus for the accessRequestId
        """
        return pulumi.get(self, "audit_report_status")

    @property
    @pulumi.getter(name="enableProcessTree")
    def enable_process_tree(self) -> Optional[int]:
        return pulumi.get(self, "enable_process_tree")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="processTree")
    def process_tree(self) -> str:
        """
        Contains the process tree data
        """
        return pulumi.get(self, "process_tree")

    @property
    @pulumi.getter
    def report(self) -> str:
        """
        Contains the report data.
        """
        return pulumi.get(self, "report")

    @property
    @pulumi.getter(name="timeOfReportGeneration")
    def time_of_report_generation(self) -> str:
        """
        Time when the audit report was generated [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_report_generation")


class AwaitableGetAccessRequestAuditLogReportResult(GetAccessRequestAuditLogReportResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessRequestAuditLogReportResult(
            access_request_id=self.access_request_id,
            audit_report_status=self.audit_report_status,
            enable_process_tree=self.enable_process_tree,
            id=self.id,
            process_tree=self.process_tree,
            report=self.report,
            time_of_report_generation=self.time_of_report_generation)


def get_access_request_audit_log_report(access_request_id: Optional[str] = None,
                                        enable_process_tree: Optional[int] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessRequestAuditLogReportResult:
    """
    This data source provides details about a specific Access Request Audit Log Report resource in Oracle Cloud Infrastructure Operator Access Control service.

    Gets the Audit Log Report for the given access requestId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_access_request_audit_log_report = oci.OperatorAccessControl.get_access_request_audit_log_report(access_request_id=test_access_request["id"],
        enable_process_tree=access_request_audit_log_report_enable_process_tree)
    ```


    :param str access_request_id: unique AccessRequest identifier
    :param int enable_process_tree: To enable process tree computation in audit report
    """
    __args__ = dict()
    __args__['accessRequestId'] = access_request_id
    __args__['enableProcessTree'] = enable_process_tree
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OperatorAccessControl/getAccessRequestAuditLogReport:getAccessRequestAuditLogReport', __args__, opts=opts, typ=GetAccessRequestAuditLogReportResult).value

    return AwaitableGetAccessRequestAuditLogReportResult(
        access_request_id=pulumi.get(__ret__, 'access_request_id'),
        audit_report_status=pulumi.get(__ret__, 'audit_report_status'),
        enable_process_tree=pulumi.get(__ret__, 'enable_process_tree'),
        id=pulumi.get(__ret__, 'id'),
        process_tree=pulumi.get(__ret__, 'process_tree'),
        report=pulumi.get(__ret__, 'report'),
        time_of_report_generation=pulumi.get(__ret__, 'time_of_report_generation'))
def get_access_request_audit_log_report_output(access_request_id: Optional[pulumi.Input[str]] = None,
                                               enable_process_tree: Optional[pulumi.Input[Optional[int]]] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAccessRequestAuditLogReportResult]:
    """
    This data source provides details about a specific Access Request Audit Log Report resource in Oracle Cloud Infrastructure Operator Access Control service.

    Gets the Audit Log Report for the given access requestId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_access_request_audit_log_report = oci.OperatorAccessControl.get_access_request_audit_log_report(access_request_id=test_access_request["id"],
        enable_process_tree=access_request_audit_log_report_enable_process_tree)
    ```


    :param str access_request_id: unique AccessRequest identifier
    :param int enable_process_tree: To enable process tree computation in audit report
    """
    __args__ = dict()
    __args__['accessRequestId'] = access_request_id
    __args__['enableProcessTree'] = enable_process_tree
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OperatorAccessControl/getAccessRequestAuditLogReport:getAccessRequestAuditLogReport', __args__, opts=opts, typ=GetAccessRequestAuditLogReportResult)
    return __ret__.apply(lambda __response__: GetAccessRequestAuditLogReportResult(
        access_request_id=pulumi.get(__response__, 'access_request_id'),
        audit_report_status=pulumi.get(__response__, 'audit_report_status'),
        enable_process_tree=pulumi.get(__response__, 'enable_process_tree'),
        id=pulumi.get(__response__, 'id'),
        process_tree=pulumi.get(__response__, 'process_tree'),
        report=pulumi.get(__response__, 'report'),
        time_of_report_generation=pulumi.get(__response__, 'time_of_report_generation')))
