# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetErrataResult',
    'AwaitableGetErrataResult',
    'get_errata',
    'get_errata_output',
]

@pulumi.output_type
class GetErrataResult:
    """
    A collection of values returned by getErrata.
    """
    def __init__(__self__, advisory_severities=None, advisory_types=None, classification_types=None, compartment_id=None, erratum_collections=None, filters=None, id=None, name_contains=None, names=None, os_family=None, time_issue_date_end=None, time_issue_date_start=None):
        if advisory_severities and not isinstance(advisory_severities, list):
            raise TypeError("Expected argument 'advisory_severities' to be a list")
        pulumi.set(__self__, "advisory_severities", advisory_severities)
        if advisory_types and not isinstance(advisory_types, list):
            raise TypeError("Expected argument 'advisory_types' to be a list")
        pulumi.set(__self__, "advisory_types", advisory_types)
        if classification_types and not isinstance(classification_types, list):
            raise TypeError("Expected argument 'classification_types' to be a list")
        pulumi.set(__self__, "classification_types", classification_types)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if erratum_collections and not isinstance(erratum_collections, list):
            raise TypeError("Expected argument 'erratum_collections' to be a list")
        pulumi.set(__self__, "erratum_collections", erratum_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name_contains and not isinstance(name_contains, str):
            raise TypeError("Expected argument 'name_contains' to be a str")
        pulumi.set(__self__, "name_contains", name_contains)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if os_family and not isinstance(os_family, str):
            raise TypeError("Expected argument 'os_family' to be a str")
        pulumi.set(__self__, "os_family", os_family)
        if time_issue_date_end and not isinstance(time_issue_date_end, str):
            raise TypeError("Expected argument 'time_issue_date_end' to be a str")
        pulumi.set(__self__, "time_issue_date_end", time_issue_date_end)
        if time_issue_date_start and not isinstance(time_issue_date_start, str):
            raise TypeError("Expected argument 'time_issue_date_start' to be a str")
        pulumi.set(__self__, "time_issue_date_start", time_issue_date_start)

    @property
    @pulumi.getter(name="advisorySeverities")
    def advisory_severities(self) -> Optional[Sequence[str]]:
        """
        The severity for a security advisory, otherwise, null.
        """
        return pulumi.get(self, "advisory_severities")

    @property
    @pulumi.getter(name="advisoryTypes")
    def advisory_types(self) -> Optional[Sequence[str]]:
        """
        The advisory type of the erratum.
        """
        return pulumi.get(self, "advisory_types")

    @property
    @pulumi.getter(name="classificationTypes")
    def classification_types(self) -> Optional[Sequence[str]]:
        """
        Type of the erratum. This property is deprecated and it will be removed in a future API release. Please refer to the advisoryType property instead.
        """
        return pulumi.get(self, "classification_types")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="erratumCollections")
    def erratum_collections(self) -> Sequence['outputs.GetErrataErratumCollectionResult']:
        """
        The list of erratum_collection.
        """
        return pulumi.get(self, "erratum_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetErrataFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nameContains")
    def name_contains(self) -> Optional[str]:
        return pulumi.get(self, "name_contains")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        Unique identifier for the package. Note that this is not an OCID.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[str]:
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="timeIssueDateEnd")
    def time_issue_date_end(self) -> Optional[str]:
        return pulumi.get(self, "time_issue_date_end")

    @property
    @pulumi.getter(name="timeIssueDateStart")
    def time_issue_date_start(self) -> Optional[str]:
        return pulumi.get(self, "time_issue_date_start")


class AwaitableGetErrataResult(GetErrataResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetErrataResult(
            advisory_severities=self.advisory_severities,
            advisory_types=self.advisory_types,
            classification_types=self.classification_types,
            compartment_id=self.compartment_id,
            erratum_collections=self.erratum_collections,
            filters=self.filters,
            id=self.id,
            name_contains=self.name_contains,
            names=self.names,
            os_family=self.os_family,
            time_issue_date_end=self.time_issue_date_end,
            time_issue_date_start=self.time_issue_date_start)


def get_errata(advisory_severities: Optional[Sequence[str]] = None,
               advisory_types: Optional[Sequence[str]] = None,
               classification_types: Optional[Sequence[str]] = None,
               compartment_id: Optional[str] = None,
               filters: Optional[Sequence[Union['GetErrataFilterArgs', 'GetErrataFilterArgsDict']]] = None,
               name_contains: Optional[str] = None,
               names: Optional[Sequence[str]] = None,
               os_family: Optional[str] = None,
               time_issue_date_end: Optional[str] = None,
               time_issue_date_start: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetErrataResult:
    """
    This data source provides the list of Errata in Oracle Cloud Infrastructure Os Management Hub service.

    Lists all of the currently available errata. Filter the list against a variety of criteria including but not
    limited to its name, classification type, advisory severity, and OS family.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_errata = oci.OsManagementHub.get_errata(compartment_id=compartment_id,
        advisory_severities=erratum_advisory_severity,
        advisory_types=erratum_advisory_type,
        classification_types=erratum_classification_type,
        names=erratum_name,
        name_contains=erratum_name_contains,
        os_family=erratum_os_family,
        time_issue_date_end=erratum_time_issue_date_end,
        time_issue_date_start=erratum_time_issue_date_start)
    ```


    :param Sequence[str] advisory_severities: The advisory severity.
    :param Sequence[str] advisory_types: A filter to return only errata that match the given advisory types.
    :param Sequence[str] classification_types: A filter to return only packages that match the given update classification type.
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment. This parameter is required and returns only resources contained within the specified compartment.
    :param str name_contains: A filter to return resources that may partially match the erratum name given.
    :param Sequence[str] names: The assigned erratum name. It's unique and not changeable.  Example: `ELSA-2020-5804`
    :param str os_family: A filter to return only resources that match the given operating system family.
    :param str time_issue_date_end: The issue date before which to list all errata, in ISO 8601 format  Example: 2017-07-14T02:40:00.000Z
    :param str time_issue_date_start: The issue date after which to list all errata, in ISO 8601 format  Example: 2017-07-14T02:40:00.000Z
    """
    __args__ = dict()
    __args__['advisorySeverities'] = advisory_severities
    __args__['advisoryTypes'] = advisory_types
    __args__['classificationTypes'] = classification_types
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['nameContains'] = name_contains
    __args__['names'] = names
    __args__['osFamily'] = os_family
    __args__['timeIssueDateEnd'] = time_issue_date_end
    __args__['timeIssueDateStart'] = time_issue_date_start
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getErrata:getErrata', __args__, opts=opts, typ=GetErrataResult).value

    return AwaitableGetErrataResult(
        advisory_severities=pulumi.get(__ret__, 'advisory_severities'),
        advisory_types=pulumi.get(__ret__, 'advisory_types'),
        classification_types=pulumi.get(__ret__, 'classification_types'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        erratum_collections=pulumi.get(__ret__, 'erratum_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name_contains=pulumi.get(__ret__, 'name_contains'),
        names=pulumi.get(__ret__, 'names'),
        os_family=pulumi.get(__ret__, 'os_family'),
        time_issue_date_end=pulumi.get(__ret__, 'time_issue_date_end'),
        time_issue_date_start=pulumi.get(__ret__, 'time_issue_date_start'))
def get_errata_output(advisory_severities: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                      advisory_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                      classification_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                      compartment_id: Optional[pulumi.Input[str]] = None,
                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetErrataFilterArgs', 'GetErrataFilterArgsDict']]]]] = None,
                      name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                      names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                      os_family: Optional[pulumi.Input[Optional[str]]] = None,
                      time_issue_date_end: Optional[pulumi.Input[Optional[str]]] = None,
                      time_issue_date_start: Optional[pulumi.Input[Optional[str]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetErrataResult]:
    """
    This data source provides the list of Errata in Oracle Cloud Infrastructure Os Management Hub service.

    Lists all of the currently available errata. Filter the list against a variety of criteria including but not
    limited to its name, classification type, advisory severity, and OS family.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_errata = oci.OsManagementHub.get_errata(compartment_id=compartment_id,
        advisory_severities=erratum_advisory_severity,
        advisory_types=erratum_advisory_type,
        classification_types=erratum_classification_type,
        names=erratum_name,
        name_contains=erratum_name_contains,
        os_family=erratum_os_family,
        time_issue_date_end=erratum_time_issue_date_end,
        time_issue_date_start=erratum_time_issue_date_start)
    ```


    :param Sequence[str] advisory_severities: The advisory severity.
    :param Sequence[str] advisory_types: A filter to return only errata that match the given advisory types.
    :param Sequence[str] classification_types: A filter to return only packages that match the given update classification type.
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment. This parameter is required and returns only resources contained within the specified compartment.
    :param str name_contains: A filter to return resources that may partially match the erratum name given.
    :param Sequence[str] names: The assigned erratum name. It's unique and not changeable.  Example: `ELSA-2020-5804`
    :param str os_family: A filter to return only resources that match the given operating system family.
    :param str time_issue_date_end: The issue date before which to list all errata, in ISO 8601 format  Example: 2017-07-14T02:40:00.000Z
    :param str time_issue_date_start: The issue date after which to list all errata, in ISO 8601 format  Example: 2017-07-14T02:40:00.000Z
    """
    __args__ = dict()
    __args__['advisorySeverities'] = advisory_severities
    __args__['advisoryTypes'] = advisory_types
    __args__['classificationTypes'] = classification_types
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['nameContains'] = name_contains
    __args__['names'] = names
    __args__['osFamily'] = os_family
    __args__['timeIssueDateEnd'] = time_issue_date_end
    __args__['timeIssueDateStart'] = time_issue_date_start
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsManagementHub/getErrata:getErrata', __args__, opts=opts, typ=GetErrataResult)
    return __ret__.apply(lambda __response__: GetErrataResult(
        advisory_severities=pulumi.get(__response__, 'advisory_severities'),
        advisory_types=pulumi.get(__response__, 'advisory_types'),
        classification_types=pulumi.get(__response__, 'classification_types'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        erratum_collections=pulumi.get(__response__, 'erratum_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name_contains=pulumi.get(__response__, 'name_contains'),
        names=pulumi.get(__response__, 'names'),
        os_family=pulumi.get(__response__, 'os_family'),
        time_issue_date_end=pulumi.get(__response__, 'time_issue_date_end'),
        time_issue_date_start=pulumi.get(__response__, 'time_issue_date_start')))
