# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMaintenanceWindowsResult',
    'AwaitableGetMaintenanceWindowsResult',
    'get_maintenance_windows',
    'get_maintenance_windows_output',
]

@pulumi.output_type
class GetMaintenanceWindowsResult:
    """
    A collection of values returned by getMaintenanceWindows.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, lifecycle_details=None, maintenance_window_collections=None, name=None, status=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if maintenance_window_collections and not isinstance(maintenance_window_collections, list):
            raise TypeError("Expected argument 'maintenance_window_collections' to be a list")
        pulumi.set(__self__, "maintenance_window_collections", maintenance_window_collections)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMaintenanceWindowsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[str]:
        """
        Lifecycle Details of the Maintenance Window.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maintenanceWindowCollections")
    def maintenance_window_collections(self) -> Sequence['outputs.GetMaintenanceWindowsMaintenanceWindowCollectionResult']:
        """
        The list of maintenance_window_collection.
        """
        return pulumi.get(self, "maintenance_window_collections")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the monitored resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")


class AwaitableGetMaintenanceWindowsResult(GetMaintenanceWindowsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMaintenanceWindowsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            maintenance_window_collections=self.maintenance_window_collections,
            name=self.name,
            status=self.status)


def get_maintenance_windows(compartment_id: Optional[str] = None,
                            filters: Optional[Sequence[Union['GetMaintenanceWindowsFilterArgs', 'GetMaintenanceWindowsFilterArgsDict']]] = None,
                            lifecycle_details: Optional[str] = None,
                            name: Optional[str] = None,
                            status: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMaintenanceWindowsResult:
    """
    This data source provides the list of Maintenance Windows in Oracle Cloud Infrastructure Stack Monitoring service.

    Returns a list of maintenance windows.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_maintenance_windows = oci.StackMonitoring.get_maintenance_windows(compartment_id=compartment_id,
        lifecycle_details=maintenance_window_lifecycle_details,
        name=maintenance_window_name,
        status=maintenance_window_status)
    ```


    :param str compartment_id: The ID of the compartment in which data is listed.
    :param str lifecycle_details: A filter to return maintenance windows with matching lifecycleDetails.
    :param str name: A filter to return maintenance windows that match exact resource name.
    :param str status: A filter to return only maintenance windows with matching lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['lifecycleDetails'] = lifecycle_details
    __args__['name'] = name
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:StackMonitoring/getMaintenanceWindows:getMaintenanceWindows', __args__, opts=opts, typ=GetMaintenanceWindowsResult).value

    return AwaitableGetMaintenanceWindowsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        maintenance_window_collections=pulumi.get(__ret__, 'maintenance_window_collections'),
        name=pulumi.get(__ret__, 'name'),
        status=pulumi.get(__ret__, 'status'))
def get_maintenance_windows_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMaintenanceWindowsFilterArgs', 'GetMaintenanceWindowsFilterArgsDict']]]]] = None,
                                   lifecycle_details: Optional[pulumi.Input[Optional[str]]] = None,
                                   name: Optional[pulumi.Input[Optional[str]]] = None,
                                   status: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMaintenanceWindowsResult]:
    """
    This data source provides the list of Maintenance Windows in Oracle Cloud Infrastructure Stack Monitoring service.

    Returns a list of maintenance windows.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_maintenance_windows = oci.StackMonitoring.get_maintenance_windows(compartment_id=compartment_id,
        lifecycle_details=maintenance_window_lifecycle_details,
        name=maintenance_window_name,
        status=maintenance_window_status)
    ```


    :param str compartment_id: The ID of the compartment in which data is listed.
    :param str lifecycle_details: A filter to return maintenance windows with matching lifecycleDetails.
    :param str name: A filter to return maintenance windows that match exact resource name.
    :param str status: A filter to return only maintenance windows with matching lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['lifecycleDetails'] = lifecycle_details
    __args__['name'] = name
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:StackMonitoring/getMaintenanceWindows:getMaintenanceWindows', __args__, opts=opts, typ=GetMaintenanceWindowsResult)
    return __ret__.apply(lambda __response__: GetMaintenanceWindowsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        maintenance_window_collections=pulumi.get(__response__, 'maintenance_window_collections'),
        name=pulumi.get(__response__, 'name'),
        status=pulumi.get(__response__, 'status')))
