# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMetricExtensionResult',
    'AwaitableGetMetricExtensionResult',
    'get_metric_extension',
    'get_metric_extension_output',
]

@pulumi.output_type
class GetMetricExtensionResult:
    """
    A collection of values returned by getMetricExtension.
    """
    def __init__(__self__, collection_method=None, collection_recurrences=None, compartment_id=None, created_by=None, description=None, display_name=None, enabled_on_resources=None, enabled_on_resources_count=None, id=None, last_updated_by=None, metric_extension_id=None, metric_lists=None, name=None, publish_trigger=None, query_properties=None, resource_type=None, resource_uri=None, state=None, status=None, tenant_id=None, time_created=None, time_updated=None):
        if collection_method and not isinstance(collection_method, str):
            raise TypeError("Expected argument 'collection_method' to be a str")
        pulumi.set(__self__, "collection_method", collection_method)
        if collection_recurrences and not isinstance(collection_recurrences, str):
            raise TypeError("Expected argument 'collection_recurrences' to be a str")
        pulumi.set(__self__, "collection_recurrences", collection_recurrences)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if enabled_on_resources and not isinstance(enabled_on_resources, list):
            raise TypeError("Expected argument 'enabled_on_resources' to be a list")
        pulumi.set(__self__, "enabled_on_resources", enabled_on_resources)
        if enabled_on_resources_count and not isinstance(enabled_on_resources_count, int):
            raise TypeError("Expected argument 'enabled_on_resources_count' to be a int")
        pulumi.set(__self__, "enabled_on_resources_count", enabled_on_resources_count)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated_by and not isinstance(last_updated_by, str):
            raise TypeError("Expected argument 'last_updated_by' to be a str")
        pulumi.set(__self__, "last_updated_by", last_updated_by)
        if metric_extension_id and not isinstance(metric_extension_id, str):
            raise TypeError("Expected argument 'metric_extension_id' to be a str")
        pulumi.set(__self__, "metric_extension_id", metric_extension_id)
        if metric_lists and not isinstance(metric_lists, list):
            raise TypeError("Expected argument 'metric_lists' to be a list")
        pulumi.set(__self__, "metric_lists", metric_lists)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if publish_trigger and not isinstance(publish_trigger, bool):
            raise TypeError("Expected argument 'publish_trigger' to be a bool")
        pulumi.set(__self__, "publish_trigger", publish_trigger)
        if query_properties and not isinstance(query_properties, list):
            raise TypeError("Expected argument 'query_properties' to be a list")
        pulumi.set(__self__, "query_properties", query_properties)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if resource_uri and not isinstance(resource_uri, str):
            raise TypeError("Expected argument 'resource_uri' to be a str")
        pulumi.set(__self__, "resource_uri", resource_uri)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="collectionMethod")
    def collection_method(self) -> str:
        """
        Type of possible collection methods.
        """
        return pulumi.get(self, "collection_method")

    @property
    @pulumi.getter(name="collectionRecurrences")
    def collection_recurrences(self) -> str:
        """
        Schedule of metric extension should use RFC 5545 format > recur-rule-part = "FREQ";"INTERVAL" where FREQ rule part identifies the type of recurrence rule. Valid values are "MINUTELY","HOURLY","DAILY" to specify repeating events based on an interval of a minute, an hour and a day or more. Example- FREQ=DAILY;INTERVAL=1
        """
        return pulumi.get(self, "collection_recurrences")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        Created by user
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the metric extension.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display name of the metric.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enabledOnResources")
    def enabled_on_resources(self) -> Sequence['outputs.GetMetricExtensionEnabledOnResourceResult']:
        """
        List of resource objects on which this metric extension is enabled.
        """
        return pulumi.get(self, "enabled_on_resources")

    @property
    @pulumi.getter(name="enabledOnResourcesCount")
    def enabled_on_resources_count(self) -> int:
        """
        Count of resources on which this metric extension is enabled.
        """
        return pulumi.get(self, "enabled_on_resources_count")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of Metric Extension resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> str:
        """
        Last updated by user
        """
        return pulumi.get(self, "last_updated_by")

    @property
    @pulumi.getter(name="metricExtensionId")
    def metric_extension_id(self) -> str:
        return pulumi.get(self, "metric_extension_id")

    @property
    @pulumi.getter(name="metricLists")
    def metric_lists(self) -> Sequence['outputs.GetMetricExtensionMetricListResult']:
        """
        List of metrics which are part of this metric extension
        """
        return pulumi.get(self, "metric_lists")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the script file
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publishTrigger")
    def publish_trigger(self) -> bool:
        return pulumi.get(self, "publish_trigger")

    @property
    @pulumi.getter(name="queryProperties")
    def query_properties(self) -> Sequence['outputs.GetMetricExtensionQueryPropertyResult']:
        """
        Collection method and query properties details of metric extension
        """
        return pulumi.get(self, "query_properties")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Resource type to which Metric Extension applies
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> str:
        """
        The URI path that the user can do a GET on to access the metric extension metadata
        """
        return pulumi.get(self, "resource_uri")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the metric extension
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The current status of the metric extension i.e. whether it is Draft or Published
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        Tenant Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Metric Extension creation time. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        Metric Extension update time. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetMetricExtensionResult(GetMetricExtensionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMetricExtensionResult(
            collection_method=self.collection_method,
            collection_recurrences=self.collection_recurrences,
            compartment_id=self.compartment_id,
            created_by=self.created_by,
            description=self.description,
            display_name=self.display_name,
            enabled_on_resources=self.enabled_on_resources,
            enabled_on_resources_count=self.enabled_on_resources_count,
            id=self.id,
            last_updated_by=self.last_updated_by,
            metric_extension_id=self.metric_extension_id,
            metric_lists=self.metric_lists,
            name=self.name,
            publish_trigger=self.publish_trigger,
            query_properties=self.query_properties,
            resource_type=self.resource_type,
            resource_uri=self.resource_uri,
            state=self.state,
            status=self.status,
            tenant_id=self.tenant_id,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_metric_extension(metric_extension_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMetricExtensionResult:
    """
    This data source provides details about a specific Metric Extension resource in Oracle Cloud Infrastructure Stack Monitoring service.

    Gets a Metric Extension by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_metric_extension = oci.StackMonitoring.get_metric_extension(metric_extension_id=test_metric_extension_oci_stack_monitoring_metric_extension["id"])
    ```


    :param str metric_extension_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the metric extension resource.
    """
    __args__ = dict()
    __args__['metricExtensionId'] = metric_extension_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:StackMonitoring/getMetricExtension:getMetricExtension', __args__, opts=opts, typ=GetMetricExtensionResult).value

    return AwaitableGetMetricExtensionResult(
        collection_method=pulumi.get(__ret__, 'collection_method'),
        collection_recurrences=pulumi.get(__ret__, 'collection_recurrences'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        created_by=pulumi.get(__ret__, 'created_by'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        enabled_on_resources=pulumi.get(__ret__, 'enabled_on_resources'),
        enabled_on_resources_count=pulumi.get(__ret__, 'enabled_on_resources_count'),
        id=pulumi.get(__ret__, 'id'),
        last_updated_by=pulumi.get(__ret__, 'last_updated_by'),
        metric_extension_id=pulumi.get(__ret__, 'metric_extension_id'),
        metric_lists=pulumi.get(__ret__, 'metric_lists'),
        name=pulumi.get(__ret__, 'name'),
        publish_trigger=pulumi.get(__ret__, 'publish_trigger'),
        query_properties=pulumi.get(__ret__, 'query_properties'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        resource_uri=pulumi.get(__ret__, 'resource_uri'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_metric_extension_output(metric_extension_id: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMetricExtensionResult]:
    """
    This data source provides details about a specific Metric Extension resource in Oracle Cloud Infrastructure Stack Monitoring service.

    Gets a Metric Extension by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_metric_extension = oci.StackMonitoring.get_metric_extension(metric_extension_id=test_metric_extension_oci_stack_monitoring_metric_extension["id"])
    ```


    :param str metric_extension_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the metric extension resource.
    """
    __args__ = dict()
    __args__['metricExtensionId'] = metric_extension_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:StackMonitoring/getMetricExtension:getMetricExtension', __args__, opts=opts, typ=GetMetricExtensionResult)
    return __ret__.apply(lambda __response__: GetMetricExtensionResult(
        collection_method=pulumi.get(__response__, 'collection_method'),
        collection_recurrences=pulumi.get(__response__, 'collection_recurrences'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        created_by=pulumi.get(__response__, 'created_by'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        enabled_on_resources=pulumi.get(__response__, 'enabled_on_resources'),
        enabled_on_resources_count=pulumi.get(__response__, 'enabled_on_resources_count'),
        id=pulumi.get(__response__, 'id'),
        last_updated_by=pulumi.get(__response__, 'last_updated_by'),
        metric_extension_id=pulumi.get(__response__, 'metric_extension_id'),
        metric_lists=pulumi.get(__response__, 'metric_lists'),
        name=pulumi.get(__response__, 'name'),
        publish_trigger=pulumi.get(__response__, 'publish_trigger'),
        query_properties=pulumi.get(__response__, 'query_properties'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        resource_uri=pulumi.get(__response__, 'resource_uri'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
