#!/usr/bin/env python

# CMOR table definitions used to determine the product.

# cmor_variables : cmor_table => { variable => (priority, dimension_names)}
cmor_variables = {   '3hr': {   'clt': (1, ['longitude', 'latitude', 'time']),
               'hfls': (1, ['longitude', 'latitude', 'time']),
               'hfss': (1, ['longitude', 'latitude', 'time']),
               'huss': (1, ['longitude', 'latitude', 'time1', 'height2m']),
               'mrro': (1, ['longitude', 'latitude', 'time']),
               'mrsos': (1, ['longitude', 'latitude', 'time1', 'sdepth1']),
               'pr': (1, ['longitude', 'latitude', 'time']),
               'prc': (1, ['longitude', 'latitude', 'time']),
               'prsn': (1, ['longitude', 'latitude', 'time']),
               'ps': (1, ['longitude', 'latitude', 'time1']),
               'rlds': (1, ['longitude', 'latitude', 'time']),
               'rldscs': (1, ['longitude', 'latitude', 'time']),
               'rlus': (1, ['longitude', 'latitude', 'time']),
               'rsds': (1, ['longitude', 'latitude', 'time']),
               'rsdscs': (1, ['longitude', 'latitude', 'time']),
               'rsdsdiff': (1, ['longitude', 'latitude', 'time']),
               'rsus': (1, ['longitude', 'latitude', 'time']),
               'rsuscs': (1, ['longitude', 'latitude', 'time']),
               'tas': (1, ['longitude', 'latitude', 'time1', 'height2m']),
               'tslsi': (1, ['longitude', 'latitude', 'time1']),
               'tso': (1, ['longitude', 'latitude', 'time1']),
               'uas': (1, ['longitude', 'latitude', 'time1', 'height10m']),
               'vas': (1, ['longitude', 'latitude', 'time1', 'height10m'])},
    '6hrlev': {   'hus': (1, ['longitude', 'latitude', 'alevel', 'time1']),
                  'ps': (1, ['longitude', 'latitude', 'time1']),
                  'ta': (1, ['longitude', 'latitude', 'alevel', 'time1']),
                  'ua': (1, ['longitude', 'latitude', 'alevel', 'time1']),
                  'va': (1, ['longitude', 'latitude', 'alevel', 'time1'])},
    '6hrplev': {   'psl': (1, ['longitude', 'latitude', 'time1']),
                   'ta': (1, ['longitude', 'latitude', 'plev3', 'time1']),
                   'ua': (1, ['longitude', 'latitude', 'plev3', 'time1']),
                   'va': (1, ['longitude', 'latitude', 'plev3', 'time1'])},
    'aero': {   'abs550aer': (1, ['longitude', 'latitude', 'time']),
                'cdnc': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'chepsoa': (1, ['longitude', 'latitude', 'time']),
                'cldnci': (1, ['longitude', 'latitude', 'time']),
                'cldncl': (1, ['longitude', 'latitude', 'time']),
                'cldnvi': (1, ['longitude', 'latitude', 'time']),
                'concaerh2o': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'concbb': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'concbc': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'conccmcn': (2, ['longitude', 'latitude', 'alevel', 'time']),
                'conccn': (2, ['longitude', 'latitude', 'alevel', 'time']),
                'concdms': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'concdust': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'concnh4': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'concnmcn': (3, ['longitude', 'latitude', 'alevel', 'time']),
                'concno3': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'concoa': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'concpoa': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'concso2': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'concso4': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'concsoa': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'concss': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'drybc': (3, ['longitude', 'latitude', 'time']),
                'drydms': (3, ['longitude', 'latitude', 'time']),
                'drydust': (1, ['longitude', 'latitude', 'time']),
                'drynh3': (3, ['longitude', 'latitude', 'time']),
                'drynh4': (1, ['longitude', 'latitude', 'time']),
                'dryoa': (3, ['longitude', 'latitude', 'time']),
                'drypoa': (3, ['longitude', 'latitude', 'time']),
                'dryso2': (3, ['longitude', 'latitude', 'time']),
                'dryso4': (1, ['longitude', 'latitude', 'time']),
                'drysoa': (3, ['longitude', 'latitude', 'time']),
                'dryss': (3, ['longitude', 'latitude', 'time']),
                'ec550aer': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'emibb': (1, ['longitude', 'latitude', 'time']),
                'emibc': (1, ['longitude', 'latitude', 'time']),
                'emidms': (1, ['longitude', 'latitude', 'time']),
                'emidust': (1, ['longitude', 'latitude', 'time']),
                'eminh3': (1, ['longitude', 'latitude', 'time']),
                'emioa': (1, ['longitude', 'latitude', 'time']),
                'emipoa': (1, ['longitude', 'latitude', 'time']),
                'emiso2': (1, ['longitude', 'latitude', 'time']),
                'emiso4': (1, ['longitude', 'latitude', 'time']),
                'emiss': (1, ['longitude', 'latitude', 'time']),
                'inc': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'loadbc': (1, ['longitude', 'latitude', 'time']),
                'loaddust': (1, ['longitude', 'latitude', 'time']),
                'loadnh4': (3, ['longitude', 'latitude', 'time']),
                'loadno3': (1, ['longitude', 'latitude', 'time']),
                'loadoa': (1, ['longitude', 'latitude', 'time']),
                'loadpoa': (1, ['longitude', 'latitude', 'time']),
                'loadso4': (1, ['longitude', 'latitude', 'time']),
                'loadsoa': (1, ['longitude', 'latitude', 'time']),
                'loadss': (1, ['longitude', 'latitude', 'time']),
                'od550aer': (1, ['longitude', 'latitude', 'time']),
                'od550lt1aer': (1, ['longitude', 'latitude', 'time']),
                'od870aer': (2, ['longitude', 'latitude', 'time']),
                'reffclwc': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'reffclws': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'reffclwtop': (1, ['longitude', 'latitude', 'time']),
                'rsdscsdiff': (2, ['longitude', 'latitude', 'time']),
                'rsdsdiff': (2, ['longitude', 'latitude', 'time']),
                'sconcbc': (3, ['longitude', 'latitude', 'alev1', 'time']),
                'sconcdust': (3, ['longitude', 'latitude', 'alev1', 'time']),
                'sconcnh4': (3, ['longitude', 'latitude', 'alev1', 'time']),
                'sconcno3': (3, ['longitude', 'latitude', 'alev1', 'time']),
                'sconcoa': (3, ['longitude', 'latitude', 'alev1', 'time']),
                'sconcpoa': (3, ['longitude', 'latitude', 'alev1', 'time']),
                'sconcso4': (3, ['longitude', 'latitude', 'alev1', 'time']),
                'sconcsoa': (3, ['longitude', 'latitude', 'alev1', 'time']),
                'sconcss': (3, ['longitude', 'latitude', 'alev1', 'time']),
                'wetbc': (3, ['longitude', 'latitude', 'time']),
                'wetdms': (3, ['longitude', 'latitude', 'time']),
                'wetdust': (1, ['longitude', 'latitude', 'time']),
                'wetnh4': (1, ['longitude', 'latitude', 'time']),
                'wetoa': (3, ['longitude', 'latitude', 'time']),
                'wetpoa': (3, ['longitude', 'latitude', 'time']),
                'wetso2': (3, ['longitude', 'latitude', 'time']),
                'wetso4': (1, ['longitude', 'latitude', 'time']),
                'wetsoa': (3, ['longitude', 'latitude', 'time']),
                'wetss': (3, ['longitude', 'latitude', 'time'])},
    'amon': {   'ccb': (1, ['longitude', 'latitude', 'time']),
                'cct': (1, ['longitude', 'latitude', 'time']),
                'cfc113global': (3, ['time']),
                'cfc11global': (3, ['time']),
                'cfc12global': (3, ['time']),
                'ch4': (1, ['longitude', 'latitude', 'plevs', 'time']),
                'ch4global': (1, ['time']),
                'ci': (1, ['longitude', 'latitude', 'time']),
                'cl': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'cli': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'clivi': (1, ['longitude', 'latitude', 'time']),
                'clt': (1, ['longitude', 'latitude', 'time']),
                'clw': (1, ['longitude', 'latitude', 'alevel', 'time']),
                'clwvi': (1, ['longitude', 'latitude', 'time']),
                'co2': (1, ['longitude', 'latitude', 'plevs', 'time']),
                'co2mass': (1, ['time']),
                'evspsbl': (1, ['longitude', 'latitude', 'time']),
                'fco2antt': (1, ['longitude', 'latitude', 'time']),
                'fco2fos': (1, ['longitude', 'latitude', 'time']),
                'fco2nat': (1, ['longitude', 'latitude', 'time']),
                'hcfc22global': (3, ['time']),
                'hfls': (1, ['longitude', 'latitude', 'time']),
                'hfss': (1, ['longitude', 'latitude', 'time']),
                'hur': (1, ['longitude', 'latitude', 'plevs', 'time']),
                'hurs': (1, ['longitude', 'latitude', 'time', 'height2m']),
                'hus': (1, ['longitude', 'latitude', 'plevs', 'time']),
                'huss': (1, ['longitude', 'latitude', 'time', 'height2m']),
                'mc': (1, ['longitude', 'latitude', 'alevhalf', 'time']),
                'n2o': (1, ['longitude', 'latitude', 'plevs', 'time']),
                'n2oglobal': (1, ['time']),
                'pfull': (1, ['longitude', 'latitude', 'alevel', 'time2']),
                'phalf': (1, ['longitude', 'latitude', 'alevhalf', 'time2']),
                'pr': (1, ['longitude', 'latitude', 'time']),
                'pradjust': (1, ['longitude', 'latitude', 'time']),
                'prc': (1, ['longitude', 'latitude', 'time']),
                'prsn': (1, ['longitude', 'latitude', 'time']),
                'prw': (1, ['longitude', 'latitude', 'time']),
                'ps': (1, ['longitude', 'latitude', 'time']),
                'psl': (1, ['longitude', 'latitude', 'time']),
                'psladjust': (1, ['longitude', 'latitude', 'time']),
                'rlds': (1, ['longitude', 'latitude', 'time']),
                'rldscs': (1, ['longitude', 'latitude', 'time']),
                'rlus': (1, ['longitude', 'latitude', 'time']),
                'rlut': (1, ['longitude', 'latitude', 'time']),
                'rlutcs': (1, ['longitude', 'latitude', 'time']),
                'rsds': (1, ['longitude', 'latitude', 'time']),
                'rsdscs': (1, ['longitude', 'latitude', 'time']),
                'rsdt': (1, ['longitude', 'latitude', 'time']),
                'rsus': (1, ['longitude', 'latitude', 'time']),
                'rsuscs': (1, ['longitude', 'latitude', 'time']),
                'rsut': (1, ['longitude', 'latitude', 'time']),
                'rsutcs': (1, ['longitude', 'latitude', 'time']),
                'rtmt': (1, ['longitude', 'latitude', 'time']),
                'sbl': (1, ['longitude', 'latitude', 'time']),
                'sci': (1, ['longitude', 'latitude', 'time']),
                'sfcwind': (1, ['longitude', 'latitude', 'time', 'height10m']),
                'ta': (1, ['longitude', 'latitude', 'plevs', 'time']),
                'tas': (1, ['longitude', 'latitude', 'time', 'height2m']),
                'tasadjust': (1, ['longitude', 'latitude', 'time', 'height2m']),
                'tasmax': (1, ['longitude', 'latitude', 'time', 'height2m']),
                'tasmin': (1, ['longitude', 'latitude', 'time', 'height2m']),
                'tauu': (1, ['longitude', 'latitude', 'time']),
                'tauv': (1, ['longitude', 'latitude', 'time']),
                'tro3': (1, ['longitude', 'latitude', 'plevs', 'time']),
                'ts': (1, ['longitude', 'latitude', 'time']),
                'tsadjust': (1, ['longitude', 'latitude', 'time']),
                'ua': (1, ['longitude', 'latitude', 'plevs', 'time']),
                'uas': (1, ['longitude', 'latitude', 'time', 'height10m']),
                'va': (1, ['longitude', 'latitude', 'plevs', 'time']),
                'vas': (1, ['longitude', 'latitude', 'time', 'height10m']),
                'wap': (1, ['longitude', 'latitude', 'plevs', 'time']),
                'zg': (1, ['longitude', 'latitude', 'plevs', 'time'])},
    'cf3hr': {   'ccb': (1, ['longitude', 'latitude', 'time1']),
                 'cct': (1, ['longitude', 'latitude', 'time1']),
                 'cfaddbze94': (1, ['location', 'alt40', 'dbze', 'time1']),
                 'cfadlidarsr532': (1, ['location', 'alt40', 'scatratio', 'time1']),
                 'ci': (1, ['longitude', 'latitude', 'time1']),
                 'clc': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'clcalipso': (1, ['location', 'alt40', 'time1']),
                 'clcalipso2': (1, ['location', 'alt40', 'time1']),
                 'clhcalipso': (1, ['location', 'time1', 'p220']),
                 'clic': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'clis': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'clivi': (1, ['longitude', 'latitude', 'time1']),
                 'cllcalipso': (1, ['location', 'time1', 'p840']),
                 'clmcalipso': (1, ['location', 'time1', 'p560']),
                 'cls': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'clt': (1, ['longitude', 'latitude', 'time1']),
                 'cltc': (1, ['longitude', 'latitude', 'time1']),
                 'cltcalipso': (1, ['location', 'time1']),
                 'clwc': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'clws': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'clwvi': (1, ['longitude', 'latitude', 'time1']),
                 'demc': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'dems': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'dtauc': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'dtaus': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'evspsbl': (1, ['longitude', 'latitude', 'time1']),
                 'fco2antt': (1, ['longitude', 'latitude', 'time1']),
                 'fco2fos': (1, ['longitude', 'latitude', 'time1']),
                 'fco2nat': (1, ['longitude', 'latitude', 'time1']),
                 'grpllsprof': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'h2o': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'hfls': (1, ['longitude', 'latitude', 'time1']),
                 'hfss': (1, ['longitude', 'latitude', 'time1']),
                 'hurs': (1, ['longitude', 'latitude', 'time1', 'height2m']),
                 'huss': (1, ['longitude', 'latitude', 'time1', 'height2m']),
                 'parasolrefl': (1, ['location', 'sza5', 'time1']),
                 'pfull': (1, ['longitude', 'latitude', 'alevel', 'time1']),
                 'phalf': (1, ['longitude', 'latitude', 'alevhalf', 'time1']),
                 'pr': (1, ['longitude', 'latitude', 'time1']),
                 'prc': (1, ['longitude', 'latitude', 'time1']),
                 'prcprof': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'prlsns': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'prlsprof': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'prsn': (1, ['longitude', 'latitude', 'time1']),
                 'prsnc': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'prw': (1, ['longitude', 'latitude', 'time1']),
                 'ps': (1, ['longitude', 'latitude', 'time1']),
                 'psl': (1, ['longitude', 'latitude', 'time1']),
                 'reffclic': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'reffclis': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'reffclwc': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'reffclws': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'reffgrpls': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'reffrainc': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'reffrains': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'reffsnowc': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'reffsnows': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'rlds': (1, ['longitude', 'latitude', 'time1']),
                 'rldscs': (1, ['longitude', 'latitude', 'time1']),
                 'rlus': (1, ['longitude', 'latitude', 'time1']),
                 'rlut': (1, ['longitude', 'latitude', 'time1']),
                 'rlutcs': (1, ['longitude', 'latitude', 'time1']),
                 'rsds': (1, ['longitude', 'latitude', 'time1']),
                 'rsdscs': (1, ['longitude', 'latitude', 'time1']),
                 'rsdt': (1, ['longitude', 'latitude', 'time1']),
                 'rsus': (1, ['longitude', 'latitude', 'time1']),
                 'rsuscs': (1, ['longitude', 'latitude', 'time1']),
                 'rsut': (1, ['longitude', 'latitude', 'time1']),
                 'rsutcs': (1, ['longitude', 'latitude', 'time1']),
                 'rtmt': (1, ['longitude', 'latitude', 'time1']),
                 'sbl': (1, ['longitude', 'latitude', 'time1']),
                 'sci': (1, ['longitude', 'latitude', 'time1']),
                 'sfcwind': (1, ['longitude', 'latitude', 'time1', 'height10m']),
                 'ta': (1, ['longitude', 'latitude', 'alevel', 'time1']),
                 'tas': (1, ['longitude', 'latitude', 'time1', 'height2m']),
                 'tauu': (1, ['longitude', 'latitude', 'time1']),
                 'tauv': (1, ['longitude', 'latitude', 'time1']),
                 'toffset': (1, ['location', 'time1']),
                 'ts': (1, ['longitude', 'latitude', 'time1']),
                 'uas': (1, ['longitude', 'latitude', 'time1', 'height10m']),
                 'vas': (1, ['longitude', 'latitude', 'time1', 'height10m']),
                 'zfull': (2, ['longitude', 'latitude', 'alevel', 'time1']),
                 'zhalf': (2, ['longitude', 'latitude', 'alevhalf', 'time1'])},
    'cfday': {   'albisccp': (1, ['longitude', 'latitude', 'time']),
                 'ccb': (1, ['longitude', 'latitude', 'time']),
                 'cct': (1, ['longitude', 'latitude', 'time']),
                 'cl': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'clcalipso': (1, ['longitude', 'latitude', 'alt40', 'time']),
                 'clhcalipso': (1, ['longitude', 'latitude', 'time']),
                 'cli': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'clisccp': (1, ['longitude', 'latitude', 'tau', 'plev7', 'time']),
                 'clivi': (1, ['longitude', 'latitude', 'time']),
                 'cllcalipso': (1, ['longitude', 'latitude', 'time']),
                 'clmcalipso': (1, ['longitude', 'latitude', 'time']),
                 'clt': (1, ['longitude', 'latitude', 'time']),
                 'cltcalipso': (1, ['longitude', 'latitude', 'time']),
                 'cltisccp': (1, ['longitude', 'latitude', 'time']),
                 'clw': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'clwvi': (1, ['longitude', 'latitude', 'time']),
                 'hfls': (1, ['longitude', 'latitude', 'time']),
                 'hfss': (1, ['longitude', 'latitude', 'time']),
                 'hur': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'hus': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'mc': (1, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'parasolrefl': (1, ['longitude', 'latitude', 'sza5', 'time']),
                 'pctisccp': (1, ['longitude', 'latitude', 'time']),
                 'pfull': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'phalf': (1, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'prc': (1, ['longitude', 'latitude', 'time']),
                 'ps': (1, ['longitude', 'latitude', 'time']),
                 'rlds': (1, ['longitude', 'latitude', 'time']),
                 'rldscs': (1, ['longitude', 'latitude', 'time']),
                 'rlus': (1, ['longitude', 'latitude', 'time']),
                 'rlut': (1, ['longitude', 'latitude', 'time']),
                 'rlutcs': (1, ['longitude', 'latitude', 'time']),
                 'rsds': (1, ['longitude', 'latitude', 'time']),
                 'rsdscs': (1, ['longitude', 'latitude', 'time']),
                 'rsdt': (1, ['longitude', 'latitude', 'time']),
                 'rsus': (1, ['longitude', 'latitude', 'time']),
                 'rsuscs': (1, ['longitude', 'latitude', 'time']),
                 'rsut': (1, ['longitude', 'latitude', 'time']),
                 'rsutcs': (1, ['longitude', 'latitude', 'time']),
                 'ta': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'ta700': (1, ['longitude', 'latitude', 'time', 'p700']),
                 'ua': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'va': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'wap': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'wap500': (1, ['longitude', 'latitude', 'time', 'p500']),
                 'zg': (1, ['longitude', 'latitude', 'alevel', 'time'])},
    'cfmon': {   'albisccp': (1, ['longitude', 'latitude', 'time']),
                 'clc': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'clcalipso': (1, ['longitude', 'latitude', 'alt40', 'time']),
                 'clhcalipso': (1, ['longitude', 'latitude', 'time', 'p220']),
                 'clic': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'clis': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'clisccp': (1, ['longitude', 'latitude', 'plev7', 'tau', 'time']),
                 'cllcalipso': (1, ['longitude', 'latitude', 'time', 'p840']),
                 'clmcalipso': (1, ['longitude', 'latitude', 'time', 'p560']),
                 'cls': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'cltcalipso': (1, ['longitude', 'latitude', 'time']),
                 'cltisccp': (1, ['longitude', 'latitude', 'time']),
                 'clwc': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'clws': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'dmc': (2, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'evisct': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'eviscu': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'hur': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'hus': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'mcd': (2, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'mcu': (2, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'parasolrefl': (1, ['longitude', 'latitude', 'sza5', 'time']),
                 'pctisccp': (1, ['longitude', 'latitude', 'time']),
                 'rld': (1, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'rld4co2': (1, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'rldcs': (1, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'rldcs4co2': (1, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'rlu': (1, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'rlu4co2': (1, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'rlucs': (1, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'rlucs4co2': (1, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'rlut4co2': (1, ['longitude', 'latitude', 'time']),
                 'rlutcs4co2': (1, ['longitude', 'latitude', 'time']),
                 'rsd': (1, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'rsd4co2': (1, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'rsdcs': (1, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'rsdcs4co2': (1, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'rsu': (1, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'rsu4co2': (1, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'rsucs': (1, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'rsucs4co2': (1, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'rsut4co2': (1, ['longitude', 'latitude', 'time']),
                 'rsutcs4co2': (1, ['longitude', 'latitude', 'time']),
                 'smc': (2, ['longitude', 'latitude', 'alevhalf', 'time']),
                 'ta': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnhus': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnhusa': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnhusc': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnhusd': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnhusmp': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnhusscpbl': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsccw': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsccwa': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsccwacr': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsccwacs': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsccwbl': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsccwce': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsccwcm': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsccwif': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnscli': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclia': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnscliag': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclias': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclibfpcl': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclibl': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclicd': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclicm': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclids': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnscliemi': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclihencl': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclihenv': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclihon': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnscliif': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclimcl': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclimr': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnscliricl': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclirir': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclw': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclwa': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclwac': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclwar': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclwas': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclwbfpcli': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclwbl': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclwcd': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclwce': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclwcm': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclwhen': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclwhon': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclwmi': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnsclwri': (2, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnt': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'tnta': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'tntc': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'tntmp': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'tntr': (1, ['longitude', 'latitude', 'alevel', 'time']),
                 'tntscpbl': (1, ['longitude', 'latitude', 'alevel', 'time'])},
    'cfoff': {   'cfaddbze94': (1, ['longitude', 'latitude', 'alt40', 'dbze', 'time']),
                 'cfadlidarsr532': (1, ['longitude', 'latitude', 'alt40', 'scatratio', 'time']),
                 'clcalipso': (1, ['longitude', 'latitude', 'alt40', 'time']),
                 'clcalipso2': (1, ['longitude', 'latitude', 'alt40', 'time']),
                 'clhcalipso': (1, ['longitude', 'latitude', 'time', 'p220']),
                 'cllcalipso': (1, ['longitude', 'latitude', 'time', 'p840']),
                 'clmcalipso': (1, ['longitude', 'latitude', 'time', 'p560']),
                 'cltcalipso': (1, ['longitude', 'latitude', 'time']),
                 'parasolrefl': (1, ['longitude', 'latitude', 'sza5', 'time'])},
    'cfsites': {   'ccb': (1, ['site', 'time1']),
                   'cct': (1, ['site', 'time1']),
                   'ci': (1, ['site', 'time1']),
                   'cl': (1, ['alevel', 'site', 'time1']),
                   'cli': (1, ['alevel', 'site', 'time1']),
                   'clivi': (1, ['site', 'time1']),
                   'clt': (1, ['site', 'time1']),
                   'clw': (1, ['alevel', 'site', 'time1']),
                   'clwvi': (1, ['site', 'time1']),
                   'edt': (1, ['alevel', 'site', 'time1']),
                   'evspsbl': (1, ['site', 'time1']),
                   'evu': (1, ['alevel', 'site', 'time1']),
                   'fco2antt': (1, ['site', 'time1']),
                   'fco2fos': (1, ['site', 'time1']),
                   'fco2nat': (1, ['site', 'time1']),
                   'hfls': (1, ['site', 'time1']),
                   'hfss': (1, ['site', 'time1']),
                   'hur': (1, ['alevel', 'site', 'time1']),
                   'hurs': (1, ['site', 'time1', 'height2m']),
                   'hus': (1, ['alevel', 'site', 'time1']),
                   'huss': (1, ['site', 'time1', 'height2m']),
                   'mc': (1, ['alevhalf', 'site', 'time1']),
                   'pfull': (1, ['alevel', 'site', 'time1']),
                   'phalf': (1, ['alevel', 'site', 'time1']),
                   'pr': (1, ['site', 'time1']),
                   'prc': (1, ['site', 'time1']),
                   'prsn': (1, ['site', 'time1']),
                   'prw': (1, ['site', 'time1']),
                   'ps': (1, ['site', 'time1']),
                   'psl': (1, ['site', 'time1']),
                   'rld': (1, ['alevel', 'site', 'time1']),
                   'rldcs': (1, ['alevel', 'site', 'time1']),
                   'rlds': (1, ['site', 'time1']),
                   'rldscs': (1, ['site', 'time1']),
                   'rlu': (1, ['alevel', 'site', 'time1']),
                   'rlucs': (1, ['alevel', 'site', 'time1']),
                   'rlus': (1, ['site', 'time1']),
                   'rlut': (1, ['site', 'time1']),
                   'rlutcs': (1, ['site', 'time1']),
                   'rsd': (1, ['alevel', 'site', 'time1']),
                   'rsdcs': (1, ['alevel', 'site', 'time1']),
                   'rsds': (1, ['site', 'time1']),
                   'rsdscs': (1, ['site', 'time1']),
                   'rsdt': (1, ['site', 'time1']),
                   'rsu': (1, ['alevel', 'site', 'time1']),
                   'rsucs': (1, ['alevel', 'site', 'time1']),
                   'rsus': (1, ['site', 'time1']),
                   'rsuscs': (1, ['site', 'time1']),
                   'rsut': (1, ['site', 'time1']),
                   'rsutcs': (1, ['site', 'time1']),
                   'rtmt': (1, ['site', 'time1']),
                   'sbl': (1, ['site', 'time1']),
                   'sci': (1, ['site', 'time1']),
                   'sfcwind': (1, ['site', 'time1', 'height10m']),
                   'ta': (1, ['alevel', 'site', 'time1']),
                   'tas': (1, ['site', 'time1', 'height2m']),
                   'tauu': (1, ['site', 'time1']),
                   'tauv': (1, ['site', 'time1']),
                   'tnhus': (1, ['alevel', 'site', 'time1']),
                   'tnhusa': (1, ['alevel', 'site', 'time1']),
                   'tnhusc': (1, ['alevel', 'site', 'time1']),
                   'tnhusd': (1, ['alevel', 'site', 'time1']),
                   'tnhusmp': (1, ['alevel', 'site', 'time1']),
                   'tnhusscpbl': (1, ['alevel', 'site', 'time1']),
                   'tnt': (1, ['alevel', 'site', 'time1']),
                   'tnta': (1, ['alevel', 'site', 'time1']),
                   'tntc': (1, ['alevel', 'site', 'time1']),
                   'tntmp': (1, ['alevel', 'site', 'time1']),
                   'tntr': (1, ['alevel', 'site', 'time1']),
                   'tntscpbl': (1, ['alevel', 'site', 'time1']),
                   'ts': (1, ['site', 'time1']),
                   'ua': (1, ['alevel', 'site', 'time1']),
                   'uas': (1, ['site', 'time1', 'height10m']),
                   'va': (1, ['alevel', 'site', 'time1']),
                   'vas': (1, ['site', 'time1', 'height10m']),
                   'wap': (1, ['alevel', 'site', 'time1']),
                   'zg': (1, ['alevel', 'site', 'time1'])},
    'day': {   'clt': (1, ['longitude', 'latitude', 'time']),
               'hfls': (1, ['longitude', 'latitude', 'time']),
               'hfss': (1, ['longitude', 'latitude', 'time']),
               'hur': (1, ['longitude', 'latitude', 'plev8', 'time']),
               'hus': (1, ['longitude', 'latitude', 'plev8', 'time']),
               'huss': (1, ['longitude', 'latitude', 'time', 'height2m']),
               'mrro': (1, ['longitude', 'latitude', 'time']),
               'mrsos': (1, ['longitude', 'latitude', 'time', 'sdepth1']),
               'omldamax': (1, ['longitude', 'latitude', 'time']),
               'pr': (1, ['longitude', 'latitude', 'time']),
               'prc': (1, ['longitude', 'latitude', 'time']),
               'prsn': (1, ['longitude', 'latitude', 'time']),
               'psl': (1, ['longitude', 'latitude', 'time']),
               'rhs': (1, ['longitude', 'latitude', 'time', 'height2m']),
               'rhsmax': (1, ['longitude', 'latitude', 'time', 'height2m']),
               'rhsmin': (1, ['longitude', 'latitude', 'time', 'height2m']),
               'rlds': (1, ['longitude', 'latitude', 'time']),
               'rlus': (1, ['longitude', 'latitude', 'time']),
               'rlut': (1, ['longitude', 'latitude', 'time']),
               'rsds': (1, ['longitude', 'latitude', 'time']),
               'rsus': (1, ['longitude', 'latitude', 'time']),
               'sfcwind': (1, ['longitude', 'latitude', 'time', 'height10m']),
               'sfcwindmax': (1, ['longitude', 'latitude', 'time', 'height10m']),
               'sic': (1, ['longitude', 'latitude', 'time']),
               'sit': (1, ['longitude', 'latitude', 'time']),
               'snc': (1, ['longitude', 'latitude', 'time']),
               'snw': (1, ['longitude', 'latitude', 'time']),
               'ta': (1, ['longitude', 'latitude', 'plev8', 'time']),
               'tas': (1, ['longitude', 'latitude', 'time', 'height2m']),
               'tasmax': (1, ['longitude', 'latitude', 'time', 'height2m']),
               'tasmin': (1, ['longitude', 'latitude', 'time', 'height2m']),
               'tos': (1, ['longitude', 'latitude', 'time']),
               'tossq': (1, ['longitude', 'latitude', 'time']),
               'tslsi': (1, ['longitude', 'latitude', 'time']),
               'ua': (1, ['longitude', 'latitude', 'plev8', 'time']),
               'uas': (1, ['longitude', 'latitude', 'time', 'height10m']),
               'usi': (1, ['longitude', 'latitude', 'time']),
               'va': (1, ['longitude', 'latitude', 'plev8', 'time']),
               'vas': (1, ['longitude', 'latitude', 'time', 'height10m']),
               'vsi': (1, ['longitude', 'latitude', 'time']),
               'wap': (1, ['longitude', 'latitude', 'plev8', 'time']),
               'zg': (2, ['longitude', 'latitude', 'plev8', 'time'])},
    'fx': {   'areacella': (1, ['longitude', 'latitude']),
              'areacello': (1, ['longitude', 'latitude']),
              'basin': (1, ['longitude', 'latitude']),
              'deptho': (1, ['longitude', 'latitude']),
              'hfgeou': (2, ['longitude', 'latitude']),
              'mrsofc': (1, ['longitude', 'latitude']),
              'orog': (1, ['longitude', 'latitude']),
              'rootd': (1, ['longitude', 'latitude']),
              'sftgif': (1, ['longitude', 'latitude']),
              'sftlf': (1, ['longitude', 'latitude']),
              'sftof': (1, ['longitude', 'latitude']),
              'volcello': (1, ['longitude', 'latitude', 'olevel'])},
    'grids': {   'latitude': (0, ['longitude', 'latitude']),
                 'longitude': (0, ['longitude', 'latitude']),
                 'vertices_latitude': (0, ['vertices', 'longitude', 'latitude']),
                 'vertices_longitude': (0, ['vertices', 'longitude', 'latitude'])},
    'limon': {   'agesno': (1, ['longitude', 'latitude', 'time']),
                 'hfdsn': (1, ['longitude', 'latitude', 'time']),
                 'lwsnl': (2, ['longitude', 'latitude', 'time']),
                 'pflw': (3, ['longitude', 'latitude', 'time']),
                 'sbl': (1, ['longitude', 'latitude', 'time']),
                 'snc': (1, ['longitude', 'latitude', 'time']),
                 'snd': (1, ['longitude', 'latitude', 'time']),
                 'snm': (1, ['longitude', 'latitude', 'time']),
                 'snw': (1, ['longitude', 'latitude', 'time']),
                 'sootsn': (2, ['longitude', 'latitude', 'time']),
                 'tpf': (3, ['longitude', 'latitude', 'time']),
                 'tsn': (1, ['longitude', 'latitude', 'time'])},
    'lmon': {   'baresoilfrac': (1, ['longitude', 'latitude', 'time', 'typebare']),
                'burntarea': (1, ['longitude', 'latitude', 'time']),
                'c3pftfrac': (2, ['longitude', 'latitude', 'time', 'typec3pft']),
                'c4pftfrac': (2, ['longitude', 'latitude', 'time', 'typec4pft']),
                'ccwd': (2, ['longitude', 'latitude', 'time']),
                'cleaf': (2, ['longitude', 'latitude', 'time']),
                'clitter': (1, ['longitude', 'latitude', 'time']),
                'clitterabove': (2, ['longitude', 'latitude', 'time']),
                'clitterbelow': (2, ['longitude', 'latitude', 'time']),
                'cmisc': (2, ['longitude', 'latitude', 'time']),
                'cproduct': (1, ['longitude', 'latitude', 'time']),
                'croot': (2, ['longitude', 'latitude', 'time']),
                'csoil': (1, ['longitude', 'latitude', 'time']),
                'csoilfast': (2, ['longitude', 'latitude', 'time']),
                'csoilmedium': (2, ['longitude', 'latitude', 'time']),
                'csoilslow': (2, ['longitude', 'latitude', 'time']),
                'cveg': (1, ['longitude', 'latitude', 'time']),
                'cwood': (2, ['longitude', 'latitude', 'time']),
                'cropfrac': (1, ['longitude', 'latitude', 'time']),
                'evspsblsoi': (1, ['longitude', 'latitude', 'time']),
                'evspsblveg': (1, ['longitude', 'latitude', 'time']),
                'ffire': (1, ['longitude', 'latitude', 'time']),
                'fgrazing': (1, ['longitude', 'latitude', 'time']),
                'fharvest': (1, ['longitude', 'latitude', 'time']),
                'flittersoil': (1, ['longitude', 'latitude', 'time']),
                'fluc': (1, ['longitude', 'latitude', 'time']),
                'fveglitter': (1, ['longitude', 'latitude', 'time']),
                'fvegsoil': (1, ['longitude', 'latitude', 'time']),
                'gpp': (1, ['longitude', 'latitude', 'time']),
                'grassfrac': (1, ['longitude', 'latitude', 'time']),
                'lai': (1, ['longitude', 'latitude', 'time']),
                'landcoverfrac': (2, ['longitude', 'latitude', 'vegtype', 'time']),
                'mrfso': (1, ['longitude', 'latitude', 'time']),
                'mrlsl': (1, ['longitude', 'latitude', 'sdepth', 'time']),
                'mrro': (1, ['longitude', 'latitude', 'time']),
                'mrros': (1, ['longitude', 'latitude', 'time']),
                'mrso': (1, ['longitude', 'latitude', 'time']),
                'mrsos': (1, ['longitude', 'latitude', 'time', 'sdepth1']),
                'nbp': (1, ['longitude', 'latitude', 'time']),
                'nep': (1, ['longitude', 'latitude', 'time']),
                'npp': (1, ['longitude', 'latitude', 'time']),
                'nppleaf': (2, ['longitude', 'latitude', 'time']),
                'npproot': (2, ['longitude', 'latitude', 'time']),
                'nppwood': (2, ['longitude', 'latitude', 'time']),
                'pasturefrac': (1, ['longitude', 'latitude', 'time']),
                'prveg': (2, ['longitude', 'latitude', 'time']),
                'rgrowth': (2, ['longitude', 'latitude', 'time']),
                'rmaint': (2, ['longitude', 'latitude', 'time']),
                'ra': (1, ['longitude', 'latitude', 'time']),
                'residualfrac': (1, ['longitude', 'latitude', 'time']),
                'rh': (1, ['longitude', 'latitude', 'time']),
                'shrubfrac': (1, ['longitude', 'latitude', 'time']),
                'tran': (1, ['longitude', 'latitude', 'time']),
                'treefrac': (1, ['longitude', 'latitude', 'time']),
                'treefracprimdec': (2, ['longitude', 'latitude', 'time', 'typepdec']),
                'treefracprimever': (2, ['longitude', 'latitude', 'time', 'typepever']),
                'treefracsecdec': (2, ['longitude', 'latitude', 'time', 'typesdec']),
                'treefracsecever': (2, ['longitude', 'latitude', 'time', 'typesever']),
                'tsl': (2, ['longitude', 'latitude', 'sdepth', 'time'])},
    'oclim': {   'difmxybo': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'difmxylo': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'diftrbbo': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'diftrblo': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'diftrebo': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'diftrelo': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'diftrxybo': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'diftrxylo': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'difvho': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'difvmbo': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'difvmfdo': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'difvmo': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'difvmto': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'difvso': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'difvtrbo': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'difvtrto': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'dispkevfo': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'dispkexyfo': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'tnkebto': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'tnpeo': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'tnpeot': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'tnpeotb': (3, ['longitude', 'latitude', 'olevel', 'time2']),
                 'zfull': (1, ['longitude', 'latitude', 'olevel', 'time2']),
                 'zhalf': (1, ['longitude', 'latitude', 'olevel', 'time2'])},
    'oimon': {   'ageice': (3, ['longitude', 'latitude', 'time']),
                 'bmelt': (1, ['longitude', 'latitude', 'time']),
                 'divice': (2, ['longitude', 'latitude', 'time']),
                 'eshrice': (2, ['longitude', 'latitude', 'time']),
                 'evap': (1, ['longitude', 'latitude', 'time']),
                 'grcongel': (1, ['longitude', 'latitude', 'time']),
                 'grfrazil': (1, ['longitude', 'latitude', 'time']),
                 'grlateral': (1, ['longitude', 'latitude', 'time']),
                 'hcice': (2, ['longitude', 'latitude', 'time']),
                 'hflssi': (2, ['longitude', 'latitude', 'time']),
                 'hfssi': (2, ['longitude', 'latitude', 'time']),
                 'ialb': (1, ['longitude', 'latitude', 'time']),
                 'nshrice': (2, ['longitude', 'latitude', 'time']),
                 'pr': (1, ['longitude', 'latitude', 'time']),
                 'prsn': (1, ['longitude', 'latitude', 'time']),
                 'ridgice': (2, ['longitude', 'latitude', 'time']),
                 'rldssi': (2, ['longitude', 'latitude', 'time']),
                 'rlussi': (2, ['longitude', 'latitude', 'time']),
                 'rsdssi': (1, ['longitude', 'latitude', 'time']),
                 'rsussi': (1, ['longitude', 'latitude', 'time']),
                 'sblsi': (2, ['longitude', 'latitude', 'time']),
                 'sic': (1, ['longitude', 'latitude', 'time']),
                 'sim': (1, ['longitude', 'latitude', 'time']),
                 'sit': (1, ['longitude', 'latitude', 'time']),
                 'snc': (2, ['longitude', 'latitude', 'time']),
                 'snd': (1, ['longitude', 'latitude', 'time']),
                 'snotoice': (1, ['longitude', 'latitude', 'time']),
                 'snomelt': (1, ['longitude', 'latitude', 'time']),
                 'ssi': (3, ['longitude', 'latitude', 'time']),
                 'strairx': (2, ['longitude', 'latitude', 'time']),
                 'strairy': (2, ['longitude', 'latitude', 'time']),
                 'streng': (2, ['longitude', 'latitude', 'time']),
                 'strocnx': (2, ['longitude', 'latitude', 'time']),
                 'strocny': (2, ['longitude', 'latitude', 'time']),
                 'tmelt': (1, ['longitude', 'latitude', 'time']),
                 'transifs': (2, ['time']),
                 'transix': (1, ['longitude', 'latitude', 'time']),
                 'transiy': (1, ['longitude', 'latitude', 'time']),
                 'tsice': (1, ['longitude', 'latitude', 'time']),
                 'tsnint': (1, ['longitude', 'latitude', 'time'])},
    'omon': {   'agessc': (3, ['longitude', 'latitude', 'olevel', 'time']),
                'arag': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'bacc': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'bfe': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'bsi': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'calc': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'cfc11': (3, ['longitude', 'latitude', 'olevel', 'time']),
                'chl': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'chlcalc': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'chldiat': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'chldiaz': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'chlmisc': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'chlpico': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'co3': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'co3satarag': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'co3satcalc': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'detoc': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'dfe': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'dissic': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'dissoc': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'dms': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'dpco2': (3, ['longitude', 'latitude', 'time']),
                'dpo2': (3, ['longitude', 'latitude', 'time']),
                'eparag100': (1, ['longitude', 'latitude', 'time', 'depth100m']),
                'epc100': (1, ['longitude', 'latitude', 'time', 'depth100m']),
                'epcalc100': (1, ['longitude', 'latitude', 'time', 'depth100m']),
                'epfe100': (3, ['longitude', 'latitude', 'time', 'depth100m']),
                'epsi100': (3, ['longitude', 'latitude', 'time', 'depth100m']),
                'evs': (2, ['longitude', 'latitude', 'time']),
                'fbddtalk': (3, ['longitude', 'latitude', 'time', 'olayer100m']),
                'fbddtdic': (3, ['longitude', 'latitude', 'time', 'olayer100m']),
                'fbddtdife': (3, ['longitude', 'latitude', 'time', 'olayer100m']),
                'fbddtdin': (3, ['longitude', 'latitude', 'time', 'olayer100m']),
                'fbddtdip': (3, ['longitude', 'latitude', 'time', 'olayer100m']),
                'fbddtdisi': (3, ['longitude', 'latitude', 'time', 'olayer100m']),
                'fddtalk': (3, ['longitude', 'latitude', 'time', 'olayer100m']),
                'fddtdic': (3, ['longitude', 'latitude', 'time', 'olayer100m']),
                'fddtdife': (3, ['longitude', 'latitude', 'time', 'olayer100m']),
                'fddtdin': (3, ['longitude', 'latitude', 'time', 'olayer100m']),
                'fddtdip': (3, ['longitude', 'latitude', 'time', 'olayer100m']),
                'fddtdisi': (3, ['longitude', 'latitude', 'time', 'olayer100m']),
                'fgco2': (1, ['longitude', 'latitude', 'time']),
                'fgdms': (3, ['longitude', 'latitude', 'time']),
                'fgo2': (1, ['longitude', 'latitude', 'time']),
                'ficeberg': (2, ['longitude', 'latitude', 'olevel', 'time']),
                'frc': (3, ['longitude', 'latitude', 'time']),
                'frfe': (3, ['longitude', 'latitude', 'time']),
                'friver': (2, ['longitude', 'latitude', 'time']),
                'frn': (3, ['longitude', 'latitude', 'time']),
                'fsc': (3, ['longitude', 'latitude', 'time']),
                'fsfe': (3, ['longitude', 'latitude', 'time']),
                'fsitherm': (1, ['longitude', 'latitude', 'time']),
                'fsn': (3, ['longitude', 'latitude', 'time']),
                'hfbasin': (2, ['latitude', 'basin', 'time']),
                'hfbasinba': (3, ['latitude', 'basin', 'time']),
                'hfbasindiff': (3, ['latitude', 'basin', 'time']),
                'hfcorr': (2, ['longitude', 'latitude', 'time']),
                'hfds': (1, ['longitude', 'latitude', 'time']),
                'hfevapds': (2, ['longitude', 'latitude', 'time']),
                'hfgeou': (2, ['longitude', 'latitude', 'time']),
                'hfibthermds': (2, ['longitude', 'latitude', 'olevel', 'time']),
                'hfls': (2, ['longitude', 'latitude', 'time']),
                'hfnorth': (2, ['longitude', 'latitude', 'time']),
                'hfnorthba': (3, ['longitude', 'latitude', 'time']),
                'hfnorthdiff': (3, ['longitude', 'latitude', 'time']),
                'hfrainds': (2, ['longitude', 'latitude', 'time']),
                'hfrunoffds': (2, ['longitude', 'latitude', 'olevel', 'time']),
                'hfsifrazil': (1, ['longitude', 'latitude', 'olevel', 'time']),
                'hfsithermds': (1, ['longitude', 'latitude', 'olevel', 'time']),
                'hfsnthermds': (2, ['longitude', 'latitude', 'olevel', 'time']),
                'hfss': (2, ['longitude', 'latitude', 'time']),
                'hfx': (2, ['longitude', 'latitude', 'time']),
                'hfxba': (3, ['longitude', 'latitude', 'time']),
                'hfxdiff': (3, ['longitude', 'latitude', 'time']),
                'hfy': (2, ['longitude', 'latitude', 'time']),
                'hfyba': (3, ['longitude', 'latitude', 'time']),
                'hfydiff': (3, ['longitude', 'latitude', 'time']),
                'htovgyre': (2, ['latitude', 'basin', 'time']),
                'htovovrt': (2, ['latitude', 'basin', 'time']),
                'intdic': (2, ['longitude', 'latitude', 'time']),
                'intparag': (3, ['longitude', 'latitude', 'time']),
                'intpbfe': (3, ['longitude', 'latitude', 'time']),
                'intpbsi': (3, ['longitude', 'latitude', 'time']),
                'intpcalc': (3, ['longitude', 'latitude', 'time']),
                'intpcalcite': (3, ['longitude', 'latitude', 'time']),
                'intpdiat': (2, ['longitude', 'latitude', 'time']),
                'intpdiaz': (3, ['longitude', 'latitude', 'time']),
                'intpmisc': (3, ['longitude', 'latitude', 'time']),
                'intpn2': (3, ['longitude', 'latitude', 'time']),
                'intpnitrate': (2, ['longitude', 'latitude', 'time']),
                'intpp': (1, ['longitude', 'latitude', 'time']),
                'intppico': (3, ['longitude', 'latitude', 'time']),
                'masscello': (1, ['longitude', 'latitude', 'olevel', 'time']),
                'masso': (1, ['time']),
                'mfo': (2, ['oline', 'time']),
                'mlotst': (3, ['longitude', 'latitude', 'time']),
                'mlotstsq': (3, ['longitude', 'latitude', 'time']),
                'msftbarot': (3, ['longitude', 'latitude', 'time']),
                'msftmrhoz': (2, ['latitude', 'rho', 'basin', 'time']),
                'msftmrhozba': (3, ['latitude', 'rho', 'basin', 'time']),
                'msftmyz': (2, ['latitude', 'olevel', 'basin', 'time']),
                'msftmyzba': (3, ['latitude', 'olevel', 'basin', 'time']),
                'msftyrhoz': (2, ['latitude', 'rho', 'basin', 'time']),
                'msftyrhozba': (3, ['latitude', 'rho', 'basin', 'time']),
                'msftyyz': (2, ['latitude', 'olevel', 'basin', 'time']),
                'msftyyzba': (3, ['latitude', 'olevel', 'basin', 'time']),
                'nh4': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'no3': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'o2': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'o2min': (3, ['longitude', 'latitude', 'time']),
                'omldamax': (3, ['longitude', 'latitude', 'time']),
                'omlmax': (3, ['longitude', 'latitude', 'time']),
                'pbo': (1, ['longitude', 'latitude', 'time']),
                'ph': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'phyc': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'phycalc': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'phydiat': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'phydiaz': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'phyfe': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'phymisc': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'phyn': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'phyp': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'phypico': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'physi': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'po4': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'pon': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'pop': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'pr': (2, ['longitude', 'latitude', 'time']),
                'prsn': (2, ['longitude', 'latitude', 'time']),
                'pso': (2, ['longitude', 'latitude', 'time']),
                'rhopoto': (3, ['longitude', 'latitude', 'olevel', 'time']),
                'rlds': (2, ['longitude', 'latitude', 'time']),
                'rsds': (2, ['longitude', 'latitude', 'olevel', 'time']),
                'rsntds': (2, ['longitude', 'latitude', 'time']),
                'sfdsi': (1, ['longitude', 'latitude', 'time']),
                'sfriver': (2, ['longitude', 'latitude', 'time']),
                'si': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'sltovgyre': (2, ['latitude', 'basin', 'time']),
                'sltovovrt': (2, ['latitude', 'basin', 'time']),
                'so': (1, ['longitude', 'latitude', 'olevel', 'time']),
                'soga': (1, ['time']),
                'sos': (2, ['longitude', 'latitude', 'time']),
                'spco2': (1, ['longitude', 'latitude', 'time']),
                'talk': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'tauucorr': (2, ['longitude', 'latitude', 'time']),
                'tauuo': (2, ['longitude', 'latitude', 'time']),
                'tauvcorr': (2, ['longitude', 'latitude', 'time']),
                'tauvo': (2, ['longitude', 'latitude', 'time']),
                'thetao': (1, ['longitude', 'latitude', 'olevel', 'time']),
                'thetaoga': (1, ['time']),
                'thkcello': (1, ['longitude', 'latitude', 'olevel', 'time']),
                'tos': (2, ['longitude', 'latitude', 'time']),
                'tossq': (3, ['longitude', 'latitude', 'time']),
                'umo': (2, ['longitude', 'latitude', 'olevel', 'time']),
                'uo': (1, ['longitude', 'latitude', 'olevel', 'time']),
                'vmo': (2, ['longitude', 'latitude', 'olevel', 'time']),
                'vo': (1, ['longitude', 'latitude', 'olevel', 'time']),
                'volo': (1, ['time']),
                'vsf': (2, ['longitude', 'latitude', 'time']),
                'vsfcorr': (2, ['longitude', 'latitude', 'time']),
                'vsfevap': (2, ['longitude', 'latitude', 'time']),
                'vsfpr': (2, ['longitude', 'latitude', 'time']),
                'vsfriver': (2, ['longitude', 'latitude', 'time']),
                'vsfsit': (1, ['longitude', 'latitude', 'time']),
                'wfcorr': (2, ['longitude', 'latitude', 'time']),
                'wfo': (2, ['longitude', 'latitude', 'time']),
                'wfonocorr': (2, ['longitude', 'latitude', 'time']),
                'wmo': (1, ['longitude', 'latitude', 'olevel', 'time']),
                'wmosq': (1, ['longitude', 'latitude', 'olevel', 'time']),
                'zfull': (1, ['longitude', 'latitude', 'olevel', 'time']),
                'zhalf': (1, ['longitude', 'latitude', 'olevel', 'time']),
                'zmeso': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'zmicro': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'zo2min': (3, ['longitude', 'latitude', 'time']),
                'zooc': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'zoocmisc': (2, ['longitude', 'latitude', 'time', 'depth0m']),
                'zos': (1, ['longitude', 'latitude', 'time']),
                'zosga': (1, ['time']),
                'zossga': (1, ['time']),
                'zossq': (3, ['longitude', 'latitude', 'time']),
                'zostoga': (1, ['time']),
                'zsatarag': (3, ['longitude', 'latitude', 'time']),
                'zsatcalc': (3, ['longitude', 'latitude', 'time'])},
    'oyr': {   'arag': (2, ['longitude', 'latitude', 'olevel', 'time']),
               'bacc': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'bddtalk': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'bddtdic': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'bddtdife': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'bddtdin': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'bddtdip': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'bddtdisi': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'bfe': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'bsi': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'calc': (2, ['longitude', 'latitude', 'olevel', 'time']),
               'chl': (1, ['longitude', 'latitude', 'olevel', 'time']),
               'chlcalc': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'chldiat': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'chldiaz': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'chlmisc': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'chlpico': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'co3': (2, ['longitude', 'latitude', 'olevel', 'time']),
               'co3satarag': (2, ['longitude', 'latitude', 'olevel', 'time']),
               'co3satcalc': (2, ['longitude', 'latitude', 'olevel', 'time']),
               'darag': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'dcalc': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'detoc': (2, ['longitude', 'latitude', 'olevel', 'time']),
               'dfe': (1, ['longitude', 'latitude', 'olevel', 'time']),
               'dissic': (1, ['longitude', 'latitude', 'olevel', 'time']),
               'dissoc': (2, ['longitude', 'latitude', 'olevel', 'time']),
               'dms': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'dpocdtcalc': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'dpocdtdiaz': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'dpocdtpico': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'exparag': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'expc': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'expcalc': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'expcfe': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'expn': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'expp': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'expsi': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'fediss': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'fescav': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'graz': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'nh4': (2, ['longitude', 'latitude', 'olevel', 'time']),
               'no3': (1, ['longitude', 'latitude', 'olevel', 'time']),
               'o2': (1, ['longitude', 'latitude', 'olevel', 'time']),
               'parag': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'pbfe': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'pbsi': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'pcalc': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'pdi': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'ph': (1, ['longitude', 'latitude', 'olevel', 'time']),
               'phyc': (2, ['longitude', 'latitude', 'olevel', 'time']),
               'phycalc': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'phydiat': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'phydiaz': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'phyfe': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'phymisc': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'phyn': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'phyp': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'phypico': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'phypmisc': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'physi': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'pnitrate': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'po4': (1, ['longitude', 'latitude', 'olevel', 'time']),
               'pon': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'pop': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'pp': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'si': (1, ['longitude', 'latitude', 'olevel', 'time']),
               'talk': (1, ['longitude', 'latitude', 'olevel', 'time']),
               'zfull': (1, ['longitude', 'latitude', 'olevel', 'time']),
               'zhalf': (1, ['longitude', 'latitude', 'olevel', 'time']),
               'zmeso': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'zmicro': (3, ['longitude', 'latitude', 'olevel', 'time']),
               'zooc': (2, ['longitude', 'latitude', 'olevel', 'time']),
               'zoocmisc': (3, ['longitude', 'latitude', 'olevel', 'time'])}}

# requested_time : cmor_table => { experiment => ['abs' | 'rel' | 'cor', time_ranges]}
requested_time = {   '3hr': {   '1pctco2': ['cor', []],
               'abrupt4xco2': ['cor', []],
               'esmhistorical': ['abs', [(1960, 2005)]],
               'esmrcp85': ['abs', [(2026, 2045), (2081, 2100)]],
               'historical': ['abs', [(1960, 2005)]],
               'picontrol': ['rel', [(50, 80), (110, 140)]],
               'rcp26': ['abs', [(2026, 2045), (2081, 2100), (2181, 2200), (2281, 2300)]],
               'rcp45': ['abs', [(2026, 2045), (2081, 2100), (2181, 2200), (2281, 2300)]],
               'rcp60': ['abs', [(2026, 2045), (2081, 2100)]],
               'rcp85': ['abs', [(2026, 2045), (2081, 2100), (2181, 2200), (2281, 2300)]]},
    '6hrplev': {   'historical': ['abs', [(1950, 2005)]],
                   'lgm': ['cor', []],
                   'midholocene': ['cor', []],
                   'picontrol': ['rel', [(50, 80), (110, 140)]],
                   'rcp45': ['abs', [(2000, 2100)]],
                   'rcp85': ['abs', [(2000, 2100)]]},
    'aero': {   'amip': ['abs', [(1980, 1980), (1990, 1990), (2000, 2000), (2010, 2010)]],
                'decadal_10': ['base', [(10, 10)]],
                'decadal_30': ['base', [(10, 10), (20, 20), (30, 30)]],
                'decadalxxxx': ['base', [(10, 10)]],
                'esmcontrol': [   'rel',
                                  [   (1850, 1850),
                                      (1870, 1870),
                                      (1890, 1890),
                                      (1910, 1910),
                                      (1930, 1930),
                                      (1950, 1950),
                                      (1960, 1960),
                                      (1970, 1970),
                                      (1980, 1980),
                                      (1990, 1990),
                                      (2000, 2000),
                                      (2010, 2010),
                                      (2020, 2020),
                                      (2040, 2040),
                                      (2060, 2060),
                                      (2080, 2080),
                                      (2100, 2100)]],
                'esmhistorical': [   'abs',
                                     [   (1850, 1850),
                                         (1870, 1870),
                                         (1890, 1890),
                                         (1910, 1910),
                                         (1930, 1930),
                                         (1950, 1950),
                                         (1960, 1960),
                                         (1970, 1970),
                                         (1980, 1980),
                                         (1990, 1990),
                                         (2000, 2000)]],
                'esmrcp85': [   'abs',
                                [(2010, 2010), (2020, 2020), (2040, 2040), (2060, 2060), (2080, 2080), (2100, 2100)]],
                'historical': [   'abs',
                                  [   (1850, 1850),
                                      (1870, 1870),
                                      (1890, 1890),
                                      (1910, 1910),
                                      (1930, 1930),
                                      (1950, 1950),
                                      (1960, 1960),
                                      (1970, 1970),
                                      (1980, 1980),
                                      (1990, 1990),
                                      (2000, 2000)]],
                'novolcano': ['abs', [(2010, 2010), (2011, 2011), (2012, 2012)]],
                'picontrol': ['rel', [(50, 80), (110, 140)]],
                'rcp26': [   'abs',
                             [(2010, 2010), (2020, 2020), (2040, 2040), (2060, 2060), (2080, 2080), (2100, 2100)]],
                'rcp45': [   'abs',
                             [(2010, 2010), (2020, 2020), (2040, 2040), (2060, 2060), (2080, 2080), (2100, 2100)]],
                'rcp60': [   'abs',
                             [(2010, 2010), (2020, 2020), (2040, 2040), (2060, 2060), (2080, 2080), (2100, 2100)]],
                'rcp85': [   'abs',
                             [(2010, 2010), (2020, 2020), (2040, 2040), (2060, 2060), (2080, 2080), (2100, 2100)]],
                'sst2030': ['abs', [(2035, 2035)]],
                'volcano2010': ['abs', [(10, 10)]]},
    'day': {   'esmcontrol': ['rel', [(1986, 2005)]],
               'esmhistorical': ['abs', [(1950, 2005)]],
               'historical': ['abs', [(1950, 2005)]],
               'picontrol': ['rel', [(50, 80), (110, 140)]],
               'rcp26': ['abs', [(2000, 2100), (2181, 2200), (2281, 2300)]],
               'rcp45': ['abs', [(2000, 2100), (2181, 2200), (2281, 2300)]],
               'rcp85': ['abs', [(2000, 2100), (2181, 2200), (2281, 2300)]]}}
