from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel

VTK_FILE_BYTE_ORDER_BIG_ENDIAN:int
VTK_FILE_BYTE_ORDER_LITTLE_ENDIAN:int

class vtkImageReader2(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    data_byte_order:'getset_descriptor'
    data_direction:'getset_descriptor'
    data_extent:'getset_descriptor'
    data_increments:'getset_descriptor'
    data_origin:'getset_descriptor'
    data_scalar_type:'getset_descriptor'
    data_spacing:'getset_descriptor'
    descriptive_name:'getset_descriptor'
    file_dimensionality:'getset_descriptor'
    file_extensions:'getset_descriptor'
    file_lower_left:'getset_descriptor'
    file_name:'getset_descriptor'
    file_name_slice_offset:'getset_descriptor'
    file_name_slice_spacing:'getset_descriptor'
    file_names:'getset_descriptor'
    file_pattern:'getset_descriptor'
    file_prefix:'getset_descriptor'
    header_size:'getset_descriptor'
    internal_file_name:'getset_descriptor'
    memory_buffer:'getset_descriptor'
    memory_buffer_length:'getset_descriptor'
    number_of_scalar_components:'getset_descriptor'
    swap_bytes:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CanReadFile(self, fname:str) -> int: ...
    def CloseFile(self) -> None: ...
    def ComputeInternalFileName(self, slice:int) -> None: ...
    def FileLowerLeftOff(self) -> None: ...
    def FileLowerLeftOn(self) -> None: ...
    def GetDataByteOrder(self) -> int: ...
    def GetDataByteOrderAsString(self) -> str: ...
    def GetDataDirection(self) -> Tuple[float, float, float, float, float, float, float, float, float]: ...
    def GetDataExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetDataIncrements(self) -> Tuple[int, int, int, int]: ...
    def GetDataOrigin(self) -> Tuple[float, float, float]: ...
    def GetDataScalarType(self) -> int: ...
    def GetDataSpacing(self) -> Tuple[float, float, float]: ...
    def GetDescriptiveName(self) -> str: ...
    def GetFileDimensionality(self) -> int: ...
    def GetFileExtensions(self) -> str: ...
    def GetFileLowerLeft(self) -> int: ...
    def GetFileName(self) -> str: ...
    def GetFileNameSliceOffset(self) -> int: ...
    def GetFileNameSliceSpacing(self) -> int: ...
    def GetFileNames(self) -> 'vtkStringArray': ...
    def GetFilePattern(self) -> str: ...
    def GetFilePrefix(self) -> str: ...
    @overload
    def GetHeaderSize(self) -> int: ...
    @overload
    def GetHeaderSize(self, slice:int) -> int: ...
    def GetInternalFileName(self) -> str: ...
    def GetMemoryBuffer(self) -> Pointer: ...
    def GetMemoryBufferLength(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfScalarComponents(self) -> int: ...
    def GetSwapBytes(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageReader2': ...
    def OpenFile(self) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageReader2': ...
    def SeekFile(self, i:int, j:int, k:int) -> None: ...
    def SetDataByteOrder(self, __a:int) -> None: ...
    def SetDataByteOrderToBigEndian(self) -> None: ...
    def SetDataByteOrderToLittleEndian(self) -> None: ...
    def SetDataDirection(self, data:Sequence[float]) -> None: ...
    @overload
    def SetDataExtent(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetDataExtent(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetDataOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDataOrigin(self, _arg:Sequence[float]) -> None: ...
    def SetDataScalarType(self, type:int) -> None: ...
    def SetDataScalarTypeToChar(self) -> None: ...
    def SetDataScalarTypeToDouble(self) -> None: ...
    def SetDataScalarTypeToFloat(self) -> None: ...
    def SetDataScalarTypeToInt(self) -> None: ...
    def SetDataScalarTypeToShort(self) -> None: ...
    def SetDataScalarTypeToSignedChar(self) -> None: ...
    def SetDataScalarTypeToUnsignedChar(self) -> None: ...
    def SetDataScalarTypeToUnsignedInt(self) -> None: ...
    def SetDataScalarTypeToUnsignedShort(self) -> None: ...
    @overload
    def SetDataSpacing(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDataSpacing(self, _arg:Sequence[float]) -> None: ...
    def SetFileDimensionality(self, _arg:int) -> None: ...
    def SetFileLowerLeft(self, _arg:int) -> None: ...
    def SetFileName(self, __a:str) -> None: ...
    def SetFileNameSliceOffset(self, _arg:int) -> None: ...
    def SetFileNameSliceSpacing(self, _arg:int) -> None: ...
    def SetFileNames(self, __a:'vtkStringArray') -> None: ...
    def SetFilePattern(self, __a:str) -> None: ...
    def SetFilePrefix(self, __a:str) -> None: ...
    def SetHeaderSize(self, size:int) -> None: ...
    def SetMemoryBuffer(self, __a:Pointer) -> None: ...
    def SetMemoryBufferLength(self, buflen:int) -> None: ...
    def SetNumberOfScalarComponents(self, _arg:int) -> None: ...
    def SetSwapBytes(self, _arg:int) -> None: ...
    def SwapBytesOff(self) -> None: ...
    def SwapBytesOn(self) -> None: ...

class vtkImageReader(vtkImageReader2):
    data_mask:'getset_descriptor'
    data_voi:'getset_descriptor'
    scalar_array_name:'getset_descriptor'
    transform:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CanReadFile(self, __a:str) -> int: ...
    def ComputeInverseTransformedExtent(self, inExtent:MutableSequence[int], outExtent:MutableSequence[int]) -> None: ...
    def ComputeInverseTransformedIncrements(self, inIncr:MutableSequence[int], outIncr:MutableSequence[int]) -> None: ...
    def GetDataMask(self) -> int: ...
    def GetDataVOI(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScalarArrayName(self) -> str: ...
    def GetTransform(self) -> 'vtkTransform': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageReader': ...
    def OpenAndSeekFile(self, extent:MutableSequence[int], slice:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageReader': ...
    def SetDataMask(self, _arg:int) -> None: ...
    @overload
    def SetDataVOI(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetDataVOI(self, _arg:Sequence[int]) -> None: ...
    def SetScalarArrayName(self, _arg:str) -> None: ...
    def SetTransform(self, __a:'vtkTransform') -> None: ...

class vtkBMPReader(vtkImageReader):
    allow8_bit_bmp:'getset_descriptor'
    colors:'getset_descriptor'
    depth:'getset_descriptor'
    descriptive_name:'getset_descriptor'
    file_extensions:'getset_descriptor'
    lookup_table:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Allow8BitBMPOff(self) -> None: ...
    def Allow8BitBMPOn(self) -> None: ...
    def CanReadFile(self, fname:str) -> int: ...
    def GetAllow8BitBMP(self) -> int: ...
    def GetColors(self) -> Pointer: ...
    def GetDepth(self) -> int: ...
    def GetDescriptiveName(self) -> str: ...
    def GetFileExtensions(self) -> str: ...
    def GetLookupTable(self) -> 'vtkLookupTable': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBMPReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBMPReader': ...
    def SetAllow8BitBMP(self, _arg:int) -> None: ...

class vtkImageWriter(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    file_dimensionality:'getset_descriptor'
    file_name:'getset_descriptor'
    file_pattern:'getset_descriptor'
    file_prefix:'getset_descriptor'
    input:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def DeleteFiles(self) -> None: ...
    def GetFileDimensionality(self) -> int: ...
    def GetFileName(self) -> str: ...
    def GetFilePattern(self) -> str: ...
    def GetFilePrefix(self) -> str: ...
    def GetInput(self) -> 'vtkImageData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageWriter': ...
    def SetFileDimensionality(self, _arg:int) -> None: ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetFilePattern(self, _arg:str) -> None: ...
    def SetFilePrefix(self, _arg:str) -> None: ...
    def Write(self) -> None: ...

class vtkBMPWriter(vtkImageWriter):
    result:'getset_descriptor'
    write_to_memory:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetResult(self) -> 'vtkUnsignedCharArray': ...
    def GetWriteToMemory(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBMPWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBMPWriter': ...
    def SetResult(self, __a:'vtkUnsignedCharArray') -> None: ...
    def SetWriteToMemory(self, _arg:int) -> None: ...
    def WriteToMemoryOff(self) -> None: ...
    def WriteToMemoryOn(self) -> None: ...

class vtkDEMReader(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    REFERENCE_ELEVATION_BOUNDS:int
    REFERENCE_SEA_LEVEL:int
    accuracy_code:'getset_descriptor'
    dem_level:'getset_descriptor'
    elevation_bounds:'getset_descriptor'
    elevation_pattern:'getset_descriptor'
    elevation_reference:'getset_descriptor'
    elevation_unit_of_measure:'getset_descriptor'
    file_name:'getset_descriptor'
    ground_system:'getset_descriptor'
    ground_zone:'getset_descriptor'
    local_rotation:'getset_descriptor'
    map_label:'getset_descriptor'
    plane_unit_of_measure:'getset_descriptor'
    polygon_size:'getset_descriptor'
    profile_dimension:'getset_descriptor'
    projection_parameters:'getset_descriptor'
    spatial_resolution:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetAccuracyCode(self) -> int: ...
    def GetDEMLevel(self) -> int: ...
    def GetElevationBounds(self) -> Tuple[float, float]: ...
    def GetElevationPattern(self) -> int: ...
    def GetElevationReference(self) -> int: ...
    def GetElevationReferenceAsString(self) -> str: ...
    def GetElevationReferenceMaxValue(self) -> int: ...
    def GetElevationReferenceMinValue(self) -> int: ...
    def GetElevationUnitOfMeasure(self) -> int: ...
    def GetFileName(self) -> str: ...
    def GetGroundSystem(self) -> int: ...
    def GetGroundZone(self) -> int: ...
    def GetLocalRotation(self) -> float: ...
    def GetMapLabel(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlaneUnitOfMeasure(self) -> int: ...
    def GetPolygonSize(self) -> int: ...
    def GetProfileDimension(self) -> Tuple[int, int]: ...
    def GetProjectionParameters(self) -> Tuple[float, float, float, float, float, float, float, float, float, float, float, float, float, float, float]: ...
    def GetSpatialResolution(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDEMReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDEMReader': ...
    def SetElevationReference(self, _arg:int) -> None: ...
    def SetElevationReferenceToElevationBounds(self) -> None: ...
    def SetElevationReferenceToSeaLevel(self) -> None: ...
    def SetFileName(self, _arg:str) -> None: ...

class vtkDICOMImageReader(vtkImageReader2):
    bits_allocated:'getset_descriptor'
    descriptive_name:'getset_descriptor'
    directory_name:'getset_descriptor'
    file_extensions:'getset_descriptor'
    file_name:'getset_descriptor'
    gantry_angle:'getset_descriptor'
    height:'getset_descriptor'
    image_orientation_patient:'getset_descriptor'
    image_position_patient:'getset_descriptor'
    number_of_components:'getset_descriptor'
    patient_name:'getset_descriptor'
    pixel_representation:'getset_descriptor'
    pixel_spacing:'getset_descriptor'
    rescale_offset:'getset_descriptor'
    rescale_slope:'getset_descriptor'
    study_id:'getset_descriptor'
    study_uid:'getset_descriptor'
    transfer_syntax_uid:'getset_descriptor'
    width:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CanReadFile(self, fname:str) -> int: ...
    def GetBitsAllocated(self) -> int: ...
    def GetDescriptiveName(self) -> str: ...
    def GetDirectoryName(self) -> str: ...
    def GetFileExtensions(self) -> str: ...
    def GetGantryAngle(self) -> float: ...
    def GetHeight(self) -> int: ...
    def GetImageOrientationPatient(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetImagePositionPatient(self) -> Tuple[float, float, float]: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPatientName(self) -> str: ...
    def GetPixelRepresentation(self) -> int: ...
    def GetPixelSpacing(self) -> Tuple[float, float, float]: ...
    def GetRescaleOffset(self) -> float: ...
    def GetRescaleSlope(self) -> float: ...
    def GetStudyID(self) -> str: ...
    def GetStudyUID(self) -> str: ...
    def GetTransferSyntaxUID(self) -> str: ...
    def GetWidth(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDICOMImageReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDICOMImageReader': ...
    def SetDirectoryName(self, dn:str) -> None: ...
    def SetFileName(self, fn:str) -> None: ...

class vtkMedicalImageReader2(vtkImageReader2):
    date:'getset_descriptor'
    image_number:'getset_descriptor'
    medical_image_properties:'getset_descriptor'
    modality:'getset_descriptor'
    patient_id:'getset_descriptor'
    patient_name:'getset_descriptor'
    series:'getset_descriptor'
    study:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDate(self) -> str: ...
    def GetImageNumber(self) -> str: ...
    def GetMedicalImageProperties(self) -> 'vtkMedicalImageProperties': ...
    def GetModality(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPatientID(self) -> str: ...
    def GetPatientName(self) -> str: ...
    def GetSeries(self) -> str: ...
    def GetStudy(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMedicalImageReader2': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMedicalImageReader2': ...
    def SetDate(self, __a:str) -> None: ...
    def SetImageNumber(self, __a:str) -> None: ...
    def SetModality(self, __a:str) -> None: ...
    def SetPatientID(self, __a:str) -> None: ...
    def SetPatientName(self, __a:str) -> None: ...
    def SetSeries(self, __a:str) -> None: ...
    def SetStudy(self, __a:str) -> None: ...

class vtkGESignaReader(vtkMedicalImageReader2):
    descriptive_name:'getset_descriptor'
    file_extensions:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CanReadFile(self, fname:str) -> int: ...
    def GetDescriptiveName(self) -> str: ...
    def GetFileExtensions(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGESignaReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGESignaReader': ...

class vtkHDRReader(vtkImageReader):
    class FormatType(int): ...
    FORMAT_32BIT_RLE_RGBE:'FormatType'
    FORMAT_32BIT_RLE_XYZE:'FormatType'
    descriptive_name:'getset_descriptor'
    exposure:'getset_descriptor'
    file_extensions:'getset_descriptor'
    format:'getset_descriptor'
    gamma:'getset_descriptor'
    pixel_aspect:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CanReadFile(self, fname:str) -> int: ...
    def GetDescriptiveName(self) -> str: ...
    def GetExposure(self) -> float: ...
    def GetFileExtensions(self) -> str: ...
    def GetFormat(self) -> int: ...
    def GetGamma(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPixelAspect(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHDRReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHDRReader': ...

class vtkImageExport(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    callback_user_data:'getset_descriptor'
    data_dimensions:'getset_descriptor'
    data_direction:'getset_descriptor'
    data_extent:'getset_descriptor'
    data_memory_size:'getset_descriptor'
    data_number_of_scalar_components:'getset_descriptor'
    data_origin:'getset_descriptor'
    data_scalar_type:'getset_descriptor'
    data_spacing:'getset_descriptor'
    export_void_pointer:'getset_descriptor'
    image_lower_left:'getset_descriptor'
    input:'getset_descriptor'
    pointer_to_data:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def Export(self) -> None: ...
    @overload
    def Export(self, __a:Pointer) -> None: ...
    def GetCallbackUserData(self) -> Pointer: ...
    @overload
    def GetDataDimensions(self, ptr:MutableSequence[int]) -> None: ...
    @overload
    def GetDataDimensions(self) -> Tuple[int, int, int]: ...
    @overload
    def GetDataDirection(self) -> Tuple[float, float, float, float, float, float, float, float, float]: ...
    @overload
    def GetDataDirection(self, ptr:MutableSequence[float]) -> None: ...
    @overload
    def GetDataExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    @overload
    def GetDataExtent(self, ptr:MutableSequence[int]) -> None: ...
    def GetDataMemorySize(self) -> int: ...
    def GetDataNumberOfScalarComponents(self) -> int: ...
    @overload
    def GetDataOrigin(self) -> Tuple[float, float, float]: ...
    @overload
    def GetDataOrigin(self, ptr:MutableSequence[float]) -> None: ...
    def GetDataScalarType(self) -> int: ...
    def GetDataScalarTypeAsString(self) -> str: ...
    @overload
    def GetDataSpacing(self) -> Tuple[float, float, float]: ...
    @overload
    def GetDataSpacing(self, ptr:MutableSequence[float]) -> None: ...
    def GetExportVoidPointer(self) -> Pointer: ...
    def GetImageLowerLeft(self) -> int: ...
    def GetInput(self) -> 'vtkImageData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointerToData(self) -> Pointer: ...
    def ImageLowerLeftOff(self) -> None: ...
    def ImageLowerLeftOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageExport': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageExport': ...
    def SetExportVoidPointer(self, __a:Pointer) -> None: ...
    def SetImageLowerLeft(self, _arg:int) -> None: ...

class vtkImageImport(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    callback_user_data:'getset_descriptor'
    data_direction:'getset_descriptor'
    data_extent:'getset_descriptor'
    data_origin:'getset_descriptor'
    data_scalar_type:'getset_descriptor'
    data_spacing:'getset_descriptor'
    import_void_pointer:'getset_descriptor'
    number_of_scalar_components:'getset_descriptor'
    scalar_array_name:'getset_descriptor'
    whole_extent:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CopyImportVoidPointer(self, ptr:Pointer, size:int) -> None: ...
    def GetCallbackUserData(self) -> Pointer: ...
    def GetDataDirection(self) -> Tuple[float, float, float, float, float, float, float, float, float]: ...
    def GetDataExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetDataOrigin(self) -> Tuple[float, float, float]: ...
    def GetDataScalarType(self) -> int: ...
    def GetDataScalarTypeAsString(self) -> str: ...
    def GetDataSpacing(self) -> Tuple[float, float, float]: ...
    def GetImportVoidPointer(self) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfScalarComponents(self) -> int: ...
    def GetScalarArrayName(self) -> str: ...
    def GetWholeExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def InvokeExecuteDataCallbacks(self) -> None: ...
    def InvokeExecuteInformationCallbacks(self) -> None: ...
    def InvokePipelineModifiedCallbacks(self) -> int: ...
    def InvokeUpdateInformationCallbacks(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LegacyCheckWholeExtent(self) -> None: ...
    def NewInstance(self) -> 'vtkImageImport': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageImport': ...
    def SetCallbackUserData(self, _arg:Pointer) -> None: ...
    def SetDataDirection(self, data:Sequence[float]) -> None: ...
    @overload
    def SetDataExtent(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetDataExtent(self, _arg:Sequence[int]) -> None: ...
    def SetDataExtentToWholeExtent(self) -> None: ...
    @overload
    def SetDataOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDataOrigin(self, _arg:Sequence[float]) -> None: ...
    def SetDataScalarType(self, _arg:int) -> None: ...
    def SetDataScalarTypeToDouble(self) -> None: ...
    def SetDataScalarTypeToFloat(self) -> None: ...
    def SetDataScalarTypeToInt(self) -> None: ...
    def SetDataScalarTypeToShort(self) -> None: ...
    def SetDataScalarTypeToUnsignedChar(self) -> None: ...
    def SetDataScalarTypeToUnsignedShort(self) -> None: ...
    @overload
    def SetDataSpacing(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDataSpacing(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetImportVoidPointer(self, ptr:Pointer) -> None: ...
    @overload
    def SetImportVoidPointer(self, ptr:Pointer, save:int) -> None: ...
    def SetNumberOfScalarComponents(self, _arg:int) -> None: ...
    def SetScalarArrayName(self, _arg:str) -> None: ...
    @overload
    def SetWholeExtent(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetWholeExtent(self, _arg:Sequence[int]) -> None: ...

class vtkImageImportExecutive(vtkmodules.vtkCommonExecutionModel.vtkStreamingDemandDrivenPipeline):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageImportExecutive': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageImportExecutive': ...

class vtkImageReader2Collection(vtkmodules.vtkCommonCore.vtkCollection):
    next_item:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddItem(self, __a:'vtkImageReader2') -> None: ...
    def GetNextItem(self) -> 'vtkImageReader2': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageReader2Collection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageReader2Collection': ...

class vtkImageReader2Factory(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def CheckExtensionIsInExtensions(extension:str, extensions:str) -> bool: ...
    @staticmethod
    def CreateImageReader2(path:str) -> 'vtkImageReader2': ...
    @staticmethod
    def CreateImageReader2FromExtension(extension:str) -> 'vtkImageReader2': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetRegisteredReaders(__a:'vtkImageReader2Collection') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageReader2Factory': ...
    @staticmethod
    def RegisterReader(r:'vtkImageReader2') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageReader2Factory': ...

class vtkJPEGReader(vtkImageReader2):
    descriptive_name:'getset_descriptor'
    file_extensions:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CanReadFile(self, fname:str) -> int: ...
    def GetDescriptiveName(self) -> str: ...
    def GetFileExtensions(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkJPEGReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkJPEGReader': ...

class vtkJPEGWriter(vtkImageWriter):
    progressive:'getset_descriptor'
    quality:'getset_descriptor'
    result:'getset_descriptor'
    write_to_memory:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProgressive(self) -> int: ...
    def GetQuality(self) -> int: ...
    def GetQualityMaxValue(self) -> int: ...
    def GetQualityMinValue(self) -> int: ...
    def GetResult(self) -> 'vtkUnsignedCharArray': ...
    def GetWriteToMemory(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkJPEGWriter': ...
    def ProgressiveOff(self) -> None: ...
    def ProgressiveOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkJPEGWriter': ...
    def SetProgressive(self, _arg:int) -> None: ...
    def SetQuality(self, _arg:int) -> None: ...
    def SetResult(self, __a:'vtkUnsignedCharArray') -> None: ...
    def SetWriteToMemory(self, _arg:int) -> None: ...
    def Write(self) -> None: ...
    def WriteToMemoryOff(self) -> None: ...
    def WriteToMemoryOn(self) -> None: ...

class vtkJSONImageWriter(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    array_name:'getset_descriptor'
    file_name:'getset_descriptor'
    slice:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetArrayName(self) -> str: ...
    def GetFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSlice(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkJSONImageWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkJSONImageWriter': ...
    def SetArrayName(self, _arg:str) -> None: ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetSlice(self, _arg:int) -> None: ...
    def Write(self) -> None: ...

class vtkMRCReader(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    file_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMRCReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMRCReader': ...
    def SetFileName(self, _arg:str) -> None: ...

class vtkMedicalImageProperties(vtkmodules.vtkCommonCore.vtkObject):
    AXIAL:int
    CORONAL:int
    SAGITTAL:int
    acquisition_date:'getset_descriptor'
    acquisition_date_day:'getset_descriptor'
    acquisition_date_month:'getset_descriptor'
    acquisition_date_year:'getset_descriptor'
    acquisition_time:'getset_descriptor'
    convolution_kernel:'getset_descriptor'
    direction_cosine:'getset_descriptor'
    echo_time:'getset_descriptor'
    echo_train_length:'getset_descriptor'
    exposure:'getset_descriptor'
    exposure_time:'getset_descriptor'
    gantry_tilt:'getset_descriptor'
    gantry_tilt_as_double:'getset_descriptor'
    image_date:'getset_descriptor'
    image_date_day:'getset_descriptor'
    image_date_month:'getset_descriptor'
    image_date_year:'getset_descriptor'
    image_number:'getset_descriptor'
    image_time:'getset_descriptor'
    institution_name:'getset_descriptor'
    kvp:'getset_descriptor'
    manufacturer:'getset_descriptor'
    manufacturer_model_name:'getset_descriptor'
    modality:'getset_descriptor'
    number_of_user_defined_values:'getset_descriptor'
    orientation_type:'getset_descriptor'
    patient_age:'getset_descriptor'
    patient_age_day:'getset_descriptor'
    patient_age_month:'getset_descriptor'
    patient_age_week:'getset_descriptor'
    patient_age_year:'getset_descriptor'
    patient_birth_date:'getset_descriptor'
    patient_birth_date_day:'getset_descriptor'
    patient_birth_date_month:'getset_descriptor'
    patient_birth_date_year:'getset_descriptor'
    patient_id:'getset_descriptor'
    patient_name:'getset_descriptor'
    patient_sex:'getset_descriptor'
    repetition_time:'getset_descriptor'
    series_description:'getset_descriptor'
    series_number:'getset_descriptor'
    slice_thickness:'getset_descriptor'
    slice_thickness_as_double:'getset_descriptor'
    station_name:'getset_descriptor'
    study_date:'getset_descriptor'
    study_description:'getset_descriptor'
    study_id:'getset_descriptor'
    study_time:'getset_descriptor'
    x_ray_tube_current:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddUserDefinedValue(self, name:str, value:str) -> None: ...
    def AddWindowLevelPreset(self, w:float, l:float) -> int: ...
    def Clear(self) -> None: ...
    def DeepCopy(self, p:'vtkMedicalImageProperties') -> None: ...
    def GetAcquisitionDate(self) -> str: ...
    def GetAcquisitionDateDay(self) -> int: ...
    def GetAcquisitionDateMonth(self) -> int: ...
    def GetAcquisitionDateYear(self) -> int: ...
    def GetAcquisitionTime(self) -> str: ...
    @staticmethod
    def GetAgeAsFields(age:str, year:int, month:int, week:int, day:int) -> int: ...
    def GetConvolutionKernel(self) -> str: ...
    @staticmethod
    def GetDateAsFields(date:str, year:int, month:int, day:int) -> int: ...
    @staticmethod
    def GetDateAsLocale(date:str, locale:str) -> int: ...
    def GetDirectionCosine(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetEchoTime(self) -> str: ...
    def GetEchoTrainLength(self) -> str: ...
    def GetExposure(self) -> str: ...
    def GetExposureTime(self) -> str: ...
    def GetGantryTilt(self) -> str: ...
    def GetGantryTiltAsDouble(self) -> float: ...
    def GetImageDate(self) -> str: ...
    def GetImageDateDay(self) -> int: ...
    def GetImageDateMonth(self) -> int: ...
    def GetImageDateYear(self) -> int: ...
    def GetImageNumber(self) -> str: ...
    def GetImageTime(self) -> str: ...
    def GetInstanceUIDFromSliceID(self, volumeidx:int, sliceid:int) -> str: ...
    def GetInstitutionName(self) -> str: ...
    def GetKVP(self) -> str: ...
    def GetManufacturer(self) -> str: ...
    def GetManufacturerModelName(self) -> str: ...
    def GetModality(self) -> str: ...
    @overload
    def GetNthWindowLevelPreset(self, idx:int, w:MutableSequence[float], l:MutableSequence[float]) -> int: ...
    @overload
    def GetNthWindowLevelPreset(self, idx:int) -> Tuple[float, float]: ...
    def GetNthWindowLevelPresetComment(self, idx:int) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfUserDefinedValues(self) -> int: ...
    def GetNumberOfWindowLevelPresets(self) -> int: ...
    def GetOrientationType(self, volumeidx:int) -> int: ...
    def GetPatientAge(self) -> str: ...
    def GetPatientAgeDay(self) -> int: ...
    def GetPatientAgeMonth(self) -> int: ...
    def GetPatientAgeWeek(self) -> int: ...
    def GetPatientAgeYear(self) -> int: ...
    def GetPatientBirthDate(self) -> str: ...
    def GetPatientBirthDateDay(self) -> int: ...
    def GetPatientBirthDateMonth(self) -> int: ...
    def GetPatientBirthDateYear(self) -> int: ...
    def GetPatientID(self) -> str: ...
    def GetPatientName(self) -> str: ...
    def GetPatientSex(self) -> str: ...
    def GetRepetitionTime(self) -> str: ...
    def GetSeriesDescription(self) -> str: ...
    def GetSeriesNumber(self) -> str: ...
    def GetSliceIDFromInstanceUID(self, volumeidx:int, uid:str) -> int: ...
    def GetSliceThickness(self) -> str: ...
    def GetSliceThicknessAsDouble(self) -> float: ...
    def GetStationName(self) -> str: ...
    @staticmethod
    def GetStringFromOrientationType(type:int) -> str: ...
    def GetStudyDate(self) -> str: ...
    def GetStudyDescription(self) -> str: ...
    def GetStudyID(self) -> str: ...
    def GetStudyTime(self) -> str: ...
    @staticmethod
    def GetTimeAsFields(time:str, hour:int, minute:int, second:int) -> int: ...
    def GetUserDefinedNameByIndex(self, idx:int) -> str: ...
    def GetUserDefinedValue(self, name:str) -> str: ...
    def GetUserDefinedValueByIndex(self, idx:int) -> str: ...
    def GetWindowLevelPresetIndex(self, w:float, l:float) -> int: ...
    def GetXRayTubeCurrent(self) -> str: ...
    def HasWindowLevelPreset(self, w:float, l:float) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMedicalImageProperties': ...
    def RemoveAllUserDefinedValues(self) -> None: ...
    def RemoveAllWindowLevelPresets(self) -> None: ...
    def RemoveWindowLevelPreset(self, w:float, l:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMedicalImageProperties': ...
    def SetAcquisitionDate(self, _arg:str) -> None: ...
    def SetAcquisitionTime(self, _arg:str) -> None: ...
    def SetConvolutionKernel(self, _arg:str) -> None: ...
    @overload
    def SetDirectionCosine(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetDirectionCosine(self, _arg:Sequence[float]) -> None: ...
    def SetEchoTime(self, _arg:str) -> None: ...
    def SetEchoTrainLength(self, _arg:str) -> None: ...
    def SetExposure(self, _arg:str) -> None: ...
    def SetExposureTime(self, _arg:str) -> None: ...
    def SetGantryTilt(self, _arg:str) -> None: ...
    def SetImageDate(self, _arg:str) -> None: ...
    def SetImageNumber(self, _arg:str) -> None: ...
    def SetImageTime(self, _arg:str) -> None: ...
    def SetInstanceUIDFromSliceID(self, volumeidx:int, sliceid:int, uid:str) -> None: ...
    def SetInstitutionName(self, _arg:str) -> None: ...
    def SetKVP(self, _arg:str) -> None: ...
    def SetManufacturer(self, _arg:str) -> None: ...
    def SetManufacturerModelName(self, _arg:str) -> None: ...
    def SetModality(self, _arg:str) -> None: ...
    def SetNthWindowLevelPresetComment(self, idx:int, comment:str) -> None: ...
    def SetOrientationType(self, volumeidx:int, orientation:int) -> None: ...
    def SetPatientAge(self, _arg:str) -> None: ...
    def SetPatientBirthDate(self, _arg:str) -> None: ...
    def SetPatientID(self, _arg:str) -> None: ...
    def SetPatientName(self, _arg:str) -> None: ...
    def SetPatientSex(self, _arg:str) -> None: ...
    def SetRepetitionTime(self, _arg:str) -> None: ...
    def SetSeriesDescription(self, _arg:str) -> None: ...
    def SetSeriesNumber(self, _arg:str) -> None: ...
    def SetSliceThickness(self, _arg:str) -> None: ...
    def SetStationName(self, _arg:str) -> None: ...
    def SetStudyDate(self, _arg:str) -> None: ...
    def SetStudyDescription(self, _arg:str) -> None: ...
    def SetStudyID(self, _arg:str) -> None: ...
    def SetStudyTime(self, _arg:str) -> None: ...
    def SetXRayTubeCurrent(self, _arg:str) -> None: ...

class vtkMetaImageReader(vtkImageReader2):
    anatomical_orientation:'getset_descriptor'
    bits_allocated:'getset_descriptor'
    data_byte_order:'getset_descriptor'
    date:'getset_descriptor'
    descriptive_name:'getset_descriptor'
    distance_units:'getset_descriptor'
    file_extensions:'getset_descriptor'
    gantry_angle:'getset_descriptor'
    height:'getset_descriptor'
    image_number:'getset_descriptor'
    image_position_patient:'getset_descriptor'
    modality:'getset_descriptor'
    number_of_components:'getset_descriptor'
    patient_id:'getset_descriptor'
    patient_name:'getset_descriptor'
    pixel_representation:'getset_descriptor'
    pixel_spacing:'getset_descriptor'
    rescale_offset:'getset_descriptor'
    rescale_slope:'getset_descriptor'
    series:'getset_descriptor'
    study_id:'getset_descriptor'
    study_uid:'getset_descriptor'
    transfer_syntax_uid:'getset_descriptor'
    width:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CanReadFile(self, name:str) -> int: ...
    def GetAnatomicalOrientation(self) -> str: ...
    def GetBitsAllocated(self) -> int: ...
    def GetDataByteOrder(self) -> int: ...
    def GetDate(self) -> str: ...
    def GetDescriptiveName(self) -> str: ...
    def GetDistanceUnits(self) -> str: ...
    def GetFileExtensions(self) -> str: ...
    def GetGantryAngle(self) -> float: ...
    def GetHeight(self) -> int: ...
    def GetImageNumber(self) -> str: ...
    def GetImagePositionPatient(self) -> Pointer: ...
    def GetModality(self) -> str: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPatientID(self) -> str: ...
    def GetPatientName(self) -> str: ...
    def GetPixelRepresentation(self) -> int: ...
    def GetPixelSpacing(self) -> Pointer: ...
    def GetRescaleOffset(self) -> float: ...
    def GetRescaleSlope(self) -> float: ...
    def GetSeries(self) -> str: ...
    def GetStudyID(self) -> str: ...
    def GetStudyUID(self) -> str: ...
    def GetTransferSyntaxUID(self) -> str: ...
    def GetWidth(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMetaImageReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMetaImageReader': ...

class vtkMetaImageWriter(vtkImageWriter):
    compression:'getset_descriptor'
    file_name:'getset_descriptor'
    raw_file_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCompression(self) -> bool: ...
    def GetFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRAWFileName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMetaImageWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMetaImageWriter': ...
    def SetCompression(self, compress:bool) -> None: ...
    def SetFileName(self, fname:str) -> None: ...
    def SetRAWFileName(self, fname:str) -> None: ...
    def Write(self) -> None: ...

class vtkNIFTIImageHeader(vtkmodules.vtkCommonCore.vtkObject):
    class DataTypeEnum(int): ...
    class HeaderSizeEnum(int): ...
    class IntentCodeEnum(int): ...
    class SliceCodeEnum(int): ...
    class UnitsXYZTEnum(int): ...
    class XFormCodeEnum(int): ...
    IntentBeta:'IntentCodeEnum'
    IntentBinom:'IntentCodeEnum'
    IntentChi:'IntentCodeEnum'
    IntentChiSQ:'IntentCodeEnum'
    IntentChiSQNonc:'IntentCodeEnum'
    IntentCorrel:'IntentCodeEnum'
    IntentDimless:'IntentCodeEnum'
    IntentDispVect:'IntentCodeEnum'
    IntentEstimate:'IntentCodeEnum'
    IntentExtVal:'IntentCodeEnum'
    IntentFTest:'IntentCodeEnum'
    IntentFTestNonc:'IntentCodeEnum'
    IntentGamma:'IntentCodeEnum'
    IntentGenMatrix:'IntentCodeEnum'
    IntentInvGauss:'IntentCodeEnum'
    IntentLabel:'IntentCodeEnum'
    IntentLaplace:'IntentCodeEnum'
    IntentLog10PVal:'IntentCodeEnum'
    IntentLogPVal:'IntentCodeEnum'
    IntentLogistic:'IntentCodeEnum'
    IntentNeuroName:'IntentCodeEnum'
    IntentNodeIndex:'IntentCodeEnum'
    IntentNone:'IntentCodeEnum'
    IntentNormal:'IntentCodeEnum'
    IntentPVal:'IntentCodeEnum'
    IntentPointSet:'IntentCodeEnum'
    IntentPoisson:'IntentCodeEnum'
    IntentQuaternion:'IntentCodeEnum'
    IntentRGBAVector:'IntentCodeEnum'
    IntentRGBVector:'IntentCodeEnum'
    IntentShape:'IntentCodeEnum'
    IntentSymMatrix:'IntentCodeEnum'
    IntentTTest:'IntentCodeEnum'
    IntentTTestNonc:'IntentCodeEnum'
    IntentTimeSeries:'IntentCodeEnum'
    IntentTriangle:'IntentCodeEnum'
    IntentUniform:'IntentCodeEnum'
    IntentVector:'IntentCodeEnum'
    IntentWeibull:'IntentCodeEnum'
    IntentZScore:'IntentCodeEnum'
    NIFTI1HeaderSize:'HeaderSizeEnum'
    NIFTI2HeaderSize:'HeaderSizeEnum'
    SliceAltDec:'SliceCodeEnum'
    SliceAltDec2:'SliceCodeEnum'
    SliceAltInc:'SliceCodeEnum'
    SliceAltInc2:'SliceCodeEnum'
    SliceSeqDec:'SliceCodeEnum'
    SliceSeqInc:'SliceCodeEnum'
    SliceUnknown:'SliceCodeEnum'
    TypeComplex128:'DataTypeEnum'
    TypeComplex256:'DataTypeEnum'
    TypeComplex64:'DataTypeEnum'
    TypeFloat128:'DataTypeEnum'
    TypeFloat32:'DataTypeEnum'
    TypeFloat64:'DataTypeEnum'
    TypeInt16:'DataTypeEnum'
    TypeInt32:'DataTypeEnum'
    TypeInt64:'DataTypeEnum'
    TypeInt8:'DataTypeEnum'
    TypeRGB24:'DataTypeEnum'
    TypeRGBA32:'DataTypeEnum'
    TypeUInt16:'DataTypeEnum'
    TypeUInt32:'DataTypeEnum'
    TypeUInt64:'DataTypeEnum'
    TypeUInt8:'DataTypeEnum'
    UnitsHz:'UnitsXYZTEnum'
    UnitsMM:'UnitsXYZTEnum'
    UnitsMSec:'UnitsXYZTEnum'
    UnitsMeter:'UnitsXYZTEnum'
    UnitsMicron:'UnitsXYZTEnum'
    UnitsPPM:'UnitsXYZTEnum'
    UnitsRads:'UnitsXYZTEnum'
    UnitsSec:'UnitsXYZTEnum'
    UnitsSpace:'UnitsXYZTEnum'
    UnitsTime:'UnitsXYZTEnum'
    UnitsUSec:'UnitsXYZTEnum'
    UnitsUnknown:'UnitsXYZTEnum'
    XFormAlignedAnat:'XFormCodeEnum'
    XFormMNI152:'XFormCodeEnum'
    XFormScannerAnat:'XFormCodeEnum'
    XFormTalairach:'XFormCodeEnum'
    XFormUnkown:'XFormCodeEnum'
    aux_file:'getset_descriptor'
    bit_pix:'getset_descriptor'
    cal_max:'getset_descriptor'
    cal_min:'getset_descriptor'
    data_type:'getset_descriptor'
    descrip:'getset_descriptor'
    dim_info:'getset_descriptor'
    intent_code:'getset_descriptor'
    intent_name:'getset_descriptor'
    intent_p1:'getset_descriptor'
    intent_p2:'getset_descriptor'
    intent_p3:'getset_descriptor'
    magic:'getset_descriptor'
    q_form_code:'getset_descriptor'
    q_offset_x:'getset_descriptor'
    q_offset_y:'getset_descriptor'
    q_offset_z:'getset_descriptor'
    quatern_b:'getset_descriptor'
    quatern_c:'getset_descriptor'
    quatern_d:'getset_descriptor'
    s_form_code:'getset_descriptor'
    s_row_x:'getset_descriptor'
    s_row_y:'getset_descriptor'
    s_row_z:'getset_descriptor'
    scl_inter:'getset_descriptor'
    scl_slope:'getset_descriptor'
    slice_code:'getset_descriptor'
    slice_duration:'getset_descriptor'
    slice_end:'getset_descriptor'
    slice_start:'getset_descriptor'
    t_offset:'getset_descriptor'
    vox_offset:'getset_descriptor'
    xyzt_units:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def DeepCopy(self, o:'vtkNIFTIImageHeader') -> None: ...
    def GetAuxFile(self) -> str: ...
    def GetBitPix(self) -> int: ...
    def GetCalMax(self) -> float: ...
    def GetCalMin(self) -> float: ...
    def GetDataType(self) -> int: ...
    def GetDescrip(self) -> str: ...
    def GetDim(self, i:int) -> int: ...
    def GetDimInfo(self) -> int: ...
    def GetIntentCode(self) -> int: ...
    def GetIntentName(self) -> str: ...
    def GetIntentP1(self) -> float: ...
    def GetIntentP2(self) -> float: ...
    def GetIntentP3(self) -> float: ...
    def GetMagic(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPixDim(self, i:int) -> float: ...
    def GetQFormCode(self) -> int: ...
    def GetQOffsetX(self) -> float: ...
    def GetQOffsetY(self) -> float: ...
    def GetQOffsetZ(self) -> float: ...
    def GetQuaternB(self) -> float: ...
    def GetQuaternC(self) -> float: ...
    def GetQuaternD(self) -> float: ...
    def GetSFormCode(self) -> int: ...
    def GetSRowX(self) -> Tuple[float, float, float, float]: ...
    def GetSRowY(self) -> Tuple[float, float, float, float]: ...
    def GetSRowZ(self) -> Tuple[float, float, float, float]: ...
    def GetSclInter(self) -> float: ...
    def GetSclSlope(self) -> float: ...
    def GetSliceCode(self) -> int: ...
    def GetSliceDuration(self) -> float: ...
    def GetSliceEnd(self) -> int: ...
    def GetSliceStart(self) -> int: ...
    def GetTOffset(self) -> float: ...
    def GetVoxOffset(self) -> int: ...
    def GetXYZTUnits(self) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkNIFTIImageHeader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkNIFTIImageHeader': ...
    def SetAuxFile(self, auxfile:str) -> None: ...
    def SetCalMax(self, _arg:float) -> None: ...
    def SetCalMin(self, _arg:float) -> None: ...
    def SetDescrip(self, descrip:str) -> None: ...
    def SetDimInfo(self, _arg:int) -> None: ...
    def SetIntentCode(self, _arg:int) -> None: ...
    def SetIntentName(self, name:str) -> None: ...
    def SetIntentP1(self, _arg:float) -> None: ...
    def SetIntentP2(self, _arg:float) -> None: ...
    def SetIntentP3(self, _arg:float) -> None: ...
    def SetQFormCode(self, _arg:int) -> None: ...
    def SetQOffsetX(self, _arg:float) -> None: ...
    def SetQOffsetY(self, _arg:float) -> None: ...
    def SetQOffsetZ(self, _arg:float) -> None: ...
    def SetQuaternB(self, _arg:float) -> None: ...
    def SetQuaternC(self, _arg:float) -> None: ...
    def SetQuaternD(self, _arg:float) -> None: ...
    def SetSFormCode(self, _arg:int) -> None: ...
    @overload
    def SetSRowX(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetSRowX(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetSRowY(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetSRowY(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetSRowZ(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetSRowZ(self, _arg:Sequence[float]) -> None: ...
    def SetSclInter(self, _arg:float) -> None: ...
    def SetSclSlope(self, _arg:float) -> None: ...
    def SetSliceCode(self, _arg:int) -> None: ...
    def SetSliceDuration(self, _arg:float) -> None: ...
    def SetSliceEnd(self, _arg:int) -> None: ...
    def SetSliceStart(self, _arg:int) -> None: ...
    def SetTOffset(self, _arg:float) -> None: ...
    def SetXYZTUnits(self, _arg:int) -> None: ...

class vtkNIFTIImageReader(vtkImageReader2):
    descriptive_name:'getset_descriptor'
    file_extensions:'getset_descriptor'
    nifti_header:'getset_descriptor'
    planar_rgb:'getset_descriptor'
    q_fac:'getset_descriptor'
    q_form_matrix:'getset_descriptor'
    rescale_intercept:'getset_descriptor'
    rescale_slope:'getset_descriptor'
    s_form_matrix:'getset_descriptor'
    time_as_vector:'getset_descriptor'
    time_dimension:'getset_descriptor'
    time_spacing:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CanReadFile(self, filename:str) -> int: ...
    def GetDescriptiveName(self) -> str: ...
    def GetFileExtensions(self) -> str: ...
    def GetNIFTIHeader(self) -> 'vtkNIFTIImageHeader': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlanarRGB(self) -> bool: ...
    def GetQFac(self) -> float: ...
    def GetQFormMatrix(self) -> 'vtkMatrix4x4': ...
    def GetRescaleIntercept(self) -> float: ...
    def GetRescaleSlope(self) -> float: ...
    def GetSFormMatrix(self) -> 'vtkMatrix4x4': ...
    def GetTimeAsVector(self) -> bool: ...
    def GetTimeDimension(self) -> int: ...
    def GetTimeSpacing(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkNIFTIImageReader': ...
    def PlanarRGBOff(self) -> None: ...
    def PlanarRGBOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkNIFTIImageReader': ...
    def SetPlanarRGB(self, _arg:bool) -> None: ...
    def SetTimeAsVector(self, _arg:bool) -> None: ...
    def TimeAsVectorOff(self) -> None: ...
    def TimeAsVectorOn(self) -> None: ...

class vtkNIFTIImageWriter(vtkImageWriter):
    description:'getset_descriptor'
    nifti_header:'getset_descriptor'
    nifti_version:'getset_descriptor'
    planar_rgb:'getset_descriptor'
    q_fac:'getset_descriptor'
    q_form_matrix:'getset_descriptor'
    rescale_intercept:'getset_descriptor'
    rescale_slope:'getset_descriptor'
    s_form_matrix:'getset_descriptor'
    time_dimension:'getset_descriptor'
    time_spacing:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDescription(self) -> str: ...
    def GetNIFTIHeader(self) -> 'vtkNIFTIImageHeader': ...
    def GetNIFTIVersion(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlanarRGB(self) -> bool: ...
    def GetQFac(self) -> float: ...
    def GetQFormMatrix(self) -> 'vtkMatrix4x4': ...
    def GetRescaleIntercept(self) -> float: ...
    def GetRescaleSlope(self) -> float: ...
    def GetSFormMatrix(self) -> 'vtkMatrix4x4': ...
    def GetTimeDimension(self) -> int: ...
    def GetTimeSpacing(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkNIFTIImageWriter': ...
    def PlanarRGBOff(self) -> None: ...
    def PlanarRGBOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkNIFTIImageWriter': ...
    def SetDescription(self, _arg:str) -> None: ...
    def SetNIFTIHeader(self, hdr:'vtkNIFTIImageHeader') -> None: ...
    def SetNIFTIVersion(self, _arg:int) -> None: ...
    def SetPlanarRGB(self, _arg:bool) -> None: ...
    def SetQFac(self, _arg:float) -> None: ...
    def SetQFormMatrix(self, __a:'vtkMatrix4x4') -> None: ...
    def SetRescaleIntercept(self, _arg:float) -> None: ...
    def SetRescaleSlope(self, _arg:float) -> None: ...
    def SetSFormMatrix(self, __a:'vtkMatrix4x4') -> None: ...
    def SetTimeDimension(self, _arg:int) -> None: ...
    def SetTimeSpacing(self, _arg:float) -> None: ...

class vtkNrrdReader(vtkImageReader):
    def __init__(self, **properties:Any) -> None: ...
    def CanReadFile(self, filename:str) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkNrrdReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkNrrdReader': ...

class vtkTIFFReader(vtkImageReader2):
    descriptive_name:'getset_descriptor'
    file_extensions:'getset_descriptor'
    ignore_color_map:'getset_descriptor'
    orientation_type:'getset_descriptor'
    orientation_type_specified_flag:'getset_descriptor'
    origin_specified_flag:'getset_descriptor'
    spacing_specified_flag:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CanReadFile(self, fname:str) -> int: ...
    def GetDescriptiveName(self) -> str: ...
    def GetFileExtensions(self) -> str: ...
    def GetIgnoreColorMap(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientationType(self) -> int: ...
    def GetOrientationTypeSpecifiedFlag(self) -> bool: ...
    def GetOriginSpecifiedFlag(self) -> bool: ...
    def GetSpacingSpecifiedFlag(self) -> bool: ...
    def IgnoreColorMapOff(self) -> None: ...
    def IgnoreColorMapOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTIFFReader': ...
    def OriginSpecifiedFlagOff(self) -> None: ...
    def OriginSpecifiedFlagOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTIFFReader': ...
    def SetIgnoreColorMap(self, _arg:bool) -> None: ...
    def SetOrientationType(self, orientationType:int) -> None: ...
    def SetOriginSpecifiedFlag(self, _arg:bool) -> None: ...
    def SetSpacingSpecifiedFlag(self, _arg:bool) -> None: ...
    def SpacingSpecifiedFlagOff(self) -> None: ...
    def SpacingSpecifiedFlagOn(self) -> None: ...

class vtkOMETIFFReader(vtkTIFFReader):
    descriptive_name:'getset_descriptor'
    file_extensions:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CanReadFile(self, fname:str) -> int: ...
    def GetDescriptiveName(self) -> str: ...
    def GetFileExtensions(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOMETIFFReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOMETIFFReader': ...

class vtkPNGReader(vtkImageReader2):
    descriptive_name:'getset_descriptor'
    file_extensions:'getset_descriptor'
    number_of_text_chunks:'getset_descriptor'
    read_spacing_from_file:'getset_descriptor'
    text_keys:'getset_descriptor'
    text_values:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CanReadFile(self, fname:str) -> int: ...
    def GetDescriptiveName(self) -> str: ...
    def GetFileExtensions(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTextChunks(self) -> int: ...
    def GetReadSpacingFromFile(self) -> bool: ...
    def GetTextChunks(self, key:str, beginEndIndex:MutableSequence[int]) -> None: ...
    def GetTextKey(self, index:int) -> str: ...
    def GetTextKeys(self) -> 'vtkStringArray': ...
    def GetTextValue(self, index:int) -> str: ...
    def GetTextValues(self) -> 'vtkStringArray': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPNGReader': ...
    def ReadSpacingFromFileOff(self) -> None: ...
    def ReadSpacingFromFileOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPNGReader': ...
    def SetReadSpacingFromFile(self, _arg:bool) -> None: ...

class vtkPNGWriter(vtkImageWriter):
    compression_level:'getset_descriptor'
    result:'getset_descriptor'
    write_to_memory:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddText(self, key:str, value:str) -> None: ...
    def ClearText(self) -> None: ...
    def GetCompressionLevel(self) -> int: ...
    def GetCompressionLevelMaxValue(self) -> int: ...
    def GetCompressionLevelMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetResult(self) -> 'vtkUnsignedCharArray': ...
    def GetWriteToMemory(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPNGWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPNGWriter': ...
    def SetCompressionLevel(self, _arg:int) -> None: ...
    def SetResult(self, __a:'vtkUnsignedCharArray') -> None: ...
    def SetWriteToMemory(self, _arg:int) -> None: ...
    def Write(self) -> None: ...
    def WriteToMemoryOff(self) -> None: ...
    def WriteToMemoryOn(self) -> None: ...

class vtkPNMReader(vtkImageReader):
    descriptive_name:'getset_descriptor'
    file_extensions:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CanReadFile(self, fname:str) -> int: ...
    def GetDescriptiveName(self) -> str: ...
    def GetFileExtensions(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPNMReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPNMReader': ...

class vtkPNMWriter(vtkImageWriter):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPNMWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPNMWriter': ...

class vtkPostScriptWriter(vtkImageWriter):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPostScriptWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPostScriptWriter': ...

class vtkSEPReader(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    all_dimensions:'getset_descriptor'
    all_ranges:'getset_descriptor'
    data_origin:'getset_descriptor'
    data_spacing:'getset_descriptor'
    extent_split_mode:'getset_descriptor'
    file_name:'getset_descriptor'
    fixed_dim_range:'getset_descriptor'
    fixed_dimension1:'getset_descriptor'
    fixed_dimension2:'getset_descriptor'
    fixed_dimension_value1:'getset_descriptor'
    fixed_dimension_value2:'getset_descriptor'
    output_grid_dimension:'getset_descriptor'
    x_dimension:'getset_descriptor'
    y_dimension:'getset_descriptor'
    z_dimension:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CanReadFile(self, __a:str) -> bool: ...
    def GetAllDimensions(self) -> 'vtkStringArray': ...
    def GetAllRanges(self) -> 'vtkStringArray': ...
    def GetDataOrigin(self) -> Pointer: ...
    def GetDataSpacing(self) -> Pointer: ...
    def GetExtentSplitMode(self) -> int: ...
    def GetFileName(self) -> str: ...
    def GetFixedDimRange(self) -> Tuple[int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputGridDimension(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSEPReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSEPReader': ...
    def SetExtentSplitMode(self, _arg:int) -> None: ...
    def SetFileName(self, arg:str) -> None: ...
    def SetFixedDimension1(self, arg:str) -> None: ...
    def SetFixedDimension2(self, arg:str) -> None: ...
    def SetFixedDimensionValue1(self, _arg:int) -> None: ...
    def SetFixedDimensionValue2(self, _arg:int) -> None: ...
    def SetOutputGridDimension(self, _arg:int) -> None: ...
    def SetXDimension(self, arg:str) -> None: ...
    def SetYDimension(self, arg:str) -> None: ...
    def SetZDimension(self, arg:str) -> None: ...

class vtkSLCReader(vtkImageReader2):
    descriptive_name:'getset_descriptor'
    error:'getset_descriptor'
    file_extensions:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CanReadFile(self, fname:str) -> int: ...
    def GetDescriptiveName(self) -> str: ...
    def GetError(self) -> int: ...
    def GetFileExtensions(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSLCReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSLCReader': ...

class vtkTGAReader(vtkImageReader2):
    descriptive_name:'getset_descriptor'
    file_extensions:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CanReadFile(self, fname:str) -> int: ...
    def GetDescriptiveName(self) -> str: ...
    def GetFileExtensions(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTGAReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTGAReader': ...

class vtkTIFFWriter(vtkImageWriter):
    Deflate:int
    JPEG:int
    LZW:int
    NoCompression:int
    PackBits:int
    compression:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCompression(self) -> int: ...
    def GetCompressionMaxValue(self) -> int: ...
    def GetCompressionMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTIFFWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTIFFWriter': ...
    def SetCompression(self, _arg:int) -> None: ...
    def SetCompressionToDeflate(self) -> None: ...
    def SetCompressionToJPEG(self) -> None: ...
    def SetCompressionToLZW(self) -> None: ...
    def SetCompressionToNoCompression(self) -> None: ...
    def SetCompressionToPackBits(self) -> None: ...
    def Write(self) -> None: ...

class vtkVolumeReader(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    data_origin:'getset_descriptor'
    data_spacing:'getset_descriptor'
    file_pattern:'getset_descriptor'
    file_prefix:'getset_descriptor'
    image_range:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDataOrigin(self) -> Tuple[float, float, float]: ...
    def GetDataSpacing(self) -> Tuple[float, float, float]: ...
    def GetFilePattern(self) -> str: ...
    def GetFilePrefix(self) -> str: ...
    def GetImage(self, ImageNumber:int) -> 'vtkImageData': ...
    def GetImageRange(self) -> Tuple[int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVolumeReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVolumeReader': ...
    @overload
    def SetDataOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDataOrigin(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetDataSpacing(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDataSpacing(self, _arg:Sequence[float]) -> None: ...
    def SetFilePattern(self, _arg:str) -> None: ...
    def SetFilePrefix(self, _arg:str) -> None: ...
    @overload
    def SetImageRange(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetImageRange(self, _arg:Sequence[int]) -> None: ...

class vtkVolume16Reader(vtkVolumeReader):
    data_byte_order:'getset_descriptor'
    data_dimensions:'getset_descriptor'
    data_mask:'getset_descriptor'
    header_size:'getset_descriptor'
    swap_bytes:'getset_descriptor'
    transform:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDataByteOrder(self) -> int: ...
    def GetDataByteOrderAsString(self) -> str: ...
    def GetDataDimensions(self) -> Tuple[int, int]: ...
    def GetDataMask(self) -> int: ...
    def GetHeaderSize(self) -> int: ...
    def GetImage(self, ImageNumber:int) -> 'vtkImageData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSwapBytes(self) -> int: ...
    def GetTransform(self) -> 'vtkTransform': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVolume16Reader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVolume16Reader': ...
    def SetDataByteOrder(self, __a:int) -> None: ...
    def SetDataByteOrderToBigEndian(self) -> None: ...
    def SetDataByteOrderToLittleEndian(self) -> None: ...
    @overload
    def SetDataDimensions(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetDataDimensions(self, _arg:Sequence[int]) -> None: ...
    def SetDataMask(self, _arg:int) -> None: ...
    def SetHeaderSize(self, _arg:int) -> None: ...
    def SetSwapBytes(self, _arg:int) -> None: ...
    def SetTransform(self, __a:'vtkTransform') -> None: ...
    def SwapBytesOff(self) -> None: ...
    def SwapBytesOn(self) -> None: ...

