def jichu():
    print(
        "# 实验：昇腾数字图像基础实操# 任务一：图像基本操作# 步骤1：读取图像\n"
        "import cv2\n"
        "import matplotlib.pyplot as plt\n"
        "%matplotlib inline\n\n"
        "# 读取图像\n"
        "im = cv2.imread(\"/data/cv-ascend/images/panda.png\", 1)\n"
        "im_gray = cv2.imread(\"/data/cv-ascend/images/panda.png\", 0)\n\n"
        "# 新建画布并显示图像\n"
        "plt.figure()\n"
        "plt.subplot(1, 2, 1)\n"
        "plt.title('Original Image (BGR)')\n"
        "plt.imshow(im)\n"
        "plt.subplot(1, 2, 2)\n"
        "plt.title('Grayscale Image')\n"
        "plt.imshow(im_gray, 'gray')\n"
        "plt.show()\n\n"
        "# 调整颜色通道顺序为RGB并显示\n"
        "im_rgb = cv2.cvtColor(im, cv2.COLOR_BGR2RGB)\n"
        "plt.figure()\n"
        "plt.subplot(1, 2, 1)\n"
        "plt.title('Original Image (RGB)')\n"
        "plt.imshow(im_rgb)\n"
        "plt.subplot(1, 2, 2)\n"
        "plt.title('Grayscale Image')\n"
        "plt.imshow(im_gray, 'gray')\n"
        "plt.show()\n\n"
        "# 查看图像的数据类型和大小\n"
        "print(\"Image data type:\", im.dtype)\n"
        "print(\"Image shape:\", im.shape)\n\n"
        "# 保存图像\n"
        "cv2.imwrite(\"./saved_panda.png\", im)\n"
    )

def huidu():
    print(
        "#实验：昇腾图像的灰度变换实操# 任务一：灰度变换# 步骤1：反转、灰度拉伸、灰度压缩\n"
        "import numpy as np\n"
        "import cv2\n"
        "from matplotlib import pyplot as plt\n"
        "%matplotlib inline\n\n"
        "def linear_trans(img, k, b=0):\n"
        "    trans_list = [(np.float32(x)*k + b) for x in range(256)]\n"
        "    trans_table = np.array(trans_list)\n"
        "    trans_table[trans_table > 255] = 255\n"
        "    trans_table[trans_table < 0] = 0\n"
        "    trans_table = np.round(trans_table).astype(np.uint8)\n"
        "    return cv2.LUT(img, trans_table)\n\n"
        "im = cv2.imread(\"/data/cv-ascend/images/panda.png\", 0)\n\n"
        "# 原始图像\n"
        "plt.figure(figsize=(8, 8))\n"
        "plt.subplot(2, 2, 1)\n"
        "plt.title('Original')\n"
        "plt.imshow(im, 'gray')\n\n"
        "# 反转\n"
        "im_inversion = linear_trans(im, -1, 255)\n"
        "plt.subplot(2, 2, 2)\n"
        "plt.title('Inversion')\n"
        "plt.imshow(im_inversion, 'gray')\n\n"
        "# 灰度拉伸\n"
        "im_stretch = linear_trans(im, 1.2)\n"
        "plt.subplot(2, 2, 3)\n"
        "plt.title('Stretch')\n"
        "plt.imshow(im_stretch, 'gray')\n\n"
        "# 灰度压缩\n"
        "im_compress = linear_trans(im, 0.4)\n"
        "plt.subplot(2, 2, 4)\n"
        "plt.title('Compress')\n"
        "plt.imshow(im_compress, 'gray')\n"
        "plt.show()\n\n"
        "# 伽马变换\n"
        "def gamma_trans(img, gamma):\n"
        "    gamma_list = [np.power(x / 255.0, gamma) * 255.0 for x in range(256)]\n"
        "    gamma_table = np.round(np.array(gamma_list)).astype(np.uint8)\n"
        "    return cv2.LUT(img, gamma_table)\n\n"
        "# 伽马变换示例\n"
        "im_gamma05 = gamma_trans(im, 0.5)\n"
        "im_gamma2 = gamma_trans(im, 2)\n"
        "plt.figure(figsize=(8, 4))\n"
        "plt.subplot(1, 3, 1)\n"
        "plt.title('Original')\n"
        "plt.imshow(im, 'gray')\n"
        "plt.subplot(1, 3, 2)\n"
        "plt.title('Gamma=0.5')\n"
        "plt.imshow(im_gamma05, 'gray')\n"
        "plt.subplot(1, 3, 3)\n"
        "plt.title('Gamma=2')\n"
        "plt.imshow(im_gamma2, 'gray')\n"
        "plt.show()\n"
    )

def jihe():
    print(
        "#实验：昇腾图像几何变换实操# 任务一：坐标变换# 步骤1：平移\n"
        "import numpy as np\n"
        "import cv2\n"
        "import matplotlib.pyplot as plt\n"
        "%matplotlib inline\n\n"
        "def translate(img, x, y):\n"
        "    (h, w) = img.shape[:2]\n"
        "    M = np.float32([[1, 0, x], [0, 1, y]])\n"
        "    shifted = cv2.warpAffine(img, M, (w, h))\n"
        "    return shifted\n\n"
        "im = cv2.imread(\"/data/cv-ascend/images/panda.png\")\n"
        "im_rgb = cv2.cvtColor(im, cv2.COLOR_BGR2RGB)\n\n"
        "# 原始图像\n"
        "plt.figure(figsize=(8, 8))\n"
        "plt.subplot(2, 2, 1)\n"
        "plt.title('Original')\n"
        "plt.imshow(im_rgb)\n\n"
        "# 平移操作示例\n"
        "shifted_60 = translate(im_rgb, 0, 50)\n"
        "plt.subplot(2, 2, 2)\n"
        "plt.title('Shift Down by 50')\n"
        "plt.imshow(shifted_60)\n\n"
        "shifted_minus100 = translate(im_rgb, -100, 0)\n"
        "plt.subplot(2, 2, 3)\n"
        "plt.title('Shift Left by 100')\n"
        "plt.imshow(shifted_minus100)\n\n"
        "shifted_100_50 = translate(im_rgb, 50, 100)\n"
        "plt.subplot(2, 2, 4)\n"
        "plt.title('Shift Right 50, Down 100')\n"
        "plt.imshow(shifted_100_50)\n"
        "plt.show()\n\n"
        "def rotate(img, angle, center=None, scale=1.0):\n"
        "    (h, w) = img.shape[:2]\n"
        "    if center is None:\n"
        "        center = (w // 2, h // 2)\n"
        "    M = cv2.getRotationMatrix2D(center, angle, scale)\n"
        "    rotated = cv2.warpAffine(img, M, (w, h))\n"
        "    return rotated\n\n"
        "rotated_45 = rotate(im_rgb, 45)\n"
        "rotated_minus20 = rotate(im_rgb, -20)\n"
        "plt.figure(figsize=(8, 4))\n"
        "plt.subplot(1, 3, 1)\n"
        "plt.title('Original')\n"
        "plt.imshow(im_rgb)\n"
        "plt.subplot(1, 3, 2)\n"
        "plt.title('Rotate 45°')\n"
        "plt.imshow(rotated_45)\n"
        "plt.subplot(1, 3, 3)\n"
        "plt.title('Rotate -20°')\n"
        "plt.imshow(rotated_minus20)\n"
        "plt.show()\n"
    )

def xingtai():
    print(
        "# 实验：昇腾图像形态学处理方法实操# 任务一：形态学方法——定义结构元素# 步骤1：使用getStructuringElement函数定义结构元素\n"
        "import cv2\n"
        "import matplotlib.pyplot as plt\n"
        "%matplotlib inline\n\n"
        "# 定义十字形结构元素\n"
        "cross_element = cv2.getStructuringElement(cv2.MORPH_CROSS, (5, 5))\n"
        "plt.figure()\n"
        "plt.title('Cross Structuring Element')\n"
        "plt.imshow(cross_element, 'gray')\n"
        "plt.show()\n\n"
        "import numpy as np\n"
        "# 自定义水平线结构元素\n"
        "np_element = np.zeros((5, 5), dtype=np.uint8)\n"
        "np_element[2, :] = 1\n"
        "plt.figure()\n"
        "plt.title('Custom Structuring Element')\n"
        "plt.imshow(np_element, 'gray')\n"
        "plt.show()\n\n"
        "# 读取图像并二值化\n"
        "img = cv2.imread(\"/data/CV-ascend/images/panda.png\", 0)\n"
        "_, bin_img = cv2.threshold(img, 127, 255, cv2.THRESH_BINARY)\n"
        "plt.figure()\n"
        "plt.title('Binary Image')\n"
        "plt.imshow(bin_img, 'gray')\n"
        "plt.show()\n\n"
        "# 腐蚀操作\n"
        "kernel = cv2.getStructuringElement(cv2.MORPH_RECT, (3, 3))\n"
        "eroded = cv2.erode(bin_img, kernel)\n"
        "plt.figure()\n"
        "plt.title('Eroded Image')\n"
        "plt.imshow(eroded, 'gray')\n"
        "plt.show()\n\n"
        "# 膨胀操作\n"
        "dilated = cv2.dilate(bin_img, kernel)\n"
        "plt.figure()\n"
        "plt.title('Dilated Image')\n"
        "plt.imshow(dilated, 'gray')\n"
        "plt.show()\n"
    )

def unet():
    print(
        "# 实验：昇腾基于U-net医学图像分割# 任务一：展示数据集# 步骤1：导入所需库\n"
        "import os\n"
        "import argparse\n"
        "import ast\n"
        "import numpy as np\n"
        "import cv2\n"
        "import mindspore\n"
        "import mindspore.dataset as ds\n"
        "import mindspore.dataset.vision as vision\n"
        "from mindspore import nn, ops\n"
        "import matplotlib.pyplot as plt\n\n"
        "# 配置环境和设备\n"
        "device_target = \"Ascend\"\n"
        "mindspore.set_context(mode=mindspore.GRAPH_MODE, device_target=device_target)\n\n"
        "# 数据集说明和图像展示\n"
        "data_dir = \"/data/CV-ascend/B12/data\"\n"
        "# 加载图像和标签\n"
        "image=np.array([np.array(p) for p in image_sequence.Iterator(Image.open(os.path.join(data_dir, 'train-volume.tif')))])\n"
        "label = np.array([np.array(p) for p in image_sequence.Iterator(Image.open(os.path.join(data_dir, 'train-labels.tif')))])\n"
        "print(\"Image shape:\", image.shape)\n"
        "print(\"Label shape:\", label.shape)\n\n"
        "# 显示第一张图像和对应的标签\n"
        "plt.figure(figsize=(10, 5))\n"
        "plt.subplot(1, 2, 1)\n"
        "plt.title('Original Image')\n"
        "plt.imshow(image[0], cmap='gray')\n"
        "plt.subplot(1, 2, 2)\n"
        "plt.title('Corresponding Label')\n"
        "plt.imshow(label[0], cmap='gray')\n"
        "plt.show()\n\n"
        "# 使用大津阈值法进行图像分割\n"
        "ret, th = cv2.threshold(image[0], 0, 255, cv2.THRESH_BINARY + cv2.THRESH_OTSU)\n"
        "plt.figure()\n"
        "plt.title('Otsu Thresholding Result')\n"
        "plt.imshow(th, 'gray')\n"
        "plt.show()\n\n"
        "# 定义U-net网络结构（简化版）\n"
        "class DoubleConv(nn.Cell):\n"
        "    def __init__(self, in_channels, out_channels):\n"
        "        super(DoubleConv, self).__init__()\n"
        "        self.double_conv = nn.SequentialCell(\n"
        "            nn.Conv2d(in_channels, out_channels, kernel_size=3, has_bias=False),\n"
        "            nn.BatchNorm2d(out_channels),\n"
        "            nn.ReLU(),\n"
        "            nn.Conv2d(out_channels, out_channels, kernel_size=3, has_bias=False),\n"
        "            nn.BatchNorm2d(out_channels),\n"
        "            nn.ReLU()\n"
        "        )\n"
        "    def construct(self, x):\n"
        "        return self.double_conv(x)\n\n"
        "class UNet(nn.Cell):\n"
        "    def __init__(self, n_channels, n_classes):\n"
        "        super(UNet, self).__init__()\n"
        "        self.inc = DoubleConv(n_channels, 64)\n"
        "        self.down1 = nn.MaxPool2d(kernel_size=2)\n"
        "        self.conv1 = DoubleConv(64, 128)\n"
        "        self.down2 = nn.MaxPool2d(kernel_size=2)\n"
        "        self.conv2 = DoubleConv(128, 256)\n"
        "        self.down3 = nn.MaxPool2d(kernel_size=2)\n"
        "        self.conv3 = DoubleConv(256, 512)\n"
        "        self.down4 = nn.MaxPool2d(kernel_size=2)\n"
        "        self.conv4 = DoubleConv(512, 1024)\n"
        "        self.up1 = nn.Conv2dTranspose(1024, 512, kernel_size=2, stride=2)\n"
        "        self.conv5 = DoubleConv(1024, 512)\n"
        "        self.up2 = nn.Conv2dTranspose(512, 256, kernel_size=2, stride=2)\n"
        "        self.conv6 = DoubleConv(512, 256)\n"
        "        self.up3 = nn.Conv2dTranspose(256, 128, kernel_size=2, stride=2)\n"
        "        self.conv7 = DoubleConv(256, 128)\n"
        "        self.up4 = nn.Conv2dTranspose(128, 64, kernel_size=2, stride=2)\n"
        "        self.conv8 = DoubleConv(128, 64)\n"
        "        self.outc = nn.Conv2d(64, n_classes, kernel_size=1)\n\n"
        "    def construct(self, x):\n"
        "        x1 = self.inc(x)\n"
        "        x2 = self.down1(x1)\n"
        "        x2 = self.conv1(x2)\n"
        "        x3 = self.down2(x2)\n"
        "        x3 = self.conv2(x3)\n"
        "        x4 = self.down3(x3)\n"
        "        x4 = self.conv3(x4)\n"
        "        x5 = self.down4(x4)\n"
        "        x5 = self.conv4(x5)\n"
        "        x = self.up1(x5)\n"
        "        x = self.conv5(ops.concat((x4, x), axis=1))\n"
        "        x = self.up2(x)\n"
        "        x = self.conv6(ops.concat((x3, x), axis=1))\n"
        "        x = self.up3(x)\n"
        "        x = self.conv7(ops.concat((x2, x), axis=1))\n"
        "        x = self.up4(x)\n"
        "        x = self.conv8(ops.concat((x1, x), axis=1))\n"
        "        x = self.outc(x)\n"
        "        return x\n\n"
        "# 模型训练（简化示例）\n"
        "net = UNet(n_channels=1, n_classes=2)\n"
        "criterion = nn.SoftmaxCrossEntropyWithLogits(sparse=True, reduction='mean')\n"
        "optimizer = nn.Adam(net.trainable_params(), learning_rate=0.001)\n\n"
        "# 模拟训练过程\n"
        "for epoch in range(5):\n"
        "    print(f\"Epoch {epoch+1}/5 - Training in progress...\")\n"
        "print(\"Training completed.\")\n\n"
        "# 验证模型\n"
        "class DiceCoefficient(nn.Metric):\n"
        "    def __init__(self):\n"
        "        super(DiceCoefficient, self).__init__()\n"
        "        self.clear()\n\n"
        "    def clear(self):\n"
        "        self._dice_coeff_sum = 0\n"
        "        self._samples_num = 0\n\n"
        "    def update(self, *inputs):\n"
        "        if len(inputs) != 2:\n"
        "            raise ValueError(\"Need 2 inputs (preds, labels), but got {}\".format(len(inputs)))\n"
        "        y_pred = inputs[0]\n"
        "        y = inputs[1]\n"
        "        intersection = (y_pred * y).sum()\n"
        "        union = y_pred.sum() + y.sum()\n"
        "        dice_coeff = (2.0 * intersection + 1e-6) / (union + 1e-6)\n"
        "        self._dice_coeff_sum += dice_coeff.asnumpy()\n"
        "        self._samples_num += 1\n\n"
        "    def eval(self):\n"
        "        if self._samples_num == 0:\n"
        "            raise RuntimeError(\"Must have at least one sample to calculate.\")\n"
        "        return self._dice_coeff_sum / self._samples_num\n\n"
        "# 验证模型\n"
        "dice_coeff = DiceCoefficient()\n"
        "print(\"Validation Dice Coefficient:\", dice_coeff.eval())\n"
    )

def lvbo():
    print(
        "# 实验：昇腾图像滤波实操\n\n"
        "# 任务一：中值滤波\n"
        "import cv2\n"
        "import numpy as np\n"
        "import matplotlib.pyplot as plt\n"
        "%matplotlib inline\n\n"
        "# 步骤1：读取图像并应用中值滤波\n"
        "im = cv2.imread(\"/data/cv-ascend/images/panda.png\")\n"
        "im = cv2.cvtColor(im, cv2.COLOR_BGR2RGB)\n"
        "plt.figure()\n"
        "plt.title('Original Image')\n"
        "plt.imshow(im)\n\n"
        "# 调用OpenCV的中值模糊API\n"
        "img_medianblur = cv2.medianBlur(im, 5)\n"
        "plt.figure()\n"
        "plt.title('Median Blurred Image')\n"
        "plt.imshow(img_medianblur)\n"
        "plt.show()\n\n"
        "# 任务二：均值滤波\n"
        "# 方法一：直接调用OpenCV的API\n"
        "im = cv2.imread(\"/data/cv-ascend/images/panda.png\")\n"
        "im = cv2.cvtColor(im, cv2.COLOR_BGR2RGB)\n"
        "img_meanblur = cv2.blur(im, (3, 3))\n"
        "plt.figure()\n"
        "plt.title('Mean Blurred Image (API)')\n"
        "plt.imshow(img_meanblur)\n"
        "plt.show()\n\n"
        "# 方法二：使用均值算子和filter2D自定义滤波操作\n"
        "mean_blur = np.ones([3, 3], np.float32) / 9\n"
        "im_meanblur2 = cv2.filter2D(im, -1, mean_blur)\n"
        "plt.figure()\n"
        "plt.title('Mean Blurred Image (Custom)')\n"
        "plt.imshow(im_meanblur2)\n"
        "plt.show()\n\n"
        "# 任务三：高斯滤波\n"
        "# 方法一：直接调用OpenCV的API\n"
        "im = cv2.imread(\"/data/cv-ascend/images/panda.png\")\n"
        "im = cv2.cvtColor(im, cv2.COLOR_BGR2RGB)\n"
        "im_gaussianblur = cv2.GaussianBlur(im, (5, 5), 0)\n"
        "plt.figure()\n"
        "plt.title('Gaussian Blurred Image (API)')\n"
        "plt.imshow(im_gaussianblur)\n"
        "plt.show()\n\n"
        "# 方法二：使用高斯算子和filter2D自定义滤波操作\n"
        "gaussian_blur = np.array([\n"
        "    [1, 4, 7, 4, 1],\n"
        "    [4, 16, 26, 16, 4],\n"
        "    [7, 26, 41, 26, 7],\n"
        "    [4, 16, 26, 16, 4],\n"
        "    [1, 4, 7, 4, 1]], dtype=np.float32) / 273\n"
        "im_gaussianblur2 = cv2.filter2D(im, -1, gaussian_blur)\n"
        "plt.figure()\n"
        "plt.title('Gaussian Blurred Image (Custom)')\n"
        "plt.imshow(im_gaussianblur2)\n"
        "plt.show()\n\n"
        "# 任务四：锐化\n"
        "im = cv2.imread(\"/data/cv-ascend/images/panda.png\")\n"
        "im = cv2.cvtColor(im, cv2.COLOR_BGR2RGB)\n"
        "plt.figure()\n"
        "plt.title('Original Image')\n"
        "plt.imshow(im)\n\n"
        "# 锐化算子1\n"
        "sharpen = np.array([\n"
        "    [-1, -1, -1],\n"
        "    [-1, 9, -1],\n"
        "    [-1, -1, -1]])\n"
        "im_sharpen1 = cv2.filter2D(im, -1, sharpen)\n"
        "plt.figure()\n"
        "plt.title('Sharpened Image (Kernel 1)')\n"
        "plt.imshow(im_sharpen1)\n\n"
        "# 锐化算子2\n"
        "sharpen2 = np.array([\n"
        "    [0, -1, 0],\n"
        "    [-1, 5, -1],\n"
        "    [0, -1, 0]])\n"
        "im_sharpen2 = cv2.filter2D(im, -1, sharpen2)\n"
        "plt.figure()\n"
        "plt.title('Sharpened Image (Kernel 2)')\n"
        "plt.imshow(im_sharpen2)\n"
        "plt.show()\n\n"
        "# 任务五：双边滤波\n"
        "im = cv2.imread(\"/data/cv-ascend/images/panda.png\")\n"
        "im = cv2.cvtColor(im, cv2.COLOR_BGR2RGB)\n"
        "plt.figure()\n"
        "plt.title('Original Image')\n"
        "plt.imshow(im)\n\n"
        "# 调用OpenCV的双边滤波API\n"
        "im_bilateral = cv2.bilateralFilter(im, 5, 21, 21)\n"
        "plt.figure()\n"
        "plt.title('Bilateral Filtered Image')\n"
        "plt.imshow(im_bilateral)\n"
        "plt.show()\n"
    )


def tidu():
    print(
        "# 实验：昇腾HOG方向梯度直方图实操\n\n"
        "# 任务一：导入相关库并初始化\n"
        "import numpy as np\n"
        "import cv2\n"
        "from matplotlib import pyplot as plt\n"
        "%matplotlib inline\n\n"
        "# 设置默认图片大小\n"
        "plt.rcParams['figure.figsize'] = (14.0, 12.0)\n"
        "plt.rcParams['image.interpolation'] = 'nearest'\n"
        "plt.rcParams['image.cmap'] = 'gray'\n"
        "plt.rcParams['font.sans-serif'] = ['SimHei']\n"
        "plt.rcParams['axes.unicode_minus'] = False\n\n"
        "# 任务二：图像读取与预处理\n"
        "filename = \"/data/CV-ascend/images/body.jpg\"\n"
        "img = cv2.imread(filename)\n"
        "img = cv2.cvtColor(img, cv2.COLOR_BGR2RGB)\n\n"
        "# 图片的预处理：灰度处理\n"
        "gray = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY)\n\n"
        "# 任务三：生成特征向量descriptor\n"
        "winsize = (128, 128)\n"
        "blocksize = (64, 64)\n"
        "blockstride = (8, 8)\n"
        "cellsize = (16, 16)\n"
        "nbins = 9\n\n"
        "# 定义HOG特征检测器\n"
        "hog = cv2.HOGDescriptor(winsize, blocksize, blockstride, cellsize, nbins)\n\n"
        "# 利用HOG特征检测器对灰度图像生成特征向量descriptor\n"
        "descriptor = hog.compute(gray)\n\n"
        "print(\"图片HOG特征向量的大小为：\", descriptor.size)\n\n"
        "# 任务四：行人检测\n"
        "hog_SVM = cv2.HOGDescriptor()\n"
        "hog_SVM.setSVMDetector(hog_SVM.getDefaultPeopleDetector())\n\n"
        "# 对行人进行检测，得到目标的矩形框坐标\n"
        "result = gray.copy()\n"
        "peopleLocation = hog_SVM.detectMultiScale(result, 0, (8, 8), (16, 16), 1.05, 2.0)\n\n"
        "# 将得到的矩形框画在结果图中\n"
        "for i in range(len(peopleLocation[0])):\n"
        "    x, y, w, h = peopleLocation[0][i]\n"
        "    result = cv2.rectangle(result, (x, y), (x + w, y + h), (255, 255, 0), 3)\n\n"
        "# 任务五：检测结果显示\n"
        "plt.figure(figsize=(10, 10))\n"
        "plt.subplot(1, 3, 1)\n"
        "plt.imshow(img)\n"
        "plt.title('Original Image')\n"
        "plt.subplot(1, 3, 2)\n"
        "plt.imshow(gray)\n"
        "plt.title('Grayscale Image')\n"
        "plt.subplot(1, 3, 3)\n"
        "plt.imshow(result)\n"
        "plt.title('Detection Result')\n"
        "plt.show()\n"
    )


def erzhi():
    print(
        "# 实验：昇腾LBP局部二值模式实操\n\n"
        "# 任务一：导入相关库并初始化\n"
        "import numpy as np\n"
        "import cv2\n"
        "from matplotlib import pyplot as plt\n"
        "%matplotlib inline\n\n"
        "# 设置默认图片大小\n"
        "plt.rcParams['figure.figsize'] = (14.0, 12.0)\n"
        "plt.rcParams['image.interpolation'] = 'nearest'\n"
        "plt.rcParams['image.cmap'] = 'gray'\n"
        "plt.rcParams['font.sans-serif'] = ['SimHei']\n"
        "plt.rcParams['axes.unicode_minus'] = False\n\n"
        "# 任务二：图像读取与预处理\n"
        "filename = \"/data/CV-ascend/images/panda.png\"\n"
        "img = cv2.imread(filename)\n"
        "img = cv2.cvtColor(img, cv2.COLOR_BGR2RGB)\n\n"
        "# 图片的预处理：灰度处理\n"
        "gray = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY)\n\n"
        "# 任务三：LBP函数的实现\n"
        "def LBP(image):\n"
        "    height, width = image.shape\n"
        "    lbp_image = np.zeros((height - 2, width - 2), dtype=np.uint8)\n"
        "    for i in range(1, height - 1):\n"
        "        for j in range(1, width - 1):\n"
        "            center = image[i, j]\n"
        "            code = 0\n"
        "            code |= (image[i - 1, j - 1] >= center) << 7\n"
        "            code |= (image[i - 1, j] >= center) << 6\n"
        "            code |= (image[i - 1, j + 1] >= center) << 5\n"
        "            code |= (image[i, j + 1] >= center) << 4\n"
        "            code |= (image[i + 1, j + 1] >= center) << 3\n"
        "            code |= (image[i + 1, j] >= center) << 2\n"
        "            code |= (image[i + 1, j - 1] >= center) << 1\n"
        "            code |= (image[i, j - 1] >= center)\n"
        "            lbp_image[i - 1, j - 1] = code\n"
        "    return lbp_image\n\n"
        "# 任务四：对灰度图像进行LBP特征检测\n"
        "lbp_result = LBP(gray)\n\n"
        "# 任务五：原图、灰度图和LBP特征检测效果图的显示\n"
        "plt.figure(figsize=(15, 5))\n"
        "plt.subplot(1, 3, 1)\n"
        "plt.imshow(img)\n"
        "plt.title('Original Image')\n"
        "plt.subplot(1, 3, 2)\n"
        "plt.imshow(gray)\n"
        "plt.title('Grayscale Image')\n"
        "plt.subplot(1, 3, 3)\n"
        "plt.imshow(lbp_result)\n"
        "plt.title('LBP Result')\n"
        "plt.show()\n"
    )


def haer():
    print(
        "# 实验：昇腾哈尔特征实操\n\n"
        "# 任务一：导入相关库并初始化\n"
        "import numpy as np\n"
        "import cv2\n"
        "from matplotlib import pyplot as plt\n"
        "%matplotlib inline\n\n"
        "# 设置默认图片大小\n"
        "plt.rcParams['figure.figsize'] = (14.0, 12.0)\n"
        "plt.rcParams['image.interpolation'] = 'nearest'\n"
        "plt.rcParams['image.cmap'] = 'gray'\n"
        "plt.rcParams['font.sans-serif'] = ['SimHei']\n"
        "plt.rcParams['axes.unicode_minus'] = False\n\n"
        "# 任务二：图像读取与灰度处理\n"
        "filename = \"/data/CV-ascend/images/face.jpg\"\n"
        "img = cv2.imread(filename)\n"
        "img = cv2.resize(img, (80, 80))\n"
        "gray = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY)\n\n"
        "# 任务三：计算积分图\n"
        "def integral(img):\n"
        "    integral_graph = np.zeros((img.shape[0], img.shape[1]), dtype=np.int32)\n"
        "    for x in range(img.shape[0]):\n"
        "        sum_col = 0\n"
        "        for y in range(img.shape[1]):\n"
        "            sum_col += img[x, y]\n"
        "            integral_graph[x, y] = integral_graph[x - 1, y] + sum_col\n"
        "    return integral_graph\n\n"
        "# 任务四：Haar特征区域设置\n"
        "def get_haar_features_area(width, height):\n"
        "    features = []\n"
        "    for w in range(1, width):\n"
        "        for h in range(1, height // 2):\n"
        "            for x in range(width - w):\n"
        "                for y in range(height - 2 * h):\n"
        "                    features.append([x, y, w, h])\n"
        "    return features\n\n"
        "# 任务五：通过积分图特征区域计算Haar特征\n"
        "def cal_haar_features(integral_graph, features_graph, min_value):\n"
        "    haar_features = []\n"
        "    for num in range(len(features_graph)):\n"
        "        x, y, w, h = features_graph[num]\n"
        "        haar1 = integral_graph[x, y] + integral_graph[x + w, y + h] - integral_graph[x, y + h] - integral_graph[x + w, y]\n"
        "        haar2 = integral_graph[x, y + h] + integral_graph[x + w, y + 2 * h] - integral_graph[x, y + 2 * h] - integral_graph[x + w, y + h]\n"
        "        if haar2 - haar1 > min_value:\n"
        "            haar_features.append(haar2 - haar1)\n"
        "    return haar_features\n\n"
        "# 任务六：对灰度图像求Haar特征\n"
        "integral_graph = integral(gray)\n"
        "features_area = get_haar_features_area(gray.shape[0], gray.shape[1])\n"
        "haar_features = cal_haar_features(integral_graph, features_area, 0)\n"
        "print(\"当前图像的Haar特征数量为：\", len(haar_features))\n\n"
        "# 任务七：人脸检测实例\n"
        "face_cascade = cv2.CascadeClassifier(\"/data/CV-ascend/B08/haarcascade_frontalface_default.xml\")\n"
        "faces = face_cascade.detectMultiScale(gray, 1.3, 5)\n\n"
        "# 利用矩形框将检测出的人脸框出\n"
        "result = gray.copy()\n"
        "for (x, y, w, h) in faces:\n"
        "    result = cv2.rectangle(result, (x, y), (x + w, y + h), (255, 0, 0), 3)\n\n"
        "# 任务八：人脸检测结果显示\n"
        "plt.figure(figsize=(15, 5))\n"
        "plt.subplot(1, 3, 1)\n"
        "plt.imshow(img)\n"
        "plt.title('Original Image')\n"
        "plt.subplot(1, 3, 2)\n"
        "plt.imshow(gray)\n"
        "plt.title('Grayscale Image')\n"
        "plt.subplot(1, 3, 3)\n"
        "plt.imshow(result)\n"
        "plt.title('Face Detection Result')\n"
        "plt.show()\n"
    )


def juzhen():
    print(
        "# 实验：昇腾利用矩阵运算实现卷积\n\n"
        "# 任务一：导入工具包\n"
        "import matplotlib.pyplot as plt\n"
        "import numpy as np\n\n"
        "# 任务二：定义单核一维卷积运算\n"
        "def _convolve(img, fil):\n"
        "    fil_height = fil.shape[0]\n"
        "    fil_width = fil.shape[1]\n"
        "    conv_height = img.shape[0] - fil_height + 1\n"
        "    conv_width = img.shape[1] - fil_width + 1\n"
        "    conv = np.zeros((conv_height, conv_width), dtype=np.uint8)\n"
        "    for i in range(conv_height):\n"
        "        for j in range(conv_width):\n"
        "            conv[i, j] = np.sum(img[i:i + fil_height, j:j + fil_width] * fil)\n"
        "    return conv\n\n"
        "def wise_element_sum(img, fil):\n"
        "    return np.sum(img * fil)\n\n"
        "# 任务三：考虑图像的维度后定义卷积运算\n"
        "def convolve(img, fil):\n"
        "    if len(img.shape) == 3:\n"
        "        conv_b = _convolve(img[:, :, 0], fil)\n"
        "        conv_g = _convolve(img[:, :, 1], fil)\n"
        "        conv_r = _convolve(img[:, :, 2], fil)\n"
        "        return np.dstack([conv_b, conv_g, conv_r])\n"
        "    elif len(img.shape) == 2:\n"
        "        return _convolve(img, fil)\n\n"
        "# 任务四：实现卷积运算\n"
        "# 步骤1：加载图像\n"
        "im_gray = cv2.imread(\"/data/cv-ascend/images/panda.png\", 0)\n"
        "plt.imshow(im_gray, 'gray')\n"
        "plt.show()\n\n"
        "# 步骤2：定义卷积核参数\n"
        "fil = np.array([[0, -1, 0], [-1, 4, -1], [0, -1, 0]])\n\n"
        "# 步骤3：卷积操作\n"
        "res = convolve(im_gray, fil)\n\n"
        "# 步骤4：打印参数及可视化\n"
        "print(\"卷积前图像的大小：\", im_gray.shape)\n"
        "print(\"卷积后图像的大小：\", res.shape)\n"
        "plt.figure()\n"
        "plt.imshow(im_gray, 'gray')\n"
        "plt.figure()\n"
        "plt.imshow(res, 'gray')\n"
        "plt.show()\n"
    )

if __name__ == '__main__':
    jichu()
    huidu()
    jihe()
    xingtai()
    unet()
    lvbo()
    tidu()
    erzhi()
    haer()
    juzhen()
