# coding: utf-8
# Copyright 2023 Ant Group CO., Ltd.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
# in compliance with the License. You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software distributed under the License
# is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
# or implied.


"""
    knext

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from knext.rest.configuration import Configuration


class RelationMappingNodeConfig(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "type": "str",
        "relation": "str",
        "mapping_filters": "list[MappingFilter]",
        "mapping_configs": "list[MappingConfig]",
        "predicting_configs": "list[PredictingConfig]",
    }

    attribute_map = {
        "type": "type",
        "relation": "relation",
        "mapping_filters": "mappingFilters",
        "mapping_configs": "mappingConfigs",
        "predicting_configs": "predictingConfigs",
    }

    def __init__(
        self,
        type="RELATION_MAPPING",
        relation=None,
        mapping_filters=None,
        mapping_configs=None,
        predicting_configs=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """RelationMappingNodeConfig - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._type = None
        self._relation = None
        self._mapping_filters = None
        self._mapping_configs = None
        self._predicting_configs = None
        self.discriminator = type

        self.type = type
        if relation is not None:
            self.relation = relation
        if mapping_filters is not None:
            self.mapping_filters = mapping_filters
        if mapping_configs is not None:
            self.mapping_configs = mapping_configs
        if predicting_configs is not None:
            self.predicting_configs = predicting_configs

    @property
    def type(self):
        """Gets the type of this RelationMappingNodeConfig.  # noqa: E501


        :return: The type of this RelationMappingNodeConfig.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this RelationMappingNodeConfig.


        :param type: The type of this RelationMappingNodeConfig.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and type is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `type`, must not be `None`"
            )  # noqa: E501
        allowed_values = [
            "CSV_SOURCE",
            "SPG_TYPE_MAPPING",
            "RELATION_MAPPING",
            "SUBGRAPH_MAPPING",
            "USER_DEFINED_EXTRACT",
            "LLM_BASED_EXTRACT",
            "GRAPH_SINK",
        ]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and type not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}".format(  # noqa: E501
                    type, allowed_values
                )
            )

        self._type = type

    @property
    def relation(self):
        """Gets the relation of this RelationMappingNodeConfig.  # noqa: E501


        :return: The relation of this RelationMappingNodeConfig.  # noqa: E501
        :rtype: str
        """
        return self._relation

    @relation.setter
    def relation(self, relation):
        """Sets the relation of this RelationMappingNodeConfig.


        :param relation: The relation of this RelationMappingNodeConfig.  # noqa: E501
        :type: str
        """

        self._relation = relation

    @property
    def mapping_filters(self):
        """Gets the mapping_filters of this RelationMappingNodeConfig.  # noqa: E501


        :return: The mapping_filters of this RelationMappingNodeConfig.  # noqa: E501
        :rtype: list[MappingFilter]
        """
        return self._mapping_filters

    @mapping_filters.setter
    def mapping_filters(self, mapping_filters):
        """Sets the mapping_filters of this RelationMappingNodeConfig.


        :param mapping_filters: The mapping_filters of this RelationMappingNodeConfig.  # noqa: E501
        :type: list[MappingFilter]
        """

        self._mapping_filters = mapping_filters

    @property
    def mapping_configs(self):
        """Gets the mapping_configs of this RelationMappingNodeConfig.  # noqa: E501


        :return: The mapping_configs of this RelationMappingNodeConfig.  # noqa: E501
        :rtype: list[MappingConfig]
        """
        return self._mapping_configs

    @mapping_configs.setter
    def mapping_configs(self, mapping_configs):
        """Sets the mapping_configs of this RelationMappingNodeConfig.


        :param mapping_configs: The mapping_configs of this RelationMappingNodeConfig.  # noqa: E501
        :type: list[MappingConfig]
        """

        self._mapping_configs = mapping_configs

    @property
    def predicting_configs(self):
        """Gets the predicting_configs of this RelationMappingNodeConfig.  # noqa: E501


        :return: The predicting_configs of this RelationMappingNodeConfig.  # noqa: E501
        :rtype: list[PredictingConfig]
        """
        return self._predicting_configs

    @predicting_configs.setter
    def predicting_configs(self, predicting_configs):
        """Sets the predicting_configs of this RelationMappingNodeConfig.


        :param predicting_configs: The predicting_configs of this RelationMappingNodeConfig.  # noqa: E501
        :type: list[PredictingConfig]
        """

        self._predicting_configs = predicting_configs

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RelationMappingNodeConfig):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RelationMappingNodeConfig):
            return True

        return self.to_dict() != other.to_dict()
