# -----------------------------------------------------------
# Copyright (c) 2023 Lauris BH
# SPDX-License-Identifier: MIT
# -----------------------------------------------------------

from typing import Final

from .consts import Region


COUNTRIES = {
    'AD': 'AND',
    'AE': 'UAE',
    'AF': 'AFG',
    'AG': 'ANT',
    'AL': 'ALB',
    'AM': 'ARM',
    'AR': 'ARG',
    'AT': 'AUT',
    'AZ': 'AZE',
    'BB': 'BAR',
    'BD': 'BAN',
    'BE': 'BEL',
    'BG': 'BUL',
    'BH': 'BRN',
    'BN': 'BRU',
    'BO': 'BOL',
    'BR': 'BRA',
    'BS': 'BAH',
    'BT': 'BHU',
    'BY': 'BLR',
    'BZ': 'BIZ',
    'CA': 'CAN',
    'CH': 'SUI',
    'CL': 'CHI',
    'CN': 'CHN',
    'CO': 'COL',
    'CR': 'CRC',
    'CU': 'CUB',
    'CY': 'CYP',
    'CZ': 'CZE',
    'DE': 'GER',
    'DI': 'SLO',
    'DK': 'DEN',
    'DM': 'DMA',
    'DO': 'DOM',
    'EC': 'ECU',
    'EE': 'EST',
    'ES': 'ES',
    'FI': 'FIN',
    'FR': 'FRA',
    'GB': 'GBR',
    'GD': 'GRN',
    'GE': 'GEO',
    'GR': 'GRE',
    'GT': 'GUA',
    'GY': 'GUY',
    'HK': 'HKG',
    'HN': 'HON',
    'HR': 'CRO',
    'HT': 'HAI',
    'HU': 'HUN',
    'ID': 'INA',
    'IE': 'IRL',
    'IL': 'ISR',
    'IN': 'IND',
    'IQ': 'IRQ',
    'IR': 'IRI',
    'IS': 'ISL',
    'IT': 'ITA',
    'JM': 'JAM',
    'JO': 'JOR',
    'JP': 'JPN',
    'KG': 'KGZ',
    'KH': 'CAM',
    'KP': 'PRK',
    'KR': 'KOR',
    'KW': 'KUW',
    'KZ': 'KAZ',
    'LA': 'LAO',
    'LB': 'LIB',
    'LC': 'LCA',
    'LI': 'LIE',
    'LK': 'SRI',
    'LT': 'LTU',
    'LU': 'LUX',
    'LV': 'LAT',
    'MC': 'MAS',
    'MD': 'MDA',
    'ME': 'MNE',
    'MK': 'MKD',
    'MM': 'MYA',
    'MN': 'MGL',
    'MO': 'Macao',
    'MT': 'MLT',
    'MV': 'MDV',
    'MX': 'MEX',
    'NI': 'NCA',
    'NL': 'NED',
    'NO': 'NOR',
    'NP': 'NEP',
    'OM': 'OMA',
    'PA': 'PAN',
    'PE': 'PER',
    'PH': 'PHI',
    'PK': 'PAK',
    'PL': 'POL',
    'PT': 'POR',
    'PY': 'PAR',
    'QA': 'QAT',
    'RO': 'ROU',
    'RS': 'SRB',
    'RU': 'RUS',
    'SA': 'KSA',
    'SE': 'SWE',
    'SG': 'SIN',
    'SK': 'SVK',
    'SM': 'SMR',
    'SR': 'SUR',
    'SV': 'ESA',
    'SY': 'SYR',
    'TH': 'THA',
    'TJ': 'TJK',
    'TL': 'TLS',
    'TM': 'TKM',
    'TR': 'TUR',
    'TT': 'TRI',
    'UA': 'UKR',
    'US': 'USA',
    'UY': 'URU',
    'UZ': 'UZB',
    'VA': 'VCS',
    'VC': 'VIN',
    'VE': 'VEN',
    'VN': 'VIE',
    'YE': 'YEM',
    'BIH': 'BIH',
    'PLE': 'PLE',
    'SKN': 'SKN',
    'TWN': 'TWN',
}

COUNTRY_REGIONS: Final = {
    'AND': Region.EU,
    'UAE': Region.EU,
    'AFG': Region.CN,
    'ANT': Region.US,
    'ALB': Region.EU,
    'ARM': Region.EU,
    'ARG': Region.US,
    'AUT': Region.EU,
    'AZE': Region.EU,
    'BAR': Region.US,
    'BAN': Region.CN,
    'BEL': Region.EU,
    'BUL': Region.EU,
    'BRN': Region.EU,
    'BRU': Region.CN,
    'BOL': Region.US,
    'BRA': Region.US,
    'BAH': Region.US,
    'BHU': Region.CN,
    'BLR': Region.EU,
    'BIZ': Region.US,
    'CAN': Region.US,
    'SUI': Region.EU,
    'CHI': Region.US,
    'CHN': Region.CN,
    'COL': Region.US,
    'CRI': Region.US,
    'CUB': Region.US,
    'CYP': Region.EU,
    'CZE': Region.EU,
    'GER': Region.EU,
    'DEN': Region.EU,
    'DMA': Region.US,
    'DOM': Region.US,
    'ECU': Region.US,
    'EST': Region.EU,
    'ESP': Region.EU,
    'FIN': Region.EU,
    'FRA': Region.EU,
    'GBR': Region.EU,
    'GRN': Region.US,
    'GEO': Region.EU,
    'GRE': Region.EU,
    'GUA': Region.US,
    'GUY': Region.US,
    'HKG': Region.CN,
    'HON': Region.US,
    'CRO': Region.EU,
    'HAI': Region.US,
    'HUN': Region.EU,
    'INA': Region.CN,
    'IRL': Region.EU,
    'ISR': Region.EU,
    'IND': Region.CN,
    'IRQ': Region.EU,
    'IRI': Region.EU,
    'ISL': Region.EU,
    'ITA': Region.EU,
    'JAM': Region.US,
    'JOR': Region.EU,
    'JPN': Region.CN,
    'KEN': Region.EU,
    'KGZ': Region.CN,
    'CAM': Region.CN,
    'KOR': Region.CN,
    'KUW': Region.EU,
    'KAZ': Region.CN,
    'LAO': Region.CN,
    'LIB': Region.EU,
    'LCA': Region.US,
    'LIE': Region.EU,
    'SRI': Region.CN,
    'LTU': Region.EU,
    'LUX': Region.EU,
    'LAT': Region.EU,
    'MAS': Region.CN,
    'MON': Region.EU,
    'MDA': Region.EU,
    'MGL': Region.CN,
    'Macao': Region.CN,
    'MAC': Region.CN,
    'MEX': Region.US,
    'NED': Region.EU,
    'NOR': Region.EU,
    'NEP': Region.CN,
    'NZL': Region.US,
    'OMA': Region.EU,
    'PAN': Region.US,
    'PER': Region.US,
    'PHI': Region.CN,
    'PAK': Region.CN,
    'POL': Region.EU,
    'PUR': Region.US,
    'POR': Region.EU,
    'PAR': Region.US,
    'QAT': Region.EU,
    'ROU': Region.EU,
    'SRB': Region.EU,
    'RUS': Region.EU,
    'KSA': Region.EU,
    'SIN': Region.CN,
    'SVK': Region.EU,
    'SMR': Region.EU,
    'SUR': Region.US,
    'ESA': Region.US,
    'SYR': Region.EU,
    'THA': Region.CN,
    'TJK': Region.CN,
    'TLS': Region.CN,
    'TKM': Region.CN,
    'TUR': Region.EU,
    'TRI': Region.US,
    'UKR': Region.EU,
    'USA': Region.US,
    'URU': Region.US,
    'UZB': Region.CN,
    'VCS': Region.US,
    'VIN': Region.US,
    'VEN': Region.US,
    'VIE': Region.CN,
    'YEM': Region.EU,
    'BIH': Region.EU,
    'PLE': Region.EU,
    'SKN': Region.US,
    'TWN': Region.CN,
}


def get_country_code(country: str) -> str:
    """Get country code."""

    country = country.upper()
    if country in COUNTRIES:
        return COUNTRIES[country]
    return country


def get_region_by_country(country: str) -> Region:
    """Get region by country."""

    country = get_country_code(country)

    # Return region (US, EU or CN) based on country code
    if country in COUNTRY_REGIONS:
        return COUNTRY_REGIONS[country]
    return Region.EU
