"""Custom pyplot style and palette."""

import matplotlib.pyplot as plt
import seaborn as sns

plt.rcParams.update(
    {
        "figure.dpi": 120,
        "savefig.dpi": 300,
        "figure.figsize": (7, 4.33),
        "lines.linewidth": 2,
        "axes.spines.bottom": False,
        "axes.spines.top": False,
        "axes.spines.left": False,
        "axes.spines.right": False,
        "axes.grid": True,
        "axes.grid.axis": "y",
        "ytick.left": False,
        "grid.linewidth": 0.8,
        "grid.alpha": 0.8,
        "font.family": "Lato",
        "font.weight": "regular",
    }
)

glasbey_bw_50 = [
    (0.843137, 0.0, 0.0, 1.0),
    (0.54902, 0.235294, 1.0, 1.0),
    (0.007843000000000044, 0.533333, 0.0, 1.0),
    (0.0, 0.67451, 0.780392, 1.0),
    (0.596078, 1.0, 0.0, 1.0),
    (1.0, 0.498039, 0.819608, 1.0),
    (0.42352900000000004, 0.0, 0.3098040000000001, 1.0),
    (1.0, 0.647059, 0.188235, 1.0),
    (0.0, 0.0, 0.615686, 1.0),
    (0.52549, 0.439216, 0.407843, 1.0),
    (0.0, 0.286275, 0.258824, 1.0),
    (0.309804, 0.164706, 0.0, 1.0),
    (0.0, 0.992157, 0.811765, 1.0),
    (0.737255, 0.717647, 1.0, 1.0),
    (0.584314, 0.705882, 0.47843100000000005, 1.0),
    (0.752941, 0.015685999999999978, 0.72549, 1.0),
    (0.14509800000000006, 0.4, 0.635294, 1.0),
    (0.156863, 0.0, 0.254902, 1.0),
    (0.862745, 0.701961, 0.686275, 1.0),
    (0.996078, 0.960784, 0.564706, 1.0),
    (0.31372500000000003, 0.27058799999999994, 0.356863, 1.0),
    (0.643137, 0.486275, 0.0, 1.0),
    (1.0, 0.443137, 0.4, 1.0),
    (0.24705900000000003, 0.505882, 0.431373, 1.0),
    (0.509804, 0.0, 0.050980000000000025, 1.0),
    (0.639216, 0.482353, 0.701961, 1.0),
    (0.203922, 0.305882, 0.0, 1.0),
    (0.607843, 0.894118, 1.0, 1.0),
    (0.921569, 0.0, 0.46666699999999994, 1.0),
    (0.17647099999999993, 0.0, 0.03921599999999997, 1.0),
    (0.368627, 0.564706, 1.0, 1.0),
    (0.0, 0.780392, 0.12549, 1.0),
    (0.345098, 0.003921999999999981, 0.666667, 1.0),
    (0.0, 0.117647, 0.0, 1.0),
    (0.603922, 0.278431, 0.0, 1.0),
    (0.588235, 0.623529, 0.65098, 1.0),
    (0.607843, 0.258824, 0.360784, 1.0),
    (0.0, 0.12156899999999998, 0.196078, 1.0),
    (0.784314, 0.768627, 0.0, 1.0),
    (1.0, 0.815686, 1.0, 1.0),
    (0.0, 0.745098, 0.603922, 1.0),
    (0.215686, 0.08235300000000001, 1.0, 1.0),
    (0.176471, 0.145098, 0.14509799999999995, 1.0),
    (0.8745100000000001, 0.345098, 1.0, 1.0),
    (0.745098, 0.905882, 0.752941, 1.0),
    (0.498039, 0.27058799999999994, 0.596078, 1.0),
    (0.321569, 0.309804, 0.235294, 1.0),
    (0.847059, 0.4, 0.0, 1.0),
    (0.392157, 0.454902, 0.219608, 1.0),
    (0.756863, 0.45098, 0.533333, 1.0),
]

sns.set_palette(glasbey_bw_50)
palette = sns.color_palette()
