from huza.icons.img import image_dict
from PyQt5 import QtGui, QtCore


class IconHandlerBase:

    def __init__(self):
        self._qicon_cache = {}
        self._icon_database = {}

    def _set_img_database(self, img_data_base):
        self._icon_database.update(img_data_base)

    def __getattr__(self, attr):
        if self._icon_database.get(attr) is not None:
            icon_from_db = self._icon_database[attr]
            len_icon_db = len(icon_from_db)
            if len_icon_db < 3:
                data, filetype = icon_from_db
                try:
                    return self._qicon_cache[data]
                except:
                    icon = QtGui.QIcon(QtGui.QPixmap.fromImage(
                        QtGui.QImage().fromData(QtCore.QByteArray.fromBase64(bytes(data, encoding='utf-8')),
                                                format=filetype)))
                    self._qicon_cache[data] = icon
            else:
                data, filetype, data2 = icon_from_db
                try:
                    return self._qicon_cache[data]
                except:
                    icon = QtGui.QIcon(QtGui.QPixmap.fromImage(
                        QtGui.QImage().fromData(QtCore.QByteArray.fromBase64(bytes(data, encoding='utf-8')),
                                                format=filetype)))
                    icon.addPixmap(QtGui.QPixmap.fromImage(
                        QtGui.QImage().fromData(QtCore.QByteArray.fromBase64(bytes(data2, encoding='utf-8')),
                                                format=filetype)),
                        state=QtGui.QIcon.On)
                    self._qicon_cache[data] = icon

            return icon
        return None


class IconHandler(IconHandlerBase):
    def get_picmap(self, attr):
        if self._icon_database.get(attr) is not None:
            icon_from_db = self._icon_database[attr]
            len_icon_db = len(icon_from_db)
            if len_icon_db < 3:
                data, filetype = icon_from_db
                try:
                    return self._qicon_cache[data]
                except:
                    icon = QtGui.QPixmap.fromImage(
                        QtGui.QImage().fromData(QtCore.QByteArray.fromBase64(bytes(data, encoding='utf-8')),
                                                format=filetype))
                    self._qicon_cache[data] = icon
            else:
                data, filetype, data2 = icon_from_db
                try:
                    return self._qicon_cache[data]
                except:
                    icon = QtGui.QPixmap.fromImage(
                        QtGui.QImage().fromData(QtCore.QByteArray.fromBase64(bytes(data, encoding='utf-8')),
                                                format=filetype))
                    self._qicon_cache[data] = icon

            return icon
        return None


class DefaultIconHandler(IconHandler):
    def __init__(self):
        super(DefaultIconHandler, self).__init__()
        self._icon_database = image_dict

    def __show_context(self):
        """函数没有啥用处，只是为了能够提示补全"""
        self.ACos563 = None
        self.ACot561 = None
        self.ARanalysis598 = None
        self.ASin569 = None
        self.ATan562 = None
        self.Absolutecenter432 = None
        self.Absoluteisometric425 = None
        self.Absolutevalue564 = None
        self.Accelerate367 = None
        self.Accountnumber196 = None
        self.Accountnumber740 = None
        self.Add592 = None
        self.Adddata231 = None
        self.Adddata6 = None
        self.Addfigure657 = None
        self.Addframecheme31 = None
        self.Addlayer29 = None
        self.Addline344 = None
        self.Addplottingmap88 = None
        self.Addressmatch817 = None
        self.Advancedfeatures22 = None
        self.Advancedtools35 = None
        self.Aggregate802 = None
        self.Aggregationdiagram251 = None
        self.Aggregationfigure754 = None
        self.Aimingpointalignment266 = None
        self.Airqualityanalysis606 = None
        self.Align694 = None
        self.Alignends265 = None
        self.Alignleft272 = None
        self.Alignleft421 = None
        self.Alignright279 = None
        self.Alignright407 = None
        self.Alignup413 = None
        self.Amendment258 = None
        self.Analysis773 = None
        self.Analysismode139 = None
        self.Analysisprocess517 = None
        self.And627 = None  # asdf
        self.Annotationmanagement239 = None
        self.Area310 = None
        self.Areadrawing796 = None
        self.Armap107 = None
        self.Artificialneuralnetworkcellularautomata816 = None
        self.Artificialneuralnetworktraining809 = None
        self.Ascending340 = None
        self.Associatedbrowsing191 = None
        self.Attribute343 = None
        self.Attributeextraction166 = None
        self.Attributetodictionary583 = None
        self.Automaticcrolling73 = None
        self.Autumn599 = None
        self.Auxiliarydrawing41 = None
        self.Avoidaddingpictures87 = None
        self.Avoidancearea485 = None
        self.Avoidancearea778 = None
        self.Avoiddeletingpictures482 = None
        self.Avoiddeletingpictures80 = None
        self.BIMlightweight441 = None
        self.Backgroundcolor267 = None
        self.Bandmanagement656 = None
        self.Batchdrawing621 = None
        self.Batchgenerationcache164 = None
        self.Blackandwhite618 = None
        self.Blank244 = None
        self.Blocktatistics803 = None
        self.Blocktatistics825 = None
        self.Bold280 = None
        self.Booleanoperation451 = None
        self.Bottom405 = None
        self.Box371 = None
        self.Bright538 = None
        self.Brightness584 = None
        self.Browse771 = None
        self.Browsecene750 = None
        self.Browsemaps752 = None
        self.Browsemode594 = None
        self.Browseproperties718 = None
        self.Bshapeampling544 = None
        self.Buffer157 = None
        self.Buildinganetwork155 = None
        self.Buildinghouses513 = None
        self.Buildingpitchedroofs438 = None
        self.Buildnetwork726 = None
        self.Buildtim168 = None
        self.By596 = None
        self.CMYKmode566 = None
        self.Cache325 = None
        self.Calculategeometricattributes335 = None
        self.Calculatehortestpath_grid_671 = None
        self.Calculatethehortestpath_vector_672 = None
        self.Calculatethehortestpath675 = None
        self.Cancel214 = None
        self.Cartography127 = None
        self.Centeralignment273 = None
        self.Centerleftandright420 = None
        self.Centerupanddown430 = None
        self.Chart114 = None
        self.Chartdatawarehousing20 = None
        self.Check217 = None
        self.Classdiagram652 = None
        self.Clear221 = None
        self.Clear293 = None
        self.Clicktart50 = None
        self.Closeall192 = None
        self.Closedocument17 = None
        self.Clusterdistribution138 = None
        self.Color286 = None
        self.Color595 = None
        self.Coloradjustment712 = None
        self.Colorchannel567 = None
        self.Colorcheme831 = None
        self.Colorenhancement586 = None
        self.Colorlibrary625 = None
        self.Colormanagement777 = None
        self.Columnartackingfigure785 = None
        self.Combination416 = None
        self.Combination691 = None
        self.Compass427 = None
        self.Compoundtyle241 = None
        self.Compressandmonomer180 = None
        self.Computer3 = None
        self.Condition620 = None
        self.Cone376 = None
        self.Connectedtochart808 = None
        self.Connectedtochartot812 = None
        self.Connection216 = None
        self.Constructvoxelgrid165 = None
        self.Contour276 = None
        self.Contour408 = None
        self.Contour805 = None
        self.Contouranalysis471 = None
        self.Contrast585 = None
        self.Controlpointetting715 = None
        self.Convertfromline360 = None
        self.Convertfromlinetopath369 = None
        self.Convertfromlinetotation363 = None
        self.Convertymbollibrary659 = None
        self.Convexhull445 = None
        self.Cooltone645 = None
        self.Coordinatepositioning11 = None
        self.Copy292 = None
        self.Copy45 = None
        self.Cos582 = None
        self.Cosh588 = None
        self.Createaddressindex649 = None
        self.Createampleclassificationtemplate632 = None
        self.Createmapindex648 = None
        self.Createrandompoints814 = None
        self.Createroofelevationinformation572 = None
        self.Curvepath98 = None
        self.Custom201 = None
        self.Custom257 = None
        self.Custom653 = None
        self.Custom764 = None
        self.Custom801 = None
        self.Customlegend650 = None
        self.Custompanel504 = None
        self.Customtemplatemanagement798 = None
        self.Cylinder381 = None
        self.DEMbuild148 = None
        self.Data736 = None
        self.Dataacquisition116 = None
        self.Database117 = None
        self.Databasetype110 = None
        self.Dataconsolidation60 = None
        self.Datadownload206 = None
        self.Dataexport122 = None
        self.Dataharing173 = None
        self.Dataharing521 = None
        self.Dataimport123 = None
        self.Datamanagement175 = None
        self.Dataource744 = None
        self.Dataource829 = None
        self.Dataourceconversion529 = None
        self.Dataourceconversion727 = None
        self.Dataplitting59 = None
        self.Dataprocessing178 = None
        self.Dataprocessing757 = None
        self.Dataprocessing762 = None
        self.Dataprocessing9 = None
        self.Datasetprojectionconversion0 = None
        self.Datatorageconversion530 = None
        self.Dataupdate1 = None
        self.Dataupload204 = None
        self.Datawarehousing77 = None
        self.Decelerate364 = None
        self.Defaultattribute33 = None
        self.Defaultattribute483 = None
        self.Delayedrefresh27 = None
        self.Deleteduplicatepoints557 = None
        self.Deleteline283 = None
        self.Deleteline341 = None
        self.Deleteuspendedolids440 = None
        self.Densityanalysis137 = None
        self.Densityclustering532 = None
        self.Descending338 = None
        self.Desktop67 = None
        self.Dictionarylibrary624 = None
        self.Dictionarylibraryfile647 = None
        self.Dictionarytoattribute611 = None
        self.Digging448 = None
        self.Disassembling423 = None
        self.Display44 = None
        self.Displayactionlabel48 = None
        self.Displayallrecords515 = None
        self.Displaymode39 = None
        self.Displaynavigationchart66 = None
        self.Displaytheelectedrecord520 = None
        self.Displaytime615 = None
        self.Distance311 = None
        self.Distance748 = None
        self.Distancegrid145 = None
        self.Dmplusworkspace679 = None
        self.Document113 = None
        self.Dotchart791 = None
        self.Drawing781 = None
        self.Drawingettings297 = None
        self.Drawinginspection21 = None
        self.Drawlocator644 = None
        self.Dynamicegmentation161 = None
        self.Dynamicegmentation731 = None
        self.Dynamictext612 = None
        self.EGCelevationtorage38 = None
        self.EPSexport635 = None
        self.EPSimport590 = None
        self.Eagleeye224 = None
        self.Edit706 = None
        self.Ellipsoid379 = None
        self.Environmentettings143 = None
        self.Equalize419 = None
        self.Equalize821 = None
        self.Equalto629 = None
        self.Equalwidth433 = None
        self.Equalwidth804 = None
        self.Escrow667 = None
        self.Except610 = None
        self.Execute751 = None
        self.Execution215 = None
        self.ExitHide65 = None
        self.ExitZoom92 = None
        self.Exitretreat84 = None
        self.Export213 = None
        self.Exportamplelibrary637 = None
        self.Exportastool209 = None
        self.Exportquicklaunch502 = None
        self.Exporttatisticalchart242 = None
        self.Exporttopython210 = None
        self.Extract3Ddata182 = None
        self.Extractattribute167 = None
        self.Extractboundaryline129 = None
        self.Extractdata187 = None
        self.Extractdata512 = None
        self.Extractmvalue162 = None
        self.FTPdirectory810 = None
        self.Face299 = None
        self.Face409 = None
        self.Fenceanalysis536 = None
        self.Fieldindex104 = None
        self.Figure501 = None
        self.Fileelection172 = None
        self.Filetype118 = None
        self.Fillandcutanalysis474 = None
        self.Filltyle725 = None
        self.Fillymbol282 = None
        self.Fillymbol355 = None
        self.Fillymbol404 = None
        self.Findandlocate233 = None
        self.Fixedize271 = None
        self.Flashing8 = None
        self.Flight10 = None
        self.Flight365 = None
        self.Flowpatterncorrection524 = None
        self.Folder826 = None
        self.Forecast551 = None
        self.Foregroundcolor268 = None
        self.Forward666 = None
        self.Fourcolors261 = None
        self.Frontview76 = None
        self.Fullcreen90 = None
        self.Fullcreenpreview495 = None
        self.Fullpagedisplay396 = None
        self.Fullwidth225 = None
        self.Fullwidth399 = None
        self.Fullwidth475 = None
        self.Functionbutton516 = None
        self.Fusion2 = None
        self.GDBimport638 = None
        self.Generate2D463 = None
        self.Generatedistancegrid674 = None
        self.Generatedistancegrid677 = None
        self.Generatedom468 = None
        self.Generatedsm469 = None
        self.Generateelevation462 = None
        self.Generatemapcacheandpublish665 = None
        self.Generatemapcheme32 = None
        self.Generatemodelcacheandpublish660 = None
        self.Generatepatialweightmatrixfile134 = None
        self.Generatepointcloudcache183 = None
        self.Generatepointcloudcacheandpublish668 = None
        self.Generatetincacheandpublish662 = None
        self.Generateviewframelist36 = None
        self.Geographicimulation811 = None
        self.Geologicalbody184 = None
        self.Global324 = None
        self.Global86 = None
        self.Globalcoherentroaming63 = None
        self.Gotothelastline332 = None
        self.Grademovementymbol250 = None
        self.Gradeymbol255 = None
        self.Gradeymbol772 = None
        self.Grayscale600 = None
        self.Greaterthan609 = None
        self.Greaterthanorequalto581 = None
        self.Grid806 = None
        self.Gridanalysis737 = None
        self.Griddiagram245 = None
        self.Gridquery141 = None
        self.Gridtatistics152 = None
        self.Gridvectorization720 = None
        self.GroundtreetView658 = None
        self.Growth99 = None
        self.HSBmode568 = None
        self.Harddisk93 = None
        self.Height318 = None
        self.Help776 = None
        self.Hex337 = None
        self.Hidecolumn345 = None
        self.Hiderow342 = None
        self.Hideystemfield329 = None
        self.Histogram142 = None
        self.Histogram789 = None
        self.Horizontalcenter411 = None
        self.Horizontalequidistant431 = None
        self.Horizontaltext499 = None
        self.Hue579 = None
        self.Hydrologicalanalysis146 = None
        self.Iconfile356 = None
        self.Image_Normal177 = None
        self.Imagedataconversion46 = None
        self.Imagedatawarehousing69 = None
        self.Imagepyramid124 = None
        self.Imagethematiccut68 = None
        self.Implementation156 = None
        self.Import208 = None
        self.Importamplelibrary628 = None
        self.Importcogo522 = None
        self.Importdrawinginformation603 = None
        self.Importingplacenameinformation54 = None
        self.Importtocurrentwindow211 = None
        self.Inclinedtorage170 = None
        self.Inclinedtorage465 = None
        self.Informationboard503 = None
        self.Informationinquiry75 = None
        self.Interpolationanalysis140 = None
        self.Intervisibilityanalysis466 = None
        self.Inundationanalysis472 = None
        self.Invisible323 = None
        self.Issue489 = None
        self.Italic275 = None
        self.Iterationfile815 = None
        self.Iterativedataset818 = None
        self.Key414 = None
        self.Key78 = None
        self.Labelmode190 = None
        self.Labelpretreatment263 = None
        self.Ladderdiagram790 = None
        self.Landmark383 = None
        self.Largecreenproduction497 = None
        self.Layercontrol34 = None
        self.Layerplayback605 = None
        self.Layerproperties230 = None
        self.Layerproperties309 = None
        self.Layertyle284 = None
        self.Layertyle743 = None
        self.Layout121 = None
        self.Layoutbrowsing700 = None
        self.Layoutettings697 = None
        self.Layoutproperties390 = None
        self.Layoutproperties714 = None
        self.LeftItalic277 = None
        self.Lessthan639 = None
        self.Licenseplaterecognition542 = None
        self.Line302 = None
        self.Line417 = None
        self.Lineardistancegrid678 = None
        self.Linechart794 = None
        self.Linetopologycheck130 = None
        self.Linetyle747 = None
        self.Linetylecolor288 = None
        self.Lineymbol281 = None
        self.Lineymbol357 = None
        self.Lineymbol403 = None
        self.Loadingtatistics256 = None
        self.Loadmapcheme26 = None
        self.Localtiles203 = None
        self.Localupdate96 = None
        self.Localvideo491 = None
        self.Lockmap392 = None
        self.Longitudinallycentered422 = None
        self.Loweralignment424 = None
        self.MDBimport651 = None
        self.MXDtoxwu661 = None
        self.Magnifyingglass223 = None
        self.Management205 = None
        self.Management763 = None
        self.Map111 = None
        self.Map415 = None
        self.Mapclipping234 = None
        self.Mapcollaboration767 = None
        self.Mapediting721 = None
        self.Mapettings354 = None
        self.Maphutter765 = None
        self.Mapmeasurement227 = None
        self.Mapoperations709 = None
        self.Mappositioning61 = None
        self.Mapproperties229 = None
        self.Mapreset23 = None
        self.Maproaming386 = None
        self.Maprollerhutter236 = None
        self.Margins394 = None
        self.Matrixtyle240 = None
        self.Measuringgeographicaldistribution136 = None
        self.Mergetinprofiles510 = None
        self.Migrationettings655 = None
        self.Militarydatawarehousing24 = None
        self.Militarymappluginregistration4 = None
        self.Militarymappluginuninstall12 = None
        self.Minus565 = None
        self.Mode597 = None
        self.Model775 = None
        self.Modeldrawing688 = None
        self.Modelediting455 = None
        self.Modelflattening188 = None
        self.Modeloperation701 = None
        self.Modelprocessing174 = None
        self.Modifynovalue823 = None
        self.Modulus630 = None
        self.Mongdbtile232 = None
        self.Mongotile200 = None
        self.Mongoworkspace683 = None
        self.Movedownonelayer406 = None
        self.Moveuponelayer412 = None
        self.MySQLworkspace680 = None
        self.Mydocuments25 = None
        self.Navalchartdatawarehousing71 = None
        self.Navigatetothefirstline328 = None
        self.NetCDF613 = None
        self.Networkanalysis151 = None
        self.New218 = None
        self.New362 = None
        self.Newbulletinboard370 = None
        self.Newdataset738 = None
        self.NewdesktopUIcolorchanges193 = None
        self.Newfolder202 = None
        self.Newtatisticalchart708 = None
        self.Noanimation18 = None
        self.Non578 = None
        self.NonGJBdatawarehousing70 = None
        self.Normal189 = None
        self.Notequalto575 = None
        self.Numberofinglevalues = None
        self.Objectdrawing580 = None
        self.Objectdrawing755 = None
        self.Objectediting716 = None
        self.Objectoperation704 = None
        self.Objectorder693 = None
        self.Objecttyle287 = None
        self.Obliqueclipping437 = None
        self.Obliqueinlay454 = None
        self.Onlinemap197 = None
        self.Onlinemap321 = None
        self.Onlinemap832 = None
        self.Onlinevideo500 = None
        self.Onlineymbol830 = None
        self.Open361 = None
        self.Opendocument16 = None
        self.Openinganalysis464 = None
        self.Openituationchart13 = None
        self.Openplottingmap49 = None
        self.Operation479 = None
        self.Operation703 = None
        self.Operation746 = None
        self.Or570 = None
        self.Oracleplusworkspace685 = None
        self.Ordinaryleastquares548 = None
        self.Originalinformationmanagement643 = None
        self.Orthogonalpolygon304 = None
        self.Orthogonalrightanglediagram593 = None
        self.Outputandprinting705 = None
        self.Outputpdf14 = None
        self.Outputpdf395 = None
        self.Outputpicture391 = None
        self.Outputpicture58 = None
        self.Pageetup717 = None
        self.Paperdirection397 = None
        self.Paperize401 = None
        self.Paste294 = None
        self.Paste83 = None
        self.Picture393 = None
        self.Picture498 = None
        self.Piechart786 = None
        self.Pipelineflow663 = None
        self.Placenameinquiry95 = None
        self.Play40afterthepreviousaction = None
        self.Plotlayercontroller51 = None
        self.Plotpanel759 = None
        self.Point295 = None
        self.Point429 = None
        self.PointCloudToList176 = None
        self.PointCloudToOSGB186 = None
        self.Pointadjustment807 = None
        self.Pointcloud770 = None
        self.Pointdensity247 = None
        self.Pointdensity732 = None
        self.Pointmatchlinedirection = None
        self.Pointtyle782 = None
        self.Pointymbol274 = None
        self.Pointymbol353 = None
        self.Pointymbol402 = None
        self.Polygon820 = None
        self.Polygonelection313 = None
        self.Polylinepath97 = None
        self.Polymerization824 = None
        self.Positioning339 = None
        self.Positioning5 = None
        self.PostGISworkspace684 = None
        self.PostgreSQLworkspace682 = None
        self.Previewpicture94 = None
        self.Prickedit480 = None
        self.Prickpoint477 = None
        self.Principalcomponentanalysiscellularautomata819 = None
        self.Principalcomponentanalysistraining822 = None
        self.Printmapbook604 = None
        self.Printpreview388 = None
        self.Profile181 = None
        self.Projectionconversion120 = None
        self.Projectionettings112 = None
        self.Property749 = None
        self.Propertyheet108 = None
        self.Propertyheet53 = None
        self.Proximityanalysis150 = None
        self.Publishindex617 = None
        self.Publishiservice742 = None
        self.Pulldownfunctionbutton511 = None
        self.Pyramid377 = None
        self.Python119 = None
        self.Query780 = None
        self.Querycoordinatevalue315 = None
        self.Querymvalue160 = None
        self.RGBmode616 = None
        self.Randomampling545 = None
        self.Rasterimage779 = None
        self.Realtimetreamingdata760 = None
        self.Rearview74 = None
        self.Recoverytask195 = None
        self.Redo290 = None
        self.Refresh308 = None
        self.Registration115 = None
        self.Registration476 = None
        self.Registrationbrowsing711 = None
        self.Registrationmode576 = None
        self.Remoteensingmapping126 = None
        self.Removeoption30 = None
        self.Resetdefaultproperty481 = None
        self.Resetpicture81 = None
        self.Restoredefaultparameterettings543 = None
        self.Resulttorage535 = None
        self.Reversecolor614 = None
        self.Revocation289 = None
        self.Ringdiagram793 = None
        self.Roadnetworkanalysis758 = None
        self.Roaming238 = None
        self.Roaming478 = None
        self.Rose787 = None
        self.Rotationangle269 = None
        self.Rounddown623 = None
        self.Rulemodeling710 = None
        self.SDBtoudb526 = None
        self.SDEimport669 = None
        self.SHPimport636 = None
        self.SQLquery159 = None
        self.SQLtatementquery813 = None
        self.Samplelabelextraction646 = None
        self.Samplemanagement631 = None
        self.Saturation601 = None
        self.Save103 = None
        self.Save359 = None
        self.Save57 = None
        self.Saveas358 = None
        self.SaveasExcel327 = None
        self.SaveasExcel641 = None
        self.Saveasdataset243 = None
        self.Saveasdataset333 = None
        self.Saveastool212 = None
        self.Savetotemplatelibrary799 = None
        self.Scale434 = None
        self.Scenario109 = None
        self.Sceneclipping320 = None
        self.Sceneproperties312 = None
        self.Scenerollerhutter322 = None
        self.Screening331 = None
        self.Screening514 = None
        self.Secondarydevelopmentexample537 = None
        self.Sectionanalysis460 = None
        self.Sectionandprojection446 = None
        self.See319 = None
        self.Select237 = None
        self.Select305 = None
        self.Selectpath72 = None
        self.Selectroaming306 = None
        self.Service207 = None
        self.Service784 = None
        self.Setgriddata91 = None
        self.Setting228 = None
        self.Setting626 = None
        self.Settingout449 = None
        self.Settings296 = None
        self.Shadowbody452 = None
        self.Shadows285 = None
        self.Sharpening591 = None
        self.Shear291 = None
        self.Shear62 = None
        self.Shrink226 = None
        self.Shrinkby400 = None
        self.Sin589 = None
        self.Singlepointareaestimation546 = None
        self.Singlevalue259 = None
        self.Singlevalue723 = None
        self.Singlevaluetyle260 = None
        self.Sitemanagement368 = None
        self.Situationdeduction56 = None
        self.Situationdeduction733 = None
        self.Size699 = None
        self.Sketch654 = None
        self.Skylineanalysis467 = None
        self.Slopeaspectanalysis473 = None
        self.Snapettings300 = None
        self.Snapettings410 = None
        self.Solarradiation147 = None
        self.Spatialindex106 = None
        self.Spatialquery158 = None
        self.Spatialquery435 = None
        self.Spatialrelationshipmodeling135 = None
        self.Spatialtatisticalanalysis686 = None
        self.Specialeffects607 = None
        self.Sphere378 = None
        self.Split633 = None
        self.Splitline490 = None
        self.Sqlplusworkspace681 = None
        self.Stackanalysis154 = None
        self.Standarddeviation347 = None
        self.Staticmodel372 = None
        self.Statisticalanalysis713 = None
        self.Statisticalchart105 = None
        self.Statisticalchart640 = None
        self.Statisticalchartconversion696 = None
        self.Statisticalchartprocessing698 = None
        self.Statisticalinference547 = None
        self.Statisticalmovementymbol253 = None
        self.Statistics252 = None
        self.Statistics730 = None
        self.Stop366 = None
        self.Stop37 = None
        self.Straw608 = None
        self.Streamingvideo496 = None
        self.Stretch456 = None
        self.Stretchettings728 = None
        self.Style769 = None
        self.Stylebrush79 = None
        self.Stylemigration719 = None
        self.Subection741 = None
        self.Subject774 = None
        self.Subparagraph262 = None
        self.Summaryfield330 = None
        self.Summer619 = None
        self.Sunshineanalysis461 = None
        self.Surfaceanalysis153 = None
        self.Suspension15 = None
        self.Switchunderlay43 = None
        self.Symbollibrary827 = None
        self.Systemmodewitching55 = None
        self.Tagmovetag246 = None
        self.Tan642 = None
        self.Targetdetection541 = None
        self.Targetdetectionettings534 = None
        self.Targettracking539 = None
        self.Targettrackingettings549 = None
        self.Taskmanagement199 = None
        self.Technicalupport219 = None
        self.Templatemanagement248 = None
        self.Templatemanagement800 = None
        self.Tensileclosure436 = None
        self.Terrainmodification444 = None
        self.Terrainmodificationmodel185 = None
        self.Text298 = None
        self.Text426 = None
        self.Textfind519 = None
        self.Texttemplate702 = None
        self.Texttyle687 = None
        self.Textureextraction459 = None
        self.Texturereplacement457 = None
        self.Theaveragevalueis349 = None
        self.Theettingratiois85 = None
        self.Thermodynamicdiagram254 = None
        self.Theurfacedistancefromthegridis670 = None
        self.ThreeDanalysis689 = None
        self.ThreeDbuffer443 = None
        self.ThreeDcircle374 = None
        self.ThreeDcolumnartackingfigure792 = None
        self.ThreeDface380 = None
        self.ThreeDfielddata768 = None
        self.ThreeDline385 = None
        self.ThreeDplottingattributes487 = None
        self.ThreeDplottingpanel488 = None
        self.ThreeDplottingpanel89 = None
        self.ThreeDplottingproperties102 = None
        self.ThreeDpoint384 = None
        self.ThreeDpolyline382 = None
        self.ThreeDrose788 = None
        self.Threedimensionalhistogram797 = None
        self.Threedimensionalpiechart795 = None
        self.Threedimensionalvolumeanalysis692 = None
        self.Tiltphotographingdataoperation695 = None
        self.Tiltphotography756 = None
        self.Tiltwarehousing525 = None
        self.TinBooleanbudget447 = None
        self.Tincutting453 = None
        self.Tindig450 = None
        self.Tininlay458 = None
        self.Tinterrain179 = None
        self.Tinterrain722 = None
        self.Tinterrainoperation690 = None
        self.Tool783 = None
        self.Toolbar82 = None
        self.Topologicalplane133 = None
        self.Topology724 = None
        self.Topologycheck132 = None
        self.Topologynetwork163 = None
        self.Topologynetwork735 = None
        self.Toponymicinformation47 = None
        self.Topping418 = None
        self.Total348 = None
        self.Track307 = None
        self.Trajectorymodel375 = None
        self.Transparentbackground270 = None
        self.Tree373 = None
        self.Treediagram622 = None
        self.Triangulationoperation442 = None
        self.TwoDplotattributes486 = None
        self.TwoDplottingattributes101 = None
        self.TwoDplottingpanel28 = None
        self.TwoDplottingpanel484 = None
        self.TwoDtopologypreprocessing128 = None
        self.Twopointhortesturfacepath673 = None
        self.Twopointminimumcostpath676 = None
        self.Typeconversion131 = None
        self.Typeconversion171 = None
        self.Typeconversion509 = None
        self.UDBtoudbx527 = None
        self.UIcolormatchingmodification194 = None
        self.Udbxtoudb528 = None
        self.Underground729 = None
        self.Undergroundcolor316 = None
        self.Underline278 = None
        self.Unhidecolumn336 = None
        self.Unhiderow334 = None
        self.Unifiedtyle249 = None
        self.Unifiedtyle739 = None
        self.Unit220 = None
        self.Unit314 = None
        self.Updatecolumn326 = None
        self.Upgradetolargefile508 = None
        self.Upto602 = None
        self.Utility144 = None
        self.Variance346 = None
        self.Vectoranalysis753 = None
        self.Vectorgridconversion149 = None
        self.Vectorizationline303 = None
        self.Vectorizationplane301 = None
        self.Velocityanalysis540 = None
        self.Verticallyequidistant428 = None
        self.Verticaltext494 = None
        self.Video533 = None
        self.Videodataset577 = None
        self.Videoparameters492 = None
        self.Videotag493 = None
        self.View64 = None
        self.View745 = None
        self.Viewableanalysis470 = None
        self.Viewelection531 = None
        self.Viewportmanagement734 = None
        self.Violationdetection587 = None
        self.Visualmodeling707 = None
        self.Voxelgridgenerationcache169 = None
        self.Warehousingandpublishing3Dervice664 = None
        self.Warmtone634 = None
        self.Web125 = None
        self.Window761 = None
        self.Workingdirectory52 = None
        self.Workspace198 = None
        self.Workspace766 = None
        self.Workspace828 = None
        self.XOR574 = None
        self.Zoom100 = None
        self.Zoom235 = None
        self.Zoomin222 = None
        self.Zoomin398 = None
        self.Zoominonthemap387 = None
        self.Zoomoutonthemap389 = None
        self.Zoomreferencepicture42 = None
        self.Zoomthemap19 = None
        self.ai571 = None
        self.bim439 = None
        self.bim507 = None
        self.cogo518 = None
        self.cot550 = None
        self.cotH558 = None
        self.dm7 = None
        self.exp556 = None
        self.kml317 = None
        self.ln553 = None
        self.log552 = None
        self.max352 = None
        self.min351 = None
        self.ndvi505 = None
        self.ndwi506 = None
        self.pow555 = None
        self.sinH560 = None
        self.sqrt554 = None
        self.tanH559 = None
        self.vectortext573 = None
        self.xugu523 = None
        self.default_logo = None
