# generated by datamodel-codegen:
#   filename:  instill_task_visual_question_answering_input.json

from __future__ import annotations

from dataclasses import dataclass
from enum import Enum
from typing import Any, Dict, List, Optional


@dataclass
class ImageUrl:
    url: str


class Type(Enum):
    text = 'text'
    image_url = 'image_url'


@dataclass
class ContentItem:
    type: Type
    image_url: Optional[ImageUrl] = None
    text: Optional[str] = None


@dataclass
class ChatMessage:
    content: List[ContentItem]
    role: str


@dataclass
class Input:
    model_name: str
    prompt: str
    prompt_images: List[str]
    chat_history: Optional[List[ChatMessage]] = None
    extra_params: Optional[Dict[str, Any]] = None
    max_new_tokens: Optional[int] = 50
    seed: Optional[int] = None
    system_message: Optional[str] = 'You are a helpful assistant.'
    temperature: Optional[float] = 0.7
    top_k: Optional[int] = 10
