import gym


class NormalizedActions(gym.ActionWrapper):
  def _action(self, action):
    action = (action + 1) / 2  # [-1, 1] => [0, 1]
    action *= self.action_space.high - self.action_space.low
    action += self.action_space.low
    return action

  def _reverse_action(self, action):
    action -= self.action_space.low
    action /= self.action_space.high - self.action_space.low
    action = action * 2 - 1
    return action
