/* -*- c++ -*-
 * Copyright (c) 2012-2022 by the GalSim developers team on GitHub
 * https://github.com/GalSim-developers
 *
 * This file is part of GalSim: The modular galaxy image simulation toolkit.
 * https://github.com/GalSim-developers/GalSim
 *
 * GalSim is free software: redistribution and use in source and binary forms,
 * with or without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions, and the disclaimer given in the accompanying LICENSE
 *    file.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions, and the disclaimer given in the documentation
 *    and/or other materials provided with the distribution.
 */

#ifndef GalSim_SBDeconvolve_H
#define GalSim_SBDeconvolve_H
/**
 * @file SBDeconvolve.h @brief SBProfile adapter which inverts its subject in k space to effect a
 * deconvolution.
 */


#include "SBProfile.h"

namespace galsim {

    /**
     * @brief SBProfile adapter which inverts its subject in k space to effect a deconvolvution.
     *
     * @param[in] adaptee   SBProfile for which to effect a deconvolution by k space inversion.
     * @param[in] gsparams  GSParams object storing constants that control the accuracy of
     *                      image operations and rendering, if different from the default.
     */
    class PUBLIC_API SBDeconvolve : public SBProfile
    {
    public:
        /// @brief Constructor.
        SBDeconvolve(const SBProfile& adaptee, const GSParams& gsparams);

        /// @brief Copy constructor.
        SBDeconvolve(const SBDeconvolve& rhs);

        /// @brief Destructor.
        ~SBDeconvolve();

        /// @brief Get the SBProfile being deconvolved
        SBProfile getObj() const;

    protected:

        class SBDeconvolveImpl;

    private:
        // op= is undefined
        void operator=(const SBDeconvolve& rhs);
    };

}

#endif
