/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.CVLFunction;
import com.certora.evmverifier.cvl.GhostDecl;
import com.certora.evmverifier.cvl.Hook;
import com.certora.evmverifier.cvl.Invariant;
import com.certora.evmverifier.cvl.KotlinizeResult;
import com.certora.evmverifier.cvl.MacroDefinition;
import com.certora.evmverifier.cvl.MethodEntry;
import com.certora.evmverifier.cvl.OverrideDeclaration;
import com.certora.evmverifier.cvl.Rule;
import com.certora.evmverifier.cvl.UninterpretedSortDecl;
import com.certora.evmverifier.cvl.UseDeclaration;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kotlinizable.Kotlinizer;
import spec.TypeResolver;
import spec.cvlast.CVLDefinition;
import spec.cvlast.CVLGhostDeclaration;
import spec.cvlast.CVLHook;
import spec.cvlast.CVLInvariant;
import spec.cvlast.CVLScope;
import spec.cvlast.IRule;
import spec.cvlast.MethodBlockEntry;
import spec.cvlast.OverrideDeclarations;
import spec.cvlast.SortDeclaration;
import spec.cvlast.UseDeclarations;
import spec.cvlast.typechecker.CVLError;
import utils.CollectingResult;

public class AstBaseBlocks {
    private final ArrayList<Rule> rules = new ArrayList();
    private final ArrayList<CVLFunction> subs = new ArrayList();
    private final ArrayList<Invariant> invs = new ArrayList();
    private final ArrayList<UninterpretedSortDecl> sorts = new ArrayList();
    private final ArrayList<GhostDecl> ghosts = new ArrayList();
    private final ArrayList<MacroDefinition> macros = new ArrayList();
    private final ArrayList<Hook> hooks = new ArrayList();
    private final ArrayList<UseDeclaration.ImportedRule> useImportedRuleDeclarations = new ArrayList();
    private final ArrayList<UseDeclaration.ImportedInvariant> useImportedInvariantDeclarations = new ArrayList();
    private final ArrayList<UseDeclaration.BuiltInRule> useBuiltInRuleDeclarations = new ArrayList();
    private final ArrayList<OverrideDeclaration.MacroDefinition> overrideDefinitionDeclarations = new ArrayList();
    private final ArrayList<OverrideDeclaration.CVLFunction> overrideFunctionDeclarations = new ArrayList();
    private final ArrayList<MethodEntry<?>> methods = new ArrayList();

    public void add(Rule rule2) {
        this.rules.add(rule2);
    }

    public CollectingResult<List<IRule>, CVLError> kotlinizeRules(TypeResolver resolver, CVLScope scope) {
        return Kotlinizer.kotlinizeList(this.rules, scope, resolver);
    }

    public void add(CVLFunction sub2) {
        this.subs.add(sub2);
    }

    public CollectingResult<List<spec.cvlast.CVLFunction>, CVLError> kotlinizeSubs(TypeResolver resolver, CVLScope scope) {
        return Kotlinizer.kotlinizeList(this.subs, scope, resolver);
    }

    public void add(Invariant inv2) {
        this.invs.add(inv2);
    }

    public CollectingResult<List<CVLInvariant>, CVLError> kotlinizeInvariants(TypeResolver resolver, CVLScope scope) {
        return Kotlinizer.kotlinizeList(this.invs, scope, resolver);
    }

    public void add(UninterpretedSortDecl sort) {
        this.sorts.add(sort);
    }

    public CollectingResult<List<SortDeclaration>, CVLError> kotlinizeSorts(TypeResolver resolver, CVLScope scope) {
        return Kotlinizer.kotlinizeList(this.sorts, scope, resolver);
    }

    public void add(GhostDecl ghost2) {
        this.ghosts.add(ghost2);
    }

    public CollectingResult<List<CVLGhostDeclaration>, CVLError> kotlinizeGhostDecls(TypeResolver resolver, CVLScope scope) {
        return Kotlinizer.kotlinizeList(this.ghosts, scope, resolver);
    }

    public void add(MacroDefinition macro) {
        this.macros.add(macro);
    }

    public CollectingResult<List<CVLDefinition>, CVLError> kotlinizeMacroDefinitions(TypeResolver resolver, CVLScope scope) {
        return Kotlinizer.kotlinizeList(this.macros, scope, resolver);
    }

    public void add(Hook hook2) {
        this.hooks.add(hook2);
    }

    public CollectingResult<List<CVLHook>, CVLError> kotlinizeHooks(TypeResolver resolver, CVLScope scope) {
        return Kotlinizer.kotlinizeList(this.hooks, scope, resolver);
    }

    public void add(UseDeclaration useDeclaration) {
        if (useDeclaration instanceof UseDeclaration.ImportedRule) {
            this.useImportedRuleDeclarations.add((UseDeclaration.ImportedRule)useDeclaration);
        } else if (useDeclaration instanceof UseDeclaration.ImportedInvariant) {
            this.useImportedInvariantDeclarations.add((UseDeclaration.ImportedInvariant)useDeclaration);
        } else if (useDeclaration instanceof UseDeclaration.BuiltInRule) {
            this.useBuiltInRuleDeclarations.add((UseDeclaration.BuiltInRule)useDeclaration);
        } else {
            throw new UnsupportedOperationException(String.format("Cannot handle the use declaration %s", useDeclaration));
        }
    }

    public CollectingResult<UseDeclarations, CVLError> kotlinizeUseDeclarations(TypeResolver resolver, CVLScope scope) {
        return KotlinizeResult.map(Kotlinizer.kotlinizeList(this.useImportedRuleDeclarations, scope, resolver), Kotlinizer.kotlinizeList(this.useImportedInvariantDeclarations, scope, resolver), Kotlinizer.kotlinizeList(this.useBuiltInRuleDeclarations, scope, resolver), UseDeclarations::new);
    }

    public void add(OverrideDeclaration overrideDeclaration) {
        if (overrideDeclaration instanceof OverrideDeclaration.MacroDefinition) {
            this.overrideDefinitionDeclarations.add((OverrideDeclaration.MacroDefinition)overrideDeclaration);
        } else if (overrideDeclaration instanceof OverrideDeclaration.CVLFunction) {
            this.overrideFunctionDeclarations.add((OverrideDeclaration.CVLFunction)overrideDeclaration);
        } else {
            throw new UnsupportedOperationException(String.format("Cannot handle the override declaration %s", overrideDeclaration));
        }
    }

    public CollectingResult<OverrideDeclarations, CVLError> kotlinizeOverrideDeclarations(TypeResolver resolver, CVLScope scope) {
        return KotlinizeResult.map(Kotlinizer.kotlinizeList(this.overrideDefinitionDeclarations, scope, resolver), Kotlinizer.kotlinizeList(this.overrideFunctionDeclarations, scope, resolver), OverrideDeclarations::new);
    }

    public void add(List<MethodEntry<?>> methods) {
        this.methods.addAll(methods);
    }

    public CollectingResult<List<MethodBlockEntry>, CVLError> kotlinizeImportedMethods(TypeResolver resolver, CVLScope scope) {
        return CollectingResult.Companion.flatten(this.methods.stream().map(o -> KotlinizeResult.map(o.kotlinize(resolver, scope), r -> {
            MethodBlockEntry safeUpCast = r;
            return safeUpCast;
        })).collect(Collectors.toList()));
    }
}

