/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.Exp;
import com.certora.evmverifier.cvl.KotlinizeResult;
import spec.TypeResolver;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLExpTag;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLScope;
import spec.cvlast.TwoStateIndex;
import spec.cvlast.typechecker.CVLError;
import utils.CollectingResult;

public class VariableExp
extends Exp {
    public String id;
    public Annotation annotation;

    public VariableExp(String _id, Annotation _annotation, CVLRange range) {
        super(range);
        this.id = _id;
        this.annotation = _annotation;
    }

    public VariableExp(String _id, CVLRange range) {
        this(_id, Annotation.NONE, range);
    }

    public static VariableExp oldVariable(String _id, CVLRange range) {
        return new VariableExp(_id, Annotation.OLD, range);
    }

    public static VariableExp newVariable(String _id, CVLRange range) {
        return new VariableExp(_id, Annotation.NEW, range);
    }

    public boolean isOldVersion() {
        return this.annotation == Annotation.OLD;
    }

    public boolean isNewVersion() {
        return this.annotation == Annotation.NEW;
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof VariableExp)) {
            return false;
        }
        VariableExp otherVarExp = (VariableExp)obj2;
        if (this == otherVarExp) {
            return true;
        }
        return this.annotation.equals((Object)otherVarExp.annotation) && this.id.equals(otherVarExp.id);
    }

    public int hashCode() {
        int result2 = this.id == null ? 0 : this.id.hashCode();
        result2 = 31 * result2 + (this.annotation == null ? 0 : this.annotation.hashCode());
        return result2;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public CollectingResult<CVLExp.VariableExp, CVLError> kotlinize(TypeResolver resolver, CVLScope scope) {
        TwoStateIndex index = TwoStateIndex.NEITHER;
        if (this.isOldVersion()) {
            index = TwoStateIndex.OLD;
        }
        if (this.isNewVersion()) {
            index = TwoStateIndex.NEW;
        }
        return KotlinizeResult.lift(new CVLExp.VariableExp(this.id, new CVLExpTag(scope, this.range), index));
    }

    static enum Annotation {
        OLD,
        NEW,
        NONE;

    }
}

