/*
 * Decompiled with CFR 0.152.
 */
package compiler;

import compiler.ABI;
import compiler.ABIComponent;
import compiler.FunctionHashesKt;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.komputing.khash.keccak.Keccak;
import org.komputing.khash.keccak.KeccakParameter;
import utils.ExtStdlibKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010 \n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u001f\u0010\u0000\u001a\u00020\u00012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u001f\u0010\t\u001a\u00020\u00012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0004\u001a\u0014\u0010\n\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u001a\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u001a\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fH\u0007\u001a\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\fH\u0007\u001a\u001c\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u001a\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0018\u001a\u00020\f\u001a\u0010\u0010\u0019\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\u001a"}, d2={"applyKeccak", "Ljava/math/BigInteger;", "words", "", "([Ljava/math/BigInteger;)Ljava/math/BigInteger;", "byteArray", "", "", "", "applyKeccakByHexStringConversion", "applyKeccakList", "calculateEventHash", "", "name", "args", "calculateHash", "abi", "Lcompiler/ABI;", "calculateHashFromCanonicalName", "canonicalName", "calculateHashFromCanonicalNameBigInt", "calculateHashFromNameAndArgTypes", "argTypes", "hexStringToByteTokens", "hexBytecode", "toByteArray", "Shared"})
@SourceDebugExtension(value={"SMAP\nFunctionHashes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionHashes.kt\ncompiler/FunctionHashesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,126:1\n1549#2:127\n1620#2,3:128\n1549#2:131\n1620#2,3:132\n1549#2:135\n1620#2,3:136\n1549#2:143\n1620#2,3:144\n2661#2,7:147\n1549#2:154\n1620#2,3:155\n11345#3:139\n11680#3,3:140\n*S KotlinDebug\n*F\n+ 1 FunctionHashes.kt\ncompiler/FunctionHashesKt\n*L\n57#1:127\n57#1:128,3\n65#1:131\n65#1:132,3\n72#1:135\n72#1:136,3\n88#1:143\n88#1:144,3\n99#1:147,7\n125#1:154\n125#1:155,3\n84#1:139\n84#1:140,3\n*E\n"})
public final class FunctionHashesKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String calculateHash(@NotNull ABI abi) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(abi, "abi");
        String name = abi.getName();
        Iterable $this$map$iv = abi.getInputs();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ABIComponent aBIComponent = (ABIComponent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        List inputTypes = (List)destination$iv$iv;
        return FunctionHashesKt.calculateHashFromNameAndArgTypes(name, inputTypes);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String calculateHashFromNameAndArgTypes(@NotNull String name, @NotNull List<String> argTypes) {
        void $this$mapTo$iv$iv;
        String stringToHash;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(argTypes, "argTypes");
        String string = stringToHash = name + "(" + CollectionsKt.joinToString$default(argTypes, ",", null, null, 0, null, null, 62, null) + ")";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        byte[] hash2 = Keccak.INSTANCE.digest(byArray, KeccakParameter.KECCAK_256);
        Iterable $this$map$iv = ArraysKt.take(hash2, 4);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            byte by = ((Number)item$iv$iv).byteValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Locale locale = Locale.ROOT;
            String string2 = "%02x";
            Object[] objectArray = new Object[]{(byte)it};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(locale, format, *args)");
            collection.add(string3);
        }
        return CollectionsKt.joinToString$default((List)destination$iv$iv, "", null, null, 0, null, null, 62, null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="probably shouldn't be used; we are computing sighashes on python level (stored in certora_build.json), so this is duplicate functionality")
    @NotNull
    public static final String calculateHashFromCanonicalName(@NotNull String canonicalName) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(canonicalName, "canonicalName");
        String string = canonicalName;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        byte[] hash2 = Keccak.INSTANCE.digest(byArray, KeccakParameter.KECCAK_256);
        Iterable $this$map$iv = ArraysKt.take(hash2, 4);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            byte by = ((Number)item$iv$iv).byteValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Locale locale = Locale.ROOT;
            String string2 = "%02x";
            Object[] objectArray = new Object[]{(byte)it};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(locale, format, *args)");
            collection.add(string3);
        }
        return CollectionsKt.joinToString$default((List)destination$iv$iv, "", null, null, 0, null, null, 62, null);
    }

    @Deprecated(message="probably shouldn't be used; we are computing sighashes on python level (stored in certora_build.json), so this is duplicate functionality")
    @NotNull
    public static final BigInteger calculateHashFromCanonicalNameBigInt(@NotNull String canonicalName) {
        Intrinsics.checkNotNullParameter(canonicalName, "canonicalName");
        return new BigInteger(FunctionHashesKt.calculateHashFromCanonicalName(canonicalName), CharsKt.checkRadix(16));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String calculateEventHash(@NotNull String name, @NotNull List<String> args2) {
        void $this$mapTo$iv$iv;
        byte[] hash2;
        String stringToHash;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(args2, "args");
        String string = stringToHash = name + "(" + CollectionsKt.joinToString$default(args2, ",", null, null, 0, null, null, 62, null) + ")";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        byte[] $this$map$iv = hash2 = Keccak.INSTANCE.digest(byArray, KeccakParameter.KECCAK_256);
        boolean $i$f$map = false;
        byte[] byArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Locale locale = Locale.ROOT;
            String string2 = "%02x";
            Object[] objectArray = new Object[]{(byte)it};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(locale, format, *args)");
            collection.add(string3);
        }
        return CollectionsKt.joinToString$default((List)destination$iv$iv, "", null, null, 0, null, null, 62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BigInteger applyKeccakList(@NotNull List<? extends BigInteger> words) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(words, "words");
        Iterable $this$map$iv = words;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            byte[] byArray;
            void it;
            BigInteger bigInteger = (BigInteger)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            byte[] ba = it.toByteArray();
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(ba, "ba");
            List<Byte> lsbs = ArraysKt.takeLast(ba, Math.min(ba.length, 32));
            if (lsbs.size() <= 32) {
                byte[] byteArray = new byte[32 - lsbs.size()];
                byArray = ArraysKt.plus(byteArray, CollectionsKt.toByteArray((Collection<Byte>)lsbs));
            } else {
                byArray = CollectionsKt.toByteArray((Collection<Byte>)lsbs);
            }
            collection.add(byArray);
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void y;
            byte[] $i$f$mapTo2 = (byte[])iterator$iv.next();
            byte[] x = (byte[])accumulator$iv;
            boolean bl = false;
            accumulator$iv = ArraysKt.plus(x, (byte[])y);
        }
        byte[] input = (byte[])accumulator$iv;
        return FunctionHashesKt.applyKeccak(input);
    }

    @NotNull
    public static final BigInteger applyKeccak(BigInteger ... words) {
        Intrinsics.checkNotNullParameter(words, "words");
        return FunctionHashesKt.applyKeccakList(ArraysKt.toList(words));
    }

    @NotNull
    public static final BigInteger applyKeccakByHexStringConversion(BigInteger ... words) {
        Intrinsics.checkNotNullParameter(words, "words");
        String str2 = ArraysKt.joinToString$default(words, (CharSequence)"", null, null, 0, null, (Function1)applyKeccakByHexStringConversion.str.1.INSTANCE, 30, null);
        List<Short> tokens = FunctionHashesKt.hexStringToByteTokens(str2);
        return FunctionHashesKt.applyKeccak(tokens);
    }

    @NotNull
    public static final BigInteger applyKeccak(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter(byteArray, "byteArray");
        return new BigInteger(ArraysKt.joinToString$default(Keccak.INSTANCE.digest(byteArray, KeccakParameter.KECCAK_256), (CharSequence)"", null, null, 0, null, (Function1)applyKeccak.1.INSTANCE, 30, null), CharsKt.checkRadix(16));
    }

    @NotNull
    public static final BigInteger applyKeccak(@NotNull List<Short> byteArray) {
        Intrinsics.checkNotNullParameter(byteArray, "byteArray");
        return FunctionHashesKt.applyKeccak(FunctionHashesKt.toByteArray(byteArray));
    }

    @NotNull
    public static final List<Short> hexStringToByteTokens(@NotNull String hexBytecode) {
        Intrinsics.checkNotNullParameter(hexBytecode, "hexBytecode");
        List<String> byteStrings = StringsKt.chunked(hexBytecode, 2);
        List<Short> list = ExtStdlibKt.monadicMap((Iterable)byteStrings, hexStringToByteTokens.byteTokens.1.INSTANCE);
        if (list == null) {
            throw new RuntimeException("Failed to convert to bytes " + byteStrings);
        }
        List<Short> byteTokens2 = list;
        return byteTokens2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] toByteArray(@NotNull List<Short> $this$toByteArray) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toByteArray, "<this>");
        Iterable $this$map$iv = $this$toByteArray;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            short s = ((Number)item$iv$iv).shortValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)it);
        }
        return CollectionsKt.toByteArray((List)destination$iv$iv);
    }
}

