/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.bytecode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.harmony.unpack200.bytecode.BCIRenumberedAttribute;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPUTF8;
import org.apache.commons.compress.harmony.unpack200.bytecode.ClassConstantPool;
import org.apache.commons.compress.harmony.unpack200.bytecode.ClassFileEntry;

public class NewAttribute
extends BCIRenumberedAttribute {
    private final List lengths = new ArrayList();
    private final List body = new ArrayList();
    private ClassConstantPool pool;
    private final int layoutIndex;

    public NewAttribute(CPUTF8 attributeName, int layoutIndex) {
        super(attributeName);
        this.layoutIndex = layoutIndex;
    }

    public int getLayoutIndex() {
        return this.layoutIndex;
    }

    @Override
    protected int getLength() {
        int length2 = 0;
        for (int iter = 0; iter < this.lengths.size(); ++iter) {
            length2 += ((Integer)this.lengths.get(iter)).intValue();
        }
        return length2;
    }

    @Override
    protected void writeBody(DataOutputStream dos) throws IOException {
        for (int i = 0; i < this.lengths.size(); ++i) {
            int length2 = (Integer)this.lengths.get(i);
            Object obj2 = this.body.get(i);
            long value2 = 0L;
            if (obj2 instanceof Long) {
                value2 = (Long)obj2;
            } else if (obj2 instanceof ClassFileEntry) {
                value2 = this.pool.indexOf((ClassFileEntry)obj2);
            } else if (obj2 instanceof BCValue) {
                value2 = ((BCValue)obj2).actualValue;
            }
            if (length2 == 1) {
                dos.writeByte((int)value2);
                continue;
            }
            if (length2 == 2) {
                dos.writeShort((int)value2);
                continue;
            }
            if (length2 == 4) {
                dos.writeInt((int)value2);
                continue;
            }
            if (length2 != 8) continue;
            dos.writeLong(value2);
        }
    }

    @Override
    public String toString() {
        return this.attributeName.underlyingString();
    }

    public void addInteger(int length2, long value2) {
        this.lengths.add(length2);
        this.body.add(value2);
    }

    public void addBCOffset(int length2, int value2) {
        this.lengths.add(length2);
        this.body.add(new BCOffset(value2));
    }

    public void addBCIndex(int length2, int value2) {
        this.lengths.add(length2);
        this.body.add(new BCIndex(value2));
    }

    public void addBCLength(int length2, int value2) {
        this.lengths.add(length2);
        this.body.add(new BCLength(value2));
    }

    public void addToBody(int length2, Object value2) {
        this.lengths.add(length2);
        this.body.add(value2);
    }

    @Override
    protected void resolve(ClassConstantPool pool) {
        super.resolve(pool);
        for (int iter = 0; iter < this.body.size(); ++iter) {
            Object element = this.body.get(iter);
            if (!(element instanceof ClassFileEntry)) continue;
            ((ClassFileEntry)element).resolve(pool);
        }
        this.pool = pool;
    }

    @Override
    protected ClassFileEntry[] getNestedClassFileEntries() {
        int total = 1;
        for (int iter = 0; iter < this.body.size(); ++iter) {
            Object element = this.body.get(iter);
            if (!(element instanceof ClassFileEntry)) continue;
            ++total;
        }
        ClassFileEntry[] nested = new ClassFileEntry[total];
        nested[0] = this.getAttributeName();
        int i = 1;
        for (int iter = 0; iter < this.body.size(); ++iter) {
            Object element = this.body.get(iter);
            if (!(element instanceof ClassFileEntry)) continue;
            nested[i] = (ClassFileEntry)element;
            ++i;
        }
        return nested;
    }

    @Override
    protected int[] getStartPCs() {
        return null;
    }

    @Override
    public void renumber(List byteCodeOffsets) {
        if (!this.renumbered) {
            Object previous = null;
            for (Object obj2 : this.body) {
                if (obj2 instanceof BCIndex) {
                    BCIndex bcIndex = (BCIndex)obj2;
                    bcIndex.setActualValue((Integer)byteCodeOffsets.get(bcIndex.index));
                } else if (obj2 instanceof BCOffset) {
                    BCOffset bcOffset = (BCOffset)obj2;
                    if (previous instanceof BCIndex) {
                        int index = ((BCIndex)previous).index + bcOffset.offset;
                        bcOffset.setIndex(index);
                        bcOffset.setActualValue((Integer)byteCodeOffsets.get(index));
                    } else if (previous instanceof BCOffset) {
                        int index = ((BCOffset)previous).index + bcOffset.offset;
                        bcOffset.setIndex(index);
                        bcOffset.setActualValue((Integer)byteCodeOffsets.get(index));
                    } else {
                        bcOffset.setActualValue((Integer)byteCodeOffsets.get(bcOffset.offset));
                    }
                } else if (obj2 instanceof BCLength) {
                    BCLength bcLength = (BCLength)obj2;
                    BCIndex prevIndex = previous;
                    int index = prevIndex.index + bcLength.length;
                    int actualLength = (Integer)byteCodeOffsets.get(index) - prevIndex.actualValue;
                    bcLength.setActualValue(actualLength);
                }
                previous = obj2;
            }
            this.renumbered = true;
        }
    }

    private static abstract class BCValue {
        int actualValue;

        private BCValue() {
        }

        public void setActualValue(int value2) {
            this.actualValue = value2;
        }
    }

    private static class BCLength
    extends BCValue {
        private final int length;

        public BCLength(int length2) {
            this.length = length2;
        }
    }

    private static class BCIndex
    extends BCValue {
        private final int index;

        public BCIndex(int index) {
            this.index = index;
        }
    }

    private static class BCOffset
    extends BCValue {
        private final int offset;
        private int index;

        public BCOffset(int offset) {
            this.offset = offset;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }
}

