/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.SolverConfig;
import solver.SolverInfo;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lsolver/YicesSolverInfo;", "Lsolver/SolverInfo;", "()V", "DEFAULT_YICES_COMMAND", "", "defaultCommand", "getDefaultCommand", "()Ljava/lang/String;", "commandForStdInMode", "", "clOptions", "customBinary", "getOptionForIncremental", "getOptionForTimelimit", "timelimit", "Ljava/time/Duration;", "readResolve", "", "supportsLogicFeatures", "", "features", "Lsolver/SolverConfig$LogicFeatures;", "GeneralUtils"})
public final class YicesSolverInfo
extends SolverInfo {
    @NotNull
    public static final YicesSolverInfo INSTANCE = new YicesSolverInfo();
    @NotNull
    private static final String DEFAULT_YICES_COMMAND = "yices-smt2";

    private YicesSolverInfo() {
        super("Yices");
    }

    @Override
    @NotNull
    public List<String> getOptionForIncremental() {
        return CollectionsKt.listOf("--incremental");
    }

    @Override
    @NotNull
    public List<String> getOptionForTimelimit(@NotNull Duration timelimit) {
        Intrinsics.checkNotNullParameter(timelimit, "timelimit");
        return CollectionsKt.listOf("--timeout=" + timelimit.toSeconds());
    }

    @Override
    @NotNull
    public List<String> commandForStdInMode(@NotNull List<String> clOptions, @Nullable String customBinary) {
        Intrinsics.checkNotNullParameter(clOptions, "clOptions");
        String[] stringArray = new String[2];
        String string = customBinary;
        if (string == null) {
            string = DEFAULT_YICES_COMMAND;
        }
        stringArray[0] = string;
        stringArray[1] = "--interactive";
        return CollectionsKt.plus((Collection)CollectionsKt.listOf(stringArray), (Iterable)clOptions);
    }

    @Override
    @NotNull
    public String getDefaultCommand() {
        return DEFAULT_YICES_COMMAND;
    }

    @Override
    public boolean supportsLogicFeatures(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        return !features.getUsesDatatypes();
    }

    private final Object readResolve() {
        return INSTANCE;
    }
}

