/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.Exp;
import com.certora.evmverifier.cvl.KotlinizeResult;
import com.certora.evmverifier.cvl.NamedParam;
import com.certora.evmverifier.cvl.Param;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java_cup.runtime.ComplexSymbolFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spec.TypeResolver;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLParam;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLScope;
import spec.cvlast.SpecCallSummary;
import spec.cvlast.VMParam;
import spec.cvlast.typechecker.CVLError;
import spec.cvlast.typedescriptors.VMTypeDescriptor;
import utils.CollectingResult;

public abstract class CallSummary {
    @NotNull
    protected final CVLRange range;
    protected boolean unresolved;

    protected CallSummary(@NotNull ComplexSymbolFactory.Location left, @NotNull ComplexSymbolFactory.Location right, Boolean unresolved) {
        this.range = new CVLRange.Range(left, right);
        this.unresolved = unresolved == null ? this.defaultUnresolved() : unresolved.booleanValue();
    }

    public abstract CollectingResult<? extends SpecCallSummary.ExpressibleInCVL, CVLError> kotlinize(TypeResolver var1, CVLScope var2, List<VMParam> var3);

    private boolean defaultUnresolved() {
        return this instanceof Dispatcher;
    }

    public static interface ExpectClause {
        public CollectingResult<List<VMTypeDescriptor>, CVLError> kotlinize(TypeResolver var1, CVLScope var2);

        public static class None
        implements ExpectClause {
            @Override
            public CollectingResult<List<VMTypeDescriptor>, CVLError> kotlinize(TypeResolver resolver, CVLScope scope) {
                return KotlinizeResult.lift(null);
            }
        }

        public static class Type
        implements ExpectClause {
            @NotNull
            private final List<Param> type;

            public Type(@NotNull List<Param> type) {
                this.type = type;
            }

            @Override
            public CollectingResult<List<VMTypeDescriptor>, CVLError> kotlinize(TypeResolver resolver, CVLScope scope) {
                return CollectingResult.Companion.flatten(this.type.stream().map(p -> KotlinizeResult.map(p.toVMParam(resolver, scope), param -> param.getType())).collect(Collectors.toList()));
            }
        }

        public static class Void
        implements ExpectClause {
            @Override
            public CollectingResult<List<VMTypeDescriptor>, CVLError> kotlinize(TypeResolver resolver, CVLScope scope) {
                return KotlinizeResult.lift(Collections.emptyList());
            }
        }
    }

    public static class Expression
    extends CallSummary {
        @NotNull
        private final List<NamedParam> withParams;
        @NotNull
        private final Exp exp;
        @Nullable
        private final ExpectClause expectedType;

        public Expression(@NotNull ComplexSymbolFactory.Location left, @NotNull ComplexSymbolFactory.Location right, @Nullable Boolean resolution, @NotNull Exp exp, @Nullable List<NamedParam> withParams, @NotNull ExpectClause expectedType) {
            super(left, right, resolution);
            this.exp = exp;
            this.withParams = withParams == null ? Collections.emptyList() : withParams;
            this.expectedType = expectedType;
        }

        @Override
        public CollectingResult<? extends SpecCallSummary.ExpressibleInCVL, CVLError> kotlinize(TypeResolver resolver, CVLScope scope, List<VMParam> funParams) {
            return scope.extendInCollecting(CVLScope.Item.ExpressionSummary::new, childScope -> KotlinizeResult.bind(this.exp.kotlinize(resolver, (CVLScope)childScope), NamedParam.toPureNamedParams(this.withParams, resolver, childScope), this.expectedType.kotlinize(resolver, (CVLScope)childScope), (exp, withParams, expectedType) -> KotlinizeResult.lift(new SpecCallSummary.Exp(this.unresolved, (CVLExp)exp, (List<? extends VMParam>)funParams, (List<CVLParam.Named>)withParams, this.range, (CVLScope)childScope, (List<? extends VMTypeDescriptor>)expectedType))));
        }
    }

    public static class Dispatcher
    extends CallSummary {
        private final boolean optimistic;

        public Dispatcher(@NotNull ComplexSymbolFactory.Location left, @NotNull ComplexSymbolFactory.Location right, Boolean resolution, boolean optimistic) {
            super(left, right, resolution);
            this.optimistic = optimistic;
        }

        public CollectingResult<SpecCallSummary.Dispatcher, CVLError> kotlinize(TypeResolver resolver, CVLScope scope, List<VMParam> funParams) {
            return KotlinizeResult.lift(new SpecCallSummary.Dispatcher(this.unresolved, this.optimistic, this.range));
        }
    }

    public static class Auto
    extends CallSummary
    implements HavocingSummary {
        public Auto(@NotNull ComplexSymbolFactory.Location left, @NotNull ComplexSymbolFactory.Location right, Boolean resolution) {
            super(left, right, resolution);
        }

        public CollectingResult<SpecCallSummary.HavocSummary.Auto, CVLError> kotlinize(TypeResolver resolver, CVLScope scope, List<VMParam> funParams) {
            return KotlinizeResult.lift(new SpecCallSummary.HavocSummary.Auto(this.unresolved, this.range));
        }
    }

    public static class HavocAll
    extends CallSummary
    implements HavocingSummary {
        public HavocAll(@NotNull ComplexSymbolFactory.Location left, @NotNull ComplexSymbolFactory.Location right, Boolean resolution) {
            super(left, right, resolution);
        }

        public CollectingResult<SpecCallSummary.HavocSummary.HavocAll, CVLError> kotlinize(TypeResolver resolver, CVLScope scope, List<VMParam> funParams) {
            return KotlinizeResult.lift(new SpecCallSummary.HavocSummary.HavocAll(this.unresolved, this.range));
        }
    }

    public static class HavocECF
    extends CallSummary
    implements HavocingSummary {
        public HavocECF(@NotNull ComplexSymbolFactory.Location left, @NotNull ComplexSymbolFactory.Location right, Boolean resolution) {
            super(left, right, resolution);
        }

        public CollectingResult<SpecCallSummary.HavocSummary.HavocECF, CVLError> kotlinize(TypeResolver resolver, CVLScope scope, List<VMParam> funParams) {
            return KotlinizeResult.lift(new SpecCallSummary.HavocSummary.HavocECF(this.unresolved, this.range));
        }
    }

    public static class Nondet
    extends CallSummary
    implements HavocingSummary {
        public Nondet(@NotNull ComplexSymbolFactory.Location left, @NotNull ComplexSymbolFactory.Location right, Boolean resolution) {
            super(left, right, resolution);
        }

        public CollectingResult<SpecCallSummary.HavocSummary.Nondet, CVLError> kotlinize(TypeResolver resolver, CVLScope scope, List<VMParam> funParams) {
            return KotlinizeResult.lift(new SpecCallSummary.HavocSummary.Nondet(this.unresolved, this.range));
        }
    }

    public static interface HavocingSummary {
    }

    public static class PerCalleeConstant
    extends CallSummary {
        public PerCalleeConstant(@NotNull ComplexSymbolFactory.Location left, @NotNull ComplexSymbolFactory.Location right, Boolean resolution) {
            super(left, right, resolution);
        }

        public CollectingResult<SpecCallSummary.PerCalleeConstant, CVLError> kotlinize(TypeResolver resolver, CVLScope scope, List<VMParam> funParams) {
            return KotlinizeResult.lift(new SpecCallSummary.PerCalleeConstant(this.unresolved, this.range));
        }
    }

    public static class Constant
    extends CallSummary {
        public Constant(@NotNull ComplexSymbolFactory.Location left, @NotNull ComplexSymbolFactory.Location right, Boolean resolution) {
            super(left, right, resolution);
        }

        public CollectingResult<SpecCallSummary.Constant, CVLError> kotlinize(TypeResolver resolver, CVLScope scope, List<VMParam> funParams) {
            return KotlinizeResult.lift(new SpecCallSummary.Constant(this.unresolved, this.range));
        }
    }

    public static class Always
    extends CallSummary {
        @NotNull
        private final Exp returnValue;

        public Always(@NotNull ComplexSymbolFactory.Location left, @NotNull ComplexSymbolFactory.Location right, Boolean resolution, @NotNull Exp returnValue) {
            super(left, right, resolution);
            this.returnValue = returnValue;
        }

        public CollectingResult<SpecCallSummary.Always, CVLError> kotlinize(TypeResolver resolver, CVLScope scope, List<VMParam> funParams) {
            return KotlinizeResult.map(this.returnValue.kotlinize(resolver, scope), retVal -> new SpecCallSummary.Always((CVLExp)retVal, this.unresolved, this.range));
        }
    }
}

