/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.Cmd;
import com.certora.evmverifier.cvl.Exp;
import com.certora.evmverifier.cvl.KotlinizeResult;
import com.certora.evmverifier.cvl.TypeOrLhs;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import kotlinizable.Kotlinizer;
import spec.TypeResolver;
import spec.cvlast.CVLCmd;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLLhs;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLScope;
import spec.cvlast.CVLType;
import spec.cvlast.typechecker.CVLError;
import utils.CollectingResult;

public class DefinitionCmd
extends Cmd {
    public TypeOrLhs type;
    public List<TypeOrLhs> lhs;
    public Exp exp;

    public DefinitionCmd(CVLRange _cvlRange, TypeOrLhs _type, List<TypeOrLhs> _idL, Exp _exp) {
        super(_cvlRange);
        this.type = _type;
        this.lhs = _idL;
        this.exp = _exp;
    }

    public String toString() {
        Stream<String> idListToString = this.lhs.stream().map(Objects::toString);
        String idLString = idListToString.reduce("", (S, s) -> S + ", " + s);
        if (this.type == null) {
            return String.format(idLString, this.exp.toString());
        }
        return String.format(this.type.toString(), idLString, this.exp.toString());
    }

    @Override
    public CollectingResult<CVLCmd, CVLError> kotlinize(TypeResolver resolver, CVLScope scope) {
        CollectingResult<Object, CVLError> type = this.type != null ? this.type.toCVLType(resolver, scope) : KotlinizeResult.lift(null);
        return KotlinizeResult.map(Kotlinizer.kotlinizeList(this.lhs, scope, resolver), this.exp.kotlinize(resolver, scope), type, (lhs, exp, resolvedType) -> new CVLCmd.Simple.Definition(this.cvlRange, (CVLType.PureCVLType)resolvedType, (List<? extends CVLLhs>)lhs, (CVLExp)exp, scope));
    }
}

