/*
 * Decompiled with CFR 0.152.
 */
package ksp.hooks;

import com.google.devtools.ksp.processing.Dependencies;
import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSAnnotation;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSFile;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSValueArgument;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import ksp.CertoraAnnotationProcessor;
import ksp.hooks.CVLHookProcessor;
import ksp.hooks.OpcodeHooksProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lksp/hooks/CVLHookProcessor;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "Lksp/CertoraAnnotationProcessor;", "environment", "Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;", "(Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;)V", "annotationName", "", "annotationPackage", "getAnnotationPackage", "()Ljava/lang/String;", "getEnvironment", "()Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;", "parseHookType", "tyName", "process", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "Instrumentation", "KspGeneration"})
@SourceDebugExtension(value={"SMAP\nCVLHookProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CVLHookProcessor.kt\nksp/hooks/CVLHookProcessor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,367:1\n37#2,2:368\n1855#3,2:370\n1855#3,2:372\n1855#3,2:374\n1855#3,2:376\n*S KotlinDebug\n*F\n+ 1 CVLHookProcessor.kt\nksp/hooks/CVLHookProcessor\n*L\n248#1:368,2\n277#1:370,2\n292#1:372,2\n310#1:374,2\n351#1:376,2\n*E\n"})
public final class CVLHookProcessor
implements SymbolProcessor,
CertoraAnnotationProcessor {
    @NotNull
    private final SymbolProcessorEnvironment environment;
    @NotNull
    private final String annotationName;

    public CVLHookProcessor(@NotNull SymbolProcessorEnvironment environment) {
        Intrinsics.checkNotNullParameter(environment, "environment");
        this.environment = environment;
        this.annotationName = "OpcodeHookType";
    }

    @NotNull
    public final SymbolProcessorEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    @NotNull
    public String getAnnotationPackage() {
        return "annotation";
    }

    private final String parseHookType(String tyName) {
        String string;
        switch (tyName) {
            case "address": {
                string = "spec.cvlast.CVLType.PureCVLType.Primitive.AccountIdentifier";
                break;
            }
            case "uint256": {
                string = "spec.cvlast.CVLType.PureCVLType.Primitive.UIntK(256)";
                break;
            }
            case "bytes32": {
                string = "spec.cvlast.CVLType.PureCVLType.Primitive.BytesK(32)";
                break;
            }
            default: {
                KSPLogger.error$default(this.environment.getLogger(), "Could not understand type " + tyName + ": we only support address, bytes32, and uint256", null, 2, null);
                return null;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<KSAnnotated> process(@NotNull Resolver resolver) {
        int n;
        Instrumentation it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        int n2;
        Object writer2;
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        Set files = new LinkedHashSet();
        List instr2 = SequencesKt.toList(SequencesKt.mapNotNull(Resolver.getSymbolsWithAnnotation$default(resolver, this.getAnnotationPackage() + "." + this.annotationName, false, 2, null), (Function1)new Function1<KSAnnotated, Instrumentation>((Set<KSFile>)files, this){
            final /* synthetic */ Set<KSFile> $files;
            final /* synthetic */ CVLHookProcessor this$0;
            {
                this.$files = $files;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Instrumentation invoke(@NotNull KSAnnotated enumEntry) {
                Collection it;
                void $this$mapTo$iv$iv;
                void $this$mapTo$iv$iv2;
                List<T> list;
                Pair it$iv$iv;
                Object it2;
                Object element$iv$iv;
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Object v12;
                String valueType;
                KSValueArgument it3;
                String[] it42;
                List parameters;
                boolean hasOutput;
                Object it5;
                String declarationName;
                String opcodeName;
                block30: {
                    Object v10;
                    KSAnnotation opcodeAnnotation;
                    block29: {
                        Object object;
                        block28: {
                            KSAnnotation kSAnnotation;
                            Object object2;
                            Object object32;
                            Object object4;
                            block27: {
                                Object object5;
                                block26: {
                                    Object p0;
                                    Object object6;
                                    Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
                                    KSClassDeclaration hookableOpcodeEntry = (KSClassDeclaration)enumEntry;
                                    opcodeName = hookableOpcodeEntry.getSimpleName().asString();
                                    KSFile kSFile = ((KSClassDeclaration)enumEntry).getContainingFile();
                                    if (kSFile != null) {
                                        object6 = kSFile;
                                        object4 = this.$files;
                                        p0 = object6;
                                        boolean object32 = false;
                                        object4.add((KSFile)p0);
                                    } else {
                                        this.this$0.getEnvironment().getLogger().warn("Could not find Kotlin file containing " + ((KSClassDeclaration)enumEntry).getQualifiedName(), enumEntry);
                                    }
                                    String string = opcodeName.substring(0, 1);
                                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                                    String string2 = opcodeName.substring(1);
                                    Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
                                    String string3 = string2.toLowerCase(Locale.ROOT);
                                    Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                                    declarationName = string + string3;
                                    object6 = enumEntry.getAnnotations();
                                    object4 = this.this$0;
                                    p0 = object6;
                                    object32 = p0.iterator();
                                    while (object32.hasNext()) {
                                        object2 = object32.next();
                                        it5 = (KSAnnotation)object2;
                                        boolean bl = false;
                                        if (!((CVLHookProcessor)object4).isAnnotation((KSAnnotation)it5, CVLHookProcessor.access$getAnnotationName$p((CVLHookProcessor)object4))) continue;
                                        object5 = object2;
                                        break block26;
                                    }
                                    object5 = null;
                                }
                                Intrinsics.checkNotNull(object5);
                                opcodeAnnotation = (KSAnnotation)object5;
                                object32 = opcodeAnnotation.getArguments();
                                object2 = object32.iterator();
                                while (object2.hasNext()) {
                                    it5 = object2.next();
                                    KSValueArgument it6 = (KSValueArgument)it5;
                                    boolean bl = false;
                                    KSName kSName = it6.getName();
                                    if (!Intrinsics.areEqual(kSName != null ? kSName.asString() : null, "withOutput")) continue;
                                    kSAnnotation = it5;
                                    break block27;
                                }
                                kSAnnotation = null;
                            }
                            Intrinsics.checkNotNull(kSAnnotation);
                            object4 = ((KSValueArgument)((Object)kSAnnotation)).getValue();
                            Intrinsics.checkNotNull(object4, "null cannot be cast to non-null type kotlin.Boolean");
                            hasOutput = (Boolean)object4;
                            object32 = opcodeAnnotation.getArguments();
                            object2 = object32.iterator();
                            while (object2.hasNext()) {
                                it5 = object2.next();
                                KSValueArgument it42 = (KSValueArgument)it5;
                                boolean bl = false;
                                KSName kSName = it42.getName();
                                if (!Intrinsics.areEqual(kSName != null ? kSName.asString() : null, "params")) continue;
                                object = it5;
                                break block28;
                            }
                            object = null;
                        }
                        Intrinsics.checkNotNull(object);
                        Object $this$uncheckedAs$iv = ((KSValueArgument)object).getValue();
                        boolean $i$f$uncheckedAs = false;
                        parameters = (List)$this$uncheckedAs$iv;
                        it5 = opcodeAnnotation.getArguments();
                        it42 = it5.iterator();
                        while (it42.hasNext()) {
                            T bl = it42.next();
                            it3 = (KSValueArgument)bl;
                            boolean bl2 = false;
                            KSName kSName = it3.getName();
                            if (!Intrinsics.areEqual(kSName != null ? kSName.asString() : null, "valueType")) continue;
                            v10 = bl;
                            break block29;
                        }
                        v10 = null;
                    }
                    Intrinsics.checkNotNull(v10);
                    Object $i$f$uncheckedAs = ((KSValueArgument)v10).getValue();
                    Intrinsics.checkNotNull($i$f$uncheckedAs, "null cannot be cast to non-null type kotlin.String");
                    valueType = (String)$i$f$uncheckedAs;
                    it5 = opcodeAnnotation.getArguments();
                    it42 = it5.iterator();
                    while (it42.hasNext()) {
                        T bl = it42.next();
                        it3 = (KSValueArgument)bl;
                        boolean bl3 = false;
                        KSName kSName = it3.getName();
                        if (!Intrinsics.areEqual(kSName != null ? kSName.asString() : null, OpcodeHooksProcessor.Companion.getOnlyNoStorageSplittingProp())) continue;
                        v12 = bl;
                        break block30;
                    }
                    v12 = null;
                }
                Intrinsics.checkNotNull(v12);
                Object object = ((KSValueArgument)v12).getValue();
                Intrinsics.checkNotNull(object);
                boolean dependentOnStorageSplitting = (Boolean)object;
                it5 = parameters;
                it42 = this.this$0;
                boolean $i$f$mapNotNull = false;
                it3 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo22 = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Pair pair2;
                    T element$iv$iv$iv;
                    element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    it2 = (String)element$iv$iv;
                    boolean bl4 = false;
                    Regex regex = new Regex("\\s+");
                    CharSequence charSequence = (CharSequence)it2;
                    int n = 0;
                    List<String> parsed = regex.split(charSequence, n);
                    if (parsed.size() != 2) {
                        it42.getEnvironment().getLogger().error("Could not parse parameter declaration " + (String)it2, enumEntry);
                        pair2 = null;
                    } else {
                        String typeName;
                        pair2 = CVLHookProcessor.access$parseHookType((CVLHookProcessor)it42, parsed.get(0)) == null ? null : TuplesKt.to(parsed.get(1), typeName);
                    }
                    if (pair2 == null) continue;
                    it$iv$iv = pair2;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List<T> opcodeParamsAndTypes = (List<T>)destination$iv$iv;
                it42 = new String[]{"GeneratedOpcodeHook"};
                List<String> extendsList = CollectionsKt.mutableListOf(it42);
                if (hasOutput) {
                    extendsList.add("spec.cvlast.PatternWithValue");
                    String string = CVLHookProcessor.access$parseHookType(this.this$0, valueType);
                    if (string == null) {
                        return null;
                    }
                    list = CollectionsKt.plus((Collection)CollectionsKt.listOf(TuplesKt.to("value", string)), (Iterable)opcodeParamsAndTypes);
                } else {
                    list = opcodeParamsAndTypes;
                }
                List<T> allHookParams = list;
                Iterable $this$map$iv = allHookParams;
                boolean $i$f$map = false;
                Iterable $i$f$mapNotNullTo22 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv2) {
                    String string;
                    String string4;
                    void it7;
                    element$iv$iv = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    it2 = Intrinsics.areEqual(it7.getFirst(), "value") && hasOutput;
                    boolean it8 = (Boolean)it2;
                    boolean bl6 = false;
                    Object object7 = it8 ? it2 : null;
                    if (object7 != null) {
                        it8 = (Boolean)object7;
                        boolean bl7 = false;
                        string4 = "override ";
                    } else {
                        string4 = string = null;
                    }
                    if (string4 == null) {
                        string = "";
                    }
                    collection.add(string + "val " + it7.getFirst() + ": VMParam.Named");
                }
                List paramList = (List)destination$iv$iv2;
                String paramProperty2 = opcodeParamsAndTypes.isEmpty() ? "emptyList()" : "listOf(" + CollectionsKt.joinToString$default(opcodeParamsAndTypes, ", ", null, null, 0, null, process.instr.paramProperty.1.INSTANCE, 30, null) + ")";
                Object prettyPrint2 = "$name";
                if (!((Collection)opcodeParamsAndTypes).isEmpty()) {
                    prettyPrint2 = (String)prettyPrint2 + CollectionsKt.joinToString$default(opcodeParamsAndTypes, ",", "(", ")", 0, null, process.instr.2.INSTANCE, 24, null);
                }
                if (hasOutput) {
                    prettyPrint2 = (String)prettyPrint2 + " = $value";
                }
                String hookDeclaration2 = StringsKt.trimIndent("\n                @kotlinx.serialization.Serializable\n                data class " + declarationName + "(" + CollectionsKt.joinToString$default(paramList, ", ", null, null, 0, null, null, 62, null) + ") : CVLHookPattern.Opcode(), " + CollectionsKt.joinToString$default(extendsList, ", ", null, null, 0, null, null, 62, null) + " {\n                   override val name: String = \"" + opcodeName + "\"\n                   override val params: List<VMParam.Named> = " + paramProperty2 + "\n                   override fun toString(): String = \"" + (String)prettyPrint2 + "\"\n                }\n            ");
                String fqn = "spec.cvlast." + declarationName;
                CVLHookProcessor $this$invoke_u24lambda_u2410 = this.this$0;
                boolean bl = false;
                Iterable $this$map$iv2 = allHookParams;
                boolean $i$f$map2 = false;
                Iterable it9 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it$iv$iv = (Pair)item$iv$iv;
                    Collection bl5 = destination$iv$iv3;
                    boolean bl8 = false;
                    bl5.add("val " + ((Pair)((Object)it)).getFirst() + " = namedVMParam(pattern." + ((Pair)((Object)it)).getFirst() + ")");
                }
                List remappings = (List)destination$iv$iv3;
                String rebuild2 = StringsKt.trimIndent("\n                pattern.copy(\n                   " + CollectionsKt.joinToString$default(allHookParams, ",\n", null, null, 0, null, process.instr.hookMapper.1.rebuild.1.INSTANCE, 30, null) + "\n                ).lift()\n            ");
                String hookMapper2 = StringsKt.trimIndent("\n                    is " + fqn + " -> {\n                        " + CollectionsKt.joinToString$default(remappings, "\n", null, null, 0, null, null, 62, null) + "\n                        bindMany(" + CollectionsKt.joinToString$default(allHookParams, ", ", null, null, 0, null, process.instr.hookMapper.1.1.INSTANCE, 30, null) + ") { -> " + rebuild2 + " }\n                    }\n                ");
                CVLHookProcessor $this$invoke_u24lambda_u2412 = this.this$0;
                boolean bl9 = false;
                List fieldChecks = new ArrayList<E>();
                Iterable $this$mapTo$iv = allHookParams;
                boolean $i$f$mapTo3 = false;
                for (T item$iv : $this$mapTo$iv) {
                    Object item$iv$iv;
                    item$iv$iv = (Pair)item$iv;
                    it = fieldChecks;
                    boolean bl10 = false;
                    String fld = (String)((Pair)item$iv$iv).component1();
                    String type = (String)((Pair)item$iv$iv).component2();
                    it.add(StringsKt.trimIndent("\n                        checkHookParam(pattern." + fld + ".type, " + type + ", \"" + fld + "\", pattern)\n                    "));
                }
                Collection cfr_ignored_0 = (Collection)fieldChecks;
                if (dependentOnStorageSplitting) {
                    fieldChecks.add("if (Config.EnableStorageSplitting.get() && !TypecheckerConfig.IsTypeChecking.get()) {\n                            CVLError.General(cvlRange, \"Must disable storage splitting to handle hook " + opcodeName + "\").asError()\n                        } else {\n                            ok\n                        },");
                }
                String hookTypeChecker = StringsKt.trimIndent("\n                    is " + fqn + " -> {\n                        bindMany(\n                            " + CollectionsKt.joinToString$default(fieldChecks, ",\n", null, null, 0, null, null, 62, null) + "\n                        ) { pattern.lift() }\n                    }\n                ");
                String qualifiedEnumName = "com.certora.evmverifier.cvl.HookType." + opcodeName;
                CVLHookProcessor $this$invoke_u24lambda_u2414 = this.this$0;
                boolean bl11 = false;
                List argumentParsers = new ArrayList<E>();
                List prefix = new ArrayList<E>();
                if (hasOutput) {
                    prefix.add(StringsKt.trimIndent("\n                        if(valueParam == null) {\n                           return CVLError.General(\n                              message = \"Opcode " + opcodeName + " produces a value, but no output was declared\",\n                              cvlRange = cvlRange\n                           ).asError()\n                        }\n                    "));
                }
                prefix.add(StringsKt.trimIndent("\n                    if(params.size != " + opcodeParamsAndTypes.size() + ") {\n                       return CVLError.General(\n                          message = \"Opcode " + opcodeName + " expects " + opcodeParamsAndTypes.size() + " parameters, got \" + params.size,\n                          cvlRange = cvlRange\n                       ).asError()\n                    }\n                "));
                if (hasOutput) {
                    argumentParsers.add(TuplesKt.to("value", "valueParam.toNamedVMParam(resolver, scope)"));
                }
                Iterable $this$forEachIndexed$iv = opcodeParamsAndTypes;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Pair pair3 = (Pair)item$iv;
                    int idx = n;
                    boolean bl12 = false;
                    String paramName = (String)pair3.component1();
                    argumentParsers.add(TuplesKt.to(paramName, StringsKt.trimIndent("\n                            params[" + idx + "].toNamedVMParam(resolver, scope)\n                        ")));
                }
                String hookParser2 = StringsKt.trimIndent("\n                    " + qualifiedEnumName + " -> {\n                       " + CollectionsKt.joinToString$default(prefix, "\n", null, null, 0, null, null, 62, null) + "\n\n                       " + CollectionsKt.joinToString$default(argumentParsers, "\n", null, null, 0, null, process.instr.hookParser.1.2.INSTANCE, 30, null) + "\n                        bindMany(" + CollectionsKt.joinToString$default(argumentParsers, ", ", null, null, 0, null, process.instr.hookParser.1.3.INSTANCE, 30, null) + ") {\n                            " + fqn + "(\n                                " + CollectionsKt.joinToString$default(argumentParsers, ",\n", null, null, 0, null, process.instr.hookParser.1.4.INSTANCE, 30, null) + "\n                            ).lift()\n                        }\n                    }\n                ");
                return new Instrumentation(hookDeclaration2, hookMapper2, hookTypeChecker, parameters.size(), hookParser2, qualifiedEnumName);
            }
        }));
        if (instr2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = files;
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv22 = $this$toTypedArray$iv;
        Object object = thisCollection$iv22.toArray(new KSFile[0]);
        Dependencies deps = new Dependencies(true, Arrays.copyOf(object, ((KSFile[])object).length));
        object = this.environment.getCodeGenerator().createNewFile(deps, "spec.cvlast", "GeneratedHookHelpers", "kt");
        Object object2 = Charsets.UTF_8;
        Writer $i$f$toTypedArray22 = new OutputStreamWriter((OutputStream)object, (Charset)object2);
        int thisCollection$iv22 = 8192;
        object = $i$f$toTypedArray22 instanceof BufferedWriter ? (BufferedWriter)$i$f$toTypedArray22 : new BufferedWriter($i$f$toTypedArray22, thisCollection$iv22);
        object2 = null;
        try {
            writer2 = (BufferedWriter)object;
            n2 = 0;
            ((Writer)writer2).write("package spec.cvlast\n\nimport config.Config\nimport config.TypecheckerConfig\nimport datastructures.stdcollections.*\nimport spec.cvlast.typedescriptors.*\nimport spec.cvlast.typechecker.CVLError\nimport utils.CollectingResult.Companion.bindMany\nimport utils.CollectingResult.Companion.lift\nimport utils.CollectingResult\nimport utils.VoidResult\nimport utils.CollectingResult.Companion.asError\nimport utils.CollectingResult.Companion.ok\n\nobject GeneratedHookHelpers {");
            ((Writer)writer2).write("fun typeCheckPattern(\n    cvlRange: CVLRange,\n    pattern: GeneratedOpcodeHook,\n    checkHookParam: (VMTypeDescriptor, CVLType.PureCVLType, String, CVLHookPattern.Opcode) -> VoidResult<CVLError>\n) : CollectingResult<CVLHookPattern.Opcode, CVLError> {\n   return when(pattern) {");
            $this$forEach$iv = instr2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Instrumentation)element$iv;
                boolean bl = false;
                ((BufferedWriter)writer2).newLine();
                ((Writer)writer2).write(it.getHookPatternChecker());
            }
            ((Writer)writer2).write("    } // end when\n} // end function");
            ((BufferedWriter)writer2).newLine();
            ((Writer)writer2).write("fun <E> mapPattern(pattern: GeneratedOpcodeHook, namedVMParam: (VMParam.Named) -> CollectingResult<VMParam.Named, E>): CollectingResult<CVLHookPattern, E> {\n    return when(pattern) {");
            $this$forEach$iv = instr2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Instrumentation)element$iv;
                boolean bl = false;
                ((BufferedWriter)writer2).newLine();
                ((Writer)writer2).write(it.getHookMapper());
            }
            ((Writer)writer2).write("   } // end when\n} // end function\n} // end object");
            writer2 = Unit.INSTANCE;
        }
        catch (Throwable writer2) {
            object2 = writer2;
            throw writer2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        object = this.environment.getCodeGenerator().createNewFile(deps, "spec.cvlast", "GeneratedOpcodeHooks", "kt");
        object2 = Charsets.UTF_8;
        writer2 = new OutputStreamWriter((OutputStream)object, (Charset)object2);
        n2 = 8192;
        object = writer2 instanceof BufferedWriter ? (BufferedWriter)writer2 : new BufferedWriter((Writer)writer2, n2);
        object2 = null;
        try {
            writer2 = (BufferedWriter)object;
            n = 0;
            ((Writer)writer2).write("package spec.cvlast\n\nimport datastructures.stdcollections.*");
            $this$forEach$iv = instr2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Instrumentation)element$iv;
                boolean bl = false;
                ((BufferedWriter)writer2).newLine();
                ((Writer)writer2).write(it.getHookDeclaration());
            }
            writer2 = Unit.INSTANCE;
        }
        catch (Throwable writer2) {
            object2 = writer2;
            throw writer2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        object = this.environment.getCodeGenerator().createNewFile(deps, "spec.cvlast.parser", "GeneratedOpcodeParsers", "kt");
        object2 = Charsets.UTF_8;
        writer2 = new OutputStreamWriter((OutputStream)object, (Charset)object2);
        n = 8192;
        object = writer2 instanceof BufferedWriter ? (BufferedWriter)writer2 : new BufferedWriter((Writer)writer2, n);
        object2 = null;
        try {
            writer2 = (BufferedWriter)object;
            boolean bl = false;
            ((Writer)writer2).write(StringsKt.trimIndent("\n                @file:Suppress(\"ReplaceSizeCheckWithIsNotEmpty\", \"ConvertToStringTemplate\") // we generate const checks that might be against 0\n                   package spec.cvlast.parser\n\n                import datastructures.stdcollections.*\n                import spec.cvlast.*\n                import utils.CollectingResult.Companion.bindMany\n                import utils.CollectingResult.Companion.lift\n                import utils.CollectingResult.Companion.asError\n                import spec.cvlast.typechecker.CVLError\n                import utils.CollectingResult\n                import spec.TypeResolver\n                import spec.cvlast.CVLScope\n\n                object GeneratedOpcodeParsers {\n                   fun supportsAutoParse(\n                      hookType: com.certora.evmverifier.cvl.HookType\n                   ) : Boolean {\n                      return " + CollectionsKt.joinToString$default(instr2, " ||\n", null, null, 0, null, process.3.1.INSTANCE, 30, null) + "\n                   }\n\n                   fun handleParse(\n                      resolver: TypeResolver,\n                      scope: CVLScope,\n                      hookType: com.certora.evmverifier.cvl.HookType,\n                      valueParam: com.certora.evmverifier.cvl.NamedParam?,\n                      params: List<com.certora.evmverifier.cvl.NamedParam>,\n                      cvlRange: CVLRange\n                   ) : CollectingResult<CVLHookPattern, CVLError> {\n                      return when(hookType) {\n            "));
            $this$forEach$iv = instr2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Instrumentation)element$iv;
                boolean bl2 = false;
                ((BufferedWriter)writer2).newLine();
                ((Writer)writer2).write(it.getHookParser());
            }
            ((BufferedWriter)writer2).newLine();
            ((Writer)writer2).write("        else -> throw UnsupportedOperationException(\"cannot auto parse \" + hookType)\n    }\n   }\n}");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean isAnnotation(@NotNull KSAnnotation $this$isAnnotation, @NotNull String shortName) {
        return CertoraAnnotationProcessor.DefaultImpls.isAnnotation(this, $this$isAnnotation, shortName);
    }

    @Override
    public boolean isAnnotation(@NotNull KSAnnotation it, @NotNull String shortName, @NotNull String qualified) {
        return CertoraAnnotationProcessor.DefaultImpls.isAnnotation(this, it, shortName, qualified);
    }

    @Override
    public boolean hasAnnotation(@NotNull KSAnnotated $this$hasAnnotation, @NotNull String shortName) {
        return CertoraAnnotationProcessor.DefaultImpls.hasAnnotation(this, $this$hasAnnotation, shortName);
    }

    public static final /* synthetic */ String access$parseHookType(CVLHookProcessor $this, String tyName) {
        return $this.parseHookType(tyName);
    }

    public static final /* synthetic */ String access$getAnnotationName$p(CVLHookProcessor $this) {
        return $this.annotationName;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lksp/hooks/CVLHookProcessor$Instrumentation;", "", "hookDeclaration", "", "hookMapper", "hookPatternChecker", "numParamsDeclared", "", "hookParser", "enumEntry", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getEnumEntry", "()Ljava/lang/String;", "getHookDeclaration", "getHookMapper", "getHookParser", "getHookPatternChecker", "getNumParamsDeclared", "()I", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "KspGeneration"})
    public static final class Instrumentation {
        @NotNull
        private final String hookDeclaration;
        @NotNull
        private final String hookMapper;
        @NotNull
        private final String hookPatternChecker;
        private final int numParamsDeclared;
        @NotNull
        private final String hookParser;
        @NotNull
        private final String enumEntry;

        public Instrumentation(@NotNull String hookDeclaration2, @NotNull String hookMapper2, @NotNull String hookPatternChecker, int numParamsDeclared, @NotNull String hookParser2, @NotNull String enumEntry) {
            Intrinsics.checkNotNullParameter(hookDeclaration2, "hookDeclaration");
            Intrinsics.checkNotNullParameter(hookMapper2, "hookMapper");
            Intrinsics.checkNotNullParameter(hookPatternChecker, "hookPatternChecker");
            Intrinsics.checkNotNullParameter(hookParser2, "hookParser");
            Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
            this.hookDeclaration = hookDeclaration2;
            this.hookMapper = hookMapper2;
            this.hookPatternChecker = hookPatternChecker;
            this.numParamsDeclared = numParamsDeclared;
            this.hookParser = hookParser2;
            this.enumEntry = enumEntry;
        }

        @NotNull
        public final String getHookDeclaration() {
            return this.hookDeclaration;
        }

        @NotNull
        public final String getHookMapper() {
            return this.hookMapper;
        }

        @NotNull
        public final String getHookPatternChecker() {
            return this.hookPatternChecker;
        }

        public final int getNumParamsDeclared() {
            return this.numParamsDeclared;
        }

        @NotNull
        public final String getHookParser() {
            return this.hookParser;
        }

        @NotNull
        public final String getEnumEntry() {
            return this.enumEntry;
        }

        @NotNull
        public final String component1() {
            return this.hookDeclaration;
        }

        @NotNull
        public final String component2() {
            return this.hookMapper;
        }

        @NotNull
        public final String component3() {
            return this.hookPatternChecker;
        }

        public final int component4() {
            return this.numParamsDeclared;
        }

        @NotNull
        public final String component5() {
            return this.hookParser;
        }

        @NotNull
        public final String component6() {
            return this.enumEntry;
        }

        @NotNull
        public final Instrumentation copy(@NotNull String hookDeclaration2, @NotNull String hookMapper2, @NotNull String hookPatternChecker, int numParamsDeclared, @NotNull String hookParser2, @NotNull String enumEntry) {
            Intrinsics.checkNotNullParameter(hookDeclaration2, "hookDeclaration");
            Intrinsics.checkNotNullParameter(hookMapper2, "hookMapper");
            Intrinsics.checkNotNullParameter(hookPatternChecker, "hookPatternChecker");
            Intrinsics.checkNotNullParameter(hookParser2, "hookParser");
            Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
            return new Instrumentation(hookDeclaration2, hookMapper2, hookPatternChecker, numParamsDeclared, hookParser2, enumEntry);
        }

        public static /* synthetic */ Instrumentation copy$default(Instrumentation instrumentation, String string, String string2, String string3, int n, String string4, String string5, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = instrumentation.hookDeclaration;
            }
            if ((n2 & 2) != 0) {
                string2 = instrumentation.hookMapper;
            }
            if ((n2 & 4) != 0) {
                string3 = instrumentation.hookPatternChecker;
            }
            if ((n2 & 8) != 0) {
                n = instrumentation.numParamsDeclared;
            }
            if ((n2 & 0x10) != 0) {
                string4 = instrumentation.hookParser;
            }
            if ((n2 & 0x20) != 0) {
                string5 = instrumentation.enumEntry;
            }
            return instrumentation.copy(string, string2, string3, n, string4, string5);
        }

        @NotNull
        public String toString() {
            return "Instrumentation(hookDeclaration=" + this.hookDeclaration + ", hookMapper=" + this.hookMapper + ", hookPatternChecker=" + this.hookPatternChecker + ", numParamsDeclared=" + this.numParamsDeclared + ", hookParser=" + this.hookParser + ", enumEntry=" + this.enumEntry + ")";
        }

        public int hashCode() {
            int result2 = this.hookDeclaration.hashCode();
            result2 = result2 * 31 + this.hookMapper.hashCode();
            result2 = result2 * 31 + this.hookPatternChecker.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.numParamsDeclared);
            result2 = result2 * 31 + this.hookParser.hashCode();
            result2 = result2 * 31 + this.enumEntry.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Instrumentation)) {
                return false;
            }
            Instrumentation instrumentation = (Instrumentation)other;
            if (!Intrinsics.areEqual(this.hookDeclaration, instrumentation.hookDeclaration)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.hookMapper, instrumentation.hookMapper)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.hookPatternChecker, instrumentation.hookPatternChecker)) {
                return false;
            }
            if (this.numParamsDeclared != instrumentation.numParamsDeclared) {
                return false;
            }
            if (!Intrinsics.areEqual(this.hookParser, instrumentation.hookParser)) {
                return false;
            }
            return Intrinsics.areEqual(this.enumEntry, instrumentation.enumEntry);
        }
    }
}

