/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast.abi;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spec.EVMConfig;
import spec.cvlast.abi.DataLayout;
import spec.cvlast.abi.EVMDataLayout;
import spec.cvlast.abi.PrimitiveBufferRepresentation;
import spec.cvlast.typedescriptors.TerminalEncoding;
import utils.ExtStdlibKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u0004*\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0010\u0010\b\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0018\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0005*\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0005*\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\f"}, d2={"Lspec/cvlast/abi/EVMDataLayout;", "", "()V", "computeExactArrayElementSize", "Ljava/math/BigInteger;", "Lspec/cvlast/abi/DataLayout;", "Lspec/cvlast/abi/PrimitiveBufferRepresentation;", "encodingSizeExact", "sizeAsEncodedMember", "toDecodingLayout", "Lspec/cvlast/typedescriptors/TerminalEncoding;", "toEncodingLayout", "Shared"})
@SourceDebugExtension(value={"SMAP\nEVMDataLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EVMDataLayout.kt\nspec/cvlast/abi/EVMDataLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,266:1\n1#2:267\n2661#3,7:268\n1549#3:275\n1620#3,3:276\n2661#3,7:279\n1549#3:286\n1620#3,3:287\n*S KotlinDebug\n*F\n+ 1 EVMDataLayout.kt\nspec/cvlast/abi/EVMDataLayout\n*L\n35#1:268,7\n56#1:275\n56#1:276,3\n58#1:279,7\n256#1:286\n256#1:287,3\n*E\n"})
public final class EVMDataLayout {
    @NotNull
    public static final EVMDataLayout INSTANCE = new EVMDataLayout();

    private EVMDataLayout() {
    }

    /*
     * WARNING - void declaration
     */
    private final BigInteger encodingSizeExact(DataLayout<? extends PrimitiveBufferRepresentation> $this$encodingSizeExact) {
        BigInteger bigInteger;
        DataLayout<? extends PrimitiveBufferRepresentation> dataLayout = $this$encodingSizeExact;
        if ((dataLayout instanceof DataLayout.SequenceOf ? true : dataLayout instanceof DataLayout.DynamicPointer) ? true : dataLayout instanceof DataLayout.LengthTaggedTuple) {
            bigInteger = null;
        } else if (dataLayout instanceof DataLayout.OpenScope) {
            bigInteger = this.encodingSizeExact(((DataLayout.OpenScope)$this$encodingSizeExact).getNext());
        } else if (dataLayout instanceof DataLayout.StaticRepeatedOf) {
            BigInteger bigInteger2 = this.encodingSizeExact(((DataLayout.StaticRepeatedOf)$this$encodingSizeExact).getElem());
            if (bigInteger2 != null) {
                BigInteger bigInteger3 = bigInteger2;
                BigInteger bigInteger4 = ((DataLayout.StaticRepeatedOf)$this$encodingSizeExact).getNum();
                BigInteger p0 = bigInteger3;
                boolean bl = false;
                bigInteger = bigInteger4.multiply(p0);
            } else {
                bigInteger = null;
            }
        } else if (dataLayout instanceof DataLayout.Terminal) {
            BigInteger bigInteger5 = BigInteger.valueOf(EVMConfig.INSTANCE.getRegisterByteWidth());
            bigInteger = bigInteger5;
            Intrinsics.checkNotNullExpressionValue(bigInteger5, "valueOf(this.toLong())");
        } else if (dataLayout instanceof DataLayout.TupleOf) {
            List list = ExtStdlibKt.monadicMap(((DataLayout.TupleOf)$this$encodingSizeExact).getElements(), encodingSizeExact.2.INSTANCE);
            if (list != null) {
                void $this$reduce$iv;
                Iterable iterable = list;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void p12;
                    BigInteger bigInteger6 = (BigInteger)iterator$iv.next();
                    BigInteger p0 = (BigInteger)accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = p0.add((BigInteger)p12);
                }
                bigInteger = (BigInteger)accumulator$iv;
            } else {
                bigInteger = null;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bigInteger;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BigInteger sizeAsEncodedMember(@NotNull DataLayout<? extends PrimitiveBufferRepresentation> $this$sizeAsEncodedMember) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter($this$sizeAsEncodedMember, "<this>");
        DataLayout<? extends PrimitiveBufferRepresentation> dataLayout = $this$sizeAsEncodedMember;
        if (dataLayout instanceof DataLayout.DynamicPointer) {
            BigInteger bigInteger2 = BigInteger.valueOf(EVMConfig.INSTANCE.getRegisterByteWidth());
            bigInteger = bigInteger2;
            Intrinsics.checkNotNullExpressionValue(bigInteger2, "valueOf(this.toLong())");
        } else if (dataLayout instanceof DataLayout.OpenScope) {
            bigInteger = this.sizeAsEncodedMember(((DataLayout.OpenScope)$this$sizeAsEncodedMember).getNext());
        } else {
            if (dataLayout instanceof DataLayout.SequenceOf ? true : dataLayout instanceof DataLayout.LengthTaggedTuple) {
                throw new UnsupportedOperationException();
            }
            if (dataLayout instanceof DataLayout.StaticRepeatedOf) {
                BigInteger bigInteger3 = ((DataLayout.StaticRepeatedOf)$this$sizeAsEncodedMember).getNum().multiply(this.sizeAsEncodedMember(((DataLayout.StaticRepeatedOf)$this$sizeAsEncodedMember).getElem()));
                bigInteger = bigInteger3;
                Intrinsics.checkNotNullExpressionValue(bigInteger3, "this.multiply(other)");
            } else if (dataLayout instanceof DataLayout.Terminal) {
                BigInteger bigInteger4 = BigInteger.valueOf(EVMConfig.INSTANCE.getRegisterByteWidth());
                bigInteger = bigInteger4;
                Intrinsics.checkNotNullExpressionValue(bigInteger4, "valueOf(this.toLong())");
            } else if (dataLayout instanceof DataLayout.TupleOf) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = ((DataLayout.TupleOf)$this$sizeAsEncodedMember).getElements();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair2 = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(INSTANCE.sizeAsEncodedMember((DataLayout)it.getSecond()));
                }
                Iterable $this$reduce$iv = (List)destination$iv$iv;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void p12;
                    BigInteger $i$f$mapTo2 = (BigInteger)iterator$iv.next();
                    BigInteger p0 = (BigInteger)accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = p0.add((BigInteger)p12);
                }
                bigInteger = (BigInteger)accumulator$iv;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bigInteger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final BigInteger computeExactArrayElementSize(DataLayout<? extends PrimitiveBufferRepresentation> $this$computeExactArrayElementSize) {
        DataLayout<? extends PrimitiveBufferRepresentation> dataLayout = $this$computeExactArrayElementSize;
        if (dataLayout instanceof DataLayout.SequenceOf) {
            BigInteger bigInteger;
            DataLayout.SequenceElement sequenceElement = ((DataLayout.SequenceOf)$this$computeExactArrayElementSize).getSequenceElements();
            if (sequenceElement instanceof DataLayout.SequenceElement.Elements) {
                bigInteger = this.encodingSizeExact((DataLayout)((DataLayout.SequenceElement.Elements)((DataLayout.SequenceOf)$this$computeExactArrayElementSize).getSequenceElements()).getDataLayout());
                return bigInteger;
            } else {
                if (!Intrinsics.areEqual(sequenceElement, DataLayout.SequenceElement.PackedBytes1.INSTANCE)) throw new NoWhenBranchMatchedException();
                bigInteger = BigInteger.ONE;
            }
            return bigInteger;
        } else {
            if (dataLayout instanceof DataLayout.DynamicPointer) {
                return null;
            }
            boolean bl = dataLayout instanceof DataLayout.LengthTaggedTuple;
            if (bl) {
                return null;
            }
            boolean bl2 = dataLayout instanceof DataLayout.OpenScope;
            if (bl2) {
                return null;
            }
            boolean bl3 = dataLayout instanceof DataLayout.StaticRepeatedOf;
            if (bl3) {
                return null;
            }
            boolean bl4 = dataLayout instanceof DataLayout.Terminal;
            if (bl4) {
                return null;
            }
            boolean bl5 = dataLayout instanceof DataLayout.TupleOf;
            if (!bl5) throw new NoWhenBranchMatchedException();
            return null;
        }
    }

    @Nullable
    public final DataLayout<TerminalEncoding> toDecodingLayout(@NotNull DataLayout<? extends PrimitiveBufferRepresentation> $this$toDecodingLayout) {
        DataLayout dataLayout;
        Intrinsics.checkNotNullParameter($this$toDecodingLayout, "<this>");
        DataLayout<? extends PrimitiveBufferRepresentation> dataLayout2 = $this$toDecodingLayout;
        if (dataLayout2 instanceof DataLayout.DynamicPointer) {
            DataLayout.DynamicPointer<TerminalEncoding> dynamicPointer;
            DataLayout<TerminalEncoding> dataLayout3 = this.toDecodingLayout(((DataLayout.DynamicPointer)$this$toDecodingLayout).getNext());
            if (dataLayout3 != null) {
                DataLayout<TerminalEncoding> it = dataLayout3;
                boolean bl = false;
                dynamicPointer = new DataLayout.DynamicPointer<TerminalEncoding>(it);
            } else {
                dynamicPointer = null;
            }
            dataLayout = dynamicPointer;
        } else if (dataLayout2 instanceof DataLayout.LengthTaggedTuple) {
            DataLayout.Terminal<TerminalEncoding.MoveBlob> terminal;
            BigInteger bigInteger = this.computeExactArrayElementSize(((DataLayout.LengthTaggedTuple)$this$toDecodingLayout).getElems());
            if (bigInteger != null) {
                BigInteger eSize = bigInteger;
                boolean bl = false;
                terminal = new DataLayout.Terminal<TerminalEncoding.MoveBlob>(new TerminalEncoding.MoveBlob(true, new TerminalEncoding.MoveBlob.DataSize.Computed(eSize, TerminalEncoding.MoveBlob.ElementCount.Dynamic.INSTANCE)));
            } else {
                terminal = null;
            }
            dataLayout = terminal;
        } else if (dataLayout2 instanceof DataLayout.OpenScope) {
            DataLayout.OpenScope<TerminalEncoding> openScope;
            DataLayout<TerminalEncoding> dataLayout4 = this.toDecodingLayout(((DataLayout.OpenScope)$this$toDecodingLayout).getNext());
            if (dataLayout4 != null) {
                DataLayout<TerminalEncoding> it = dataLayout4;
                boolean bl = false;
                openScope = new DataLayout.OpenScope<TerminalEncoding>(it);
            } else {
                openScope = null;
            }
            dataLayout = openScope;
        } else if (dataLayout2 instanceof DataLayout.SequenceOf) {
            dataLayout = null;
        } else if (dataLayout2 instanceof DataLayout.StaticRepeatedOf) {
            DataLayout.Terminal<TerminalEncoding.MoveBlob> terminal;
            BigInteger bigInteger = this.encodingSizeExact(((DataLayout.StaticRepeatedOf)$this$toDecodingLayout).getElem());
            if (bigInteger != null) {
                BigInteger eSize = bigInteger;
                boolean bl = false;
                BigInteger bigInteger2 = ((DataLayout.StaticRepeatedOf)$this$toDecodingLayout).getNum();
                DataLayout.Terminal<TerminalEncoding.MoveBlob> terminal2 = new DataLayout.Terminal<TerminalEncoding.MoveBlob>(new TerminalEncoding.MoveBlob(false, new TerminalEncoding.MoveBlob.DataSize.Computed(eSize, bigInteger2)));
                terminal = terminal2;
            } else {
                terminal = null;
            }
            dataLayout = terminal;
        } else if (dataLayout2 instanceof DataLayout.Terminal) {
            dataLayout = new DataLayout.Terminal<TerminalEncoding.DirectValue>(new TerminalEncoding.DirectValue(((PrimitiveBufferRepresentation)((DataLayout.Terminal)$this$toDecodingLayout).getT()).getBufferEncoding()));
        } else if (dataLayout2 instanceof DataLayout.TupleOf) {
            DataLayout.TupleOf tupleOf;
            List list = ExtStdlibKt.monadicMap(((DataLayout.TupleOf)$this$toDecodingLayout).getElements(), toDecodingLayout.5.INSTANCE);
            if (list != null) {
                List mappedElems = list;
                boolean bl = false;
                tupleOf = new DataLayout.TupleOf(mappedElems);
            } else {
                tupleOf = null;
            }
            dataLayout = tupleOf;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return dataLayout;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataLayout<TerminalEncoding> toEncodingLayout(@NotNull DataLayout<? extends PrimitiveBufferRepresentation> $this$toEncodingLayout) {
        DataLayout dataLayout;
        Intrinsics.checkNotNullParameter($this$toEncodingLayout, "<this>");
        DataLayout<? extends PrimitiveBufferRepresentation> dataLayout2 = $this$toEncodingLayout;
        if (dataLayout2 instanceof DataLayout.DynamicPointer) {
            dataLayout = new DataLayout.DynamicPointer<TerminalEncoding>(this.toEncodingLayout(((DataLayout.DynamicPointer)$this$toEncodingLayout).getNext()));
        } else if (dataLayout2 instanceof DataLayout.LengthTaggedTuple) {
            TerminalEncoding.MoveBlob.DataSize dataSize;
            BigInteger staticSize = this.computeExactArrayElementSize(((DataLayout.LengthTaggedTuple)$this$toEncodingLayout).getElems());
            boolean bl = true;
            BigInteger bigInteger = staticSize;
            if (bigInteger != null) {
                void eSize;
                BigInteger bigInteger2 = bigInteger;
                boolean bl2 = bl;
                boolean bl3 = false;
                TerminalEncoding.MoveBlob.DataSize.Computed computed = new TerminalEncoding.MoveBlob.DataSize.Computed((BigInteger)eSize, TerminalEncoding.MoveBlob.ElementCount.Dynamic.INSTANCE);
                bl = bl2;
                dataSize = computed;
            } else {
                dataSize = TerminalEncoding.MoveBlob.DataSize.BlobSize.INSTANCE;
            }
            TerminalEncoding.MoveBlob.DataSize dataSize2 = dataSize;
            boolean bl4 = bl;
            TerminalEncoding.MoveBlob moveBlob = new TerminalEncoding.MoveBlob(bl4, dataSize2);
            dataLayout = new DataLayout.Terminal<TerminalEncoding.MoveBlob>(moveBlob);
        } else if (dataLayout2 instanceof DataLayout.OpenScope) {
            dataLayout = new DataLayout.OpenScope<TerminalEncoding>(this.toEncodingLayout(((DataLayout.OpenScope)$this$toEncodingLayout).getNext()));
        } else {
            if (dataLayout2 instanceof DataLayout.SequenceOf) {
                throw new UnsupportedOperationException("Illegal state, we should have hit length tagged tuple before this");
            }
            if (dataLayout2 instanceof DataLayout.StaticRepeatedOf) {
                TerminalEncoding.MoveBlob.DataSize dataSize;
                BigInteger staticSize = this.encodingSizeExact(((DataLayout.StaticRepeatedOf)$this$toEncodingLayout).getElem());
                boolean bl = false;
                BigInteger bigInteger = staticSize;
                if (bigInteger != null) {
                    BigInteger eSize = bigInteger;
                    boolean bl5 = bl;
                    boolean bl6 = false;
                    TerminalEncoding.MoveBlob.ElementCount.Constant constant = new TerminalEncoding.MoveBlob.ElementCount.Constant(((DataLayout.StaticRepeatedOf)$this$toEncodingLayout).getNum());
                    TerminalEncoding.MoveBlob.DataSize.Computed computed = new TerminalEncoding.MoveBlob.DataSize.Computed(eSize, constant);
                    bl = bl5;
                    dataSize = computed;
                } else {
                    dataSize = TerminalEncoding.MoveBlob.DataSize.BlobSize.INSTANCE;
                }
                TerminalEncoding.MoveBlob.DataSize dataSize3 = dataSize;
                boolean bl7 = bl;
                TerminalEncoding.MoveBlob moveBlob = new TerminalEncoding.MoveBlob(bl7, dataSize3);
                dataLayout = new DataLayout.Terminal<TerminalEncoding.MoveBlob>(moveBlob);
            } else if (dataLayout2 instanceof DataLayout.Terminal) {
                dataLayout = new DataLayout.Terminal<TerminalEncoding.DirectValue>(new TerminalEncoding.DirectValue(((PrimitiveBufferRepresentation)((DataLayout.Terminal)$this$toEncodingLayout).getT()).getBufferEncoding()));
            } else if (dataLayout2 instanceof DataLayout.TupleOf) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = ((DataLayout.TupleOf)$this$toEncodingLayout).getElements();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Pair pair2 = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String nm = (String)pair2.component1();
                    DataLayout enc = (DataLayout)pair2.component2();
                    collection.add(TuplesKt.to(nm, INSTANCE.toEncodingLayout(enc)));
                }
                List it = (List)destination$iv$iv;
                boolean bl = false;
                dataLayout = new DataLayout.TupleOf(it);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return dataLayout;
    }

    public static final /* synthetic */ BigInteger access$encodingSizeExact(EVMDataLayout $this, DataLayout $receiver) {
        return $this.encodingSizeExact($receiver);
    }
}

