/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5AbstractStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5StorageLayout;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;

public final class HDF5FloatStorageFeatures
extends HDF5AbstractStorageFeatures {
    public static final HDF5FloatStorageFeatures FLOAT_NO_COMPRESSION = new HDF5FloatStorageFeatures(null, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_NO_COMPRESSION_KEEP = new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_NO_COMPRESSION_DELETE = new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_COMPACT = new HDF5FloatStorageFeatures(HDF5StorageLayout.COMPACT, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_COMPACT_KEEP = new HDF5FloatStorageFeatures(HDF5StorageLayout.COMPACT, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_COMPACT_DELETE = new HDF5FloatStorageFeatures(HDF5StorageLayout.COMPACT, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_CONTIGUOUS = new HDF5FloatStorageFeatures(HDF5StorageLayout.CONTIGUOUS, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_CONTIGUOUS_KEEP = new HDF5FloatStorageFeatures(HDF5StorageLayout.CONTIGUOUS, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_CONTIGUOUS_DELETE = new HDF5FloatStorageFeatures(HDF5StorageLayout.CONTIGUOUS, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_CHUNKED = new HDF5FloatStorageFeatures(HDF5StorageLayout.CHUNKED, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_CHUNKED_KEEP = new HDF5FloatStorageFeatures(HDF5StorageLayout.CHUNKED, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_CHUNKED_DELETE = new HDF5FloatStorageFeatures(HDF5StorageLayout.CHUNKED, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 0, -1);
    public static final HDF5FloatStorageFeatures FLOAT_DEFLATE = new HDF5FloatStorageFeatures(null, 6, -1);
    public static final HDF5FloatStorageFeatures FLOAT_SHUFFLE_DEFLATE = new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.USE_WRITER_DEFAULT, true, 6, -1);
    public static final HDF5FloatStorageFeatures FLOAT_DEFLATE_KEEP = new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 6, -1);
    public static final HDF5FloatStorageFeatures FLOAT_DEFLATE_DELETE = new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 6, -1);
    public static final HDF5FloatStorageFeatures FLOAT_DEFLATE_MAX = new HDF5FloatStorageFeatures(null, 9, -1);
    public static final HDF5FloatStorageFeatures FLOAT_DEFLATE_MAX_KEEP = new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 9, -1);
    public static final HDF5FloatStorageFeatures FLOAT_DEFLATE_MAX_DELETE = new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 9, -1);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING1 = new HDF5FloatStorageFeatures(null, 0, 1);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING1_KEEP = new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, 1);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING1_DELETE = new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 0, 1);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING1_DEFLATE = new HDF5FloatStorageFeatures(null, 6, 1);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING1_DEFLATE_KEEP = new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 6, 1);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING1_DEFLATE_DELETE = new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 6, 1);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING2 = new HDF5FloatStorageFeatures(null, 0, 2);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING2_KEEP = new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, 2);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING2_DELETE = new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 0, 2);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING2_DEFLATE = new HDF5FloatStorageFeatures(null, 6, 2);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING2_DEFLATE_KEEP = new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 6, 2);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING2_DEFLATE_DELETE = new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 6, 2);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING3 = new HDF5FloatStorageFeatures(null, 0, 3);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING3_KEEP = new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, 3);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING3_DELETE = new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, true, 0, 3);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING3_DEFLATE = new HDF5FloatStorageFeatures(null, 6, 3);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING3_DEFLATE_KEEP = new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 6, 3);
    public static final HDF5FloatStorageFeatures FLOAT_SCALING3_DEFLATE_DELETE = new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 6, 3);

    public static HDF5FloatStorageFeatureBuilder build() {
        return new HDF5FloatStorageFeatureBuilder();
    }

    public static HDF5FloatStorageFeatureBuilder build(HDF5AbstractStorageFeatures template) {
        return new HDF5FloatStorageFeatureBuilder(template);
    }

    public static HDF5FloatStorageFeatures createFromGeneric(HDF5GenericStorageFeatures storageFeatures) {
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CHUNKED) {
            return FLOAT_CHUNKED;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CHUNKED_DELETE) {
            return FLOAT_CHUNKED_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CHUNKED_KEEP) {
            return FLOAT_CHUNKED_KEEP;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_COMPACT) {
            return FLOAT_COMPACT;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_COMPACT_DELETE) {
            return FLOAT_COMPACT_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_COMPACT_KEEP) {
            return FLOAT_COMPACT_KEEP;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CONTIGUOUS) {
            return FLOAT_CONTIGUOUS;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CONTIGUOUS_DELETE) {
            return FLOAT_CONTIGUOUS_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CONTIGUOUS_KEEP) {
            return FLOAT_CONTIGUOUS_KEEP;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION) {
            return FLOAT_NO_COMPRESSION;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION_DELETE) {
            return FLOAT_NO_COMPRESSION_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION_KEEP) {
            return FLOAT_NO_COMPRESSION_KEEP;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE) {
            return FLOAT_DEFLATE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE_DELETE) {
            return FLOAT_DEFLATE_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE_KEEP) {
            return FLOAT_DEFLATE_KEEP;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE_MAX) {
            return FLOAT_DEFLATE_MAX;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE_MAX_DELETE) {
            return FLOAT_DEFLATE_MAX_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE_MAX_KEEP) {
            return FLOAT_DEFLATE_MAX_KEEP;
        }
        return new HDF5FloatStorageFeatures(storageFeatures.tryGetProposedLayout(), storageFeatures.getDatasetReplacementPolicy(), storageFeatures.getDeflateLevel(), -1);
    }

    public static HDF5FloatStorageFeatures createDeflation(int deflationLevel) {
        return HDF5FloatStorageFeatures.createDeflation(deflationLevel, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.USE_WRITER_DEFAULT);
    }

    public static HDF5FloatStorageFeatures createDeflationKeep(int deflationLevel) {
        return HDF5FloatStorageFeatures.createDeflation(deflationLevel, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING);
    }

    public static HDF5FloatStorageFeatures createDeflationDelete(int deflationLevel) {
        return HDF5FloatStorageFeatures.createDeflation(deflationLevel, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW);
    }

    private static HDF5FloatStorageFeatures createDeflation(int deflationLevel, HDF5AbstractStorageFeatures.DataSetReplacementPolicy dataSetReplacementPolicy) {
        return new HDF5FloatStorageFeatures(null, dataSetReplacementPolicy, HDF5FloatStorageFeatures.toByte(deflationLevel), -1);
    }

    public static HDF5FloatStorageFeatures createFloatScaling(int scalingFactor) {
        return new HDF5FloatStorageFeatures(null, 0, HDF5FloatStorageFeatures.toByte(scalingFactor));
    }

    public static HDF5FloatStorageFeatures createFloatScalingKeep(int scalingFactor) {
        return new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, HDF5FloatStorageFeatures.toByte(scalingFactor));
    }

    public static HDF5FloatStorageFeatures createDeflateAndFloatScaling(int scalingFactor) {
        return new HDF5FloatStorageFeatures(null, 6, HDF5FloatStorageFeatures.toByte(scalingFactor));
    }

    public static HDF5FloatStorageFeatures createDeflateAndFloatScalingKeep(int scalingFactor) {
        return new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 6, HDF5FloatStorageFeatures.toByte(scalingFactor));
    }

    public static HDF5FloatStorageFeatures createDeflateAndFloatScaling(int deflateLevel, int scalingFactor) {
        return new HDF5FloatStorageFeatures(null, HDF5FloatStorageFeatures.toByte(deflateLevel), HDF5FloatStorageFeatures.toByte(scalingFactor));
    }

    public static HDF5FloatStorageFeatures createDeflateAndFloatScalingKeep(int deflateLevel, int scalingFactor) {
        return new HDF5FloatStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, HDF5FloatStorageFeatures.toByte(deflateLevel), HDF5FloatStorageFeatures.toByte(scalingFactor));
    }

    HDF5FloatStorageFeatures(HDF5StorageLayout proposedLayoutOrNull, byte deflateLevel, byte scalingFactor) {
        this(proposedLayoutOrNull, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.USE_WRITER_DEFAULT, deflateLevel, scalingFactor);
    }

    HDF5FloatStorageFeatures(HDF5StorageLayout proposedLayoutOrNull, HDF5AbstractStorageFeatures.DataSetReplacementPolicy dataSetReplacementPolicy, byte deflateLevel, byte scalingFactor) {
        super(proposedLayoutOrNull, dataSetReplacementPolicy, deflateLevel, scalingFactor);
    }

    HDF5FloatStorageFeatures(HDF5FloatStorageFeatureBuilder builder) {
        super(builder.getStorageLayout(), builder.getDatasetReplacementPolicy(), builder.isShuffleBeforeDeflate(), builder.getDeflateLevel(), builder.getScalingFactor());
    }

    HDF5FloatStorageFeatures(HDF5StorageLayout proposedLayoutOrNull, HDF5AbstractStorageFeatures.DataSetReplacementPolicy dataSetReplacementPolicy, boolean shuffleBeforeDeflate, byte deflateLevel, byte scalingFactor) {
        super(proposedLayoutOrNull, dataSetReplacementPolicy, shuffleBeforeDeflate, deflateLevel, scalingFactor);
    }

    @Override
    boolean isCompatibleWithDataClass(int dataClassId) {
        return dataClassId == HDF5Constants.H5T_FLOAT;
    }

    public static final class HDF5FloatStorageFeatureBuilder
    extends HDF5AbstractStorageFeatures.HDF5AbstractStorageFeatureBuilder {
        public HDF5FloatStorageFeatureBuilder() {
        }

        public HDF5FloatStorageFeatureBuilder(HDF5AbstractStorageFeatures template) {
            super(template);
        }

        @Override
        public HDF5FloatStorageFeatureBuilder compress(boolean compress) {
            super.compress(compress);
            return this;
        }

        @Override
        public HDF5FloatStorageFeatureBuilder compress() {
            super.compress();
            return this;
        }

        @Override
        public HDF5FloatStorageFeatureBuilder deflateLevel(byte deflateLevel) {
            super.deflateLevel(deflateLevel);
            return this;
        }

        @Override
        public HDF5FloatStorageFeatureBuilder scalingFactor(byte scalingFactor) {
            super.scalingFactor(scalingFactor);
            return this;
        }

        @Override
        public HDF5FloatStorageFeatureBuilder noScaling() {
            super.noScaling();
            return this;
        }

        @Override
        public HDF5FloatStorageFeatureBuilder shuffleBeforeDeflate(boolean shuffleBeforeDeflate) {
            super.shuffleBeforeDeflate(shuffleBeforeDeflate);
            return this;
        }

        @Override
        public HDF5AbstractStorageFeatures.HDF5AbstractStorageFeatureBuilder shuffleBeforeDeflate() {
            super.shuffleBeforeDeflate();
            return this;
        }

        @Override
        public HDF5FloatStorageFeatureBuilder storageLayout(HDF5StorageLayout proposedLayout) {
            super.storageLayout(proposedLayout);
            return this;
        }

        @Override
        public HDF5AbstractStorageFeatures.HDF5AbstractStorageFeatureBuilder compactStorageLayout() {
            super.compactStorageLayout();
            return this;
        }

        @Override
        public HDF5AbstractStorageFeatures.HDF5AbstractStorageFeatureBuilder contiguousStorageLayout() {
            super.contiguousStorageLayout();
            return this;
        }

        @Override
        public HDF5AbstractStorageFeatures.HDF5AbstractStorageFeatureBuilder chunkedStorageLayout() {
            super.chunkedStorageLayout();
            return this;
        }

        @Override
        public HDF5AbstractStorageFeatures.HDF5AbstractStorageFeatureBuilder defaultStorageLayout() {
            this.defaultStorageLayout();
            return this;
        }

        @Override
        public HDF5FloatStorageFeatureBuilder datasetReplacementPolicy(HDF5AbstractStorageFeatures.DataSetReplacementPolicy datasetReplacementPolicy) {
            super.datasetReplacementPolicy(datasetReplacementPolicy);
            return this;
        }

        @Override
        public HDF5FloatStorageFeatureBuilder datasetReplacementUseWriterDefault() {
            super.datasetReplacementUseWriterDefault();
            return this;
        }

        @Override
        public HDF5FloatStorageFeatureBuilder datasetReplacementEnforceKeepExisting() {
            super.datasetReplacementEnforceKeepExisting();
            return this;
        }

        @Override
        public HDF5FloatStorageFeatureBuilder datasetReplacementEnforceReplaceWithNew() {
            super.datasetReplacementEnforceReplaceWithNew();
            return this;
        }

        @Override
        public HDF5FloatStorageFeatures features() {
            return new HDF5FloatStorageFeatures(this);
        }
    }
}

