/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.iptc;

import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.StringValue;
import com.drew.metadata.iptc.IptcDirectory;
import com.drew.metadata.iptc.Iso2022Converter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;

public class IptcReader
implements JpegSegmentMetadataReader {
    private static final byte IptcMarkerByte = 28;

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Collections.singletonList(JpegSegmentType.APPD);
    }

    @Override
    public void readJpegSegments(@NotNull Iterable<byte[]> segments, @NotNull Metadata metadata, @NotNull JpegSegmentType segmentType) {
        for (byte[] segmentBytes : segments) {
            if (segmentBytes.length == 0 || segmentBytes[0] != 28) continue;
            this.extract(new SequentialByteArrayReader(segmentBytes), metadata, segmentBytes.length);
        }
    }

    public void extract(@NotNull SequentialReader reader, @NotNull Metadata metadata, long length) {
        this.extract(reader, metadata, length, null);
    }

    public void extract(@NotNull SequentialReader reader, @NotNull Metadata metadata, long length, @Nullable Directory parentDirectory) {
        IptcDirectory directory = new IptcDirectory();
        metadata.addDirectory(directory);
        if (parentDirectory != null) {
            directory.setParent(parentDirectory);
        }
        int offset = 0;
        while ((long)offset < length) {
            int tagByteCount;
            short tagType;
            short directoryType;
            short startByte;
            try {
                startByte = reader.getUInt8();
                ++offset;
            }
            catch (IOException e) {
                directory.addError("Unable to read starting byte of IPTC tag");
                return;
            }
            if (startByte != 28) {
                if ((long)offset != length) {
                    directory.addError("Invalid IPTC tag marker at offset " + (offset - 1) + ". Expected '0x" + Integer.toHexString(28) + "' but got '0x" + Integer.toHexString(startByte) + "'.");
                }
                return;
            }
            if ((long)(offset + 4) > length) {
                directory.addError("Too few bytes remain for a valid IPTC tag");
                return;
            }
            try {
                directoryType = reader.getUInt8();
                tagType = reader.getUInt8();
                tagByteCount = reader.getUInt16();
                if (tagByteCount > Short.MAX_VALUE) {
                    tagByteCount = (tagByteCount & Short.MAX_VALUE) << 16 | reader.getUInt16();
                    offset += 2;
                }
            }
            catch (IOException e) {
                directory.addError("IPTC data segment ended mid-way through tag descriptor");
                return;
            }
            if ((long)((offset += 4) + tagByteCount) > length) {
                directory.addError("Data for tag extends beyond end of IPTC segment");
                return;
            }
            try {
                this.processTag(reader, directory, directoryType, tagType, tagByteCount);
            }
            catch (IOException e) {
                directory.addError("Error processing IPTC tag");
                return;
            }
            offset += tagByteCount;
        }
    }

    private void processTag(@NotNull SequentialReader reader, @NotNull Directory directory, int directoryType, int tagType, int tagByteCount) throws IOException {
        StringValue string;
        int tagIdentifier = tagType | directoryType << 8;
        if (tagByteCount == 0) {
            directory.setString(tagIdentifier, "");
            return;
        }
        switch (tagIdentifier) {
            case 346: {
                byte[] bytes = reader.getBytes(tagByteCount);
                String charsetName = Iso2022Converter.convertISO2022CharsetToJavaCharset(bytes);
                if (charsetName == null) {
                    charsetName = new String(bytes);
                }
                directory.setString(tagIdentifier, charsetName);
                return;
            }
            case 256: 
            case 278: 
            case 378: 
            case 512: 
            case 582: {
                if (tagByteCount < 2) break;
                int shortValue = reader.getUInt16();
                reader.skip(tagByteCount - 2);
                directory.setInt(tagIdentifier, shortValue);
                return;
            }
            case 522: {
                directory.setInt(tagIdentifier, reader.getUInt8());
                reader.skip(tagByteCount - 1);
                return;
            }
        }
        String charSetName = directory.getString(346);
        Charset charset = null;
        try {
            if (charSetName != null) {
                charset = Charset.forName(charSetName);
            }
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        if (charSetName != null) {
            string = reader.getStringValue(tagByteCount, charset);
        } else {
            byte[] bytes = reader.getBytes(tagByteCount);
            Charset charSet = Iso2022Converter.guessCharSet(bytes);
            StringValue stringValue = string = charSet != null ? new StringValue(bytes, charSet) : new StringValue(bytes, null);
        }
        if (directory.containsTag(tagIdentifier)) {
            StringValue[] newStrings;
            StringValue[] oldStrings = directory.getStringValueArray(tagIdentifier);
            if (oldStrings == null) {
                newStrings = new StringValue[1];
            } else {
                newStrings = new StringValue[oldStrings.length + 1];
                System.arraycopy(oldStrings, 0, newStrings, 0, oldStrings.length);
            }
            newStrings[newStrings.length - 1] = string;
            directory.setStringValueArray(tagIdentifier, newStrings);
        } else {
            directory.setStringValue(tagIdentifier, string);
        }
    }
}

