/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.xml;

import com.google.api.client.util.Beta;
import com.google.api.client.util.ObjectParser;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.Types;
import com.google.api.client.xml.Xml;
import com.google.api.client.xml.XmlNamespaceDictionary;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class XmlObjectParser
implements ObjectParser {
    private final XmlNamespaceDictionary namespaceDictionary;

    public XmlObjectParser(XmlNamespaceDictionary namespaceDictionary) {
        this.namespaceDictionary = Preconditions.checkNotNull(namespaceDictionary);
    }

    public final XmlNamespaceDictionary getNamespaceDictionary() {
        return this.namespaceDictionary;
    }

    private Object readObject(XmlPullParser parser, Type dataType) throws XmlPullParserException, IOException {
        Preconditions.checkArgument(dataType instanceof Class, "dataType has to be of Class<?>");
        Object result = Types.newInstance((Class)dataType);
        Xml.parseElement(parser, result, this.namespaceDictionary, null);
        return result;
    }

    @Override
    public <T> T parseAndClose(InputStream in, Charset charset, Class<T> dataClass) throws IOException {
        return (T)this.parseAndClose(in, charset, (Type)dataClass);
    }

    @Override
    public Object parseAndClose(InputStream in, Charset charset, Type dataType) throws IOException {
        try {
            XmlPullParser parser = Xml.createParser();
            parser.setInput(in, charset.name());
            Object object = this.readObject(parser, dataType);
            return object;
        }
        catch (XmlPullParserException e) {
            IOException exception = new IOException();
            exception.initCause(e);
            throw exception;
        }
        finally {
            in.close();
        }
    }

    @Override
    public <T> T parseAndClose(Reader reader, Class<T> dataClass) throws IOException {
        return (T)this.parseAndClose(reader, (Type)dataClass);
    }

    @Override
    public Object parseAndClose(Reader reader, Type dataType) throws IOException {
        try {
            XmlPullParser parser = Xml.createParser();
            parser.setInput(reader);
            Object object = this.readObject(parser, dataType);
            return object;
        }
        catch (XmlPullParserException e) {
            IOException exception = new IOException();
            exception.initCause(e);
            throw exception;
        }
        finally {
            reader.close();
        }
    }
}

