/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import loci.common.IniTable;

public class IniList
extends ArrayList<IniTable> {
    public List<String> getHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        for (IniTable table : this) {
            String header = (String)table.get("header");
            headers.add(header);
        }
        return headers;
    }

    public IniTable getTable(String tableName) {
        for (IniTable table : this) {
            String header = (String)table.get("header");
            if (!tableName.equals(header)) continue;
            return table;
        }
        return null;
    }

    public HashMap<String, String> flattenIntoHashMap() {
        HashMap<String, String> h2 = new HashMap<String, String>();
        for (IniTable table : this) {
            String tableName = (String)table.get("header");
            for (String key : table.keySet()) {
                if (key.equals("header")) continue;
                h2.put("[" + tableName + "] " + key, (String)table.get(key));
            }
        }
        return h2;
    }
}

