/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffIFDEntry;
import loci.formats.tiff.TiffParser;
import org.apache.commons.io.FilenameUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class IonpathMIBITiffReader
extends BaseTiffReader {
    public static final String IONPATH_MIBI_SOFTWARE_PREFIX = "IonpathMIBI";
    private HashMap<String, Integer> seriesTypes = new HashMap();
    private List<Integer> seriesIFDs = new ArrayList<Integer>();
    private List<String> channelIDs = new ArrayList<String>();
    private List<String> channelNames = new ArrayList<String>();
    private Hashtable<String, Object> simsDescription = new Hashtable();

    public IonpathMIBITiffReader() {
        super("Ionpath MIBI", new String[]{"tif, tiff"});
        this.domains = new String[]{"Unknown"};
        this.suffixSufficient = false;
        this.canSeparateSeries = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tiffParser = new TiffParser(stream);
        IFD ifd = tiffParser.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        String software = ifd.getIFDTextValue(305);
        if (software == null) {
            return false;
        }
        return software.startsWith(IONPATH_MIBI_SOFTWARE_PREFIX);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        if (this.tiffParser == null) {
            this.initTiffParser();
        }
        this.tiffParser.getSamples((IFD)this.ifds.get(this.seriesIFDs.get(this.getSeries()) + no), buf, x, y, w, h2);
        return buf;
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        this.ifds = this.tiffParser.getMainIFDs();
        String imageType = null;
        this.core.clear();
        for (int i = 0; i < this.ifds.size(); ++i) {
            CoreMetadata ms;
            int seriesIndex;
            JSONObject jsonDescription;
            IFD ifd = (IFD)this.ifds.get(i);
            Object description = ifd.get(270);
            if (description == null) {
                throw new FormatException("Image description is mandatory.");
            }
            String imageDescription = null;
            if (description instanceof TiffIFDEntry) {
                Object value = this.tiffParser.getIFDValue((TiffIFDEntry)description);
                if (value != null) {
                    imageDescription = value.toString();
                }
            } else if (description instanceof String) {
                imageDescription = (String)description;
            }
            try {
                jsonDescription = new JSONObject(imageDescription);
                imageType = jsonDescription.getString("image.type");
                if (imageType.equals("SIMS")) {
                    String mass = jsonDescription.getString("channel.mass");
                    if (mass == null) {
                        throw new FormatException("Channel masses are mandatory.");
                    }
                    String target = jsonDescription.getString("channel.target");
                    this.channelIDs.add(mass);
                    this.channelNames.add(target != null && target != "null" ? target : mass);
                }
            }
            catch (JSONException e) {
                throw new FormatException("Unexpected format in SIMS description JSON.");
            }
            if (this.seriesTypes.containsKey(imageType)) {
                if (!imageType.equals("SIMS")) {
                    throw new FormatException("Only type 'SIMS' can have >1 image per file.");
                }
                seriesIndex = this.seriesTypes.get(imageType);
                ms = (CoreMetadata)this.core.get(seriesIndex, 0);
                ++ms.sizeC;
                ++ms.imageCount;
                continue;
            }
            seriesIndex = this.seriesTypes.size();
            this.seriesTypes.put(imageType, seriesIndex);
            this.seriesIFDs.add(i);
            this.core.add(new CoreMetadata());
            this.setSeries(seriesIndex);
            this.tiffParser.setDoCaching(true);
            this.tiffParser.fillInIFD(ifd);
            if (imageType.equals("SIMS")) {
                try {
                    Iterator keySet = jsonDescription.keys();
                    while (keySet.hasNext()) {
                        String key = (String)keySet.next();
                        if (!key.startsWith("mibi.")) continue;
                        this.simsDescription.put(key, jsonDescription.getString(key));
                    }
                }
                catch (JSONException e) {
                    throw new FormatException("Unexpected format in SIMS description JSON.");
                }
            }
            ms = (CoreMetadata)this.core.get(seriesIndex, 0);
            PhotoInterp p = ifd.getPhotometricInterpretation();
            int samples = ifd.getSamplesPerPixel();
            ms.rgb = samples > 1 || p == PhotoInterp.RGB;
            ms.sizeX = (int)ifd.getImageWidth();
            ms.sizeY = (int)ifd.getImageLength();
            ms.sizeZ = 1;
            ms.sizeT = 1;
            ms.sizeC = ms.rgb ? samples : 1;
            ms.littleEndian = ifd.isLittleEndian();
            ms.indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
            ms.imageCount = 1;
            ms.pixelType = ifd.getPixelType();
            ms.metadataComplete = true;
            ms.interleaved = false;
            ms.falseColor = false;
            ms.dimensionOrder = "XYCZT";
            ms.thumbnail = false;
            ms.imageCount = 1;
            if (!imageType.equals("SIMS")) continue;
            ms.seriesMetadata = this.simsDescription;
        }
    }

    @Override
    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        int simsIndex = this.seriesTypes.get("SIMS");
        String instrument = (String)this.simsDescription.get("mibi.instrument");
        store.setInstrumentID(IonpathMIBITiffReader.formatMetadata("Instrument", instrument), simsIndex);
        store.setImageDescription((String)this.simsDescription.get("mibi.description"), simsIndex);
        String currentFile = FilenameUtils.getName(this.getCurrentFile());
        for (Map.Entry<String, Integer> entry : this.seriesTypes.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            store.setImageID(IonpathMIBITiffReader.formatMetadata("Image", entry.getKey()), entry.getValue());
            store.setImageName(currentFile + " " + entry.getKey(), entry.getValue());
        }
        for (int j = 0; j < this.channelIDs.size(); ++j) {
            store.setChannelID(IonpathMIBITiffReader.formatMetadata("Channel", this.channelIDs.get(j)), simsIndex, j);
            if (this.channelNames.get(j) == null) continue;
            store.setChannelName(IonpathMIBITiffReader.formatMetadata("Target", this.channelNames.get(j)), simsIndex, j);
        }
    }

    private static String formatMetadata(String key, String value) {
        return key + ":" + value.replaceAll("\\s", "_");
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.seriesTypes.clear();
            this.seriesIFDs.clear();
            this.channelIDs.clear();
            this.channelNames.clear();
            this.simsDescription.clear();
        }
    }
}

