/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.util.Vector;
import loci.common.Location;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.gui.AWTImageTools;
import loci.formats.gui.LegacyQTTools;
import loci.formats.in.BIFormatReader;
import loci.formats.meta.MetadataStore;

public class LegacyQTReader
extends BIFormatReader {
    protected LegacyQTTools tools;
    protected ReflectedUniverse r;
    protected int[] times;
    protected Image image;

    public LegacyQTReader() {
        super("QuickTime", "mov");
        this.domains = new String[]{"Graphics"};
    }

    @Override
    public Object openPlane(int no, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, -1, x, y, w, h2);
        try {
            this.r.setVar("time", this.times[no]);
            this.r.exec("moviePlayer.setTime(time)");
            this.r.exec("qtip.redraw(null)");
            this.r.exec("qtip.updateConsumers(null)");
        }
        catch (ReflectException re) {
            throw new FormatException("Open movie failed", re);
        }
        return AWTImageTools.getSubimage(AWTImageTools.makeBuffered(this.image), this.isLittleEndian(), x, y, w, h2);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        try {
            if (this.r != null && this.r.getVar("openMovieFile") != null) {
                this.r.exec("openMovieFile.close()");
                if (!fileOnly) {
                    this.r.exec("m.disposeQTObject()");
                    this.r.exec("imageTrack.disposeQTObject()");
                    this.r.exec("QTSession.close()");
                }
            }
        }
        catch (ReflectException e) {
            LOGGER.debug("Failed to close QuickTime session", e);
        }
        if (!fileOnly) {
            this.currentId = null;
            this.times = null;
            this.image = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        LOGGER.info("Checking for QuickTime Java");
        if (this.tools == null) {
            this.tools = new LegacyQTTools();
            this.r = this.tools.getUniverse();
        }
        this.tools.checkQTLibrary();
        super.initFile(id);
        LOGGER.info("Reading movie dimensions");
        try {
            Integer w;
            this.r.exec("QTSession.open()");
            Location file2 = new Location(id);
            this.r.setVar("path", file2.getAbsolutePath());
            this.r.exec("qtf = new QTFile(path)");
            this.r.exec("openMovieFile = OpenMovieFile.asRead(qtf)");
            this.r.exec("m = Movie.fromFile(openMovieFile)");
            int numTracks = (Integer)this.r.exec("m.getTrackCount()");
            int trackMostLikely = 0;
            int trackNum = 0;
            while (++trackNum <= numTracks && trackMostLikely == 0) {
                this.r.setVar("trackNum", trackNum);
                this.r.exec("imageTrack = m.getTrack(trackNum)");
                this.r.exec("d = imageTrack.getSize()");
                w = (Integer)this.r.exec("d.getWidth()");
                if (w <= 0) continue;
                trackMostLikely = trackNum;
            }
            this.r.setVar("trackMostLikely", trackMostLikely);
            this.r.exec("imageTrack = m.getTrack(trackMostLikely)");
            this.r.exec("d = imageTrack.getSize()");
            w = (Integer)this.r.exec("d.getWidth()");
            Integer h2 = (Integer)this.r.exec("d.getHeight()");
            this.r.exec("moviePlayer = new MoviePlayer(m)");
            this.r.setVar("dim", new Dimension(w, h2));
            ImageProducer qtip = (ImageProducer)this.r.exec("qtip = new QTImageProducer(moviePlayer, dim)");
            this.image = Toolkit.getDefaultToolkit().createImage(qtip);
            this.r.setVar("zero", 0);
            this.r.setVar("one", 1.0f);
            this.r.exec("timeInfo = new TimeInfo(zero, zero)");
            this.r.exec("moviePlayer.setTime(zero)");
            Vector<Integer> v = new Vector<Integer>();
            int time = 0;
            Integer q = new Integer(time);
            do {
                v.add(q);
                this.r.exec("timeInfo = imageTrack.getNextInterestingTime(StdQTConstants.nextTimeMediaSample, timeInfo.time, one)");
            } while ((time = (q = (Integer)this.r.getVar("timeInfo.time")).intValue()) >= 0);
            CoreMetadata m3 = (CoreMetadata)this.core.get(0);
            m3.imageCount = v.size();
            this.times = new int[this.getImageCount()];
            for (int i = 0; i < this.times.length; ++i) {
                q = (Integer)v.elementAt(i);
                this.times[i] = q;
            }
            LOGGER.info("Populating metadata");
            BufferedImage img = AWTImageTools.makeBuffered(this.image);
            m3.sizeX = img.getWidth();
            m3.sizeY = img.getHeight();
            m3.sizeZ = 1;
            m3.sizeC = img.getRaster().getNumBands();
            m3.sizeT = this.getImageCount();
            m3.pixelType = AWTImageTools.getPixelType(img);
            m3.dimensionOrder = "XYCTZ";
            m3.rgb = true;
            m3.interleaved = false;
            m3.littleEndian = false;
            m3.indexed = false;
            m3.falseColor = false;
            MetadataStore store = this.makeFilterMetadata();
            MetadataTools.populatePixels(store, this);
        }
        catch (ReflectException e) {
            throw new FormatException("Open movie failed", e);
        }
    }
}

