/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;

public class OxfordInstrumentsReader
extends FormatReader {
    public static final String OXFORD_MAGIC_STRING = "Oxford Instruments";
    private long headerSize = 0L;

    public OxfordInstrumentsReader() {
        super(OXFORD_MAGIC_STRING, "top");
        this.suffixNecessary = false;
        this.domains = new String[]{"Scanning Probe Microscopy (SPM)"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = OXFORD_MAGIC_STRING.length();
        if (!FormatTools.validStream(stream, blockLen, false)) {
            return false;
        }
        return stream.readString(blockLen).equals(OXFORD_MAGIC_STRING);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        this.in.seek(this.headerSize);
        this.readPlane(this.in, x, y, w, h2, buf);
        return buf;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        m3.littleEndian = true;
        this.in.order(this.isLittleEndian());
        this.in.seek(48L);
        String comment = this.in.readString(32);
        String dateTime = this.readDate();
        this.in.skipBytes(8);
        double xSize = -this.in.readFloat() + this.in.readFloat();
        this.in.skipBytes(20);
        double ySize = -this.in.readFloat() + this.in.readFloat();
        this.in.skipBytes(24);
        double zMin = this.in.readFloat();
        double zMax = this.in.readFloat();
        this.in.skipBytes(864);
        m3.sizeX = this.in.readInt();
        m3.sizeY = this.in.readInt();
        this.in.skipBytes(28);
        if (this.getSizeX() == 0 && this.getSizeY() == 0) {
            m3.sizeX = this.in.readInt();
            m3.sizeY = this.in.readInt();
            this.in.skipBytes(196);
        } else {
            this.in.skipBytes(204);
        }
        m3.pixelType = 3;
        m3.sizeZ = 1;
        m3.sizeC = 1;
        m3.sizeT = 1;
        m3.imageCount = 1;
        m3.rgb = false;
        m3.indexed = false;
        m3.dimensionOrder = "XYZCT";
        m3.interleaved = false;
        if ((long)FormatTools.getPlaneSize(this) + this.in.getFilePointer() > this.in.length()) {
            m3.sizeY = 1;
        }
        int lutSize = this.in.readInt();
        this.in.skipBytes(lutSize);
        this.headerSize = this.in.getFilePointer();
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.in.skipBytes(FormatTools.getPlaneSize(this));
            int nMetadataStrings = this.in.readInt();
            for (int i = 0; i < nMetadataStrings; ++i) {
                int length = this.in.readInt();
                String s2 = this.in.readString(length);
                if (s2.indexOf(58) == -1) continue;
                String key = s2.substring(0, s2.indexOf(58)).trim();
                String value = s2.substring(s2.indexOf(58) + 1).trim();
                if (value.equals("-")) continue;
                this.addGlobalMeta(key, value);
            }
            this.addGlobalMeta("Description", comment);
            this.addGlobalMeta("Acquisition date", dateTime);
            this.addGlobalMeta("X size (um)", xSize);
            this.addGlobalMeta("Y size (um)", ySize);
            this.addGlobalMeta("Z minimum (um)", zMin);
            this.addGlobalMeta("Z maximum (um)", zMax);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        store.setImageDescription(comment, 0);
        if (dateTime != null) {
            store.setImageAcquisitionDate(new Timestamp(dateTime), 0);
        }
        double physicalSizeX = xSize / (double)this.getSizeX();
        double physicalSizeY = ySize / (double)this.getSizeY();
        Length sizeX = FormatTools.getPhysicalSizeX(physicalSizeX);
        Length sizeY = FormatTools.getPhysicalSizeY(physicalSizeY);
        if (sizeX != null) {
            store.setPixelsPhysicalSizeX(sizeX, 0);
        }
        if (sizeY != null) {
            store.setPixelsPhysicalSizeY(sizeY, 0);
        }
    }

    private String readDate() throws IOException {
        StringBuilder dateTime = new StringBuilder();
        dateTime.append(String.valueOf(this.in.readInt()));
        dateTime.append("-");
        int month = this.in.readInt();
        dateTime.append(String.format("%02d", month));
        dateTime.append("-");
        int day = this.in.readInt();
        dateTime.append(String.format("%02d", day));
        dateTime.append("T");
        int hour = this.in.readInt();
        dateTime.append(String.format("%02d", hour));
        dateTime.append(":");
        int minute = this.in.readInt();
        dateTime.append(String.format("%02d", minute));
        dateTime.append(":");
        this.in.skipBytes(4);
        float scanTime = (float)this.in.readInt() / 100.0f;
        dateTime.append(String.format("%02d", (int)scanTime));
        this.addGlobalMeta("Scan time (s)", scanTime);
        return dateTime.toString();
    }
}

