/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class SMCameraReader
extends FormatReader {
    private static final byte[] SMC_MAGIC = new byte[]{0, 0, 0, 0, 2, 0, 0, 5, -55, -120, 0, 5, -53, -120, 0, 0};
    private static final int HEADER_SIZE = 548;

    public SMCameraReader() {
        super("SM Camera", "");
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
        this.suffixSufficient = false;
        this.suffixNecessary = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 16;
        if (!FormatTools.validStream(stream, 16, false)) {
            return false;
        }
        byte[] magic = new byte[16];
        stream.read(magic);
        for (int i = 0; i < magic.length; ++i) {
            if (magic[i] == SMC_MAGIC[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        this.in.seek(548L);
        this.readPlane(this.in, x, y, w, h2, buf);
        return buf;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        this.in.seek(524L);
        m3.sizeY = this.in.readShort();
        this.in.skipBytes(6);
        m3.sizeX = this.in.readShort();
        m3.pixelType = 1;
        m3.sizeZ = 1;
        m3.sizeC = 1;
        m3.sizeT = 1;
        m3.imageCount = 1;
        m3.dimensionOrder = "XYZCT";
        m3.littleEndian = false;
        this.addGlobalMeta("Image width", this.getSizeX());
        this.addGlobalMeta("Image height", this.getSizeY());
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

