/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.common.DataTools;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.FormatException;
import loci.formats.FormatWriter;
import loci.formats.gui.AWTImageTools;
import loci.formats.gui.LegacyQTTools;
import loci.formats.meta.MetadataRetrieve;

public class LegacyQTWriter
extends FormatWriter {
    private static final int TIME_SCALE = 600;
    protected LegacyQTTools tools;
    protected ReflectedUniverse r;
    protected int codec = 0;
    protected int quality = 512;
    private int numWritten = 0;
    private int width;
    private int height;
    private int[] pixels2 = null;

    public LegacyQTWriter() {
        super("Legacy QuickTime", "mov");
    }

    public void setCodec(int codec) {
        this.codec = codec;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    @Override
    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        this.checkParams(no, buf, x, y, w, h2);
        MetadataRetrieve meta = this.getMetadataRetrieve();
        BufferedImage image = AWTImageTools.makeImage(buf, this.interleaved, meta, this.series);
        this.savePlane(no, image, x, y, w, h2);
    }

    @Override
    public void savePlane(int no, Object plane, int x, int y, int w, int h2) throws FormatException, IOException {
        if (!(plane instanceof Image)) {
            throw new IllegalArgumentException("Object to save must be a java.awt.Image");
        }
        if (this.tools == null || this.r == null) {
            this.tools = new LegacyQTTools();
            this.r = this.tools.getUniverse();
        }
        this.tools.checkQTLibrary();
        BufferedImage img = AWTImageTools.makeBuffered((Image)plane);
        if (!this.initialized[this.series][no]) {
            this.initialized[this.series][no] = true;
            try {
                this.r.exec("QTSession.open()");
                this.width = img.getWidth();
                this.height = img.getHeight();
                this.r.setVar("path", this.currentId);
                this.r.setVar("width", (float)this.width);
                this.r.setVar("height", (float)this.height);
                this.r.exec("movFile = new QTFile(path)");
                this.r.exec("kMoviePlayer = StdQTConstants.kMoviePlayer");
                int resFlag = (Integer)this.r.exec("StdQTConstants.createMovieFileDontCreateResFile");
                this.r.setVar("flags", resFlag);
                this.r.exec("movie = Movie.createMovieFile(movFile, kMoviePlayer, flags)");
                this.r.setVar("timeScale", 600);
                this.r.setVar("zero", 0);
                this.r.setVar("zeroFloat", 0.0f);
                this.r.exec("videoTrack = movie.addTrack(width, height, zeroFloat)");
                this.r.exec("videoMedia = new VideoMedia(videoTrack, timeScale)");
                this.r.exec("videoMedia.beginEdits()");
                this.r.setVar("width", this.width);
                this.r.setVar("height", this.height);
                this.r.exec("bounds = new QDRect(zero, zero, width, height)");
                this.r.exec("gw = new QDGraphics(bounds)");
                this.r.exec("pixMap = gw.getPixMap()");
                this.r.exec("pixSize = pixMap.getPixelSize()");
                this.r.setVar("codec", this.codec);
                this.r.setVar("quality", this.quality);
                int rawImageSize = this.width * this.height * 4;
                this.r.setVar("rawImageSize", rawImageSize);
                this.r.setVar("boolTrue", true);
                this.r.exec("imageHandle = new QTHandle(rawImageSize, boolTrue)");
                this.r.exec("imageHandle.lock()");
                this.r.exec("compressedImage = RawEncodedImage.fromQTHandle(imageHandle)");
                this.r.setVar("rate", 30);
                this.r.exec("seq = new CSequence(gw, bounds, pixSize, codec, CodecComponent.bestFidelityCodec, quality, quality, rate, null, zero)");
                this.r.exec("imgDesc = seq.getDescription()");
            }
            catch (ReflectException e) {
                LOGGER.debug("", e);
                throw new FormatException("Legacy QuickTime writer failed", e);
            }
        }
        ++this.numWritten;
        try {
            this.r.exec("pixelData = pixMap.getPixelData()");
            this.r.exec("intsPerRow = pixelData.getRowBytes()");
            int intsPerRow = (Integer)this.r.getVar("intsPerRow") / 4;
            byte[][] px = AWTImageTools.getBytes(img);
            int[] pixels = new int[px[0].length];
            for (int i = 0; i < pixels.length; ++i) {
                int j;
                byte[] b = new byte[4];
                for (j = 0; j < px.length; ++j) {
                    b[j] = px[j][i];
                }
                for (j = px.length; j < 4; ++j) {
                    b[j] = px[j % px.length][i];
                }
                pixels[i] = DataTools.bytesToInt(b, true);
            }
            if (this.pixels2 == null) {
                this.pixels2 = new int[intsPerRow * this.height];
            }
            this.r.exec("nativeLittle = EndianOrder.isNativeLittleEndian()");
            boolean nativeLittle = (Boolean)this.r.getVar("nativeLittle");
            if (nativeLittle) {
                for (int row = 0; row < this.height; ++row) {
                    int offset1 = row * this.width;
                    int offset2 = row * intsPerRow;
                    for (int col = 0; col < this.width; ++col) {
                        this.r.setVar("thisByte", pixels[offset1++]);
                        this.r.exec("b = EndianOrder.flipBigEndianToNative32(thisByte)");
                        this.pixels2[offset2++] = (Integer)this.r.getVar("b");
                    }
                }
            } else {
                for (int i = 0; i < this.height; ++i) {
                    System.arraycopy(pixels, i * this.width, this.pixels2, i * intsPerRow, this.width);
                }
            }
            this.r.setVar("pixels2", this.pixels2);
            this.r.setVar("len", intsPerRow * this.height);
            this.r.exec("pixelData.copyFromArray(zero, pixels2, zero, len)");
            this.r.exec("flags = StdQTConstants.codecFlagUpdatePrevious");
            this.r.exec("cfInfo = seq.compressFrame(gw, bounds, flags, compressedImage)");
            this.r.exec("similarity = cfInfo.getSimilarity()");
            int sim = (Integer)this.r.getVar("similarity");
            boolean sync = sim == 0;
            this.r.exec("dataSize = cfInfo.getDataSize()");
            this.r.setVar("fps", this.fps);
            this.r.setVar("frameRate", 600);
            this.r.setVar("rate", 600 / this.fps);
            if (sync) {
                this.r.setVar("sync", 0);
            } else {
                this.r.exec("sync = StdQTConstants.mediaSampleNotSync");
            }
            this.r.setVar("one", 1);
            this.r.exec("videoMedia.addSample(imageHandle, zero, dataSize, rate, imgDesc, one, sync)");
        }
        catch (ReflectException e) {
            LOGGER.debug("", e);
            throw new FormatException("Legacy QuickTime writer failed", e);
        }
        if (no == this.getPlaneCount() - 1) {
            try {
                this.r.exec("videoMedia.endEdits()");
                this.r.exec("duration = videoMedia.getDuration()");
                this.r.setVar("floatOne", 1.0f);
                this.r.exec("videoTrack.insertMedia(zero, zero, duration, floatOne)");
                this.r.exec("omf = OpenMovieFile.asWrite(movFile)");
                this.r.exec("name = movFile.getName()");
                this.r.exec("flags = StdQTConstants.movieInDataForkResID");
                this.r.exec("movie.addResource(omf, flags, name)");
                this.r.exec("QTSession.close()");
            }
            catch (ReflectException e) {
                LOGGER.debug("", e);
                throw new FormatException("Legacy QuickTime writer failed", e);
            }
            this.close();
        }
    }

    @Override
    public boolean canDoStacks() {
        return true;
    }

    @Override
    public Class<?> getNativeDataType() {
        return Image.class;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.r = null;
        this.numWritten = 0;
        this.width = 0;
        this.height = 0;
        this.pixels2 = null;
    }
}

