/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.model;

import loci.poi.ddf.EscherClientDataRecord;
import loci.poi.ddf.EscherContainerRecord;
import loci.poi.ddf.EscherOptRecord;
import loci.poi.ddf.EscherRecord;
import loci.poi.ddf.EscherSpRecord;
import loci.poi.hssf.model.AbstractShape;
import loci.poi.hssf.record.CommonObjectDataSubRecord;
import loci.poi.hssf.record.EndSubRecord;
import loci.poi.hssf.record.ObjRecord;
import loci.poi.hssf.usermodel.HSSFShape;
import loci.poi.hssf.usermodel.HSSFSimpleShape;

public class SimpleFilledShape
extends AbstractShape {
    private EscherContainerRecord spContainer;
    private ObjRecord objRecord;

    SimpleFilledShape(HSSFSimpleShape hssfShape, int shapeId) {
        this.spContainer = this.createSpContainer(hssfShape, shapeId);
        this.objRecord = this.createObjRecord(hssfShape, shapeId);
    }

    private EscherContainerRecord createSpContainer(HSSFSimpleShape hssfShape, int shapeId) {
        HSSFSimpleShape shape = hssfShape;
        EscherContainerRecord spContainer = new EscherContainerRecord();
        EscherSpRecord sp = new EscherSpRecord();
        EscherOptRecord opt = new EscherOptRecord();
        EscherClientDataRecord clientData = new EscherClientDataRecord();
        spContainer.setRecordId((short)-4092);
        spContainer.setOptions((short)15);
        sp.setRecordId((short)-4086);
        short shapeType = this.objTypeToShapeType(hssfShape.getShapeType());
        sp.setOptions((short)(shapeType << 4 | 2));
        sp.setShapeId(shapeId);
        sp.setFlags(2560);
        opt.setRecordId((short)-4085);
        this.addStandardOptions(shape, opt);
        EscherRecord anchor = this.createAnchor(shape.getAnchor());
        clientData.setRecordId((short)-4079);
        clientData.setOptions((short)0);
        spContainer.addChildRecord(sp);
        spContainer.addChildRecord(opt);
        spContainer.addChildRecord(anchor);
        spContainer.addChildRecord(clientData);
        return spContainer;
    }

    private short objTypeToShapeType(int objType) {
        short shapeType;
        if (objType == 3) {
            shapeType = 3;
        } else if (objType == 2) {
            shapeType = 1;
        } else {
            throw new IllegalArgumentException("Unable to handle an object of this type");
        }
        return shapeType;
    }

    private ObjRecord createObjRecord(HSSFShape hssfShape, int shapeId) {
        HSSFShape shape = hssfShape;
        ObjRecord obj = new ObjRecord();
        CommonObjectDataSubRecord c = new CommonObjectDataSubRecord();
        c.setObjectType((short)((HSSFSimpleShape)shape).getShapeType());
        c.setObjectId((short)shapeId);
        c.setLocked(true);
        c.setPrintable(true);
        c.setAutofill(true);
        c.setAutoline(true);
        EndSubRecord e = new EndSubRecord();
        obj.addSubRecord(c);
        obj.addSubRecord(e);
        return obj;
    }

    @Override
    public EscherContainerRecord getSpContainer() {
        return this.spContainer;
    }

    @Override
    public ObjRecord getObjRecord() {
        return this.objRecord;
    }
}

