/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.CellValueRecordInterface;
import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;

public class NumberRecord
extends Record
implements CellValueRecordInterface,
Comparable {
    public static final short sid = 515;
    private int field_1_row;
    private short field_2_col;
    private short field_3_xf;
    private double field_4_value;

    public NumberRecord() {
    }

    public NumberRecord(RecordInputStream in) {
        super(in);
    }

    @Override
    protected void fillFields(RecordInputStream in) {
        this.field_1_row = in.readUShort();
        this.field_2_col = in.readShort();
        this.field_3_xf = in.readShort();
        this.field_4_value = in.readDouble();
    }

    @Override
    public void setRow(int row) {
        this.field_1_row = row;
    }

    @Override
    public void setColumn(short col) {
        this.field_2_col = col;
    }

    @Override
    public void setXFIndex(short xf) {
        this.field_3_xf = xf;
    }

    public void setValue(double value) {
        this.field_4_value = value;
    }

    @Override
    public int getRow() {
        return this.field_1_row;
    }

    @Override
    public short getColumn() {
        return this.field_2_col;
    }

    @Override
    public short getXFIndex() {
        return this.field_3_xf;
    }

    public double getValue() {
        return this.field_4_value;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[NUMBER]\n");
        buffer.append("    .row            = ").append(Integer.toHexString(this.getRow())).append("\n");
        buffer.append("    .col            = ").append(Integer.toHexString(this.getColumn())).append("\n");
        buffer.append("    .xfindex        = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        buffer.append("    .value          = ").append(this.getValue()).append("\n");
        buffer.append("[/NUMBER]\n");
        return buffer.toString();
    }

    @Override
    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)515);
        LittleEndian.putShort(data, 2 + offset, (short)14);
        LittleEndian.putShort(data, 4 + offset, (short)this.getRow());
        LittleEndian.putShort(data, 6 + offset, this.getColumn());
        LittleEndian.putShort(data, 8 + offset, this.getXFIndex());
        LittleEndian.putDouble(data, 10 + offset, this.getValue());
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        return 18;
    }

    @Override
    protected void validateSid(short id) {
        if (id != 515) {
            throw new RecordFormatException("NOT A Number RECORD");
        }
    }

    @Override
    public short getSid() {
        return 515;
    }

    @Override
    public boolean isBefore(CellValueRecordInterface i) {
        if (this.getRow() > i.getRow()) {
            return false;
        }
        if (this.getRow() == i.getRow() && this.getColumn() > i.getColumn()) {
            return false;
        }
        return this.getRow() != i.getRow() || this.getColumn() != i.getColumn();
    }

    @Override
    public boolean isAfter(CellValueRecordInterface i) {
        if (this.getRow() < i.getRow()) {
            return false;
        }
        if (this.getRow() == i.getRow() && this.getColumn() < i.getColumn()) {
            return false;
        }
        return this.getRow() != i.getRow() || this.getColumn() != i.getColumn();
    }

    @Override
    public boolean isEqual(CellValueRecordInterface i) {
        return this.getRow() == i.getRow() && this.getColumn() == i.getColumn();
    }

    @Override
    public boolean isInValueSection() {
        return true;
    }

    @Override
    public boolean isValue() {
        return true;
    }

    public int compareTo(Object obj) {
        CellValueRecordInterface loc = (CellValueRecordInterface)obj;
        if (this.getRow() == loc.getRow() && this.getColumn() == loc.getColumn()) {
            return 0;
        }
        if (this.getRow() < loc.getRow()) {
            return -1;
        }
        if (this.getRow() > loc.getRow()) {
            return 1;
        }
        if (this.getColumn() < loc.getColumn()) {
            return -1;
        }
        if (this.getColumn() > loc.getColumn()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CellValueRecordInterface)) {
            return false;
        }
        CellValueRecordInterface loc = (CellValueRecordInterface)obj;
        return this.getRow() == loc.getRow() && this.getColumn() == loc.getColumn();
    }

    @Override
    public Object clone() {
        NumberRecord rec = new NumberRecord();
        rec.field_1_row = this.field_1_row;
        rec.field_2_col = this.field_2_col;
        rec.field_3_xf = this.field_3_xf;
        rec.field_4_value = this.field_4_value;
        return rec;
    }
}

