/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.hssf.record.UnicodeString;
import loci.poi.util.LittleEndian;
import loci.poi.util.StringUtil;

public class WriteAccessRecord
extends Record {
    public static final short sid = 92;
    private String field_1_username;

    public WriteAccessRecord() {
    }

    public WriteAccessRecord(RecordInputStream in) {
        super(in);
    }

    @Override
    protected void validateSid(short id) {
        if (id != 92) {
            throw new RecordFormatException("NOT A WRITEACCESS RECORD");
        }
    }

    @Override
    protected void fillFields(RecordInputStream in) {
        byte[] data = in.readRemainder();
        this.field_1_username = StringUtil.getFromCompressedUnicode(data, 3, data.length - 3);
    }

    public void setUsername(String username) {
        this.field_1_username = username;
    }

    public String getUsername() {
        return this.field_1_username;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[WRITEACCESS]\n");
        buffer.append("    .name            = ").append(this.field_1_username.toString()).append("\n");
        buffer.append("[/WRITEACCESS]\n");
        return buffer.toString();
    }

    @Override
    public int serialize(int offset, byte[] data) {
        String username = this.getUsername();
        StringBuffer temp = new StringBuffer(109);
        temp.append(username);
        while (temp.length() < 109) {
            temp.append(" ");
        }
        username = temp.toString();
        UnicodeString str = new UnicodeString(username);
        str.setOptionFlags((byte)0);
        LittleEndian.putShort(data, 0 + offset, (short)92);
        LittleEndian.putShort(data, 2 + offset, (short)112);
        UnicodeString.UnicodeRecordStats stats = new UnicodeString.UnicodeRecordStats();
        stats.recordSize += 4;
        stats.remainingSize -= 4;
        str.serialize(stats, 4 + offset, data);
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        return 116;
    }

    @Override
    public short getSid() {
        return 92;
    }
}

