/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import loci.common.RandomAccessInputStream;
import ome.codecs.BaseCodec;
import ome.codecs.CodecException;
import ome.codecs.CodecOptions;
import ome.codecs.UnsupportedCompressionException;

public class PackbitsCodec
extends BaseCodec {
    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws CodecException {
        throw new UnsupportedCompressionException("Packbits Compression not currently supported");
    }

    @Override
    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws CodecException, IOException {
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        if (in == null) {
            throw new IllegalArgumentException("No data to decompress.");
        }
        long fp = in.getFilePointer();
        ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
        int nread = 0;
        BufferedInputStream s2 = new BufferedInputStream(in, 262144);
        while (output.size() < options.maxBytes) {
            byte n = (byte)(s2.read() & 0xFF);
            ++nread;
            if (n >= 0) {
                byte[] b = new byte[n + 1];
                s2.read(b);
                nread += n + 1;
                output.write(b);
                b = null;
                continue;
            }
            if (n == -128) continue;
            int len = -n + 1;
            byte inp = (byte)(s2.read() & 0xFF);
            ++nread;
            for (int i = 0; i < len; ++i) {
                output.write(inp);
            }
        }
        if (fp + (long)nread < in.length()) {
            in.seek(fp + (long)nread);
        }
        return output.toByteArray();
    }
}

