/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Folder;
import ome.xml.model.Image;
import ome.xml.model.MicrobeamManipulation;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.Union;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ROI
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(ROI.class);
    private String id;
    private String name;
    private Union union;
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();
    private String description;
    private List<Image> imageLinks = new ReferenceList<Image>();
    private List<MicrobeamManipulation> microbeamManipulationLinks = new ReferenceList<MicrobeamManipulation>();
    private List<Folder> folderLinks = new ReferenceList<Folder>();

    public ROI() {
    }

    public ROI(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public ROI(ROI orig) {
        this.id = orig.id;
        this.name = orig.name;
        this.union = orig.union;
        this.annotationLinks = orig.annotationLinks;
        this.description = orig.description;
        this.imageLinks = orig.imageLinks;
        this.microbeamManipulationLinks = orig.microbeamManipulationLinks;
        this.folderLinks = orig.folderLinks;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Union_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("ROI missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Name")) {
            this.setName(String.valueOf(element.getAttribute("Name")));
        }
        if ((Union_nodeList = ROI.getChildrenByTagName(element, "Union")).size() > 1) {
            throw new RuntimeException(String.format("Union node list size %d != 1", Union_nodeList.size()));
        }
        if (Union_nodeList.size() != 0) {
            this.setUnion(new Union(Union_nodeList.get(0), model));
        }
        List<Element> AnnotationRef_nodeList = ROI.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
        List<Element> Description_nodeList = ROI.getChildrenByTagName(element, "Description");
        if (Description_nodeList.size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkROI(this);
            this.annotationLinks.add(o_casted);
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Union getUnion() {
        return this.union;
    }

    public void setUnion(Union union) {
        this.union = union;
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkROI(this);
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkROI(this);
        return this.annotationLinks.remove(o);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int sizeOfLinkedImageList() {
        return this.imageLinks.size();
    }

    public List<Image> copyLinkedImageList() {
        return new ArrayList<Image>(this.imageLinks);
    }

    public Image getLinkedImage(int index) {
        return this.imageLinks.get(index);
    }

    public Image setLinkedImage(int index, Image o) {
        return this.imageLinks.set(index, o);
    }

    public boolean linkImage(Image o) {
        return this.imageLinks.add(o);
    }

    public boolean unlinkImage(Image o) {
        return this.imageLinks.remove(o);
    }

    public int sizeOfLinkedMicrobeamManipulationList() {
        return this.microbeamManipulationLinks.size();
    }

    public List<MicrobeamManipulation> copyLinkedMicrobeamManipulationList() {
        return new ArrayList<MicrobeamManipulation>(this.microbeamManipulationLinks);
    }

    public MicrobeamManipulation getLinkedMicrobeamManipulation(int index) {
        return this.microbeamManipulationLinks.get(index);
    }

    public MicrobeamManipulation setLinkedMicrobeamManipulation(int index, MicrobeamManipulation o) {
        return this.microbeamManipulationLinks.set(index, o);
    }

    public boolean linkMicrobeamManipulation(MicrobeamManipulation o) {
        return this.microbeamManipulationLinks.add(o);
    }

    public boolean unlinkMicrobeamManipulation(MicrobeamManipulation o) {
        return this.microbeamManipulationLinks.remove(o);
    }

    public int sizeOfLinkedFolderList() {
        return this.folderLinks.size();
    }

    public List<Folder> copyLinkedFolderList() {
        return new ArrayList<Folder>(this.folderLinks);
    }

    public Folder getLinkedFolder(int index) {
        return this.folderLinks.get(index);
    }

    public Folder setLinkedFolder(int index, Folder o) {
        return this.folderLinks.set(index, o);
    }

    public boolean linkFolder(Folder o) {
        return this.folderLinks.add(o);
    }

    public boolean unlinkFolder(Folder o) {
        return this.folderLinks.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element ROI_element) {
        if (ROI_element == null) {
            ROI_element = document.createElementNS(NAMESPACE, "ROI");
        }
        super.asXMLElement(document, ROI_element);
        if (this.id != null) {
            ROI_element.setAttribute("ID", this.id.toString());
        }
        if (this.name != null) {
            ROI_element.setAttribute("Name", this.name.toString());
        }
        if (this.union != null) {
            Element child = document.createElementNS(NAMESPACE, "Union");
            this.union.asXMLElement(document, child);
            ROI_element.appendChild(child);
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationLinks_value.getID());
                Element child = document.createElementNS(NAMESPACE, "AnnotationRef");
                o.asXMLElement(document, child);
                ROI_element.appendChild(child);
            }
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description.toString());
            ROI_element.appendChild(description_element);
        }
        if (this.imageLinks != null) {
            // empty if block
        }
        if (this.microbeamManipulationLinks != null) {
            // empty if block
        }
        if (this.folderLinks != null) {
            // empty if block
        }
        return ROI_element;
    }
}

