/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.units.UNITS;
import ome.units.quantity.Power;
import ome.units.unit.Unit;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsPower;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import ome.xml.model.primitives.NonNegativeFloat;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.PositiveLong;
import ome.xml.model.primitives.PrimitiveNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitsPowerEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitsPowerEnumHandler.class);
    private static final Hashtable<String, String> patterns = UnitsPowerEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*YW\\s*", "YW");
        p.put("^\\s*ZW\\s*", "ZW");
        p.put("^\\s*EW\\s*", "EW");
        p.put("^\\s*PW\\s*", "PW");
        p.put("^\\s*TW\\s*", "TW");
        p.put("^\\s*GW\\s*", "GW");
        p.put("^\\s*MW\\s*", "MW");
        p.put("^\\s*kW\\s*", "kW");
        p.put("^\\s*hW\\s*", "hW");
        p.put("^\\s*daW\\s*", "daW");
        p.put("^\\s*W\\s*", "W");
        p.put("^\\s*dW\\s*", "dW");
        p.put("^\\s*cW\\s*", "cW");
        p.put("^\\s*mW\\s*", "mW");
        p.put("^\\s*\u00b5W\\s*", "\u00b5W");
        p.put("^\\s*nW\\s*", "nW");
        p.put("^\\s*pW\\s*", "pW");
        p.put("^\\s*fW\\s*", "fW");
        p.put("^\\s*aW\\s*", "aW");
        p.put("^\\s*zW\\s*", "zW");
        p.put("^\\s*yW\\s*", "yW");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.matches(pattern)) continue;
                String v = patterns.get(pattern);
                return UnitsPower.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"UnitsPower", (Object)value);
        throw new EnumerationException(this.getClass().getName() + " could not find enumeration for " + value);
    }

    public Enumeration getEnumeration(Power inUnit) throws EnumerationException {
        return this.getEnumeration(inUnit.unit().getSymbol());
    }

    public static Unit<Power> getBaseUnit(UnitsPower inModelUnit) {
        Unit<Power> theResult = UNITS.WATT;
        if (UnitsPower.YOTTAWATT.equals(inModelUnit)) {
            theResult = UNITS.YOTTAWATT;
        }
        if (UnitsPower.ZETTAWATT.equals(inModelUnit)) {
            theResult = UNITS.ZETTAWATT;
        }
        if (UnitsPower.EXAWATT.equals(inModelUnit)) {
            theResult = UNITS.EXAWATT;
        }
        if (UnitsPower.PETAWATT.equals(inModelUnit)) {
            theResult = UNITS.PETAWATT;
        }
        if (UnitsPower.TERAWATT.equals(inModelUnit)) {
            theResult = UNITS.TERAWATT;
        }
        if (UnitsPower.GIGAWATT.equals(inModelUnit)) {
            theResult = UNITS.GIGAWATT;
        }
        if (UnitsPower.MEGAWATT.equals(inModelUnit)) {
            theResult = UNITS.MEGAWATT;
        }
        if (UnitsPower.KILOWATT.equals(inModelUnit)) {
            theResult = UNITS.KILOWATT;
        }
        if (UnitsPower.HECTOWATT.equals(inModelUnit)) {
            theResult = UNITS.HECTOWATT;
        }
        if (UnitsPower.DECAWATT.equals(inModelUnit)) {
            theResult = UNITS.DECAWATT;
        }
        if (UnitsPower.WATT.equals(inModelUnit)) {
            theResult = UNITS.WATT;
        }
        if (UnitsPower.DECIWATT.equals(inModelUnit)) {
            theResult = UNITS.DECIWATT;
        }
        if (UnitsPower.CENTIWATT.equals(inModelUnit)) {
            theResult = UNITS.CENTIWATT;
        }
        if (UnitsPower.MILLIWATT.equals(inModelUnit)) {
            theResult = UNITS.MILLIWATT;
        }
        if (UnitsPower.MICROWATT.equals(inModelUnit)) {
            theResult = UNITS.MICROWATT;
        }
        if (UnitsPower.NANOWATT.equals(inModelUnit)) {
            theResult = UNITS.NANOWATT;
        }
        if (UnitsPower.PICOWATT.equals(inModelUnit)) {
            theResult = UNITS.PICOWATT;
        }
        if (UnitsPower.FEMTOWATT.equals(inModelUnit)) {
            theResult = UNITS.FEMTOWATT;
        }
        if (UnitsPower.ATTOWATT.equals(inModelUnit)) {
            theResult = UNITS.ATTOWATT;
        }
        if (UnitsPower.ZEPTOWATT.equals(inModelUnit)) {
            theResult = UNITS.ZEPTOWATT;
        }
        if (UnitsPower.YOCTOWATT.equals(inModelUnit)) {
            theResult = UNITS.YOCTOWATT;
        }
        return theResult;
    }

    public static <T extends PrimitiveNumber> Power getQuantity(T inValue, UnitsPower inModelUnit) throws EnumerationException {
        if (inValue instanceof NonNegativeFloat) {
            NonNegativeFloat typedValue = (NonNegativeFloat)inValue;
            return new Power((Number)typedValue.getValue(), UnitsPowerEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof NonNegativeInteger) {
            NonNegativeInteger typedValue = (NonNegativeInteger)inValue;
            return new Power((Number)typedValue.getValue(), UnitsPowerEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof NonNegativeLong) {
            NonNegativeLong typedValue = (NonNegativeLong)inValue;
            return new Power((Number)typedValue.getValue(), UnitsPowerEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PercentFraction) {
            PercentFraction typedValue = (PercentFraction)inValue;
            return new Power((Number)typedValue.getValue(), UnitsPowerEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveFloat) {
            PositiveFloat typedValue = (PositiveFloat)inValue;
            return new Power((Number)typedValue.getValue(), UnitsPowerEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveInteger) {
            PositiveInteger typedValue = (PositiveInteger)inValue;
            return new Power((Number)typedValue.getValue(), UnitsPowerEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveLong) {
            PositiveLong typedValue = (PositiveLong)inValue;
            return new Power((Number)typedValue.getValue(), UnitsPowerEnumHandler.getBaseUnit(inModelUnit));
        }
        LOGGER.warn("Unknown type '{}' cannot be used to create a 'Power' quantity", (Object)inValue.getClass().getName());
        throw new EnumerationException("UnitsPowerEnumHandler: type '" + inValue.getClass().getName() + "' cannot be used to create a quantity");
    }

    public static <T extends Number> Power getQuantity(T inValue, UnitsPower inModelUnit) throws EnumerationException {
        if (inValue instanceof Double) {
            Double doubleValue = (Double)inValue;
            return new Power(doubleValue, UnitsPowerEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof Integer) {
            Integer intValue = (Integer)inValue;
            return new Power(intValue, UnitsPowerEnumHandler.getBaseUnit(inModelUnit));
        }
        LOGGER.warn("Unknown type '{}' cannot be used to create a 'Power' quantity", (Object)inValue.getClass().getName());
        throw new EnumerationException("UnitsPowerEnumHandler: type '" + inValue.getClass().getName() + "' cannot be used to create a quantity");
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return UnitsPower.class;
    }
}

