/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.jdom2.Namespace;
import thredds.client.catalog.Access;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.DatasetNode;
import thredds.client.catalog.Property;
import thredds.client.catalog.Service;
import thredds.client.catalog.builder.AccessBuilder;
import thredds.client.catalog.builder.CatalogBuilder;
import thredds.client.catalog.builder.CatalogRefBuilder;
import thredds.client.catalog.builder.DatasetBuilder;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.URLnaming;

@Immutable
public class Catalog
extends DatasetNode {
    public static final String CATALOG_NAMESPACE_10 = "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0";
    public static final Namespace defNS = Namespace.getNamespace((String)"http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0");
    public static final String NJ22_NAMESPACE = "http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2";
    public static final String NJ22_NAMESPACE_HTTPS = "https://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2";
    public static final Namespace ncmlNS = Namespace.getNamespace((String)"ncml", (String)"http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2");
    public static final Namespace ncmlNSHttps = Namespace.getNamespace((String)"ncml", (String)"https://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2");
    public static final String XLINK_NAMESPACE = "http://www.w3.org/1999/xlink";
    public static final Namespace xlinkNS = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink");
    public static final Namespace xsiNS = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private final URI baseURI;

    public Catalog(URI baseURI, String name, Map<String, Object> flds, List<DatasetBuilder> datasets) {
        super(null, name, flds, datasets);
        this.baseURI = baseURI;
        HashMap<String, Dataset> datasetMap = new HashMap<String, Dataset>();
        this.addDatasetsToHash(this.getDatasets(), datasetMap);
        if (!datasetMap.isEmpty()) {
            flds.put("DatasetHash", datasetMap);
        }
    }

    private void addDatasetsToHash(List<Dataset> datasets, Map<String, Dataset> datasetMap) {
        if (datasets == null) {
            return;
        }
        for (Dataset ds : datasets) {
            String id = ds.getId();
            if (id != null) {
                datasetMap.put(id, ds);
            }
            this.addDatasetsToHash(ds.getDatasets(), datasetMap);
        }
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public CalendarDate getExpires() {
        return (CalendarDate)this.flds.get("Expires");
    }

    public String getVersion() {
        return (String)this.flds.get("Version");
    }

    public List<Service> getServices() {
        List services = (List)this.flds.get("Services");
        return services == null ? new ArrayList(0) : services;
    }

    public Service findService(String serviceName) {
        if (serviceName == null) {
            return null;
        }
        List services = (List)this.flds.get("Services");
        return this.findService(services, serviceName);
    }

    private Service findService(List<Service> services, String want) {
        if (services == null) {
            return null;
        }
        for (Service s2 : services) {
            if (!s2.getName().equals(want)) continue;
            return s2;
        }
        for (Service s2 : services) {
            Service result = this.findService(s2.getNestedServices(), want);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public List<Property> getProperties() {
        List properties = (List)this.flds.get("Properties");
        return properties == null ? new ArrayList(0) : properties;
    }

    public Dataset findDatasetByID(String id) {
        Map datasetMap = (Map)this.flds.get("DatasetHash");
        return datasetMap == null ? null : (Dataset)datasetMap.get(id);
    }

    public URI resolveUri(String uriString) throws URISyntaxException {
        if (this.baseURI == null) {
            return new URI(uriString);
        }
        String resolved = URLnaming.resolve(this.baseURI.toString(), uriString);
        return new URI(resolved);
    }

    public static URI resolveUri(URI baseURI, String uriString) throws URISyntaxException {
        URI want = new URI(uriString);
        if (baseURI == null || want.isAbsolute()) {
            return want;
        }
        String scheme = baseURI.getScheme();
        if (scheme != null && scheme.equals("file")) {
            String baseString = baseURI.toString();
            if (uriString.length() > 0 && uriString.charAt(0) == '#') {
                return new URI(baseString + uriString);
            }
            int pos = baseString.lastIndexOf(47);
            if (pos > 0) {
                String r = baseString.substring(0, pos + 1) + uriString;
                return new URI(r);
            }
        }
        return baseURI.resolve(want);
    }

    public String getUriString() {
        URI baseURI = this.getBaseURI();
        return baseURI == null ? null : baseURI.toString();
    }

    public Catalog subsetCatalogOnDataset(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Dataset may not be null.");
        }
        if (dataset.getParentCatalog() != this) {
            throw new IllegalArgumentException("Catalog must contain the dataset.");
        }
        CatalogBuilder builder = new CatalogBuilder();
        URI docBaseUri = this.formDocBaseUriForSubsetCatalog(dataset);
        builder.setBaseURI(docBaseUri);
        builder.setName(dataset.getName());
        ArrayList<Service> neededServices = new ArrayList<Service>();
        DatasetBuilder topDs = this.copyDataset(null, dataset, neededServices, true);
        for (Service s2 : neededServices) {
            builder.addService(s2);
        }
        builder.addDataset(topDs);
        return builder.makeCatalog();
    }

    private DatasetBuilder copyDataset(DatasetBuilder parent, Dataset dataset, List<Service> neededServices, boolean copyInherited) {
        DatasetBuilder result;
        neededServices.add(dataset.getServiceDefault());
        if (dataset instanceof CatalogRef) {
            CatalogRef catRef = (CatalogRef)dataset;
            CatalogRefBuilder catBuilder = new CatalogRefBuilder(parent);
            catBuilder.setHref(catRef.getXlinkHref());
            catBuilder.setTitle(catRef.getName());
            result = catBuilder;
        } else {
            result = new DatasetBuilder(parent);
            List access = dataset.getLocalFieldAsList("Access");
            for (Access curAccess : access) {
                result.addAccess(this.copyAccess(result, curAccess, neededServices));
            }
            List datasets = dataset.getLocalFieldAsList("Datasets");
            for (Dataset currDs : datasets) {
                result.addDataset(this.copyDataset(result, currDs, neededServices, copyInherited));
            }
        }
        result.setName(dataset.getName());
        result.transferMetadata(dataset, false);
        return result;
    }

    private AccessBuilder copyAccess(DatasetBuilder parent, Access access, List<Service> neededServices) {
        neededServices.add(access.getService());
        return new AccessBuilder(parent, access.getUrlPath(), access.getService(), access.getDataFormatName(), access.getDataSize());
    }

    private URI formDocBaseUriForSubsetCatalog(Dataset dataset) {
        String catDocBaseUri = this.getUriString();
        String subsetDocBaseUriString = catDocBaseUri + "/" + (dataset.getID() != null ? dataset.getID() : dataset.getName());
        try {
            return new URI(subsetDocBaseUriString);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Bad document Base URI for new catalog [" + catDocBaseUri + "/" + (dataset.getID() != null ? dataset.getID() : dataset.getName()) + "].", e);
        }
    }
}

