/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import thredds.inventory.MFile;
import thredds.inventory.MFileFilter;

public class WildcardMatchOnPath
implements MFileFilter {
    private static final boolean debug = false;
    protected String wildcardString;
    protected Pattern pattern;

    public WildcardMatchOnPath(String wildcardString) {
        this.wildcardString = wildcardString;
        String regExp = wildcardString.replaceAll("\\.", "\\\\.");
        regExp = regExp.replaceAll("\\*", ".*");
        regExp = regExp.replaceAll("\\?", ".?");
        this.pattern = Pattern.compile(regExp);
    }

    public WildcardMatchOnPath(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean accept(MFile file2) {
        String p = file2.getPath();
        Matcher matcher = this.pattern.matcher(p);
        return matcher.matches();
    }

    public String toString() {
        return "WildcardMatchOnPath{wildcard=" + this.wildcardString + " regexp=" + this.pattern + '}';
    }
}

