/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import java.io.Serializable;
import java.util.Formatter;
import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.util.Format;

public class ProjectionPointImpl
implements ProjectionPoint,
Serializable {
    private double x;
    private double y;

    public ProjectionPointImpl() {
        this(0.0, 0.0);
    }

    public ProjectionPointImpl(ProjectionPoint pt) {
        this.x = pt.getX();
        this.y = pt.getY();
    }

    public ProjectionPointImpl(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    @Override
    public boolean equals(ProjectionPoint pt) {
        return pt.getX() == this.getX() && pt.getY() == this.getY();
    }

    public boolean closeEnough(ProjectionPoint pt2) {
        return Misc.closeEnough(this.getX(), pt2.getX()) && Misc.closeEnough(this.getY(), pt2.getY());
    }

    public String toString() {
        return Format.d(this.getX(), 4) + " " + Format.d(this.getY(), 4);
    }

    public void toString(Formatter f) {
        f.format("x=%f y=%f ", this.getX(), this.getY());
    }

    public void setLocation(ProjectionPoint pt) {
        this.setLocation(pt.getX(), pt.getY());
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public boolean isInfinite() {
        return this.x == Double.POSITIVE_INFINITY || this.x == Double.NEGATIVE_INFINITY || this.y == Double.POSITIVE_INFINITY || this.y == Double.NEGATIVE_INFINITY;
    }

    public static boolean isInfinite(ProjectionPoint pt) {
        return pt.getX() == Double.POSITIVE_INFINITY || pt.getX() == Double.NEGATIVE_INFINITY || pt.getY() == Double.POSITIVE_INFINITY || pt.getY() == Double.NEGATIVE_INFINITY;
    }
}

