"""This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from typing import overload

from zospy.api._ZOSAPI.Analysis import SampleSizes
from zospy.api._ZOSAPI.Common import IVectorData
from zospy.api._ZOSAPI.SystemData import ZemaxSystemUnits
from zospy.api._ZOSAPI.Tools.FileManager import IFile, KnownFolder, Operation
from zospy.api._ZOSAPI.Tools.General import (
    IComputeRMSSpotSize,
    ICreateArchive,
    ICreateProject,
    IExportCAD,
    IHullTools,
    ILensCatalogs,
    IPointTools,
    IQuickAdjust,
    IQuickFocus,
    IRayAimingWizard,
    IRestoreArchive,
    IRestoreProject,
    IScale,
)
from zospy.api._ZOSAPI.Tools.Layouts import (
    I3DViewerExport,
    ICrossSectionExport,
    INSC3DLayoutExport,
    INSCShadedModelExport,
    IShadedModelExport,
)
from zospy.api._ZOSAPI.Tools.Optimization import (
    IGlobalOptimization,
    IHammerOptimization,
    ILocalOptimization,
)
from zospy.api._ZOSAPI.Tools.OptimizationTools import (
    IConvertAsphereType,
    IFindBestAsphere,
)
from zospy.api._ZOSAPI.Tools.RayTrace import (
    IBatchRayTrace,
    ILightningTrace,
    INSCRayTrace,
    IZRDReader,
)
from zospy.api._ZOSAPI.Tools.Tolerancing import (
    IQuickSensitivity,
    IToleranceDataViewer,
    ITolerancing,
)

from . import (
    FileManager,
    General,
    Layouts,
    Optimization,
    OptimizationTools,
    RayTrace,
    Tolerancing,
)

__all__ = (
    "FileManager",
    "General",
    "Layouts",
    "Optimization",
    "OptimizationTools",
    "RayTrace",
    "Tolerancing",
    "CriticalRayType",
    "HPCEnvironments",
    "HPCNodeSize",
    "HPCRunState",
    "IAPIUtilities",
    "IConvertToNSCGroup",
    "ICriticalRaysetGenerator",
    "IDesignLockdown",
    "IExportToSpeosLensSystem",
    "IExportToSpeosWhitebox",
    "IFileManager",
    "IHPCSettings",
    "IInternalBirefringenceData",
    "IInternalBirefringenceParameter",
    "IInternalTransmissionData",
    "IInternalTransmissionParameter",
    "ILayouts",
    "IMaterialsCatalog",
    "IMFCalculator",
    "IOpticalSystemTools",
    "IShadedModelTriangleList",
    "IShadedModelVisualizationExport",
    "ISystemTool",
    "MaterialFormulas",
    "MaterialStatuses",
    "RayPatternOption",
    "RunStatus",
    "VertexOrder",
)

class CriticalRayType:
    Chief = 0
    Marginal = 1
    Grid = 2
    Ring = 3
    Y_Fan = 4
    X_Fan = 5
    XY_Fan = 6
    List = 7

class HPCEnvironments:
    OnPremise = 0
    AWSKubernetes = 1
    AzureKubernetes = 2

class HPCNodeSize:
    Default = 0
    Tiny = 1
    Small = 2
    Medium = 3
    Large = 4
    XLarge = 5

class HPCRunState:
    NotRunning = 0
    Initializing = 1
    ClusterAllocating = 2
    UploadingData = 3
    Queued = 4
    RunStarting = 5
    WaitingForResults = 6
    Complete = 7

class IAPIUtilities:
    def ConvertToStringCust(self, x: float, digits: int, expBelow: float, expAbove: float) -> str: ...
    @overload
    def ConvertToStringExp(self, x: float) -> str: ...
    @overload
    def ConvertToStringExp(self, x: float, digits: int) -> str: ...
    @overload
    def ConvertToStringFixed(self, x: float) -> str: ...
    @overload
    def ConvertToStringFixed(self, x: float, digits: int) -> str: ...
    def ConvertToStringPref(self, x: float) -> str: ...

class IConvertToNSCGroup(ISystemTool):
    @property
    def FirstSurface(self) -> int: ...
    @FirstSurface.setter
    def FirstSurface(self, value: int) -> None: ...
    @property
    def LastSurface(self) -> int: ...
    @LastSurface.setter
    def LastSurface(self, value: int) -> None: ...
    @property
    def IgnoreErrors(self) -> bool: ...
    @IgnoreErrors.setter
    def IgnoreErrors(self, value: bool) -> None: ...
    @property
    def ConvertFileToNSC(self) -> bool: ...
    @ConvertFileToNSC.setter
    def ConvertFileToNSC(self, value: bool) -> None: ...
    @property
    def CreateSourcesAndDetectors(self) -> bool: ...
    @CreateSourcesAndDetectors.setter
    def CreateSourcesAndDetectors(self, value: bool) -> None: ...
    @property
    def ConvertToGlobalCoordinates(self) -> bool: ...
    @ConvertToGlobalCoordinates.setter
    def ConvertToGlobalCoordinates(self, value: bool) -> None: ...
    @property
    def ConvertStopToNSCAperture(self) -> bool: ...
    @ConvertStopToNSCAperture.setter
    def ConvertStopToNSCAperture(self, value: bool) -> None: ...
    @property
    def StopMechanicalHalfWidth(self) -> float: ...
    @StopMechanicalHalfWidth.setter
    def StopMechanicalHalfWidth(self, value: float) -> None: ...
    @property
    def OverfillFactor(self) -> float: ...
    @OverfillFactor.setter
    def OverfillFactor(self, value: float) -> None: ...
    @property
    def StopObjectNumber(self) -> int: ...
    @property
    def StopObjectFace(self) -> int: ...

class ICriticalRaysetGenerator(ISystemTool):
    @property
    def RayPattern(self) -> RayPatternOption: ...
    @RayPattern.setter
    def RayPattern(self, value: RayPatternOption) -> None: ...
    @property
    def NumRays(self) -> int: ...
    @NumRays.setter
    def NumRays(self, value: int) -> None: ...
    @property
    def MinimumEfectiveInputDistance(self) -> float: ...
    @property
    def EffectiveInputDistance(self) -> float: ...
    @EffectiveInputDistance.setter
    def EffectiveInputDistance(self, value: float) -> None: ...
    @property
    def UseAllFields(self) -> bool: ...
    @UseAllFields.setter
    def UseAllFields(self, value: bool) -> None: ...
    @property
    def UseAllWavelengths(self) -> bool: ...
    @UseAllWavelengths.setter
    def UseAllWavelengths(self, value: bool) -> None: ...
    @property
    def ReadRaysFromFilename(self) -> None: ...
    @ReadRaysFromFilename.setter
    def ReadRaysFromFilename(self, value: str) -> None: ...
    @property
    def SaveCriticalRaysFilename(self) -> None: ...
    @SaveCriticalRaysFilename.setter
    def SaveCriticalRaysFilename(self, value: str) -> None: ...
    @property
    def RayScale(self) -> float: ...
    @RayScale.setter
    def RayScale(self, value: float) -> None: ...

class IDesignLockdown(ISystemTool):
    @property
    def DecimalPrecision(self) -> int: ...
    @DecimalPrecision.setter
    def DecimalPrecision(self, value: int) -> None: ...
    @property
    def ExcludePickups(self) -> bool: ...
    @ExcludePickups.setter
    def ExcludePickups(self, value: bool) -> None: ...
    @property
    def UsePrecisionRounding(self) -> bool: ...
    @UsePrecisionRounding.setter
    def UsePrecisionRounding(self, value: bool) -> None: ...
    @property
    def FixModelGlasses(self) -> bool: ...
    @FixModelGlasses.setter
    def FixModelGlasses(self, value: bool) -> None: ...
    @property
    def ConvertSDToMaxApertures(self) -> bool: ...
    @ConvertSDToMaxApertures.setter
    def ConvertSDToMaxApertures(self, value: bool) -> None: ...

class IExportToSpeosLensSystem(ISystemTool):
    @property
    def SensorWidth(self) -> float: ...
    @SensorWidth.setter
    def SensorWidth(self, value: float) -> None: ...
    @property
    def SensorHeight(self) -> float: ...
    @SensorHeight.setter
    def SensorHeight(self, value: float) -> None: ...
    @property
    def SkipSystemReversal(self) -> bool: ...
    @SkipSystemReversal.setter
    def SkipSystemReversal(self, value: bool) -> None: ...
    @property
    def SamplePoints(self) -> int: ...
    @SamplePoints.setter
    def SamplePoints(self, value: int) -> None: ...
    @property
    def XSampling(self) -> int: ...
    @XSampling.setter
    def XSampling(self, value: int) -> None: ...
    @property
    def YSampling(self) -> int: ...
    @YSampling.setter
    def YSampling(self, value: int) -> None: ...
    @property
    def SampleSize(self) -> SampleSizes: ...
    @SampleSize.setter
    def SampleSize(self, value: SampleSizes) -> None: ...
    @property
    def Configuration(self) -> int: ...
    @Configuration.setter
    def Configuration(self, value: int) -> None: ...
    @property
    def FileFormatVersion(self) -> int: ...
    @property
    def AssumeRadialSymmetry(self) -> bool: ...
    @AssumeRadialSymmetry.setter
    def AssumeRadialSymmetry(self, value: bool) -> None: ...
    @property
    def OPTDistortionFilename(self) -> str: ...
    @OPTDistortionFilename.setter
    def OPTDistortionFilename(self, value: str) -> None: ...

class IExportToSpeosWhitebox(ISystemTool):
    @property
    def ErrorCode(self) -> int: ...
    @property
    def OutputFilename(self) -> str: ...

class IFileManager(ISystemTool):
    @property
    def Operation(self) -> Operation: ...
    @Operation.setter
    def Operation(self, value: Operation) -> None: ...
    @property
    def NumberOfFiles(self) -> int: ...
    def AddAdditionalFile(self, knownFolder: KnownFolder, relativePath: str, fileName: str) -> bool: ...
    def GetFile(self, fileNumber: int) -> IFile: ...
    def RemoveAdditionalFile(self, project: KnownFolder, relativePath: str, fileName: str) -> bool: ...
    def UseProjectFile(self, knownFolder: KnownFolder, relativePath: str, name: str) -> bool: ...
    def UseRootFile(self, knownFolder: KnownFolder, relativePath: str, name: str) -> bool: ...

class IHPCSettings:
    @property
    def IsHPCConfigured(self) -> bool: ...
    @property
    def NodeCount(self) -> int: ...
    @property
    def MaxNodeCount(self) -> int: ...
    @property
    def InstanceType(self) -> HPCNodeSize: ...
    @property
    def ThreadsPerTask(self) -> int: ...
    @property
    def ShutdownTimeTicks(self) -> int: ...

class IInternalBirefringenceData:
    @property
    def NumberOfPoints(self) -> int: ...
    def GetDataPoint(self, pointNumber: int) -> IInternalBirefringenceParameter: ...

class IInternalBirefringenceParameter:
    @property
    def Wavelength(self) -> float: ...
    @Wavelength.setter
    def Wavelength(self, value: float) -> None: ...
    @property
    def K(self) -> float: ...
    @K.setter
    def K(self, value: float) -> None: ...
    @property
    def K11(self) -> float: ...
    @K11.setter
    def K11(self, value: float) -> None: ...
    @property
    def K12(self) -> float: ...
    @K12.setter
    def K12(self, value: float) -> None: ...

class IInternalTransmissionData:
    @property
    def NumberOfPoints(self) -> int: ...
    def GetDataPoint(self, pointNumber: int) -> IInternalTransmissionParameter: ...

class IInternalTransmissionParameter:
    @property
    def Wavelength(self) -> float: ...
    @Wavelength.setter
    def Wavelength(self, value: float) -> None: ...
    @property
    def Transmission(self) -> float: ...
    @Transmission.setter
    def Transmission(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...

class ILayouts:
    def Open3DViewerExport(self) -> I3DViewerExport: ...
    def OpenCrossSectionExport(self) -> ICrossSectionExport: ...
    def OpenNSC3DLayoutExport(self) -> INSC3DLayoutExport: ...
    def OpenNSCShadedModelExport(self) -> INSCShadedModelExport: ...
    def OpenShadedModelExport(self) -> IShadedModelExport: ...

class IMaterialsCatalog(ISystemTool):
    @property
    def SelectedCatalog(self) -> str: ...
    @SelectedCatalog.setter
    def SelectedCatalog(self, value: str) -> None: ...
    @property
    def SelectedMaterial(self) -> str: ...
    @SelectedMaterial.setter
    def SelectedMaterial(self, value: str) -> None: ...
    @property
    def NumberOfFitCoefficients(self) -> int: ...
    @property
    def CatalogComment(self) -> str: ...
    @CatalogComment.setter
    def CatalogComment(self, value: str) -> None: ...
    @property
    def MaterialFormula(self) -> MaterialFormulas: ...
    @MaterialFormula.setter
    def MaterialFormula(self, value: MaterialFormulas) -> None: ...
    @property
    def MaterialStatus(self) -> MaterialStatuses: ...
    @MaterialStatus.setter
    def MaterialStatus(self, value: MaterialStatuses) -> None: ...
    @property
    def D0(self) -> float: ...
    @D0.setter
    def D0(self, value: float) -> None: ...
    @property
    def D1(self) -> float: ...
    @D1.setter
    def D1(self, value: float) -> None: ...
    @property
    def D2(self) -> float: ...
    @D2.setter
    def D2(self, value: float) -> None: ...
    @property
    def E0(self) -> float: ...
    @E0.setter
    def E0(self, value: float) -> None: ...
    @property
    def E1(self) -> float: ...
    @E1.setter
    def E1(self, value: float) -> None: ...
    @property
    def Ltk(self) -> float: ...
    @Ltk.setter
    def Ltk(self, value: float) -> None: ...
    @property
    def TCE(self) -> float: ...
    @TCE.setter
    def TCE(self, value: float) -> None: ...
    @property
    def Temp(self) -> float: ...
    @Temp.setter
    def Temp(self, value: float) -> None: ...
    @property
    def p(self) -> float: ...
    @p.setter
    def p(self, value: float) -> None: ...
    @property
    def dPgF(self) -> float: ...
    @dPgF.setter
    def dPgF(self, value: float) -> None: ...
    @property
    def MinimumWavelength(self) -> float: ...
    @MinimumWavelength.setter
    def MinimumWavelength(self, value: float) -> None: ...
    @property
    def MaximumWavelength(self) -> float: ...
    @MaximumWavelength.setter
    def MaximumWavelength(self, value: float) -> None: ...
    @property
    def IgnoreThermalExpansion(self) -> bool: ...
    @IgnoreThermalExpansion.setter
    def IgnoreThermalExpansion(self, value: bool) -> None: ...
    @property
    def ExcludeSubstitution(self) -> bool: ...
    @ExcludeSubstitution.setter
    def ExcludeSubstitution(self, value: bool) -> None: ...
    @property
    def MetaMaterial(self) -> bool: ...
    @MetaMaterial.setter
    def MetaMaterial(self, value: bool) -> None: ...
    @property
    def MeltFreq(self) -> str: ...
    @MeltFreq.setter
    def MeltFreq(self, value: str) -> None: ...
    @property
    def Comment(self) -> str: ...
    @Comment.setter
    def Comment(self, value: str) -> None: ...
    @property
    def RelCost(self) -> str: ...
    @RelCost.setter
    def RelCost(self, value: str) -> None: ...
    @property
    def CR(self) -> str: ...
    @CR.setter
    def CR(self, value: str) -> None: ...
    @property
    def FR(self) -> str: ...
    @FR.setter
    def FR(self, value: str) -> None: ...
    @property
    def SR(self) -> str: ...
    @SR.setter
    def SR(self, value: str) -> None: ...
    @property
    def AR(self) -> str: ...
    @AR.setter
    def AR(self, value: str) -> None: ...
    @property
    def PR(self) -> str: ...
    @PR.setter
    def PR(self, value: str) -> None: ...
    @property
    def Nd(self) -> float: ...
    @property
    def Vd(self) -> float: ...
    @property
    def YoungsModulus(self) -> float: ...
    @property
    def HasYoungsModulus(self) -> bool: ...
    @property
    def PoissonRatio(self) -> float: ...
    @property
    def HasPoissonRatio(self) -> bool: ...
    @property
    def KnoopHardness(self) -> float: ...
    @property
    def HasKnoopHardness(self) -> bool: ...
    @property
    def SpecificHeatCapacity(self) -> float: ...
    @property
    def HasSpecificHeatCapacity(self) -> bool: ...
    @property
    def HeatConductivity(self) -> float: ...
    @property
    def HasHeatConductivity(self) -> bool: ...
    def GetAllCatalogs(self) -> list[str]: ...
    def GetAllMaterials(self) -> list[str]: ...
    def GetCoefficientName(self, coeff: int) -> str: ...
    def GetFitCoefficient(self, coeff: int) -> float: ...
    def GetInternalBirefringenceData(self) -> IInternalBirefringenceData: ...
    def GetInternalTransmissionData(self) -> IInternalTransmissionData: ...
    def SaveCatalog(self) -> bool: ...
    def SetFitCoefficient(self, coeff: int, Value: float) -> None: ...

class IMFCalculator(ISystemTool):
    @property
    def MeritFunctionCalculation(self) -> float: ...

class IOpticalSystemTools:
    @property
    def CurrentTool(self) -> ISystemTool: ...
    @property
    def Progress(self) -> int: ...
    @property
    def Status(self) -> str: ...
    @property
    def IsRunning(self) -> bool: ...
    @property
    def Layouts(self) -> ILayouts: ...
    @property
    def LastError(self) -> IMessage: ...
    def CreateDoubleMatrix(self, Rows: int, Cols: int) -> list[list[float]]: ...
    def CreateDoubleVector(self, numElements: int) -> list[float]: ...
    def GetConversionFromSystemUnits(self, toUnits: ZemaxSystemUnits) -> float: ...
    def GetConversionToSystemUnits(self, fromUnits: ZemaxSystemUnits) -> float: ...
    def GetHPCSettingsCustom(self, nodeCount: int, instanceType: HPCNodeSize) -> IHPCSettings: ...
    def GetHPCSettingsFromPrefs(self) -> IHPCSettings: ...
    def GetHullTools(self) -> IHullTools: ...
    def GetPointTools(self) -> IPointTools: ...
    def GetUtilities(self) -> IAPIUtilities: ...
    def OpenBatchRayTrace(self) -> IBatchRayTrace: ...
    def OpenConvertAsphereTypes(self) -> IConvertAsphereType: ...
    def OpenConvertToNSCGroup(self) -> IConvertToNSCGroup: ...
    def OpenCreateProject(self) -> ICreateProject: ...
    def OpenCreateZAR(self) -> ICreateArchive: ...
    def OpenCriticalRaysetGenerator(self) -> ICriticalRaysetGenerator: ...
    def OpenDesignLockdown(self) -> IDesignLockdown: ...
    def OpenExportCAD(self) -> IExportCAD: ...
    def OpenExportToSpeosLensSystem(self) -> IExportToSpeosLensSystem: ...
    def OpenExportToSpeosWhitebox(self) -> IExportToSpeosWhitebox: ...
    def OpenFileManager(self) -> IFileManager: ...
    def OpenFindBestAsphere(self) -> IFindBestAsphere: ...
    def OpenGlobalOptimization(self) -> IGlobalOptimization: ...
    def OpenGlobalOptimization_HPC(self, hpcSettings: IHPCSettings) -> IGlobalOptimization: ...
    def OpenHammerOptimization(self) -> IHammerOptimization: ...
    def OpenHammerOptimization_HPC(self, hpcSettings: IHPCSettings) -> IHammerOptimization: ...
    def OpenLensCatalogs(self) -> ILensCatalogs: ...
    def OpenLightningTrace(self) -> ILightningTrace: ...
    def OpenLocalOptimization(self) -> ILocalOptimization: ...
    def OpenMaterialsCatalog(self) -> IMaterialsCatalog: ...
    def OpenMeritFunctionCalculator(self) -> IMFCalculator: ...
    def OpenNSCRayTrace(self) -> INSCRayTrace: ...
    def OpenNSCRayTrace_HPC(self, hpcSettings: IHPCSettings) -> INSCRayTrace: ...
    def OpenQuickAdjust(self) -> IQuickAdjust: ...
    def OpenQuickFocus(self) -> IQuickFocus: ...
    def OpenQuickSensitivity(self) -> IQuickSensitivity: ...
    def OpenRayAimingWizard(self) -> IRayAimingWizard: ...
    def OpenRayDatabaseReader(self) -> IZRDReader: ...
    def OpenRestoreProject(self) -> IRestoreProject: ...
    def OpenRestoreZAR(self) -> IRestoreArchive: ...
    def OpenRMSSpotRadiusCalculator(self) -> IComputeRMSSpotSize: ...
    def OpenScale(self) -> IScale: ...
    def OpenShadedModelVisualizationExport(self) -> IShadedModelVisualizationExport: ...
    def OpenToleranceDataViewer(self) -> IToleranceDataViewer: ...
    def OpenTolerancing(self) -> ITolerancing: ...
    def OpenTolerancing_HPC(self, hpcSettings: IHPCSettings) -> ITolerancing: ...
    def RemoveAllVariables(self) -> bool: ...
    def SetAllRadiiVariable(self) -> int: ...
    def SetAllThicknessesVariable(self) -> int: ...

class IShadedModelTriangleList:
    @property
    def NumberOfTriangles(self) -> int: ...
    @property
    def NumberOfSurfaces(self) -> int: ...
    @property
    def TotalNumberOfObjects(self) -> int: ...
    @property
    def XCoords(self) -> IVectorData: ...
    @XCoords.setter
    def XCoords(self, value: IVectorData) -> None: ...
    @property
    def YCoords(self) -> IVectorData: ...
    @YCoords.setter
    def YCoords(self, value: IVectorData) -> None: ...
    @property
    def ZCoords(self) -> IVectorData: ...
    @ZCoords.setter
    def ZCoords(self, value: IVectorData) -> None: ...
    @property
    def XNormals(self) -> IVectorData: ...
    @XNormals.setter
    def XNormals(self, value: IVectorData) -> None: ...
    @property
    def YNormals(self) -> IVectorData: ...
    @YNormals.setter
    def YNormals(self, value: IVectorData) -> None: ...
    @property
    def ZNormals(self) -> IVectorData: ...
    @ZNormals.setter
    def ZNormals(self, value: IVectorData) -> None: ...
    @property
    def SurfaceIndex(self) -> IVectorData: ...
    @SurfaceIndex.setter
    def SurfaceIndex(self, value: IVectorData) -> None: ...
    @property
    def ObjectIndex(self) -> IVectorData: ...
    @ObjectIndex.setter
    def ObjectIndex(self, value: IVectorData) -> None: ...
    def GetVertex(
        self, TriangleNumber: int, Vertex: VertexOrder
    ) -> tuple[bool, float, float, float, float, float, float, int, int]: ...
    def NumberOfObjects(self, Surface: int) -> list[int]: ...

class IShadedModelVisualizationExport(ISystemTool):
    @property
    def StartSurface(self) -> int: ...
    @StartSurface.setter
    def StartSurface(self, value: int) -> None: ...
    @property
    def EndSurface(self) -> int: ...
    @EndSurface.setter
    def EndSurface(self, value: int) -> None: ...
    @property
    def Object(self) -> int: ...
    @Object.setter
    def Object(self, value: int) -> None: ...
    def GetResults(self) -> IShadedModelTriangleList: ...

class ISystemTool:
    @property
    def Progress(self) -> int: ...
    @property
    def Status(self) -> str: ...
    @property
    def IsRunning(self) -> bool: ...
    @property
    def CanCancel(self) -> bool: ...
    @property
    def IsAsynchronous(self) -> bool: ...
    @property
    def IsFiniteDuration(self) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Succeeded(self) -> bool: ...
    @property
    def ErrorMessage(self) -> str: ...
    def Cancel(self) -> bool: ...
    def Close(self) -> bool: ...
    def Run(self) -> bool: ...
    def RunAndWaitForCompletion(self) -> bool: ...
    def RunAndWaitWithTimeout(self, timeOutSeconds: float) -> RunStatus: ...
    def WaitForCompletion(self) -> bool: ...
    def WaitWithTimeout(self, timeOutSeconds: float) -> RunStatus: ...

class MaterialFormulas:
    Schott = 1
    Sellmeier1 = 2
    Herzberger = 3
    Sellmeier2 = 4
    Conrady = 5
    Sellmeier3 = 6
    Handbook1 = 7
    Handbook2 = 8
    Sellmeier4 = 9
    Extended = 10
    Sellmeier5 = 11
    Extended2 = 12
    Extended3 = 13

class MaterialStatuses:
    Standard = 0
    Preferred = 1
    Obsolete = 2
    Special = 3
    Melt = 4

class RayPatternOption:
    XyFan = 0
    XFan = 1
    YFan = 2
    ChiefAndRing = 3
    List = 4
    Grid = 6
    ChiefAndMarginals = 8

class RunStatus:
    Completed = 0
    FailedToStart = 1
    TimedOut = 2
    InvalidTimeout = 3

class VertexOrder:
    First = 0
    Second = 1
    Third = 2
