<a id="mypy-boto3-sso"></a>

# mypy-boto3-sso

[![PyPI - mypy-boto3-sso](https://img.shields.io/pypi/v/mypy-boto3-sso.svg?color=blue)](https://pypi.org/project/mypy-boto3-sso)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-sso.svg?color=blue)](https://pypi.org/project/mypy-boto3-sso)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/mypy-boto3-sso?color=blue)](https://pypistats.org/packages/mypy-boto3-sso)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.SSO 1.20.35](https://boto3.amazonaws.com/v1/documentation/api/1.20.35/reference/services/sso.html#SSO)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 6.3.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-sso docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sso/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-sso](#mypy-boto3-sso)
  - [How to install](#how-to-install)
    - [VSCode extension](#vscode-extension)
    - [From PyPI with pip](#from-pypi-with-pip)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

<a id="vscode-extension"></a>

### VSCode extension

Add
[AWS Boto3](https://marketplace.visualstudio.com/items?itemName=Boto3typed.boto3-ide)
extension to your VSCode and run `AWS boto3: Quick Start` command.

Click `Modify` and select `boto3 common` and `SSO`.

<a id="from-pypi-with-pip"></a>

### From PyPI with pip

Install `boto3-stubs` for `SSO` service.

```bash
python -m pip install boto3-stubs[sso]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[sso]` in your environment:
  `python -m pip install 'boto3-stubs[sso]'`

Both type checking and auto-complete should work for `SSO` service. No explicit
type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[sso]` in your environment:
  `python -m pip install 'boto3-stubs[sso]'`

Both type checking and auto-complete should work for `SSO` service. No explicit
type annotations required, write your `boto3` code as usual. Auto-complete can
be slow on big projects or if you have a lot of installed `boto3-stubs`
submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[sso]` in your environment:
  `python -m pip install 'boto3-stubs[sso]'`
- Run `mypy` as usual

Type checking should work for `SSO` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[sso]` in your environment:
  `python -m pip install 'boto3-stubs[sso]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `SSO` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`SSOClient` provides annotations for `boto3.client("sso")`.

```python
import boto3

from mypy_boto3_sso import SSOClient

client: SSOClient = boto3.client("sso")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SSOClient = session.client("sso")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_sso.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_sso import SSOClient
from mypy_boto3_sso.paginator import (
    ListAccountRolesPaginator,
    ListAccountsPaginator,
)

client: SSOClient = boto3.client("sso")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_account_roles_paginator: ListAccountRolesPaginator = client.get_paginator("list_account_roles")
list_accounts_paginator: ListAccountsPaginator = client.get_paginator("list_accounts")
```

<a id="literals"></a>

### Literals

`mypy_boto3_sso.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_sso.literals import (
    ListAccountRolesPaginatorName,
    ListAccountsPaginatorName,
    ServiceName,
    PaginatorName,
)

def check_value(value: ListAccountRolesPaginatorName) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_sso.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_sso.type_defs import (
    AccountInfoTypeDef,
    GetRoleCredentialsRequestRequestTypeDef,
    GetRoleCredentialsResponseTypeDef,
    ListAccountRolesRequestRequestTypeDef,
    ListAccountRolesResponseTypeDef,
    ListAccountsRequestRequestTypeDef,
    ListAccountsResponseTypeDef,
    LogoutRequestRequestTypeDef,
    PaginatorConfigTypeDef,
    ResponseMetadataTypeDef,
    RoleCredentialsTypeDef,
    RoleInfoTypeDef,
)

def get_structure() -> AccountInfoTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-sso` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-sso docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sso/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
