/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.vars.values;

import com.github.fge.uritemplate.expression.ExpressionType;
import com.github.fge.uritemplate.render.ListRenderer;
import com.github.fge.uritemplate.render.MapRenderer;
import com.github.fge.uritemplate.render.StringRenderer;
import com.github.fge.uritemplate.render.ValueRenderer;

public enum ValueType {
    SCALAR("scalar"){

        @Override
        public ValueRenderer selectRenderer(ExpressionType type) {
            return new StringRenderer(type);
        }
    }
    ,
    ARRAY("list"){

        @Override
        public ValueRenderer selectRenderer(ExpressionType type) {
            return new ListRenderer(type);
        }
    }
    ,
    MAP("map"){

        @Override
        public ValueRenderer selectRenderer(ExpressionType type) {
            return new MapRenderer(type);
        }
    };

    private final String name;

    private ValueType(String name) {
        this.name = name;
    }

    public abstract ValueRenderer selectRenderer(ExpressionType var1);

    public String toString() {
        return this.name;
    }
}

