"""Asynchronous Python client for the local Busch-Jaeger Free@Home API."""

import enum
from typing import Any


class MyEnumMeta(enum.EnumMeta):
    """EnumMeta."""

    def __contains__(cls, item: Any) -> bool:
        """Find for an enum."""
        try:
            cls(item)
        except ValueError:
            return False
        else:
            return True


class FunctionIDs(enum.Enum, metaclass=MyEnumMeta):
    """All FunctionIDs from FreeAtHome."""

    FID_SWITCH_SENSOR = 0x0000
    FID_DIMMING_SENSOR = 0x0001
    FID_SHUTTER_SENSOR = 0x0002
    FID_BLIND_SENSOR = 0x0003
    FID_STAIRCASE_LIGHT_SENSOR = 0x0004
    FID_FORCE_ON_OFF_SENSOR = 0x0005
    FID_SCENE_SENSOR = 0x0006
    FID_SWITCH_ACTUATOR = 0x0007
    FID_SHUTTER_ACTUATOR = 0x0009
    FID_ROOM_TEMPERATURE_CONTROLLER_MASTER_WITH_FAN = 0x000A
    FID_ROOM_TEMPERATURE_CONTROLLER_SLAVE = 0x000B
    FID_WIND_ALARM_SENSOR = 0x000C
    FID_FROST_ALARM_SENSOR = 0x000D
    FID_RAIN_ALARM_SENSOR = 0x000E
    FID_WINDOW_DOOR_SENSOR = 0x000F
    FID_MOVEMENT_DETECTOR = 0x0011
    FID_DIMMING_ACTUATOR = 0x0012
    FID_RADIATOR_ACTUATOR = 0x0014
    FID_UNDERFLOOR_HEATING = 0x0015
    FID_FAN_COIL = 0x0016
    FID_TWO_LEVEL_CONTROLLER = 0x0017
    FID_DES_DOOR_OPENER_ACTUATOR = 0x001A
    FID_PROXY = 0x001B
    FID_DES_LEVEL_CALL_ACTUATOR = 0x001D
    FID_DES_LEVEL_CALL_SENSOR = 0x001E
    FID_DES_DOOR_RINGING_SENSOR = 0x001F
    FID_DES_AUTOMATIC_DOOR_OPENER_ACTUATOR = 0x0020
    FID_DES_LIGHT_SWITCH_ACTUATOR = 0x0021
    FID_ROOM_TEMPERATURE_CONTROLLER_MASTER_WITHOUT_FAN = 0x0023
    FID_COOLING_ACTUATOR = 0x0024
    FID_DAY_NIGHT_SENSOR = 0x0025
    FID_DATE_AND_TIME = 0x0026
    FID_HEATING_ACTUATOR = 0x0027
    FID_FORCE_UP_DOWN_SENSOR = 0x0028
    FID_HEATING_COOLING_ACTUATOR = 0x0029
    FID_HEATING_COOLING_SENSOR = 0x002A
    FID_DES_DEVICE_SETTINGS = 0x002B
    FID_SACE_BLIND_ACTUATOR = 0x002C
    FID_RGB_SENSOR = 0x002D
    FID_RGB_W_ACTUATOR = 0x002E
    FID_RGB_ACTUATOR = 0x002F
    FID_PANEL_SWITCH_SENSOR = 0x0030
    FID_PANEL_DIMMING_SENSOR = 0x0031
    FID_PANEL_SHUTTER_SENSOR = 0x0032
    FID_PANEL_BLIND_SENSOR = 0x0033
    FID_PANEL_STAIRCASE_LIGHT_SENSOR = 0x0034
    FID_PANEL_FORCE_ON_OFF_SENSOR = 0x0035
    FID_PANEL_FORCE_UP_DOWN_SENSOR = 0x0036
    FID_PANEL_SCENE_SENSOR = 0x0037
    FID_PANEL_ROOM_TEMPERATURE_CONTROLLER_SLAVE = 0x0038
    FID_PANEL_FAN_COIL_SENSOR = 0x0039
    FID_PANEL_RGB_CT_SENSOR = 0x003A
    FID_PANEL_RGB_SENSOR = 0x003B
    FID_PANEL_CT_SENSOR = 0x003C
    FID_ADDITIONAL_HEATING_ACTUATOR = 0x003D
    FID_RADIATOR_ACTUATOR_MASTER = 0x003E
    FID_RADIATOR_ACTUATOR_SLAVE = 0x003F
    FID_COLORTEMPERATURE_ACTUATOR = 0x0040
    FID_BRIGHTNESS_SENSOR = 0x0041
    FID_RAIN_SENSOR = 0x0042
    FID_TEMPERATURE_SENSOR = 0x0043
    FID_WIND_SENSOR = 0x0044
    FID_TRIGGER = 0x0045
    FID_FCA_2_PIPE_HEATING = 0x0047
    FID_FCA_2_PIPE_COOLING = 0x0048
    FID_FCA_2_PIPE_HEATING_COOLING = 0x0049
    FID_FCA_4_PIPE_HEATING_AND_COOLING = 0x004A
    FID_WINDOW_DOOR_ACTUATOR = 0x004B
    FID_INVERTER_INFO = 0x004E
    FID_METER_INFO = 0x004F
    FID_BATTERY_INFO = 0x0050
    FID_PANEL_TIMER_PROGRAM_SWITCH_SENSOR = 0x0051
    FID_DOMUSTECH_ZONE = 0x0055
    FID_CENTRAL_HEATING_ACTUATOR = 0x0056
    FID_CENTRAL_COOLING_ACTUATOR = 0x0057
    FID_HOUSE_KEEPING = 0x0059
    FID_MEDIA_PLAYER = 0x005A
    FID_PANEL_ROOM_TEMPERATURE_CONTROLLER_SLAVE_FOR_BATTERY_DEVICE = 0x005B
    FID_WELCOME_IP_MUTE_SENSOR = 0x005C
    FID_WELCOME_IP_MUTE_ACTUATOR = 0x005D
    FID_WELCOME_IP_DOOR_OPEN_SENSOR = 0x005E
    FID_WELCOME_IP_SWITCH_SENSOR = 0x005F
    FID_PANEL_MEDIA_PLAYER_SENSOR = 0x0060
    FID_BLIND_ACTUATOR = 0x0061
    FID_ATTIC_WINDOW_ACTUATOR = 0x0062
    FID_AWNING_ACTUATOR = 0x0063
    FID_WINDOW_DOOR_POSITION_SENSOR = 0x0064
    FID_WINDOW_DOOR_POSITION_ACTUATOR = 0x0065
    FID_MEDIA_PLAYBACK_CONTROL_SENSOR = 0x0066
    FID_MEDIA_VOLUME_SENSOR = 0x0067
    FID_DISHWASHER = 0x0068
    FID_LAUNDRY = 0x0069
    FID_DRYER = 0x006A
    FID_OVEN = 0x006B
    FID_FRIDGE = 0x006C
    FID_FREEZER = 0x006D
    FID_HOOD = 0x006E
    FID_COFFEE_MACHINE = 0x006F
    FID_FRIDGE_FREEZER = 0x0070
    FID_TIMER_PROGRAM_OR_ALERT_SWITCH_SENSOR = 0x0071
    FID_WELCOME_IP_BELL_INDICATOR_SENSOR = 0x0072
    FID_CEILING_FAN_ACTUATOR = 0x0073
    FID_CEILING_FAN_SENSOR = 0x0074
    FID_SPLIT_UNIT_GATEWAY = 0x0075
    FID_ZONE = 0x0076
    FID_24H_ZONE = 0x0077
    FID_EXTERNAL_IR_SENSOR_BX80 = 0x0078
    FID_EXTERNAL_IR_SENSOR_VXI = 0x0079
    FID_EXTERNAL_IR_SENSOR_MINI = 0x007A
    FID_EXTERNAL_IR_SENSOR_HIGH_ALTITUDE = 0x007B
    FID_EXTERNAL_IR_SENSOR_CURTAIN = 0x007C
    FID_SMOKE_DETECTOR = 0x007D
    FID_CARBON_MONOXIDE_SENSOR = 0x007E
    FID_METHANE_DETECTOR = 0x007F
    FID_GAS_SENSOR_LPG = 0x0080
    FID_FLOOD_DETECTION = 0x0081
    FID_DOMUS_CENTRAL_UNIT_NEXTGEN = 0x0082
    FID_THERMOSTAT = 0x0083
    FID_PANEL_DOMUS_ZONE_SENSOR = 0x0084
    FID_THERMOSTAT_SLAVE = 0x0085
    FID_DOMUS_SECURE_INTEGRATION = 0x0086
    FID_ADDITIONAL_COOLING_ACTUATOR = 0x0087
    FID_TWO_LEVEL_HEATING_ACTUATOR = 0x0088
    FID_TWO_LEVEL_COOLING_ACTUATOR = 0x0089
    FID_EXTERNAL_SIREN = 0x008D
    FID_GLOBAL_ZONE = 0x008E
    FID_VOLUME_UP_SENSOR = 0x008F
    FID_VOLUME_DOWN_SENSOR = 0x0090
    FID_PLAY_PAUSE_SENSOR = 0x0091
    FID_NEXT_FAVORITE_SENSOR = 0x0092
    FID_NEXT_SONG_SENSOR = 0x0093
    FID_PREVIOUS_SONG_SENSOR = 0x0094
    FID_HOME_APPLIANCE_SENSOR = 0x0095
    FID_HEAT_SENSOR = 0x0096
    FID_ZONE_SWITCHING = 0x0097
    FID_SECURE_AT_HOME_FUNCTION = 0x0098
    FID_COMPLEX_CONFIGURATION = 0x0099
    FID_DOMUS_CENTRAL_UNIT_BASIC = 0x009A
    FID_DOMUS_REPEATER = 0x009B
    FID_DOMUS_SCENE_TRIGGER = 0x009C
    FID_DOMUS_WINDOW_CONTACT = 0x009D
    FID_DOMUS_MOVEMENT_DETECTOR = 0x009E
    FID_DOMUS_CURTAIN_DETECTOR = 0x009F
    FID_DOMUS_SMOKE_DETECTOR = 0x00A0
    FID_DOMUS_FLOOD_DETECTOR = 0x00A1
    FID_HOB = 0x00A2
    FID_PANEL_SUG_SENSOR = 0x00A3
    FID_TWO_LEVEL_HEATING_COOLING_ACTUATOR = 0x00A4
    FID_PANEL_THERMOSTAT_CONTROLLER_SLAVE = 0x00A5
    FID_WALLBOX = 0x00A6
    FID_PANEL_WALLBOX = 0x00A7
    FID_DOOR_LOCK_CONTROL = 0x00A8
    FID_DOOR_LOCK_SETTINGS = 0x00A9
    FID_VRV_GATEWAY = 0x00AA
    FID_DOMUS_PARAMETRABLE_BUTTON = 0x00AB
    FID_DOMUS_CENTRAL_UNIT_BASIC_25 = 0x00AC
    FID_DOMUS_CENTRAL_UNIT_NEXTGEN_25 = 0x00AD
    FID_PANEL_RGB_W_SENSOR = 0x00AE
    FID_INVERTER_METER_BATTERY = 0x00AF
    FID_INVERTER_METER = 0x00B0
    FID_METER_BATTERY = 0x00B1
    FID_INVERTER_BATTERY = 0x00B2
    FID_DES_VIDEO_CAMERA_LINK = 0x00B3
    FID_FINGERPRINT_SENSOR = 0x00B4
    FID_FLOOD_ALARM_SENSOR = 0x00B5
    FID_DOMUS_PRE_PROGRAMMED_REMOTE = 0x00B6
    FID_HVAC = 0x00B7
    FID_TIMED_START_STOP_ACTUATOR = 0x00B8
    FID_VENTILATION = 0x00B9
    FID_CO_2 = 0x00BA
    FID_VOC = 0x00BB
    FID_TEMPERATURE_SENSOR_TYPE1 = 0x00BC
    FID_AIRQUALITY_SENSOR = 0x00BD
    FID_VACUUM_CLEANER = 0x00BE
    FID_PANEL_ROOM_TEMPERATURE_CONTROLLER_SLAVE_1X1 = 0x00BF
    FID_SMOKE_DETECTOR_TYPE1 = 0x00C0
    FID_PANEL_ROOM_TEMPERATURE_CONTROLLER_MASTER_WITHOUT_FAN = 0x00C1
    FID_PANEL_ROOM_TEMPERATURE_CONTROLLER_MASTER_WITH_FAN = 0x00C2
    FID_DES_VIDEO_CAMERA_ACTUATOR = 0x00C3
    FID_ENERGY_ONE_WAY_METER = 0x00C4
    FID_ENERGY_TWO_WAY_METER = 0x00C5
    FID_ENERGY_INVERTER = 0x00C6
    FID_ENERGY_BATTERY = 0x00C7
    FID_WATER_METER = 0x00C8
    FID_GAS_METER = 0x00C9
    FID_CWA_ROOM_TEMPERATURE_CONTROLLER_UNDERFLOOR = 0x00CF
    FID_CWA_UNDERFLOOR_TEMPERATURE_CONTROLLER = 0x00D0
    FID_CWA_ROOM_TEMPERATURE_CONTROLLER_UNDERFLOOR_LIMITER = 0x00D1
    FID_CWA_ROOM_TEMPERATURE_CONTROLLER_HEATING_COOLING = 0x00D2
    FID_CWA_ROOM_TEMPERATURE_CONTROLLER_RADIATOR = 0x00D3
    FID_PANEL_LIGHT_SWITCH_SENSOR = 0x00D4
    FID_FLASHING_ACTUATOR = 0x00D5
    FID_PB_SWITCH_SENSOR = 0x00D6
    FID_PB_BLIND_SENSOR = 0x00D7
    FID_PB_STAIRCASE_LIGHT_SENSOR = 0x00D8
    FID_PB_SCENE_SENSOR = 0x00D9
    FID_DALI_DT0_ACTUATOR = 0x00DA
    FID_DALI_DT8_CT_ACTUATOR = 0x00DB
    FID_DALI_DT8_RGB_ACTUATOR = 0x00DC
    FID_COLORTEMPERATURE_ACTUATOR_TYPE8 = 0x00DE
    FID_RGB_ACTUATOR_TYPE8 = 0x00DF
    FID_RGB_W_ACTUATOR_TYPE8 = 0x00E0
    FID_CEILING_FAN_ACTUATOR_TYPE8 = 0x00E1
    FID_MEDIA_PLAYER_TYPE1 = 0x00E2
    FID_PANEL_MEDIA_PLAYER_SENSOR_TYPE1 = 0x00E3
    FID_SWITCH_SENSOR_ROCKER_TYPE0 = 0x1000
    FID_SWITCH_SENSOR_ROCKER_TYPE1 = 0x1001
    FID_SWITCH_SENSOR_ROCKER_TYPE2 = 0x1002
    FID_SWITCH_SENSOR_PUSHBUTTON_TYPE0 = 0x1008
    FID_SWITCH_SENSOR_PUSHBUTTON_TYPE1 = 0x1009
    FID_SWITCH_SENSOR_PUSHBUTTON_TYPE2 = 0x100A
    FID_SWITCH_SENSOR_PUSHBUTTON_TYPE3 = 0x100B
    FID_DIMMING_SENSOR_ROCKER_TYPE0 = 0x1010
    FID_DIMMING_SENSOR_ROCKER_TYPE1 = 0x1011
    FID_DIMMING_SENSOR_ROCKER_TYPE2 = 0x1012
    FID_DIMMING_SENSOR_PUSHBUTTON_TYPE0 = 0x1018
    FID_DIMMING_SENSOR_PUSHBUTTON_TYPE1 = 0x1019
    FID_DIMMING_SENSOR_PUSHBUTTON_TYPE2 = 0x101A
    FID_DIMMING_SENSOR_PUSHBUTTON_TYPE3 = 0x101B
    FID_STAIRCASE_LIGHT_SENSOR_ROCKER_TYPE0 = 0x1020
    FID_STAIRCASE_LIGHT_SENSOR_ROCKER_TYPE1 = 0x1021
    FID_STAIRCASE_LIGHT_SENSOR_ROCKER_TYPE2 = 0x1022
    FID_STAIRCASE_LIGHT_SENSOR_PUSHBUTTON_TYPE0 = 0x1028
    FID_STAIRCASE_LIGHT_SENSOR_PUSHBUTTON_TYPE1 = 0x1029
    FID_STAIRCASE_LIGHT_SENSOR_PUSHBUTTON_TYPE2 = 0x102A
    FID_STAIRCASE_LIGHT_SENSOR_PUSHBUTTON_TYPE3 = 0x102B
    FID_SCENE_SENSOR_ROCKER_TYPE0 = 0x1030
    FID_SCENE_SENSOR_ROCKER_TYPE1 = 0x1031
    FID_SCENE_SENSOR_ROCKER_TYPE2 = 0x1032
    FID_SCENE_SENSOR_PUSHBUTTON_TYPE0 = 0x1038
    FID_SCENE_SENSOR_PUSHBUTTON_TYPE1 = 0x1039
    FID_SCENE_SENSOR_PUSHBUTTON_TYPE2 = 0x103A
    FID_SCENE_SENSOR_PUSHBUTTON_TYPE3 = 0x103B
    FID_BLIND_SENSOR_ROCKER_TYPE0 = 0x1040
    FID_BLIND_SENSOR_ROCKER_TYPE1 = 0x1041
    FID_BLIND_SENSOR_ROCKER_TYPE2 = 0x1042
    FID_BLIND_SENSOR_PUSHBUTTON_TYPE0 = 0x1048
    FID_BLIND_SENSOR_PUSHBUTTON_TYPE1 = 0x1049
    FID_BLIND_SENSOR_PUSHBUTTON_TYPE2 = 0x104A
    FID_BLIND_SENSOR_PUSHBUTTON_TYPE3 = 0x104B
    FID_FORCE_ON_OFF_SENSOR_ROCKER_TYPE0 = 0x1050
    FID_FORCE_ON_OFF_SENSOR_ROCKER_TYPE1 = 0x1051
    FID_FORCE_ON_OFF_SENSOR_ROCKER_TYPE2 = 0x1052
    FID_FORCE_ON_OFF_SENSOR_PUSHBUTTON_TYPE0 = 0x1058
    FID_FORCE_ON_OFF_SENSOR_PUSHBUTTON_TYPE1 = 0x1059
    FID_FORCE_ON_OFF_SENSOR_PUSHBUTTON_TYPE2 = 0x105A
    FID_FORCE_ON_OFF_SENSOR_PUSHBUTTON_TYPE3 = 0x105B
    FID_FORCE_UP_DOWN_SENSOR_ROCKER_TYPE0 = 0x1060
    FID_FORCE_UP_DOWN_SENSOR_ROCKER_TYPE1 = 0x1061
    FID_FORCE_UP_DOWN_SENSOR_ROCKER_TYPE2 = 0x1062
    FID_FORCE_UP_DOWN_SENSOR_PUSHBUTTON_TYPE0 = 0x1068
    FID_FORCE_UP_DOWN_SENSOR_PUSHBUTTON_TYPE1 = 0x1069
    FID_FORCE_UP_DOWN_SENSOR_PUSHBUTTON_TYPE2 = 0x106A
    FID_FORCE_UP_DOWN_SENSOR_PUSHBUTTON_TYPE3 = 0x106B
    FID_TIMER_ACTION_SENSOR_ROCKER_TYPE0 = 0x1070
    FID_TIMER_ACTION_SENSOR_ROCKER_TYPE1 = 0x1071
    FID_TIMER_ACTION_SENSOR_ROCKER_TYPE2 = 0x1072
    FID_TIMER_ACTION_SENSOR_PUSHBUTTON_TYPE0 = 0x1078
    FID_TIMER_ACTION_SENSOR_PUSHBUTTON_TYPE1 = 0x1079
    FID_TIMER_ACTION_SENSOR_PUSHBUTTON_TYPE2 = 0x107A
    FID_TIMER_ACTION_SENSOR_PUSHBUTTON_TYPE3 = 0x107B
    FID_SWITCH_FORCE_ON_OFF_SENSOR_ROCKER_TYPE0 = 0x1080
    FID_SWITCH_FORCE_ON_OFF_SENSOR_ROCKER_TYPE1 = 0x1081
    FID_MOVEMENT_DETECTOR_TYPE0 = 0x1090
    FID_MOVEMENT_DETECTOR_SLAVE_TYPE0 = 0x1091
    FID_MOVEMENT_DETECTOR_TYPE2 = 0x1092
    FID_MOVEMENT_DETECTOR_TYPE3 = 0x1093
    FID_MOVEMENT_DETECTOR_TYPE4 = 0x1094
    FID_MOVEMENT_DETECTOR_SLAVE_TYPE3 = 0x1095
    FID_MOVEMENT_DETECTOR_SLAVE_TYPE4 = 0x1096
    FID_MEDIA_PLAYBACK_CONTROL_SENSOR_ROCKER_TYPE0 = 0x10A0
    FID_MEDIA_PLAYBACK_CONTROL_SENSOR_ROCKER_TYPE1 = 0x10A1
    FID_MEDIA_PLAYBACK_CONTROL_SENSOR_ROCKER_TYPE2 = 0x10A2
    FID_MEDIA_PLAY_PAUSE_SENSOR_PUSHBUTTON_TYPE0 = 0x10A8
    FID_MEDIA_PLAY_PAUSE_SENSOR_PUSHBUTTON_TYPE1 = 0x10A9
    FID_MEDIA_PLAY_PAUSE_SENSOR_PUSHBUTTON_TYPE2 = 0x10AA
    FID_MEDIA_PLAY_PAUSE_SENSOR_PUSHBUTTON_TYPE3 = 0x10AB
    FID_MEDIA_VOLUME_SENSOR_ROCKER_TYPE0 = 0x10B0
    FID_MEDIA_VOLUME_SENSOR_ROCKER_TYPE1 = 0x10B1
    FID_MEDIA_VOLUME_SENSOR_ROCKER_TYPE2 = 0x10B2
    FID_MEDIA_VOLUME_UP_SENSOR_PUSHBUTTON_TYPE0 = 0x10B8
    FID_MEDIA_VOLUME_UP_SENSOR_PUSHBUTTON_TYPE1 = 0x10B9
    FID_MEDIA_VOLUME_UP_SENSOR_PUSHBUTTON_TYPE2 = 0x10BA
    FID_MEDIA_VOLUME_UP_SENSOR_PUSHBUTTON_TYPE3 = 0x10BB
    FID_MEDIA_VOLUME_DOWN_SENSOR_PUSHBUTTON_TYPE0 = 0x10C0
    FID_MEDIA_VOLUME_DOWN_SENSOR_PUSHBUTTON_TYPE1 = 0x10C1
    FID_MEDIA_VOLUME_DOWN_SENSOR_PUSHBUTTON_TYPE2 = 0x10C2
    FID_MEDIA_VOLUME_DOWN_SENSOR_PUSHBUTTON_TYPE3 = 0x10C3
    FID_MEDIA_NEXT_FAVORITE_SENSOR_PUSHBUTTON_TYPE0 = 0x10C8
    FID_MEDIA_NEXT_FAVORITE_SENSOR_PUSHBUTTON_TYPE1 = 0x10C9
    FID_MEDIA_NEXT_FAVORITE_SENSOR_PUSHBUTTON_TYPE2 = 0x10CA
    FID_MEDIA_NEXT_FAVORITE_SENSOR_PUSHBUTTON_TYPE3 = 0x10CB
    FID_MEDIA_NEXT_SONG_SENSOR_PUSHBUTTON_TYPE0 = 0x10D0
    FID_MEDIA_NEXT_SONG_SENSOR_PUSHBUTTON_TYPE1 = 0x10D1
    FID_MEDIA_NEXT_SONG_SENSOR_PUSHBUTTON_TYPE2 = 0x10D2
    FID_MEDIA_NEXT_SONG_SENSOR_PUSHBUTTON_TYPE3 = 0x10D3
    FID_MEDIA_PREVIOUS_SONG_SENSOR_PUSHBUTTON_TYPE0 = 0x10D8
    FID_MEDIA_PREVIOUS_SONG_SENSOR_PUSHBUTTON_TYPE1 = 0x10D9
    FID_MEDIA_PREVIOUS_SONG_SENSOR_PUSHBUTTON_TYPE2 = 0x10DA
    FID_MEDIA_PREVIOUS_SONG_SENSOR_PUSHBUTTON_TYPE3 = 0x10DB
    FID_MWIRE_SWITCH_INPUT_TYPE0 = 0x10E0
    FID_MWIRE_SWITCH_OUTPUT_TYPE0 = 0x10E8
    FID_MWIRE_SWITCH_OUTPUT_TYPE1 = 0x10E9
    FID_MWIRE_BLIND_INPUT_TYPE0 = 0x10F0
    FID_MWIRE_BLIND_OUTPUT_TYPE0 = 0x10F8
    FID_MWIRE_BLIND_OUTPUT_TYPE1 = 0x10F9
    FID_MWIRE_MOVEMENT_INPUT_TYPE0 = 0x1100
    FID_MWIRE_MOVEMENT_OUTPUT_TYPE0 = 0x1108
    FID_MWIRE_PRESET_INPUT_TYPE0 = 0x1110
    FID_MWIRE_PRESET_OUTPUT_TYPE0 = 0x1118
    FID_MWIRE_PRESET_OUTPUT_TYPE1 = 0x1119
    FID_MWIRE_SWITCH_REMOTE_CONTROL_ROCKER = 0x1120
    FID_MWIRE_BLIND_REMOTE_CONTROL_ROCKER = 0x1130
    FID_MWIRE_PRESET_REMOTE_CONTROL_ROCKER = 0x1140
    FID_MWIRE_DIMMING_INPUT_TYPE0 = 0x1150
    FID_PRESENCE_DETECTOR_TYPE0 = 0x1160
    FID_PRESENCE_DETECTOR_TYPE1 = 0x1161
    FID_LOCK_SENSOR_SENSOR_ROCKER_TYPE0 = 0x1170
    FID_LOCK_SENSOR_SENSOR_ROCKER_TYPE1 = 0x1171
    FID_LOCK_SENSOR_SENSOR_ROCKER_TYPE2 = 0x1172
    FID_LOCK_SENSOR_SENSOR_PUSHBUTTON_TYPE0 = 0x1178
    FID_LOCK_SENSOR_SENSOR_PUSHBUTTON_TYPE1 = 0x1179
    FID_LOCK_SENSOR_SENSOR_PUSHBUTTON_TYPE2 = 0x117A
    FID_LOCK_SENSOR_SENSOR_PUSHBUTTON_TYPE3 = 0x117B
    FID_SWITCH_ACTUATOR_TYPE8 = 0x1808
    FID_SWITCH_ACTUATOR_TYPE9 = 0x1809
    FID_DIMMING_ACTUATOR_TYPE0 = 0x1810
    FID_DIMMING_ACTUATOR_TYPE8 = 0x1818
    FID_DIMMING_ACTUATOR_TYPE9 = 0x1819
    FID_BLINDS_ACTUATOR_TYPE0 = 0x1820
    FID_BLINDS_ACTUATOR_TYPE1 = 0x1821
    FID_BLINDS_ACTUATOR_TYPE2 = 0x1822
    FID_BLINDS_ACTUATOR_TYPE3 = 0x1823
    FID_BLINDS_ACTUATOR_TYPE5 = 0x1825
    FID_E_CONTACT_SWITCH_ACTUATOR_TYPE0 = 0x1830
    FID_VENTILATION_SWITCH_ACTUATOR_TYPE0 = 0x1840
    FID_HOUSEKEEPING_TYPE0 = 0x1F00
    FID_HOUSEKEEPING_TYPE1 = 0x1F01
    FID_LIGHT_GROUP = 0x4000
    FID_BLIND_GROUP = 0x4001
    FID_DIMMER_GROUP = 0x4002
    FID_RGB_W_GROUP = 0x4003
    FID_SACE_BLIND_GROUP = 0x4004
    FID_SHUTTER_GROUP = 0x4005
    FID_RGB_GROUP = 0x4006
    FID_RGBW_GROUP = 0x4007
    FID_LOCK_SENSOR_GROUP = 0x4008
    FID_SCENE = 0x4800
    FID_SPECIAL_SCENE_PANIC = 0x4801
    FID_SPECIAL_SCENE_ALL_OFF = 0x4802
    FID_SPECIAL_SCENE_ALL_BLINDS_UP = 0x4803
    FID_SPECIAL_SCENE_ALL_BLINDS_DOWN = 0x4804
    FID_TIMER_PROGRAM_SWITCH_ACTUATOR = 0x4A00
    FID_ALERT_SWITCH_ACTUATOR = 0x4A01
    FID_DALI_ACTUATOR_ICON = 0xF5FB
    FID_SUPER_DEVICE_ICON = 0xF6FE
    FID_83221_ICON = 0xF8FD
    FID_PILL_DEVICE = 0xF9FB
    FID_SU_F_4_0_PB_1_ICON = 0xFBFF
    FID_SU_F_2_0_PB_1_ICON = 0xFCFF
    FID_KEYPAD_DEVICE = 0xFEE4
    FID_SIMPLE_ROCKER_DEVICE = 0xFEE5
    FID_DIMMER_ROCKER_DEVICE = 0xFEE6
    FID_THERMOSTAT_DEVICE = 0xFEE7
    FID_CEILING_FAN_DEVICE = 0xFEE8
    FID_WEATHER_STATION_DEVICE = 0xFEEF
    FID_HUE_DEVICE = 0xFEF0
    FID_ACTUATOR_DEVICE = 0xFEFB
    FID_MOVEMENT_DETECTOR_DEVICE = 0xFEFC
    FID_PANEL_SENSOR = 0xFEFD
    FID_REG_DEVICE = 0xFEFE
    FID_PANEL_DEVICE = 0xFEFF
    FID_RTC_DEVICE = 0xFF00
    FID_ROCKER_SENSOR = 0xFF01
    FID_KEYPAD_ICON = 0xFFE4
    FID_SIMPLE_ROCKER_ICON = 0xFFE5
    FID_DIMMER_ROCKER_ICON = 0xFFE6
    FID_THERMOSTAT_ICON = 0xFFE7
    FID_CEILING_FAN_ACTUATOR_ICON = 0xFFE8
    FID_MEDIA_PLAYER_ICON = 0xFFE9
    FID_WINDOW_SENSOR_ICON = 0xFFEA
    FID_BINARY_SENSOR_ICON = 0xFFEB
    FID_SOLAR_ICON = 0xFFEC
    FID_WEATHER_STATION_ICON = 0xFFED
    FID_HUE_ICON = 0xFFEE
    FID_REG_HEATING_ACTUATOR_ICON = 0xFFEF
    FID_REG_BINARY_OUTPUT_ICON = 0xFFF0
    FID_REG_BINARY_INPUT_ICON = 0xFFF1
    FID_REG_SHUTTER_ICON = 0xFFF2
    FID_REG_SWITCH_ICON = 0xFFF3
    FID_REG_DIMMER_ICON = 0xFFF4
    FID_MOVEMENT_DETECTOR_ICON = 0xFFF5
    FID_RTC_ICON = 0xFFF6
    FID_4_INCH_PANEL_ICON = 0xFFF7
    FID_7_INCH_PANEL_ICON = 0xFFF8
    FID_PILL_ICON = 0xFFF9
    FID_DIN_RAIL_DEVICE_ICON = 0xFFFA
    FID_4_PUSH_BUTTON_SENSOR_ICON = 0xFFFB
    FID_2_PUSH_BUTTON_SENSOR_ICON = 0xFFFC
    FID_2_ROCKER_SWITCH_SENSOR_ICON = 0xFFFE
    FID_1_ROCKER_SWITCH_SENSOR_ICON = 0xFFFF
