# generated by fastapi-codegen:
#   filename:  /home/ivasylen/sdk_project/contracts/guardicore/connector
#   timestamp: 2025-08-08T09:27:54+00:00

from __future__ import annotations

from enum import Enum
from typing import Dict, List, Optional, Union

from pydantic import BaseModel, ConfigDict, Field


class Kind(Enum):
    NAMESPACE = 'Namespace'


class K8SNamespaceSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Kind


class Kind1(Enum):
    CONTROLLER = 'Controller'


class Type(Enum):
    UNKNOWN = 'Unknown'
    REPLICA_SET = 'ReplicaSet'
    DAEMON_SET = 'DaemonSet'
    DEPLOYMENT = 'Deployment'
    STATEFUL_SET = 'StatefulSet'
    JOB = 'Job'
    CRONE_JOB = 'CroneJob'
    REPLICATION_CONTROLLER = 'ReplicationController'


class Operator(Enum):
    IN_ = 'In'
    NOT_IN = 'NotIn'
    EXISTS = 'Exists'
    DOES_NOT_EXIST = 'DoesNotExist'


class KubernetesLabelSelectorRequirement(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    key: Optional[str] = None
    operator: Optional[Operator] = None
    values: Optional[List[str]] = None


class Kind2(Enum):
    CLUSTER = 'Cluster'


class ClusterType(Enum):
    AKS = 'AKS'
    GKE = 'GKE'
    EKS = 'EKS'
    OCP = 'OCP'
    RKE = 'RKE'
    K8_S = 'K8S'


class CniType(Enum):
    UNKNOWN = 'unknown'
    CALICO = 'calico'
    OVN = 'OVN'
    AZURECNI = 'azurecni'


class K8SClusterSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Kind2
    cluster_type: ClusterType
    cni_type: CniType = Field(..., description='supported cni type in the cluster')
    cluster_version: str = Field(..., examples=['v1.27.10'])
    node_count: int


class Kind3(Enum):
    NODE = 'Node'


class K8SNodeSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Kind3
    provider_id: Optional[str] = None
    ip_addresses: Optional[List[str]] = None
    bios_uuid: Optional[str] = None


class Kind4(Enum):
    SERVICES = 'Services'


class ServiceType(Enum):
    UNKNOWN = 'Unknown'
    EXTERNAL_NAME = 'ExternalName'
    CLUSTER_IP = 'ClusterIP'
    NODE_PORT = 'NodePort'
    LOAD_BALANCER = 'LoadBalancer'


class KubernetesServicePort(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Optional[str] = None
    node_port: Optional[int] = None
    port: Optional[int] = None
    protocol: Optional[str] = None
    target_port: Optional[str] = None


class KubernetesOwnerReference(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Optional[str] = None
    name: Optional[str] = None
    uid: Optional[str] = None


class KubernetesV1LabelSelector(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    match_expressions: Optional[List[KubernetesLabelSelectorRequirement]] = None
    match_labels: Optional[Dict[str, str]] = None


class K8SServicesSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Kind4
    cluster_ip: Optional[str] = None
    load_balancer_ip: Optional[str] = None
    service_type: Optional[ServiceType] = None
    ports: Optional[List[KubernetesServicePort]] = None
    selector: Optional[Dict[str, str]] = Field(
        None, description='Map of service selectors'
    )
    external_ips: Optional[List[str]] = Field(
        None, description='(Optional) List of external IPs'
    )
    load_balancer_ingress_ips: Optional[List[str]] = Field(
        None, description='(Optional) List of load balancer ingress ips'
    )


class K8SControllerSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Kind1
    type: Optional[Type] = Field(None, description='type of resource')
    metadata: Optional[Dict[str, str]] = None
    selector: Optional[KubernetesV1LabelSelector] = None
    owner_references: Optional[List[KubernetesOwnerReference]] = None
    dependants_labels: Optional[Dict[str, str]] = None


class K8SData(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    namespace: Optional[str] = Field(
        None,
        description='namespace of the resource. optional for cluster and namespace resource.',
    )
    cluster: Optional[str] = None
    cluster_id: str
    annotations: Optional[Dict[str, str]] = Field(
        None, description='annotations of k8s resource'
    )
    spec: Union[
        K8SNamespaceSpec,
        K8SControllerSpec,
        K8SClusterSpec,
        K8SNodeSpec,
        K8SServicesSpec,
    ]
