# generated by fastapi-codegen:
#   filename:  /home/ivasylen/sdk_project/contracts/guardicore/connector
#   timestamp: 2025-08-08T09:27:54+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Union
from uuid import UUID

from pydantic import BaseModel, ConfigDict, Field

from ..common.common import Connector


class OptType(Enum):
    OPT_INT = 'opt_int'
    OPT_STRING = 'opt_string'
    OPT_BOOL = 'opt_bool'
    OPT_FLOAT = 'opt_float'


class ConfigOpts(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str
    opt_type: OptType
    default_value: Union[str, int, bool, float]
    description: str


class Configuration(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str
    value: Union[str, int, bool, float, Dict[str, Any]]


class InternalConfigMetadata(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    component_id: UUID = Field(..., alias='component-id')
    component_type: Connector = Field(..., alias='component-type')
    opts: List[ConfigOpts]


class InternalConfig(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    configs: List[Configuration]
