# generated by fastapi-codegen:
#   filename:  /home/ivasylen/sdk_project/contracts/guardicore/connector
#   timestamp: 2025-08-08T09:27:54+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union
from uuid import UUID

from pydantic import BaseModel, ConfigDict, Field, RootModel

from ..common.common import Connector


class Name(Enum):
    AZURE_ONBOARDING = 'AzureOnboarding'
    MISCELLANEOUS = 'miscellaneous'
    AWS_ONBOARDING = 'AwsOnboarding'


class OperationMode(Enum):
    VISIBILITY = 'visibility'
    ENFORCEMENT = 'enforcement'


class OnboardConfig(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    operation_mode: OperationMode = Field(..., alias='operation-mode')
    auto_discovery: Optional[bool] = Field(False, alias='auto-discovery')
    revision: Optional[int] = None


class Scope(Enum):
    MANAGEMENT_GROUP = 'management_group'
    SUBSCRIPTION = 'subscription'


class AzureSubscriptionsFilter(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    scope: Scope
    values: List[str] = Field(
        ...,
        examples=[
            [
                '/providers/Microsoft.Management/managementGroups/EnggMgmtGroupID',
                '/providers/Microsoft.Management/managementGroups/ProdGroupID',
            ]
        ],
    )


class Scope1(Enum):
    ORG_UNIT = 'org_unit'
    ACCOUNTS = 'accounts'


class AwsAccountsFilter(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    scope: Scope1
    values: List[str] = Field(..., examples=[['012345678901']])


class StatusRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    detailed_status: Optional[Union[AzureSubscriptionsFilter, AwsAccountsFilter]] = (
        Field(None, alias='detailed-status')
    )


class Status(Enum):
    COMPLETED = 'completed'
    IN_PROGRESS = 'in_progress'
    NOT_ONBOARDED = 'not_onboarded'
    FAILED = 'failed'
    PARTIAL = 'partial'


class AzureSubscriptionsStatus(RootModel[List[Dict[str, Status]]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: List[Dict[str, Status]] = Field(
        ...,
        examples=[
            [
                {'87bd8fcb-0e02-4d5f-83e6-e045c63dd4': 'completed'},
                {'97bd8fcb-0e02-4d5f-83e6-e045c63dd4': 'in_progress'},
            ]
        ],
    )

    def __getattr__(self, attr: str):
        return getattr(self.root, attr)

    def __iter__(self):
        for item in self.root:
            yield item


class EnvUnitStatus(RootModel[List[Dict[str, Status]]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: List[Dict[str, Status]] = Field(
        ...,
        examples=[
            [
                {'87bd8fcb-0e02-4d5f-83e6-e045c63dd4': 'completed'},
                {'97bd8fcb-0e02-4d5f-83e6-e045c63dd4': 'in_progress'},
            ]
        ],
    )

    def __getattr__(self, attr: str):
        return getattr(self.root, attr)

    def __iter__(self):
        for item in self.root:
            yield item


class AzureOnboarding(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    subscriptions: AzureSubscriptionsFilter


class AwsOnboarding(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    accounts: AwsAccountsFilter


class Step1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    step: Optional[str] = None
    status: Optional[Status] = None


class StatusResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    overall_status: Status = Field(..., alias='overall-status')
    steps: Optional[List[Step1]] = None
    detailed_status: Optional[Union[AzureSubscriptionsStatus, EnvUnitStatus]] = Field(
        None, alias='detailed-status'
    )


class Step(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Name
    action: Union[AzureOnboarding, AwsOnboarding, Dict[str, Any]]


class Onboard(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    connector_type: Connector = Field(..., alias='connector-type')
    component_id: UUID = Field(..., alias='component-id')
    general: OnboardConfig
    steps: List[Step]
