# generated by fastapi-codegen:
#   filename:  /home/ivasylen/sdk_project/contracts/guardicore/connector
#   timestamp: 2025-08-08T09:27:54+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, ConfigDict, Field, SecretStr, constr


class VersionHandshakeData(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    version: Optional[str] = Field(
        None, description='The version of the endpoint system'
    )
    contract_version: Optional[str] = Field(
        None,
        alias='contract-version',
        description='The latest supported contract version in use by the endpoint i.e 4.2.1',
    )
    component_id: Optional[str] = Field(
        None,
        alias='component-id',
        description='The identifier of the cloud-app/centra system',
    )


class LoginRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    username: constr(min_length=1, max_length=255) = Field(
        ..., description="User's login username", examples=['admin']
    )
    password: SecretStr = Field(
        ..., description="User's login password", examples=['securePassword123']
    )


class LoginResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    access_token: str = Field(
        ...,
        description='JWT access token for authenticated requests',
        examples=['eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9...'],
    )
    token_type: Optional[str] = Field(
        'Bearer', description='Type of the token', examples=['Bearer']
    )
    expires_in: Optional[int] = Field(
        None, description='Token expiration time in seconds', examples=[3600]
    )


class UnauthorizedError(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    error: str = Field(..., description='Error code', examples=['UNAUTHORIZED'])
    message: str = Field(
        ..., description='Error message', examples=['Invalid username or password']
    )


class BadRequestError(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    error: str = Field(..., description='Error code', examples=['BAD_REQUEST'])
    message: str = Field(
        ..., description='Error message', examples=['Missing required field: username']
    )
