# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-08-08T09:27:54+00:00

from __future__ import annotations

from typing import Annotated

from fastapi import APIRouter, Depends, HTTPException
from fastapi.security import HTTPAuthorizationCredentials, HTTPBearer

from ..dependencies import *
from ..handler_registry import HandlerRegistry

router = APIRouter(tags=['Info'])
security = HTTPBearer(auto_error=False)
registry = HandlerRegistry()


@registry.register()
class InfoHandler:
    def __init__(self):
        pass

    def get_integration_details(
        self,
    ) -> IntegrationEnvInfo:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"get_integration_details not implemented"
        )

    def get_integration_units_details(
        self,
        cursor: Optional[conint(ge=0)] = 0,
        page_size: Optional[conint(ge=1, le=1000)] = 100,
    ) -> EnvUnits:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"get_integration_units_details not implemented"
        )


@router.get('/v1/operations/env-info', response_model=IntegrationEnvInfo, tags=['Info'])
def get_integration_details(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
) -> IntegrationEnvInfo:
    """
    Endpoint to retrieve integration environment details. Should fit in one response page.
    """

    token = credentials.credentials if credentials else None
    return registry.call_handler(
        get_integration_details.__name__,
        token,
    )


@router.get('/v1/operations/env-units-list', response_model=EnvUnits, tags=['Info'])
def get_integration_units_details(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    cursor: Optional[conint(ge=0)] = 0,
    page_size: Optional[conint(ge=1, le=1000)] = 100,
) -> EnvUnits:
    """
    Endpoint to retrieve integration environment logical units details. This endpoint support pagination for big amount of units
    """

    token = credentials.credentials if credentials else None
    return registry.call_handler(
        get_integration_units_details.__name__, token, cursor, page_size
    )
